/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.util.logging;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.accumulo.monitor.rest.logs.SanitizedLogEvent;
import org.apache.accumulo.monitor.rest.logs.SingleLogEvent;

public class RecentLogs {
    private static final int MAX_LOGS = 50;
    private final Cache<String, DedupedEvent> events = Caffeine.newBuilder().maximumSize(50L).build();

    public void addEvent(SingleLogEvent event) {
        String key = event.application + ":" + event.logger + ":" + event.level + ":" + event.message;
        this.events.asMap().computeIfAbsent(key, (Function<String, DedupedEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$addEvent$0(org.apache.accumulo.monitor.rest.logs.SingleLogEvent java.lang.String ), (Ljava/lang/String;)Lorg/apache/accumulo/monitor/util/logging/RecentLogs$DedupedEvent;)((SingleLogEvent)event)).count.incrementAndGet();
    }

    public void clearEvents() {
        this.events.invalidateAll();
    }

    public int numEvents() {
        return this.events.asMap().size();
    }

    public boolean eventsIncludeErrors() {
        return this.events.asMap().values().stream().anyMatch(x -> x.event.level.equalsIgnoreCase("ERROR") || x.event.level.equalsIgnoreCase("FATAL"));
    }

    public List<SanitizedLogEvent> getSanitizedEvents() {
        return this.events.asMap().values().stream().map(ev -> new SanitizedLogEvent(ev.event, ev.count.get())).limit(50L).collect(Collectors.toList());
    }

    private static /* synthetic */ DedupedEvent lambda$addEvent$0(SingleLogEvent event, String k) {
        return new DedupedEvent(event);
    }

    private static class DedupedEvent {
        private final SingleLogEvent event;
        private final AtomicInteger count;

        private DedupedEvent(SingleLogEvent event) {
            this.event = event;
            this.count = new AtomicInteger();
        }
    }
}

