/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.coordinator;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.micrometer.core.instrument.Tag;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.accumulo.coordinator.CompactionFinalizer;
import org.apache.accumulo.coordinator.DeadCompactionDetector;
import org.apache.accumulo.coordinator.QueueSummaries;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.clientImpl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.compaction.thrift.CompactionCoordinatorService;
import org.apache.accumulo.core.compaction.thrift.TCompactionState;
import org.apache.accumulo.core.compaction.thrift.TCompactionStatusUpdate;
import org.apache.accumulo.core.compaction.thrift.TExternalCompaction;
import org.apache.accumulo.core.compaction.thrift.TExternalCompactionList;
import org.apache.accumulo.core.compaction.thrift.TNextCompactionJob;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.TKeyExtent;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.fate.zookeeper.ServiceLockSupport;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionId;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metrics.MetricsInfo;
import org.apache.accumulo.core.process.thrift.ServerProcessService;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.tabletserver.thrift.TCompactionStats;
import org.apache.accumulo.core.tabletserver.thrift.TExternalCompactionJob;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.util.compaction.ExternalCompactionUtil;
import org.apache.accumulo.core.util.compaction.RunningCompaction;
import org.apache.accumulo.core.util.threads.ThreadPoolNames;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.server.AbstractServer;
import org.apache.accumulo.server.GarbageCollectionLogger;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.ServerOpts;
import org.apache.accumulo.server.manager.LiveTServerSet;
import org.apache.accumulo.server.rpc.ServerAddress;
import org.apache.accumulo.server.rpc.TServerUtils;
import org.apache.accumulo.server.rpc.ThriftProcessorTypes;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.apache.thrift.TException;
import org.apache.thrift.TMultiplexedProcessor;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class CompactionCoordinator
extends AbstractServer
implements CompactionCoordinatorService.Iface,
LiveTServerSet.Listener,
ServerProcessService.Iface {
    private static final Logger LOG = LoggerFactory.getLogger(CompactionCoordinator.class);
    private static final Logger STATUS_LOG = LoggerFactory.getLogger((String)(CompactionCoordinator.class.getName() + ".compaction.status"));
    private static final long TIME_BETWEEN_GC_CHECKS = 5000L;
    protected static final QueueSummaries QUEUE_SUMMARIES = new QueueSummaries();
    protected static final Map<ExternalCompactionId, RunningCompaction> RUNNING_CACHE = new ConcurrentHashMap<ExternalCompactionId, RunningCompaction>();
    private static final Cache<ExternalCompactionId, RunningCompaction> COMPLETED = Caffeine.newBuilder().maximumSize(200L).expireAfterWrite(10L, TimeUnit.MINUTES).build();
    private static final Map<String, Long> TIME_COMPACTOR_LAST_CHECKED = new ConcurrentHashMap<String, Long>();
    private final ConcurrentHashMap<String, FailureCounts> failingQueues = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, FailureCounts> failingCompactors = new ConcurrentHashMap();
    private final ConcurrentHashMap<TableId, FailureCounts> failingTables = new ConcurrentHashMap();
    private final GarbageCollectionLogger gcLogger = new GarbageCollectionLogger();
    protected AuditedSecurityOperation security;
    protected final AccumuloConfiguration aconf;
    protected CompactionFinalizer compactionFinalizer;
    protected LiveTServerSet tserverSet;
    private ServiceLock coordinatorLock;
    private final LoadingCache<String, Integer> compactorCounts;

    protected CompactionCoordinator(ServerOpts opts, String[] args) {
        this(opts, args, null);
    }

    protected CompactionCoordinator(ServerOpts opts, String[] args, AccumuloConfiguration conf) {
        super("compaction-coordinator", opts, args);
        this.aconf = conf == null ? super.getConfiguration() : conf;
        this.compactionFinalizer = this.createCompactionFinalizer();
        this.tserverSet = this.createLiveTServerSet();
        this.setupSecurity();
        this.startGCLogger();
        this.printStartupMsg();
        this.startCompactionCleaner();
        this.startRunningCleaner();
        this.compactorCounts = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build(queue -> ExternalCompactionUtil.countCompactors((String)queue, (ClientContext)this.getContext()));
    }

    public AccumuloConfiguration getConfiguration() {
        return this.aconf;
    }

    protected CompactionFinalizer createCompactionFinalizer() {
        return new CompactionFinalizer(this.getContext(), this.getContext().getScheduledExecutor());
    }

    protected LiveTServerSet createLiveTServerSet() {
        return new LiveTServerSet(this.getContext(), (LiveTServerSet.Listener)this);
    }

    protected void setupSecurity() {
        this.security = this.getContext().getSecurityOperation();
    }

    protected void startGCLogger() {
        ScheduledFuture<?> future = this.getContext().getScheduledExecutor().scheduleWithFixedDelay(() -> this.gcLogger.logGCInfo(this.getConfiguration()), 0L, 5000L, TimeUnit.MILLISECONDS);
        ThreadPools.watchNonCriticalScheduledTask(future);
    }

    protected void startCompactionCleaner() {
        ScheduledFuture<?> future = this.getContext().getScheduledExecutor().scheduleWithFixedDelay(this::cleanUpCompactors, 0L, 5L, TimeUnit.MINUTES);
        ThreadPools.watchNonCriticalScheduledTask(future);
    }

    protected void startRunningCleaner() {
        ScheduledFuture<?> future = this.getContext().getScheduledExecutor().scheduleWithFixedDelay(this::cleanUpRunning, 0L, 5L, TimeUnit.MINUTES);
        ThreadPools.watchNonCriticalScheduledTask(future);
    }

    protected void printStartupMsg() {
        LOG.info("Version 2.1.4");
        LOG.info("Instance " + String.valueOf(this.getContext().getInstanceID()));
    }

    protected void getCoordinatorLock(HostAndPort clientAddress) throws KeeperException, InterruptedException {
        LOG.info("trying to get coordinator lock");
        String coordinatorClientAddress = ExternalCompactionUtil.getHostPortString((HostAndPort)clientAddress);
        String lockPath = this.getContext().getZooKeeperRoot() + "/coordinators/lock";
        UUID zooLockUUID = UUID.randomUUID();
        this.coordinatorLock = new ServiceLock(this.getContext().getZooReaderWriter().getZooKeeper(), ServiceLock.path((String)lockPath), zooLockUUID);
        ServiceLockSupport.HAServiceLockWatcher coordinatorLockWatcher = new ServiceLockSupport.HAServiceLockWatcher("coordinator", () -> this.getShutdownComplete().get());
        while (true) {
            this.coordinatorLock.lock((ServiceLock.AccumuloLockWatcher)coordinatorLockWatcher, coordinatorClientAddress.getBytes(StandardCharsets.UTF_8));
            coordinatorLockWatcher.waitForChange();
            if (coordinatorLockWatcher.isLockAcquired()) break;
            if (!coordinatorLockWatcher.isFailedToAcquireLock()) {
                throw new IllegalStateException("manager lock in unknown state");
            }
            this.coordinatorLock.tryToCancelAsyncLockOrUnlock();
            UtilWaitThread.sleepUninterruptibly((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    protected ServerAddress startCoordinatorClientService() throws UnknownHostException {
        TMultiplexedProcessor processor = ThriftProcessorTypes.getCoordinatorTProcessor((ServerProcessService.Iface)this, (CompactionCoordinatorService.Iface)this, (ServerContext)this.getContext());
        Property maxMessageSizeProperty = this.getConfiguration().resolve(Property.RPC_MAX_MESSAGE_SIZE, new Property[]{Property.GENERAL_MAX_MESSAGE_SIZE});
        ServerAddress sp = TServerUtils.startServer((ServerContext)this.getContext(), (String)this.getBindAddress(), (Property)Property.COMPACTION_COORDINATOR_CLIENTPORT, (TProcessor)processor, (String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Thrift Client Server", (Property)Property.COMPACTION_COORDINATOR_THRIFTCLIENT_PORTSEARCH, (Property)Property.COMPACTION_COORDINATOR_MINTHREADS, (Property)Property.COMPACTION_COORDINATOR_MINTHREADS_TIMEOUT, (Property)Property.COMPACTION_COORDINATOR_THREADCHECK, (Property)maxMessageSizeProperty);
        LOG.info("address = {}", (Object)sp.address);
        return sp;
    }

    protected Collection<Tag> getServiceTags(HostAndPort clientAddress) {
        return MetricsInfo.serviceTags((String)this.getContext().getInstanceName(), (String)this.getApplicationName(), (HostAndPort)clientAddress, (String)"");
    }

    @SuppressFBWarnings(value={"DM_EXIT"}, justification="main class can call System.exit")
    public void run() {
        try {
            this.waitForUpgrade();
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted while waiting for upgrade to complete, exiting...");
            System.exit(1);
        }
        ServerAddress coordinatorAddress = null;
        try {
            coordinatorAddress = this.startCoordinatorClientService();
        }
        catch (UnknownHostException e1) {
            throw new RuntimeException("Failed to start the coordinator service", e1);
        }
        this.updateAdvertiseAddress(coordinatorAddress.getAddress());
        HostAndPort clientAddress = this.getAdvertiseAddress();
        try {
            this.getCoordinatorLock(clientAddress);
        }
        catch (InterruptedException | KeeperException e) {
            throw new IllegalStateException("Exception getting Coordinator lock", e);
        }
        MetricsInfo metricsInfo = this.getContext().getMetricsInfo();
        metricsInfo.init(this.getServiceTags(clientAddress));
        LOG.info("Checking for running external compactions");
        List running = ExternalCompactionUtil.getCompactionsRunningOnCompactors((ClientContext)this.getContext());
        if (running.isEmpty()) {
            LOG.info("No running external compactions found");
        } else {
            LOG.info("Found {} running external compactions", (Object)running.size());
            running.forEach(rc -> {
                TCompactionStatusUpdate update = new TCompactionStatusUpdate();
                update.setState(TCompactionState.IN_PROGRESS);
                update.setMessage("Coordinator restarted, compaction found in progress");
                rc.addUpdate(Long.valueOf(System.currentTimeMillis()), update);
                RUNNING_CACHE.put(ExternalCompactionId.of((String)rc.getJob().getExternalCompactionId()), (RunningCompaction)rc);
            });
        }
        this.tserverSet.startListeningForTabletServerChanges();
        this.startDeadCompactionDetector();
        this.startFailureSummaryLogging();
        LOG.info("Starting loop to check tservers for compaction summaries");
        while (!this.isShutdownRequested()) {
            if (Thread.currentThread().isInterrupted()) {
                LOG.info("Server process thread has been interrupted, shutting down");
                break;
            }
            try {
                long duration;
                long start = System.currentTimeMillis();
                this.updateSummaries();
                long now = System.currentTimeMillis();
                LOG.debug("Time spent checking compaction summaries: {}ms", (Object)(now - start));
                Map<String, List<HostAndPort>> idleCompactors = this.getIdleCompactors();
                TIME_COMPACTOR_LAST_CHECKED.forEach((queue, lastCheckTime) -> {
                    if (now - lastCheckTime > this.getMissingCompactorWarningTime() && QUEUE_SUMMARIES.isCompactionsQueued((String)queue) && idleCompactors.containsKey(queue)) {
                        LOG.warn("No compactors have checked in with coordinator for queue {} in {}ms", queue, (Object)this.getMissingCompactorWarningTime());
                    }
                });
                long checkInterval = this.getTServerCheckInterval();
                if (checkInterval - (duration = System.currentTimeMillis() - start) <= 0L) continue;
                LOG.debug("Waiting {}ms for next tserver check", (Object)(checkInterval - duration));
                Thread.sleep(checkInterval - duration);
            }
            catch (InterruptedException e) {
                LOG.info("Interrupt Exception received, shutting down");
                this.gracefulShutdown(this.getContext().rpcCreds());
            }
        }
        LOG.debug("Stopping Thrift Servers");
        if (coordinatorAddress.server != null) {
            coordinatorAddress.server.stop();
        }
        super.close();
        this.getShutdownComplete().set(true);
        LOG.info("stop requested. exiting ... ");
        try {
            this.coordinatorLock.unlock();
        }
        catch (Exception e) {
            LOG.warn("Failed to release Coordinator lock", (Throwable)e);
        }
    }

    private Map<String, List<HostAndPort>> getIdleCompactors() {
        Map allCompactors = ExternalCompactionUtil.getCompactorAddrs((ClientContext)this.getContext());
        HashSet emptyQueues = new HashSet();
        RUNNING_CACHE.values().forEach(rc -> {
            List busyCompactors = (List)allCompactors.get(rc.getQueueName());
            if (busyCompactors != null && busyCompactors.remove(HostAndPort.fromString((String)rc.getCompactorAddress())) && busyCompactors.isEmpty()) {
                emptyQueues.add(rc.getQueueName());
            }
        });
        emptyQueues.forEach(e -> allCompactors.remove(e));
        return allCompactors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSummaries() {
        int maxThreads = Integer.parseInt(this.getConfiguration().get(Property.COMPACTION_COORDINATOR_SUMMARIES_MAXTHREADS));
        ThreadPoolExecutor executor = ThreadPools.getServerThreadPools().getPoolBuilder(ThreadPoolNames.COMPACTION_COORDINATOR_SUMMARY_POOL).numCoreThreads(10).numMaxThreads(maxThreads).build();
        try {
            ConcurrentSkipListSet queuesSeen = new ConcurrentSkipListSet();
            this.tserverSet.getCurrentServers().forEach(tsi -> executor.execute(() -> this.updateSummaries((TServerInstance)tsi, queuesSeen)));
            executor.shutdown();
            try {
                while (!executor.awaitTermination(1L, TimeUnit.MINUTES)) {
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            TIME_COMPACTOR_LAST_CHECKED.keySet().retainAll(queuesSeen);
            queuesSeen.forEach(q -> TIME_COMPACTOR_LAST_CHECKED.computeIfAbsent((String)q, k -> System.currentTimeMillis()));
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSummaries(TServerInstance tsi, Set<String> queuesSeen) {
        String originalThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(originalThreadName + " [tserver=" + tsi.getHostPort() + "]");
        try {
            TabletClientService.Client client;
            block8: {
                client = null;
                try {
                    LOG.trace("Contacting tablet server {} to get external compaction summaries", (Object)tsi.getHostPort());
                    client = this.getTabletServerConnection(tsi);
                    if (client != null) {
                        List summaries = client.getCompactionQueueInfo(TraceUtil.traceInfo(), this.getContext().rpcCreds());
                        QUEUE_SUMMARIES.update(tsi, summaries);
                        summaries.forEach(summary -> queuesSeen.add(summary.getQueue()));
                        break block8;
                    }
                    LOG.trace("Connection to get summaries could not be established {} ", (Object)tsi.getHostAndPort());
                    QUEUE_SUMMARIES.remove(Set.of(tsi));
                }
                catch (Throwable throwable) {
                    ThriftUtil.returnClient(client, (ClientContext)this.getContext());
                    throw throwable;
                }
            }
            ThriftUtil.returnClient((TServiceClient)client, (ClientContext)this.getContext());
        }
        catch (TException e) {
            LOG.warn("Error getting external compaction summaries from tablet server: {}", (Object)tsi.getHostAndPort(), (Object)e);
            QUEUE_SUMMARIES.remove(Set.of(tsi));
        }
        finally {
            Thread.currentThread().setName(originalThreadName);
        }
    }

    protected void startDeadCompactionDetector() {
        new DeadCompactionDetector(this.getContext(), this, this.getContext().getScheduledExecutor()).start();
    }

    protected long getMissingCompactorWarningTime() {
        return this.getConfiguration().getTimeInMillis(Property.COMPACTOR_MAX_JOB_WAIT_TIME) * 3L;
    }

    protected long getTServerCheckInterval() {
        return this.getConfiguration().getTimeInMillis(Property.COMPACTION_COORDINATOR_TSERVER_COMPACTION_CHECK_INTERVAL);
    }

    public void update(LiveTServerSet current, Set<TServerInstance> deleted, Set<TServerInstance> added) {
        QUEUE_SUMMARIES.remove(deleted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TNextCompactionJob getCompactionJob(TInfo tinfo, TCredentials credentials, String queueName, String compactorAddress, String externalCompactionId) throws ThriftSecurityException {
        if (!this.security.canPerformSystemActions(credentials)) {
            throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED).asThriftException();
        }
        String queue = queueName.intern();
        LOG.trace("getCompactionJob called for queue {} by compactor {}", (Object)queue, (Object)compactorAddress);
        TIME_COMPACTOR_LAST_CHECKED.put(queue, System.currentTimeMillis());
        TExternalCompactionJob result = null;
        QueueSummaries.PrioTserver prioTserver = QUEUE_SUMMARIES.getNextTserver(queue);
        while (prioTserver != null) {
            TServerInstance tserver = prioTserver.tserver;
            LOG.trace("Getting compaction for queue {} from tserver {}", (Object)queue, (Object)tserver.getHostAndPort());
            TabletClientService.Client client = null;
            String originalThreadName = Thread.currentThread().getName();
            Thread.currentThread().setName(originalThreadName + " [tserver=" + tserver.getHostPort() + "]");
            try {
                client = this.getTabletServerConnection(tserver);
                if (client == null) {
                    LOG.trace("No connection established for queue {} on tserver {}, trying next tserver", (Object)queue, (Object)tserver.getHostAndPort());
                    QUEUE_SUMMARIES.removeSummary(tserver, queue, prioTserver.prio);
                    prioTserver = QUEUE_SUMMARIES.getNextTserver(queue);
                    continue;
                }
                TExternalCompactionJob job = client.reserveCompactionJob(TraceUtil.traceInfo(), this.getContext().rpcCreds(), queue, (long)prioTserver.prio, compactorAddress, externalCompactionId);
                if (null == job.getExternalCompactionId()) {
                    LOG.trace("No compactions found for queue {} on tserver {}, trying next tserver", (Object)queue, (Object)tserver.getHostAndPort());
                    QUEUE_SUMMARIES.removeSummary(tserver, queue, prioTserver.prio);
                    prioTserver = QUEUE_SUMMARIES.getNextTserver(queue);
                    continue;
                }
                RUNNING_CACHE.put(ExternalCompactionId.of((String)job.getExternalCompactionId()), new RunningCompaction(job, compactorAddress, queue));
                LOG.debug("Returning external job {} to {}", (Object)job.externalCompactionId, (Object)compactorAddress);
                result = job;
                break;
            }
            catch (TException e) {
                LOG.warn("Error from tserver {} while trying to reserve compaction, trying next tserver", (Object)ExternalCompactionUtil.getHostPortString((HostAndPort)tserver.getHostAndPort()), (Object)e);
                QUEUE_SUMMARIES.remove(Set.of(tserver));
                prioTserver = QUEUE_SUMMARIES.getNextTserver(queue);
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)client, (ClientContext)this.getContext());
                Thread.currentThread().setName(originalThreadName);
            }
        }
        if (result == null) {
            LOG.trace("No tservers found for queue {}, returning empty job to compactor {}", (Object)queue, (Object)compactorAddress);
            result = new TExternalCompactionJob();
        }
        return new TNextCompactionJob(result, ((Integer)this.compactorCounts.get((Object)queue)).intValue());
    }

    protected TabletClientService.Client getTabletServerConnection(TServerInstance tserver) throws TTransportException {
        LiveTServerSet.TServerConnection connection = this.tserverSet.getConnection(tserver);
        if (connection == null) {
            return null;
        }
        ServerContext serverContext = this.getContext();
        TTransport transport = serverContext.getTransportPool().getTransport((ThriftClientTypes)ThriftClientTypes.TABLET_SERVER, connection.getAddress(), this.getContext().getClientTimeoutInMillis(), (ClientContext)serverContext, true);
        return (TabletClientService.Client)ThriftUtil.createClient((ThriftClientTypes)ThriftClientTypes.TABLET_SERVER, (TTransport)transport);
    }

    public void compactionCompleted(TInfo tinfo, TCredentials credentials, String externalCompactionId, TKeyExtent textent, TCompactionStats stats) throws ThriftSecurityException {
        if (!this.security.canPerformSystemActions(credentials)) {
            throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED).asThriftException();
        }
        KeyExtent extent = KeyExtent.fromThrift((TKeyExtent)textent);
        LOG.debug("Compaction completed, id: {}, stats: {}, extent: {}", new Object[]{externalCompactionId, stats, extent});
        ExternalCompactionId ecid = ExternalCompactionId.of((String)externalCompactionId);
        this.captureSuccess(ecid, extent);
        this.compactionFinalizer.commitCompaction(ecid, extent, stats.fileSize, stats.entriesWritten);
        this.recordCompletion(ecid);
    }

    public void compactionFailed(TInfo tinfo, TCredentials credentials, String externalCompactionId, TKeyExtent extent, String exceptionClassName) throws ThriftSecurityException {
        if (!this.security.canPerformSystemActions(credentials)) {
            throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED).asThriftException();
        }
        KeyExtent fromThriftExtent = KeyExtent.fromThrift((TKeyExtent)extent);
        LOG.info("Compaction failed: id: {}, extent: {}, compactor exception:{}", new Object[]{externalCompactionId, fromThriftExtent, exceptionClassName});
        ExternalCompactionId ecid = ExternalCompactionId.of((String)externalCompactionId);
        if (exceptionClassName != null) {
            this.captureFailure(ecid, fromThriftExtent);
        }
        this.compactionFailed(Map.of(ecid, KeyExtent.fromThrift((TKeyExtent)extent)));
    }

    private void captureFailure(ExternalCompactionId ecid, KeyExtent extent) {
        RunningCompaction rc = RUNNING_CACHE.get(ecid);
        if (rc != null) {
            String queue = rc.getQueueName();
            this.failingQueues.compute(queue, FailureCounts::incrementFailure);
            String compactor = rc.getCompactorAddress();
            this.failingCompactors.compute(compactor, FailureCounts::incrementFailure);
        }
        this.failingTables.compute(extent.tableId(), FailureCounts::incrementFailure);
    }

    protected void startFailureSummaryLogging() {
        ScheduledFuture<?> future = this.getContext().getScheduledExecutor().scheduleWithFixedDelay(this::printStats, 0L, 5L, TimeUnit.MINUTES);
        ThreadPools.watchNonCriticalScheduledTask(future);
    }

    private <T> void printStats(String logPrefix, ConcurrentHashMap<T, FailureCounts> failureCounts, boolean logSuccessAtTrace) {
        for (Object key : failureCounts.keySet()) {
            failureCounts.compute(key, (k, counts) -> {
                if (counts != null) {
                    Level level = counts.failures > 0L ? Level.WARN : (logSuccessAtTrace ? Level.TRACE : Level.DEBUG);
                    LOG.atLevel(level).log("{} {} failures:{} successes:{} since last time this was logged ", new Object[]{logPrefix, k, counts.failures, counts.successes});
                }
                return null;
            });
        }
    }

    private void printStats() {
        Map allCompactors = ExternalCompactionUtil.getCompactorAddrs((ClientContext)this.getContext());
        HashSet allCompactorAddrs = new HashSet();
        allCompactors.values().forEach(l -> l.forEach(c -> allCompactorAddrs.add(c.toString())));
        ((ConcurrentHashMap.CollectionView)((Object)this.failingCompactors.keySet())).retainAll(allCompactorAddrs);
        this.printStats("Queue", this.failingQueues, false);
        this.printStats("Table", this.failingTables, false);
        this.printStats("Compactor", this.failingCompactors, true);
    }

    private void captureSuccess(ExternalCompactionId ecid, KeyExtent extent) {
        RunningCompaction rc = RUNNING_CACHE.get(ecid);
        if (rc != null) {
            String queue = rc.getQueueName();
            this.failingQueues.compute(queue, FailureCounts::incrementSuccess);
            String compactor = rc.getCompactorAddress();
            this.failingCompactors.compute(compactor, FailureCounts::incrementSuccess);
        }
        this.failingTables.compute(extent.tableId(), FailureCounts::incrementSuccess);
    }

    void compactionFailed(Map<ExternalCompactionId, KeyExtent> compactions) {
        this.compactionFinalizer.failCompactions(compactions);
        compactions.forEach((k, v) -> this.recordCompletion((ExternalCompactionId)k));
    }

    public void updateCompactionStatus(TInfo tinfo, TCredentials credentials, String externalCompactionId, TCompactionStatusUpdate update, long timestamp) throws ThriftSecurityException {
        if (!this.security.canPerformSystemActions(credentials)) {
            throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED).asThriftException();
        }
        STATUS_LOG.trace("Compaction status update, id: {}, timestamp: {}, update: {}", new Object[]{externalCompactionId, timestamp, update});
        RunningCompaction rc = RUNNING_CACHE.get(ExternalCompactionId.of((String)externalCompactionId));
        if (null != rc) {
            rc.addUpdate(Long.valueOf(timestamp), update);
        }
    }

    private void recordCompletion(ExternalCompactionId ecid) {
        RunningCompaction rc = RUNNING_CACHE.remove(ecid);
        if (rc != null) {
            COMPLETED.put((Object)ecid, (Object)rc);
        }
    }

    protected Set<ExternalCompactionId> readExternalCompactionIds() {
        return this.getContext().getAmple().readTablets().forLevel(Ample.DataLevel.USER).fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.ECOMP}).build().stream().flatMap(tm -> tm.getExternalCompactions().keySet().stream()).collect(Collectors.toSet());
    }

    protected void cleanUpRunning() {
        Set<ExternalCompactionId> idsSnapshot = Set.copyOf(RUNNING_CACHE.keySet());
        Set<ExternalCompactionId> idsInMetadata = this.readExternalCompactionIds();
        LOG.debug("Current ECIDs in metadata: {}", (Object)idsInMetadata.size());
        LOG.debug("Current ECIDs in running cache: {}", (Object)idsSnapshot.size());
        Sets.SetView idsToRemove = Sets.difference(idsSnapshot, idsInMetadata);
        idsToRemove.forEach(this::recordCompletion);
        if (!idsToRemove.isEmpty()) {
            LOG.debug("Removed {} stale entries from RUNNING_CACHE", (Object)idsToRemove.size());
            if (LOG.isTraceEnabled()) {
                idsToRemove.forEach(ecid -> LOG.trace("Removing stale entry: {} from RUNNING_CACHE", ecid));
            }
        }
    }

    public TExternalCompactionList getRunningCompactions(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException {
        if (!this.security.canPerformSystemActions(credentials)) {
            throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED).asThriftException();
        }
        TExternalCompactionList result = new TExternalCompactionList();
        RUNNING_CACHE.forEach((ecid, rc) -> {
            TExternalCompaction trc = new TExternalCompaction();
            trc.setQueueName(rc.getQueueName());
            trc.setCompactor(rc.getCompactorAddress());
            trc.setUpdates(rc.getUpdates());
            trc.setJob(rc.getJob());
            result.putToCompactions(ecid.canonical(), trc);
        });
        return result;
    }

    public TExternalCompactionList getCompletedCompactions(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException {
        if (!this.security.canPerformSystemActions(credentials)) {
            throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED).asThriftException();
        }
        TExternalCompactionList result = new TExternalCompactionList();
        COMPLETED.asMap().forEach((ecid, rc) -> {
            TExternalCompaction trc = new TExternalCompaction();
            trc.setQueueName(rc.getQueueName());
            trc.setCompactor(rc.getCompactorAddress());
            trc.setJob(rc.getJob());
            trc.setUpdates(rc.getUpdates());
            result.putToCompactions(ecid.canonical(), trc);
        });
        return result;
    }

    public void cancel(TInfo tinfo, TCredentials credentials, String externalCompactionId) throws TException {
        RunningCompaction runningCompaction = RUNNING_CACHE.get(ExternalCompactionId.of((String)externalCompactionId));
        KeyExtent extent = KeyExtent.fromThrift((TKeyExtent)runningCompaction.getJob().getExtent());
        try {
            NamespaceId nsId = this.getContext().getNamespaceId(extent.tableId());
            if (!this.security.canCompact(credentials, extent.tableId(), nsId)) {
                throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED).asThriftException();
            }
        }
        catch (TableNotFoundException e) {
            throw new ThriftTableOperationException(extent.tableId().canonical(), null, TableOperation.COMPACT_CANCEL, TableOperationExceptionType.NOTFOUND, e.getMessage());
        }
        HostAndPort address = HostAndPort.fromString((String)runningCompaction.getCompactorAddress());
        ExternalCompactionUtil.cancelCompaction((ClientContext)this.getContext(), (HostAndPort)address, (String)externalCompactionId);
    }

    private void deleteEmpty(ZooReaderWriter zoorw, String path) throws KeeperException, InterruptedException {
        try {
            LOG.debug("Deleting empty ZK node {}", (Object)path);
            zoorw.delete(path);
        }
        catch (KeeperException.NotEmptyException e) {
            LOG.debug("Failed to delete {} its not empty, likely an expected race condition.", (Object)path);
        }
    }

    private void cleanUpCompactors() {
        String compactorQueuesPath = this.getContext().getZooKeeperRoot() + "/compactors";
        ZooReaderWriter zoorw = this.getContext().getZooReaderWriter();
        try {
            List queues = zoorw.getChildren(compactorQueuesPath);
            for (String queue : queues) {
                String qpath = compactorQueuesPath + "/" + queue;
                List compactors = zoorw.getChildren(qpath);
                if (compactors.isEmpty()) {
                    this.deleteEmpty(zoorw, qpath);
                }
                for (String compactor : compactors) {
                    String cpath = compactorQueuesPath + "/" + queue + "/" + compactor;
                    List lockNodes = zoorw.getChildren(compactorQueuesPath + "/" + queue + "/" + compactor);
                    if (!lockNodes.isEmpty()) continue;
                    this.deleteEmpty(zoorw, cpath);
                }
            }
        }
        catch (RuntimeException | KeeperException e) {
            LOG.warn("Failed to clean up compactors", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public ServiceLock getLock() {
        return this.coordinatorLock;
    }

    public static void main(String[] args) throws Exception {
        try (CompactionCoordinator compactor = new CompactionCoordinator(new ServerOpts(), args);){
            compactor.runServer();
        }
    }

    static class FailureCounts {
        long failures;
        long successes;

        FailureCounts(long failures, long successes) {
            this.failures = failures;
            this.successes = successes;
        }

        static FailureCounts incrementFailure(Object key, FailureCounts counts) {
            if (counts == null) {
                return new FailureCounts(1L, 0L);
            }
            ++counts.failures;
            return counts;
        }

        static FailureCounts incrementSuccess(Object key, FailureCounts counts) {
            if (counts == null) {
                return new FailureCounts(0L, 1L);
            }
            ++counts.successes;
            return counts;
        }
    }
}

