/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.util.Iterator;
import java.util.List;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.shell.Shell;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class DeleteShellIterCommand
extends Shell.Command {
    private Option nameOpt;
    private Option allOpt;
    private Option profileOpt;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        String profile = cl.getOptionValue(this.profileOpt.getOpt());
        if (shellState.iteratorProfiles.containsKey(profile)) {
            if (cl.hasOption(this.allOpt.getOpt())) {
                shellState.iteratorProfiles.remove(profile);
                Shell.log.info("Removed profile {}", (Object)profile);
            } else {
                List<IteratorSetting> iterSettings = shellState.iteratorProfiles.get(profile);
                String name = cl.getOptionValue(this.nameOpt.getOpt());
                boolean found = false;
                Iterator<IteratorSetting> iter = iterSettings.iterator();
                while (iter.hasNext()) {
                    if (!iter.next().getName().equals(name)) continue;
                    iter.remove();
                    found = true;
                    break;
                }
                if (found) {
                    Shell.log.info("Removed iterator {} from profile {} ({} left)", new Object[]{name, profile, iterSettings.size()});
                } else {
                    Shell.log.info("No iterator named {} found", (Object)name);
                }
            }
        } else {
            Shell.log.info("No profile named {}", (Object)profile);
        }
        return 0;
    }

    @Override
    public String description() {
        return "deletes iterators profiles configured in this shell session";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        OptionGroup nameGroup = new OptionGroup();
        this.nameOpt = new Option("n", "name", true, "iterator to delete");
        this.nameOpt.setArgName("itername");
        this.allOpt = new Option("a", "all", false, "delete all scan iterators");
        this.allOpt.setArgName("all");
        nameGroup.addOption(this.nameOpt);
        nameGroup.addOption(this.allOpt);
        nameGroup.setRequired(true);
        o.addOptionGroup(nameGroup);
        this.profileOpt = new Option("pn", "profile", true, "iterator profile name");
        this.profileOpt.setRequired(true);
        this.profileOpt.setArgName("profile");
        o.addOption(this.profileOpt);
        return o;
    }

    @Override
    public int numArgs() {
        return 0;
    }
}

