/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf.util;

import com.beust.jcommander.Parameter;
import com.google.auto.service.AutoService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.accumulo.core.cli.ConfigOpts;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.zookeeper.ZooReader;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.codec.VersionedProperties;
import org.apache.accumulo.server.conf.store.NamespacePropKey;
import org.apache.accumulo.server.conf.store.SystemPropKey;
import org.apache.accumulo.server.conf.store.TablePropKey;
import org.apache.accumulo.server.conf.store.impl.PropStoreWatcher;
import org.apache.accumulo.server.conf.store.impl.ReadyMonitor;
import org.apache.accumulo.server.conf.store.impl.ZooPropStore;
import org.apache.accumulo.server.conf.util.ZooPropUtils;
import org.apache.accumulo.server.zookeeper.ZooAclUtil;
import org.apache.accumulo.start.spi.KeywordExecutable;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZKUtil;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={KeywordExecutable.class})
@SuppressFBWarnings(value={"PATH_TRAVERSAL_OUT"}, justification="app is run in same security context as user providing the filename")
public class ZooInfoViewer
implements KeywordExecutable {
    private static final DateTimeFormatter tsFormat = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneId.from(ZoneOffset.UTC));
    private static final Logger log = LoggerFactory.getLogger(ZooInfoViewer.class);
    private NullWatcher nullWatcher;
    private static final String INDENT = "  ";

    public String keyword() {
        return "zoo-info-viewer";
    }

    public String description() {
        return "view Accumulo instance and property information stored in ZooKeeper";
    }

    public void execute(String[] args) throws Exception {
        this.nullWatcher = new NullWatcher(new ReadyMonitor(ZooInfoViewer.class.getSimpleName(), 20000L));
        Opts opts = new Opts();
        opts.parseArgs(ZooInfoViewer.class.getName(), args, new Object[0]);
        log.info("print ids map: {}", (Object)opts.printIdMap);
        log.info("print properties: {}", (Object)opts.printProps);
        log.info("print instances: {}", (Object)opts.printInstanceIds);
        try (ServerContext context = this.getContext(opts);){
            this.generateReport(context.getInstanceID(), opts, context.getZooReader());
        }
    }

    ServerContext getContext(Opts opts) {
        return new ServerContext(opts.getSiteConfiguration());
    }

    void generateReport(InstanceId iid, Opts opts, ZooReader zooReader) throws Exception {
        OutputStream outStream;
        String outfile = opts.getOutfile();
        if (outfile == null || outfile.isEmpty()) {
            log.trace("No output file, using stdout.");
            outStream = System.out;
        } else {
            outStream = new FileOutputStream(outfile);
        }
        try (PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outStream, StandardCharsets.UTF_8)));){
            writer.println("-----------------------------------------------");
            writer.println("Report Time: " + tsFormat.format(Instant.now()));
            writer.println("-----------------------------------------------");
            if (opts.printInstanceIds) {
                Map<String, InstanceId> instanceMap = ZooPropUtils.readInstancesFromZk(zooReader);
                this.printInstanceIds(instanceMap, writer);
            }
            if (opts.printIdMap) {
                this.printIdMapping(iid, zooReader, writer);
            }
            if (opts.printProps) {
                this.printProps(iid, zooReader, opts, writer);
            }
            if (opts.printAcls) {
                this.printAcls(iid, opts, writer);
            }
            writer.println("-----------------------------------------------");
        }
    }

    private void printProps(InstanceId iid, ZooReader zooReader, Opts opts, PrintWriter writer) throws Exception {
        if (opts.printAllProps()) {
            log.info("all: {}", (Object)opts.printAllProps());
        } else {
            log.info("Filters:");
            log.info("system: {}", (Object)opts.printSysProps());
            log.info("namespaces: {} {}", (Object)opts.printNamespaceProps(), opts.getNamespaces().size() > 0 ? opts.getNamespaces() : "");
            log.info("tables: {} {}", (Object)opts.printTableProps(), opts.getTables().size() > 0 ? opts.getTables() : "");
        }
        writer.printf("ZooKeeper properties for instance ID: %s\n\n", iid.canonical());
        if (opts.printSysProps()) {
            this.printSortedProps(writer, Map.of("System", this.fetchSystemProp(iid, zooReader)));
        }
        if (opts.printNamespaceProps()) {
            Map<NamespaceId, String> id2NamespaceMap = ZooPropUtils.getNamespaceIdToNameMap(iid, zooReader);
            Map<String, VersionedProperties> nsProps = this.fetchNamespaceProps(iid, zooReader, id2NamespaceMap, opts.getNamespaces());
            writer.println("Namespace: ");
            this.printSortedProps(writer, nsProps);
            writer.flush();
        }
        if (opts.printTableProps()) {
            Map<String, VersionedProperties> tProps = this.fetchTableProps(iid, opts.getTables(), zooReader);
            writer.println("Tables: ");
            this.printSortedProps(writer, tProps);
        }
        writer.println();
    }

    private void printIdMapping(InstanceId iid, ZooReader zooReader, PrintWriter writer) {
        Map<NamespaceId, String> id2NamespaceMap = ZooPropUtils.getNamespaceIdToNameMap(iid, zooReader);
        writer.println("ID Mapping (id => name) for instance: " + String.valueOf(iid));
        writer.println("Namespace ids:");
        for (Map.Entry<NamespaceId, String> e : id2NamespaceMap.entrySet()) {
            String v = e.getValue().isEmpty() ? "\"\"" : e.getValue();
            writer.printf("%s%-9s => %24s\n", INDENT, e.getKey(), v);
        }
        writer.println();
        Map<TableId, String> id2TableMap = ZooPropUtils.getTableIdToName(iid, id2NamespaceMap, zooReader);
        writer.println("Table ids:");
        for (Map.Entry<TableId, String> e : id2TableMap.entrySet()) {
            writer.printf("%s%-9s => %24s\n", INDENT, e.getKey(), e.getValue());
        }
        writer.println();
    }

    private void printAcls(InstanceId iid, Opts opts, PrintWriter writer) {
        TreeMap<String, List<ACL>> aclMap = new TreeMap<String, List<ACL>>();
        writer.printf("Output format:\n", new Object[0]);
        writer.printf("ACCUMULO_PERM:OTHER_PERM path user_acls...\n\n", new Object[0]);
        writer.printf("ZooKeeper acls for instance ID: %s\n\n", iid.canonical());
        ZooKeeper zooKeeper = new ZooReaderWriter((AccumuloConfiguration)opts.getSiteConfiguration()).getZooKeeper();
        String instanceRoot = ZooUtil.getRoot((InstanceId)iid);
        Stat stat = new Stat();
        this.recursiveAclRead(zooKeeper, "/accumulo/instances", stat, aclMap);
        this.recursiveAclRead(zooKeeper, instanceRoot, stat, aclMap);
        aclMap.forEach((path, acl) -> {
            if (acl == null) {
                writer.printf("ERROR_ACCUMULO_MISSING_SOME: '%s' : none\n", path);
            } else {
                acl.sort(Comparator.comparing(a -> a.getId().getId()));
                ZooAclUtil.ZkAccumuloAclStatus aclStatus = ZooAclUtil.checkWritableAuth(acl);
                String authStatus = aclStatus.accumuloHasFull() ? "ACCUMULO_OKAY" : "ERROR_ACCUMULO_MISSING_SOME";
                String otherUpdate = aclStatus.othersMayUpdate() || aclStatus.anyCanRead() ? "NOT_PRIVATE" : "PRIVATE";
                writer.printf("%s:%s %s", authStatus, otherUpdate, path);
                boolean addSeparator = false;
                for (ACL a2 : acl) {
                    if (addSeparator) {
                        writer.printf(",", new Object[0]);
                    }
                    writer.printf(" %s:%s", ZooAclUtil.translateZooPerm(a2.getPerms()), ZooAclUtil.extractAuthName(a2));
                    addSeparator = true;
                }
            }
            writer.println("");
        });
        writer.flush();
    }

    private void recursiveAclRead(ZooKeeper zooKeeper, String rootPath, Stat stat, Map<String, List<ACL>> aclMap) {
        try {
            ZKUtil.visitSubTreeDFS((ZooKeeper)zooKeeper, (String)rootPath, (boolean)false, (rc, path, ctx, name) -> {
                try {
                    List acls = zooKeeper.getACL(path, stat);
                    aclMap.put(path, acls);
                }
                catch (KeeperException.NoNodeException ex) {
                    throw new IllegalStateException("Node removed during processing", ex);
                }
                catch (KeeperException ex) {
                    throw new IllegalStateException("ZooKeeper exception during processing", ex);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException("interrupted during processing", ex);
                }
            });
        }
        catch (KeeperException ex) {
            throw new IllegalStateException("ZooKeeper exception during processing", ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("interrupted during processing", ex);
        }
    }

    private void printInstanceIds(Map<String, InstanceId> instanceIdMap, PrintWriter writer) {
        writer.println("Instances (Instance Name, Instance ID)");
        instanceIdMap.forEach((name, iid) -> writer.println(name + "=" + String.valueOf(iid)));
        writer.println();
    }

    private Map<String, VersionedProperties> fetchNamespaceProps(InstanceId iid, ZooReader zooReader, Map<NamespaceId, String> id2NamespaceMap, List<String> namespaces) {
        TreeSet<String> cmdOptNamespaces = new TreeSet<String>(namespaces);
        Map<NamespaceId, String> filteredIds = cmdOptNamespaces.isEmpty() ? id2NamespaceMap : id2NamespaceMap.entrySet().stream().filter(e -> cmdOptNamespaces.contains(e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        log.trace("ns filter: {}", filteredIds);
        TreeMap<String, VersionedProperties> results = new TreeMap<String, VersionedProperties>();
        filteredIds.forEach((nid, name) -> {
            try {
                NamespacePropKey key = NamespacePropKey.of(iid, nid);
                log.trace("fetch props from path: {}", (Object)key.getPath());
                VersionedProperties props = ZooPropStore.readFromZk(key, this.nullWatcher, zooReader);
                results.put((String)name, props);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Interrupted reading table properties from ZooKeeper", ex);
            }
            catch (IOException | KeeperException ex) {
                throw new IllegalStateException("Failed to read table properties from ZooKeeper", ex);
            }
        });
        return results;
    }

    private Map<String, VersionedProperties> fetchTableProps(InstanceId iid, List<String> tables, ZooReader zooReader) {
        TreeSet<String> cmdOptTables = new TreeSet<String>(tables);
        Map<NamespaceId, String> id2NamespaceMap = ZooPropUtils.getNamespaceIdToNameMap(iid, zooReader);
        Map<TableId, String> allIds = ZooPropUtils.getTableIdToName(iid, id2NamespaceMap, zooReader);
        Map<TableId, String> filteredIds = cmdOptTables.isEmpty() ? allIds : allIds.entrySet().stream().filter(e -> cmdOptTables.contains(e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        log.trace("Looking for: {}", filteredIds);
        TreeMap<String, VersionedProperties> results = new TreeMap<String, VersionedProperties>();
        filteredIds.forEach((tid, name) -> {
            try {
                TablePropKey key = TablePropKey.of(iid, tid);
                log.trace("fetch props from path: {}", (Object)key.getPath());
                VersionedProperties props = ZooPropStore.readFromZk(key, this.nullWatcher, zooReader);
                results.put((String)name, props);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Interrupted reading table properties from ZooKeeper", ex);
            }
            catch (IOException | KeeperException ex) {
                throw new IllegalStateException("Failed to read table properties from ZooKeeper", ex);
            }
        });
        return results;
    }

    private void printSortedProps(PrintWriter writer, Map<String, VersionedProperties> props) {
        log.trace("Printing: {}", props);
        props.forEach((n, p) -> {
            if (p == null) {
                writer.printf("Name: '%s' : no property node present\n", n);
            } else {
                writer.printf("Name: %s, Data Version:%s, Data Timestamp: %s:\n", n, p.getDataVersion(), tsFormat.format(p.getTimestamp()));
                Map<String, String> pMap = p.asMap();
                if (pMap.isEmpty()) {
                    writer.println("-- none --");
                } else {
                    TreeMap<String, String> sorted = new TreeMap<String, String>(pMap);
                    sorted.forEach((name, value) -> writer.printf("%s%s=%s\n", INDENT, name, value));
                }
                writer.println();
            }
        });
    }

    private VersionedProperties fetchSystemProp(InstanceId iid, ZooReader zooReader) throws Exception {
        SystemPropKey propKey = SystemPropKey.of(iid);
        return ZooPropStore.readFromZk(propKey, this.nullWatcher, zooReader);
    }

    private static class NullWatcher
    extends PropStoreWatcher {
        public NullWatcher(ReadyMonitor zkReadyMonitor) {
            super(zkReadyMonitor);
        }
    }

    static class Opts
    extends ConfigOpts {
        @Parameter(names={"--outfile"}, description="Write the output to a file, if the file exists will not be overwritten.")
        public String outfile = "";
        @Parameter(names={"--print-acls"}, description="print the current acls for all ZooKeeper nodes. The acls are evaluated in context of Accumulo operations. Context: ACCUMULO_OKAY | ERROR_ACCUMULO_MISSING_SOME - Accumulo requires cdwra for ZooKeeper  nodes that it uses. PRIVATE | NOT_PRIVATE - other than configuration, most nodes are world read-able (NOT_PRIVATE) to permit client access")
        public boolean printAcls = false;
        @Parameter(names={"--print-id-map"}, description="print the namespace and table id, name mappings stored in ZooKeeper")
        public boolean printIdMap = false;
        @Parameter(names={"--print-props"}, description="print the property values stored in ZooKeeper, can be filtered with --system, --namespaces and --tables options")
        public boolean printProps = false;
        @Parameter(names={"--print-instances"}, description="print the instance ids stored in ZooKeeper")
        public boolean printInstanceIds = false;
        @Parameter(names={"-ns", "--namespaces"}, description="a list of namespace names to print properties, with none specified, print all. Only valid with --print-props", variableArity=true)
        private List<String> namespacesOpt = new ArrayList<String>();
        @Parameter(names={"--system"}, description="print the properties for the system config. Only valid with --print-props")
        private boolean printSystemOpt = false;
        @Parameter(names={"-t", "--tables"}, description="a list of table names to print properties, with none specified, print all. Only valid with --print-props", variableArity=true)
        private List<String> tablesOpt = new ArrayList<String>();

        Opts() {
        }

        boolean printAllProps() {
            return !this.printSystemOpt && this.namespacesOpt.isEmpty() && this.tablesOpt.isEmpty();
        }

        boolean printSysProps() {
            return this.printAllProps() || this.printSystemOpt;
        }

        boolean printNamespaceProps() {
            return this.printAllProps() || !this.namespacesOpt.isEmpty();
        }

        List<String> getNamespaces() {
            return this.namespacesOpt;
        }

        boolean printTableProps() {
            return this.printAllProps() || !this.tablesOpt.isEmpty();
        }

        List<String> getTables() {
            return this.tablesOpt;
        }

        String getOutfile() {
            return this.outfile;
        }
    }
}

