/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.fs;

import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterfaceEvolutionWarner {
    private static final Logger LOG = LoggerFactory.getLogger((String)"accumulo.api.evolution");
    private static final ConcurrentHashMap<String, Boolean> classesWarned = new ConcurrentHashMap();

    static void warnOnce(Class<?> userClass, Class<?> interfaceClass, String interfaceMethod, String version) {
        String interfaceSignature;
        String userClassName = userClass.getName();
        String key = userClassName + ":" + (interfaceSignature = interfaceClass.getName() + "#" + interfaceMethod);
        if (classesWarned.putIfAbsent(key, Boolean.TRUE) == null) {
            LOG.warn("{} must override {} by {}", new Object[]{userClassName, interfaceSignature, version});
        }
    }
}

