/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.noop.NoopCounter;
import io.micrometer.core.instrument.noop.NoopDistributionSummary;
import io.micrometer.core.instrument.noop.NoopFunctionTimer;
import io.micrometer.core.instrument.noop.NoopGauge;
import io.micrometer.core.instrument.noop.NoopTimer;
import java.util.concurrent.atomic.AtomicInteger;

public class NoopMetrics {
    private static final AtomicInteger idCount = new AtomicInteger(0);

    private NoopMetrics() {
    }

    public static Counter useNoopCounter() {
        return new NoopCounter(NoopMetrics.noopId(Meter.Type.COUNTER));
    }

    public static Gauge useNoopGauge() {
        return new NoopGauge(NoopMetrics.noopId(Meter.Type.GAUGE));
    }

    public static DistributionSummary useNoopDistributionSummary() {
        return new NoopDistributionSummary(NoopMetrics.noopId(Meter.Type.DISTRIBUTION_SUMMARY));
    }

    public static Timer useNoopTimer() {
        return new NoopTimer(NoopMetrics.noopId(Meter.Type.TIMER));
    }

    public static FunctionTimer useNoopFunctionTimer() {
        return new NoopFunctionTimer(NoopMetrics.noopId(Meter.Type.TIMER));
    }

    private static Meter.Id noopId(Meter.Type type) {
        return new Meter.Id(NoopMetrics.uniqueName(), Tags.of((String)"noop", (String)"none"), "", "", type);
    }

    private static String uniqueName() {
        return "noop" + idCount.incrementAndGet();
    }
}

