/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.security.handler;

import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.security.NamespacePermission;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.security.handler.Authenticator;
import org.apache.accumulo.server.security.handler.Authorizor;

public interface PermissionHandler {
    public void initialize(ServerContext var1);

    public boolean validSecurityHandlers(Authenticator var1, Authorizor var2);

    public void initializeSecurity(TCredentials var1, String var2) throws AccumuloSecurityException;

    public boolean hasSystemPermission(String var1, SystemPermission var2);

    public boolean hasCachedSystemPermission(String var1, SystemPermission var2);

    public boolean hasTablePermission(String var1, String var2, TablePermission var3) throws TableNotFoundException;

    public boolean hasCachedTablePermission(String var1, String var2, TablePermission var3);

    public boolean hasNamespacePermission(String var1, String var2, NamespacePermission var3) throws NamespaceNotFoundException;

    public boolean hasCachedNamespacePermission(String var1, String var2, NamespacePermission var3);

    public void grantSystemPermission(String var1, SystemPermission var2) throws AccumuloSecurityException;

    public void revokeSystemPermission(String var1, SystemPermission var2) throws AccumuloSecurityException;

    public void grantTablePermission(String var1, String var2, TablePermission var3) throws AccumuloSecurityException, TableNotFoundException;

    public void revokeTablePermission(String var1, String var2, TablePermission var3) throws AccumuloSecurityException, TableNotFoundException;

    public void grantNamespacePermission(String var1, String var2, NamespacePermission var3) throws AccumuloSecurityException, NamespaceNotFoundException;

    public void revokeNamespacePermission(String var1, String var2, NamespacePermission var3) throws AccumuloSecurityException, NamespaceNotFoundException;

    public void cleanTablePermissions(String var1) throws AccumuloSecurityException, TableNotFoundException;

    public void cleanNamespacePermissions(String var1) throws AccumuloSecurityException, NamespaceNotFoundException;

    public void initUser(String var1) throws AccumuloSecurityException;

    public void cleanUser(String var1) throws AccumuloSecurityException;
}

