/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.Parameter;
import com.google.auto.service.AutoService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.stream.StreamSupport;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.start.spi.KeywordExecutable;
import org.apache.hadoop.conf.Configuration;

@AutoService(value={KeywordExecutable.class})
public class ConvertConfig
implements KeywordExecutable {
    public String keyword() {
        return "convert-config";
    }

    public KeywordExecutable.UsageGroup usageGroup() {
        return KeywordExecutable.UsageGroup.OTHER;
    }

    public String description() {
        return "Convert Accumulo configuration from XML to properties";
    }

    private static void writeLine(BufferedWriter w, String value) {
        try {
            w.write(value + "\n");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="code runs in same security context as user who provided input")
    public void execute(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.parseArgs("accumulo convert-config", args, new Object[0]);
        File xmlFile = new File(opts.xmlPath);
        if (!xmlFile.exists()) {
            throw new IllegalArgumentException("xml config file does not exist at " + opts.xmlPath);
        }
        Path propsPath = Paths.get(opts.propsPath, new String[0]);
        if (propsPath.toFile().exists()) {
            throw new IllegalArgumentException("properties file already exists at " + opts.propsPath);
        }
        Configuration xmlConfig = new Configuration(false);
        xmlConfig.addResource(xmlFile.toURI().toURL());
        try (BufferedWriter w = Files.newBufferedWriter(propsPath, StandardCharsets.UTF_8, new OpenOption[0]);){
            StreamSupport.stream(xmlConfig.spliterator(), false).sorted(Map.Entry.comparingByKey()).forEach(e -> ConvertConfig.writeLine(w, e.toString()));
        }
    }

    public static void main(String[] args) throws Exception {
        new ConvertConfig().execute(args);
    }

    static class Opts
    extends Help {
        @Parameter(names={"-x", "-xml", "--xml"}, description="Path of accumulo-site.xml to convert from")
        String xmlPath = "./accumulo-site.xml";
        @Parameter(names={"-p", "-props", "--props"}, description="Path to create new accumulo.properties")
        String propsPath = "./accumulo.properties";

        Opts() {
        }
    }
}

