/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.hadoop.mapred;

import java.io.IOException;
import org.apache.accumulo.core.client.rfile.RFile;
import org.apache.accumulo.core.client.rfile.RFileWriter;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.hadoop.mapreduce.FileOutputFormatBuilder;
import org.apache.accumulo.hadoopImpl.mapreduce.FileOutputFormatBuilderImpl;
import org.apache.accumulo.hadoopImpl.mapreduce.lib.ConfiguratorBase;
import org.apache.accumulo.hadoopImpl.mapreduce.lib.FileOutputConfigurator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;

public class AccumuloFileOutputFormat
extends FileOutputFormat<Key, Value> {
    private static final Class<AccumuloFileOutputFormat> CLASS = AccumuloFileOutputFormat.class;

    public RecordWriter<Key, Value> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) {
        JobConf conf = job;
        AccumuloConfiguration acuConf = FileOutputConfigurator.getAccumuloConfiguration(AccumuloFileOutputFormat.class, (Configuration)job);
        String extension = acuConf.get(Property.TABLE_FILE_TYPE);
        final Path file = new Path(AccumuloFileOutputFormat.getWorkOutputPath((JobConf)job), AccumuloFileOutputFormat.getUniqueName((JobConf)job, (String)"part") + "." + extension);
        int visCacheSize = ConfiguratorBase.getVisibilityCacheSize((Configuration)conf);
        return new RecordWriter<Key, Value>((Configuration)conf, acuConf, visCacheSize){
            RFileWriter out = null;
            final /* synthetic */ Configuration val$conf;
            final /* synthetic */ AccumuloConfiguration val$acuConf;
            final /* synthetic */ int val$visCacheSize;
            {
                this.val$conf = configuration;
                this.val$acuConf = accumuloConfiguration;
                this.val$visCacheSize = n;
            }

            public void close(Reporter reporter) throws IOException {
                if (this.out != null) {
                    this.out.close();
                }
            }

            public void write(Key key, Value value) throws IOException {
                if (this.out == null) {
                    this.out = RFile.newWriter().to(file.toString()).withFileSystem(file.getFileSystem(this.val$conf)).withTableProperties((Iterable)this.val$acuConf).withVisibilityCacheSize(this.val$visCacheSize).build();
                    this.out.startDefaultLocalityGroup();
                }
                this.out.append(key, value);
            }
        };
    }

    public static FileOutputFormatBuilder.PathParams<JobConf> configure() {
        return new FileOutputFormatBuilderImpl<JobConf>(CLASS);
    }
}

