/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.admin;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.admin.InitialTableState;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;
import org.apache.accumulo.core.clientImpl.TableOperationsHelper;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iteratorsImpl.IteratorConfigUtil;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.summary.SummarizerConfigurationUtil;
import org.apache.accumulo.core.util.LocalityGroupUtil;
import org.apache.hadoop.io.Text;

public class NewTableConfiguration {
    private static final TimeType DEFAULT_TIME_TYPE = TimeType.MILLIS;
    private TimeType timeType = DEFAULT_TIME_TYPE;
    private static final InitialTableState DEFAULT_CREATION_MODE = InitialTableState.ONLINE;
    private InitialTableState initialTableState = DEFAULT_CREATION_MODE;
    private boolean limitVersion = true;
    private Map<String, String> properties = Collections.emptyMap();
    private Map<String, String> samplerProps = Collections.emptyMap();
    private Map<String, String> summarizerProps = Collections.emptyMap();
    private Map<String, String> localityProps = Collections.emptyMap();
    private final Map<String, String> iteratorProps = new HashMap<String, String>();
    private SortedSet<Text> splitProps = Collections.emptySortedSet();

    private void checkDisjoint(Map<String, String> props, Map<String, String> derivedProps, String kind) {
        Preconditions.checkArgument((boolean)Collections.disjoint(props.keySet(), derivedProps.keySet()), (String)"Properties and derived %s properties are not disjoint", (Object)kind);
    }

    public NewTableConfiguration setTimeType(TimeType tt) {
        Preconditions.checkArgument((tt != null ? 1 : 0) != 0, (Object)"TimeType is null");
        this.timeType = tt;
        return this;
    }

    public TimeType getTimeType() {
        return this.timeType;
    }

    public NewTableConfiguration withoutDefaultIterators() {
        this.limitVersion = false;
        return this;
    }

    public NewTableConfiguration createOffline() {
        this.initialTableState = InitialTableState.OFFLINE;
        return this;
    }

    public InitialTableState getInitialTableState() {
        return this.initialTableState;
    }

    public NewTableConfiguration setProperties(Map<String, String> props) {
        Preconditions.checkArgument((props != null ? 1 : 0) != 0, (Object)"properties is null");
        this.checkDisjoint(props, this.samplerProps, "sampler");
        this.checkDisjoint(props, this.summarizerProps, "summarizer");
        this.checkDisjoint(props, this.localityProps, "locality group");
        this.checkDisjoint(props, this.iteratorProps, "iterator");
        this.checkTableProperties(props);
        try {
            LocalityGroupUtil.checkLocalityGroups(props);
        }
        catch (LocalityGroupUtil.LocalityGroupConfigurationError e) {
            throw new IllegalArgumentException(e);
        }
        this.properties = new HashMap<String, String>(props);
        return this;
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        if (this.limitVersion) {
            propertyMap.putAll(IteratorConfigUtil.generateInitialTableProperties(this.limitVersion));
        }
        propertyMap.putAll(this.summarizerProps);
        propertyMap.putAll(this.samplerProps);
        propertyMap.putAll(this.properties);
        propertyMap.putAll(this.iteratorProps);
        propertyMap.putAll(this.localityProps);
        return Collections.unmodifiableMap(propertyMap);
    }

    public Collection<Text> getSplits() {
        return this.splitProps;
    }

    public NewTableConfiguration enableSampling(SamplerConfiguration samplerConfiguration) {
        Objects.requireNonNull(samplerConfiguration);
        Map<String, String> tmp = new SamplerConfigurationImpl(samplerConfiguration).toTablePropertiesMap();
        this.checkDisjoint(this.properties, tmp, "sampler");
        this.samplerProps = tmp;
        return this;
    }

    public NewTableConfiguration enableSummarization(SummarizerConfiguration ... configs) {
        Objects.requireNonNull(configs);
        Map<String, String> tmp = SummarizerConfigurationUtil.toTablePropertiesMap(Arrays.asList(configs));
        this.checkDisjoint(this.properties, tmp, "summarizer");
        this.summarizerProps = tmp;
        return this;
    }

    public NewTableConfiguration setLocalityGroups(Map<String, Set<Text>> groups) {
        LocalityGroupUtil.ensureNonOverlappingGroups(groups);
        HashMap<String, String> tmp = new HashMap<String, String>();
        for (Map.Entry<String, Set<Text>> entry : groups.entrySet()) {
            Set<Text> colFams = entry.getValue();
            String value = LocalityGroupUtil.encodeColumnFamilies(colFams);
            tmp.put(String.valueOf((Object)Property.TABLE_LOCALITY_GROUP_PREFIX) + entry.getKey(), value);
        }
        tmp.put(Property.TABLE_LOCALITY_GROUPS.getKey(), String.join((CharSequence)",", groups.keySet()));
        this.checkDisjoint(this.properties, tmp, "locality groups");
        this.localityProps = tmp;
        return this;
    }

    public NewTableConfiguration withSplits(SortedSet<Text> splits) {
        Preconditions.checkArgument((splits != null ? 1 : 0) != 0, (Object)"splits set is null");
        Preconditions.checkArgument((!splits.isEmpty() ? 1 : 0) != 0, (Object)"splits set is empty");
        this.splitProps = ImmutableSortedSet.copyOf(splits);
        return this;
    }

    public NewTableConfiguration attachIterator(IteratorSetting setting) {
        return this.attachIterator(setting, EnumSet.allOf(IteratorUtil.IteratorScope.class));
    }

    public NewTableConfiguration attachIterator(IteratorSetting setting, EnumSet<IteratorUtil.IteratorScope> scopes) {
        Objects.requireNonNull(setting, "setting cannot be null!");
        Objects.requireNonNull(scopes, "scopes cannot be null!");
        try {
            TableOperationsHelper.checkIteratorConflicts(this.iteratorProps, setting, scopes);
        }
        catch (AccumuloException e) {
            throw new IllegalArgumentException("The specified IteratorSetting conflicts with an iterator already defined on this NewTableConfiguration", e);
        }
        for (IteratorUtil.IteratorScope scope : scopes) {
            String root = String.format("%s%s.%s", new Object[]{Property.TABLE_ITERATOR_PREFIX, scope.name().toLowerCase(), setting.getName()});
            for (Map.Entry<String, String> prop : setting.getOptions().entrySet()) {
                this.iteratorProps.put(root + ".opt." + prop.getKey(), prop.getValue());
            }
            this.iteratorProps.put(root, setting.getPriority() + "," + setting.getIteratorClass());
            this.checkDisjoint(this.properties, this.iteratorProps, "iterator");
        }
        return this;
    }

    private void checkTableProperties(Map<String, String> props) {
        props.keySet().forEach(key -> {
            if (!key.startsWith(Property.TABLE_PREFIX.toString())) {
                throw new IllegalArgumentException("'" + key + "' is not a valid table property");
            }
        });
    }
}

