/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import com.google.common.base.Preconditions;
import org.apache.accumulo.core.client.admin.ImportConfiguration;

public class ImportConfigurationImpl
implements ImportConfiguration,
ImportConfiguration.Builder {
    private boolean built = false;
    private boolean keepOffline = false;
    private boolean keepMappingsFile = false;
    private static final String BUILT_ERROR_MSG = "ImportConfiguration was already built";
    private static final String NOT_BUILT_ERROR_MSG = "ImportConfiguration was not built yet";

    @Override
    public ImportConfiguration.Builder setKeepOffline(boolean keepOffline) {
        Preconditions.checkState((!this.built ? 1 : 0) != 0, (Object)BUILT_ERROR_MSG);
        this.keepOffline = keepOffline;
        return this;
    }

    @Override
    public ImportConfiguration.Builder setKeepMappings(boolean keepMappings) {
        Preconditions.checkState((!this.built ? 1 : 0) != 0, (Object)BUILT_ERROR_MSG);
        this.keepMappingsFile = keepMappings;
        return this;
    }

    @Override
    public ImportConfiguration build() {
        this.built = true;
        return this;
    }

    @Override
    public boolean isKeepOffline() {
        Preconditions.checkState((boolean)this.built, (Object)NOT_BUILT_ERROR_MSG);
        return this.keepOffline;
    }

    @Override
    public boolean isKeepMappings() {
        Preconditions.checkState((boolean)this.built, (Object)NOT_BUILT_ERROR_MSG);
        return this.keepMappingsFile;
    }
}

