/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.accumulo.core.clientImpl.ScanServerAttemptImpl;
import org.apache.accumulo.core.clientImpl.ScanServerAttemptReporter;
import org.apache.accumulo.core.data.TabletId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanServerAttemptsImpl {
    private static final Logger LOG = LoggerFactory.getLogger(ScanServerAttemptsImpl.class);
    private final Map<TabletId, Collection<ScanServerAttemptImpl>> attempts = new HashMap<TabletId, Collection<ScanServerAttemptImpl>>();

    ScanServerAttemptReporter createReporter(String server, TabletId tablet) {
        return result -> {
            LOG.trace("Received result: {}", (Object)result);
            Map<TabletId, Collection<ScanServerAttemptImpl>> map = this.attempts;
            synchronized (map) {
                this.attempts.computeIfAbsent(tablet, k -> new ArrayList()).add(new ScanServerAttemptImpl(result, server));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<TabletId, Collection<ScanServerAttemptImpl>> snapshot() {
        Map<TabletId, Collection<ScanServerAttemptImpl>> map = this.attempts;
        synchronized (map) {
            return this.attempts.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entry -> List.copyOf((Collection)entry.getValue())));
        }
    }
}

