/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopCredentialProvider {
    private static final Logger log = LoggerFactory.getLogger(HadoopCredentialProvider.class);
    private static final String CREDENTIAL_PROVIDER_PATH = "hadoop.security.credential.provider.path";
    private static final ConcurrentHashMap<String, List<CredentialProvider>> cachedProviders = new ConcurrentHashMap();

    public static void setPath(Configuration conf, String path) {
        conf.set(CREDENTIAL_PROVIDER_PATH, path);
    }

    private static List<CredentialProvider> getProviders(Configuration conf) {
        List providers;
        String path = conf.get(CREDENTIAL_PROVIDER_PATH);
        if (path == null || path.isEmpty()) {
            log.debug("Failed to get CredentialProviders; no provider path specified");
            return null;
        }
        try {
            providers = CredentialProviderFactory.getProviders((Configuration)conf);
        }
        catch (IOException e) {
            log.warn("Exception invoking CredentialProviderFactory.getProviders(conf)", (Throwable)e);
            return null;
        }
        return cachedProviders.computeIfAbsent(path, p -> providers);
    }

    public static char[] getValue(Configuration conf, String alias) {
        Objects.requireNonNull(alias);
        List<CredentialProvider> providerList = HadoopCredentialProvider.getProviders(Objects.requireNonNull(conf));
        return providerList == null ? null : providerList.stream().map(provider -> {
            try {
                return provider.getCredentialEntry(alias);
            }
            catch (IOException e) {
                log.warn("Failed to call getCredentialEntry(alias) for provider {}", provider, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).map(CredentialProvider.CredentialEntry::getCredential).findFirst().orElseGet(() -> {
            log.trace("Could not extract credential for {} from providers", (Object)alias);
            return null;
        });
    }

    public static List<String> getKeys(Configuration conf) {
        List<CredentialProvider> providerList = HadoopCredentialProvider.getProviders(Objects.requireNonNull(conf));
        return providerList == null ? Collections.emptyList() : providerList.stream().flatMap(provider -> {
            List aliases = null;
            try {
                aliases = provider.getAliases();
            }
            catch (IOException e) {
                log.warn("Problem getting aliases from provider {}", provider, (Object)e);
            }
            return aliases == null ? Stream.empty() : aliases.stream();
        }).collect(Collectors.toList());
    }

    public static void createEntry(Configuration conf, String name, char[] credential) throws IOException {
        Objects.requireNonNull(conf);
        Objects.requireNonNull(name);
        Objects.requireNonNull(credential);
        List<CredentialProvider> providers = HadoopCredentialProvider.getProviders(conf);
        if (providers == null || providers.isEmpty()) {
            throw new IOException("Could not fetch any CredentialProviders");
        }
        CredentialProvider provider = providers.get(0);
        if (providers.size() != 1) {
            log.warn("Found more than one CredentialProvider. Using first provider found ({})", (Object)provider);
        }
        provider.createCredentialEntry(name, credential);
        provider.flush();
    }
}

