/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.rfile;

import com.beust.jcommander.Parameter;
import com.google.auto.service.AutoService;
import java.util.ArrayList;
import java.util.List;
import org.apache.accumulo.core.cli.ConfigOpts;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.crypto.CryptoFactoryLoader;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.blockfile.impl.CachableBlockFile;
import org.apache.accumulo.core.file.rfile.RFile;
import org.apache.accumulo.core.file.rfile.bcfile.BCFile;
import org.apache.accumulo.core.spi.crypto.CryptoService;
import org.apache.accumulo.start.spi.KeywordExecutable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

@AutoService(value={KeywordExecutable.class})
public class SplitLarge
implements KeywordExecutable {
    public static void main(String[] args) throws Exception {
        new SplitLarge().execute(args);
    }

    public String keyword() {
        return "split-large";
    }

    public String description() {
        return "Splits an RFile into large and small key/value files";
    }

    public void execute(String[] args) throws Exception {
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Opts opts = new Opts();
        opts.parseArgs("accumulo split-large", args, new Object[0]);
        for (String file : opts.files) {
            SiteConfiguration aconf = opts.getSiteConfiguration();
            CryptoService cs = CryptoFactoryLoader.getServiceForServer(aconf);
            Path path = new Path(file);
            CachableBlockFile.CachableBuilder cb = new CachableBlockFile.CachableBuilder().fsPath(fs, path).conf(conf).cryptoService(cs);
            try (RFile.Reader iter = new RFile.Reader(cb);){
                if (!file.endsWith(".rf")) {
                    throw new IllegalArgumentException("File must end with .rf");
                }
                String smallName = file.substring(0, file.length() - 3) + "_small.rf";
                String largeName = file.substring(0, file.length() - 3) + "_large.rf";
                int blockSize = (int)aconf.getAsBytes(Property.TABLE_FILE_BLOCK_SIZE);
                try (RFile.Writer small = new RFile.Writer(new BCFile.Writer(fs.create(new Path(smallName)), null, "gz", conf, cs), blockSize);
                     RFile.Writer large = new RFile.Writer(new BCFile.Writer(fs.create(new Path(largeName)), null, "gz", conf, cs), blockSize);){
                    small.startDefaultLocalityGroup();
                    large.startDefaultLocalityGroup();
                    iter.seek(new Range(), new ArrayList<ByteSequence>(), false);
                    while (iter.hasTop()) {
                        Key key = iter.getTopKey();
                        Value value = iter.getTopValue();
                        if ((long)(key.getSize() + value.getSize()) < opts.maxSize) {
                            small.append(key, value);
                        } else {
                            large.append(key, value);
                        }
                        iter.next();
                    }
                }
            }
        }
    }

    static class Opts
    extends ConfigOpts {
        @Parameter(names={"-m"}, description="the maximum size of the key/value pair to shunt to the small file")
        long maxSize = 0xA00000L;
        @Parameter(description="<file.rf> { <file.rf> ... }")
        List<String> files = new ArrayList<String>();

        Opts() {
        }
    }
}

