/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators;

import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;

public class IteratorUtil {
    public static Range maximizeStartKeyTimeStamp(Range range) {
        Range seekRange = range;
        if (range.getStartKey() != null) {
            Key seekKey = range.getStartKey();
            if (range.getStartKey().getTimestamp() != Long.MAX_VALUE) {
                seekKey = new Key(seekRange.getStartKey());
                seekKey.setTimestamp(Long.MAX_VALUE);
                seekRange = new Range(seekKey, true, range.getEndKey(), range.isEndKeyInclusive());
            } else if (!range.isStartKeyInclusive()) {
                seekRange = new Range(seekKey, true, range.getEndKey(), range.isEndKeyInclusive());
            }
        }
        return seekRange;
    }

    public static Range minimizeEndKeyTimeStamp(Range range) {
        Range seekRange = range;
        if (range.getEndKey() != null) {
            Key seekKey = seekRange.getEndKey();
            if (range.getEndKey().getTimestamp() != Long.MIN_VALUE) {
                seekKey = new Key(seekRange.getEndKey());
                seekKey.setTimestamp(Long.MIN_VALUE);
                seekRange = new Range(range.getStartKey(), range.isStartKeyInclusive(), seekKey, true);
            } else if (!range.isEndKeyInclusive()) {
                seekRange = new Range(range.getStartKey(), range.isStartKeyInclusive(), seekKey, true);
            }
        }
        return seekRange;
    }

    public static enum IteratorScope {
        majc,
        minc,
        scan;

    }
}

