/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.manager.balancer;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.accumulo.core.manager.balancer.TableStatisticsImpl;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.spi.balancer.data.TServerStatus;
import org.apache.accumulo.core.spi.balancer.data.TableStatistics;

public class TServerStatusImpl
implements TServerStatus {
    private final TabletServerStatus thriftStatus;
    private Map<String, TableStatistics> tableInfoMap;

    public static TServerStatusImpl fromThrift(TabletServerStatus tss) {
        return tss == null ? null : new TServerStatusImpl(tss);
    }

    public TServerStatusImpl(TabletServerStatus thriftStatus) {
        this.thriftStatus = Objects.requireNonNull(thriftStatus);
        if (thriftStatus.getTableMap() == null) {
            this.tableInfoMap = null;
        } else {
            this.tableInfoMap = new HashMap<String, TableStatistics>();
            thriftStatus.getTableMap().forEach((name, info) -> this.tableInfoMap.put((String)name, TableStatisticsImpl.fromThrift(info)));
        }
    }

    @Override
    public Map<String, TableStatistics> getTableMap() {
        return this.tableInfoMap;
    }

    public void setTableMap(Map<String, TableStatistics> tableInfoMap) {
        this.tableInfoMap = tableInfoMap;
    }

    @Override
    public long getLastContact() {
        return this.thriftStatus.getLastContact();
    }

    @Override
    public String getName() {
        return this.thriftStatus.getName();
    }

    @Override
    public double getOsLoad() {
        return this.thriftStatus.getOsLoad();
    }

    @Override
    public long getHoldTime() {
        return this.thriftStatus.getHoldTime();
    }

    @Override
    public long getLookups() {
        return this.thriftStatus.getLookups();
    }

    @Override
    public long getIndexCacheHits() {
        return this.thriftStatus.getIndexCacheHits();
    }

    @Override
    public long getIndexCacheRequests() {
        return this.thriftStatus.getIndexCacheRequest();
    }

    @Override
    public long getDataCacheHits() {
        return this.thriftStatus.getDataCacheHits();
    }

    @Override
    public long getDataCacheRequests() {
        return this.thriftStatus.getDataCacheRequest();
    }

    @Override
    public long getFlushes() {
        return this.thriftStatus.getFlushs();
    }

    @Override
    public long getSyncs() {
        return this.thriftStatus.getSyncs();
    }

    @Override
    public String getVersion() {
        return this.thriftStatus.getVersion();
    }

    @Override
    public long getResponseTime() {
        return this.thriftStatus.getResponseTime();
    }

    @Override
    public int compareTo(TServerStatus o) {
        return this.thriftStatus.compareTo(((TServerStatusImpl)o).thriftStatus);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TServerStatusImpl that = (TServerStatusImpl)o;
        return this.thriftStatus.equals(that.thriftStatus);
    }

    public int hashCode() {
        return this.thriftStatus.hashCode();
    }

    public String toString() {
        return this.thriftStatus.toString();
    }

    public TabletServerStatus toThrift() {
        return this.thriftStatus;
    }
}

