/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata;

import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.MetadataServicer;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.hadoop.io.Text;

abstract class TableMetadataServicer
extends MetadataServicer {
    private final ClientContext context;
    private final TableId tableIdBeingServiced;
    private final String serviceTableName;

    public TableMetadataServicer(ClientContext context, String serviceTableName, TableId tableIdBeingServiced) {
        this.context = context;
        this.serviceTableName = serviceTableName;
        this.tableIdBeingServiced = tableIdBeingServiced;
    }

    @Override
    public TableId getServicedTableId() {
        return this.tableIdBeingServiced;
    }

    public String getServicingTableName() {
        return this.serviceTableName;
    }

    @Override
    public void getTabletLocations(SortedMap<KeyExtent, String> tablets) throws AccumuloException, TableNotFoundException {
        Scanner scanner = this.context.createScanner(this.getServicingTableName(), Authorizations.EMPTY);
        MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.fetch(scanner);
        scanner.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
        scanner.setRange(MetadataSchema.TabletsSection.getRange(this.getServicedTableId()));
        Text colf = new Text();
        Text colq = new Text();
        String location = null;
        Text row = null;
        for (Map.Entry<Key, Value> entry : scanner) {
            if (row != null) {
                if (!row.equals((Object)entry.getKey().getRow())) {
                    location = null;
                    row = entry.getKey().getRow();
                }
            } else {
                row = entry.getKey().getRow();
            }
            if (MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.equals(colf = entry.getKey().getColumnFamily(colf), colq = entry.getKey().getColumnQualifier(colq))) {
                KeyExtent currentKeyExtent = KeyExtent.fromMetaPrevRow(entry);
                tablets.put(currentKeyExtent, location);
                location = null;
                continue;
            }
            if (!colf.equals((Object)MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME)) continue;
            location = entry.getValue().toString();
        }
        this.validateEntries(tablets);
    }

    private void validateEntries(SortedMap<KeyExtent, String> tablets) throws AccumuloException {
        SortedSet tabletsKeys = (SortedSet)tablets.keySet();
        if (tabletsKeys.isEmpty()) {
            throw new AccumuloException("No entries found in metadata table for table " + String.valueOf(this.getServicedTableId()));
        }
        if (((KeyExtent)tabletsKeys.first()).prevEndRow() != null) {
            throw new AccumuloException("Problem with metadata table, first entry for table " + String.valueOf(this.getServicedTableId()) + "- " + String.valueOf(tabletsKeys.first()) + " - has non null prev end row");
        }
        if (((KeyExtent)tabletsKeys.last()).endRow() != null) {
            throw new AccumuloException("Problem with metadata table, last entry for table " + String.valueOf(this.getServicedTableId()) + "- " + String.valueOf(tabletsKeys.first()) + " - has non null end row");
        }
        Iterator tabIter = tabletsKeys.iterator();
        Text lastEndRow = ((KeyExtent)tabIter.next()).endRow();
        while (tabIter.hasNext()) {
            KeyExtent tabke = (KeyExtent)tabIter.next();
            if (tabke.prevEndRow() == null) {
                throw new AccumuloException("Problem with metadata table, it has null prev end row in middle of table " + String.valueOf(tabke));
            }
            if (!tabke.prevEndRow().equals((Object)lastEndRow)) {
                throw new AccumuloException("Problem with metadata table, it has a hole " + String.valueOf(tabke.prevEndRow()) + " != " + String.valueOf(lastEndRow));
            }
            lastEndRow = tabke.endRow();
        }
    }
}

