/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.rpc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.spi.SelectorProvider;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.hadoop.net.NetUtils;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TTimeoutTransport {
    private static final Logger log = LoggerFactory.getLogger(TTimeoutTransport.class);
    private static final TTimeoutTransport INSTANCE = new TTimeoutTransport();

    private TTimeoutTransport() {
    }

    public static TTransport create(HostAndPort addr, long timeoutMillis) throws TTransportException {
        return INSTANCE.createInternal(new InetSocketAddress(addr.getHost(), addr.getPort()), timeoutMillis);
    }

    TTransport createInternal(SocketAddress addr, long timeoutMillis) throws TTransportException {
        Socket socket = null;
        try {
            socket = this.openSocket(addr, (int)timeoutMillis);
        }
        catch (IOException e) {
            ThriftUtil.checkIOExceptionCause(e);
            throw new TTransportException((Throwable)e);
        }
        assert (socket != null);
        try {
            InputStream input = this.wrapInputStream(socket, timeoutMillis);
            OutputStream output = this.wrapOutputStream(socket, timeoutMillis);
            return new TIOStreamTransport(input, output);
        }
        catch (IOException e) {
            this.closeSocket(socket, e);
            ThriftUtil.checkIOExceptionCause(e);
            throw new TTransportException((Throwable)e);
        }
        catch (TTransportException e) {
            this.closeSocket(socket, (Exception)((Object)e));
            throw e;
        }
    }

    private void closeSocket(Socket socket, Exception e) {
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (IOException ioe) {
            e.addSuppressed(ioe);
            log.error("Failed to close socket after unsuccessful I/O stream setup", (Throwable)e);
        }
    }

    InputStream wrapInputStream(Socket socket, long timeoutMillis) throws IOException {
        return new BufferedInputStream((InputStream)NetUtils.getInputStream((Socket)socket, (long)timeoutMillis), 10240);
    }

    OutputStream wrapOutputStream(Socket socket, long timeoutMillis) throws IOException {
        return new BufferedOutputStream(NetUtils.getOutputStream((Socket)socket, (long)timeoutMillis), 10240);
    }

    Socket openSocket(SocketAddress addr, int timeoutMillis) throws IOException {
        Socket socket = null;
        try {
            socket = this.openSocketChannel();
            socket.setSoLinger(false, 0);
            socket.setTcpNoDelay(true);
            socket.connect(addr, timeoutMillis);
            return socket;
        }
        catch (IOException e) {
            this.closeSocket(socket, e);
            throw e;
        }
    }

    Socket openSocketChannel() throws IOException {
        return SelectorProvider.provider().openSocketChannel().socket();
    }
}

