/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.rpc.clients;

import java.util.ConcurrentModificationException;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.thrift.ThriftConcurrentModificationException;
import org.apache.accumulo.core.clientImpl.thrift.ThriftNotActiveServiceException;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.clientImpl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.manager.thrift.ManagerClientService;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ManagerClient;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagerThriftClient
extends ThriftClientTypes<ManagerClientService.Client>
implements ManagerClient<ManagerClientService.Client> {
    private static final Logger LOG = LoggerFactory.getLogger(ManagerThriftClient.class);

    ManagerThriftClient(String serviceName) {
        super(serviceName, new ManagerClientService.Client.Factory());
    }

    @Override
    public ManagerClientService.Client getConnection(ClientContext context) {
        return this.getManagerConnection(LOG, this, context);
    }

    public <R> R executeTableCommand(ClientContext context, ThriftClientTypes.Exec<R, ManagerClientService.Client> exec) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        ManagerClientService.Client client = null;
        while (true) {
            try {
                client = (ManagerClientService.Client)this.getConnectionWithRetry(context);
                R r = exec.execute(client);
                return r;
            }
            catch (TTransportException tte) {
                LOG.debug("ManagerClient request failed, retrying ... ", (Throwable)tte);
                UtilWaitThread.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
                continue;
            }
            catch (ThriftSecurityException e) {
                throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
            }
            catch (ThriftTableOperationException e) {
                switch (e.getType()) {
                    case NAMESPACE_NOTFOUND: {
                        throw new TableNotFoundException(e.getTableName(), new NamespaceNotFoundException(e));
                    }
                    case NOTFOUND: {
                        throw new TableNotFoundException(e);
                    }
                }
                throw new AccumuloException((Throwable)((Object)e));
            }
            catch (ThriftNotActiveServiceException e) {
                LOG.debug("Contacted a Manager which is no longer active, retrying");
                UtilWaitThread.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
                continue;
            }
            catch (ThriftConcurrentModificationException e) {
                throw new ConcurrentModificationException(e.getMessage(), (Throwable)((Object)e));
            }
            catch (Exception e) {
                throw new AccumuloException(e);
            }
            finally {
                if (client == null) continue;
                ThriftUtil.close(client, context);
                continue;
            }
            break;
        }
    }

    @Override
    public <R> R execute(ClientContext context, ThriftClientTypes.Exec<R, ManagerClientService.Client> exec) throws AccumuloException, AccumuloSecurityException {
        try {
            return this.executeTableCommand(context, exec);
        }
        catch (TableNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void executeVoidTableCommand(ClientContext context, ThriftClientTypes.ExecVoid<ManagerClientService.Client> exec) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        ManagerClientService.Client client = null;
        while (true) {
            try {
                client = (ManagerClientService.Client)this.getConnectionWithRetry(context);
                exec.execute(client);
                return;
            }
            catch (TTransportException tte) {
                LOG.debug("ManagerClient request failed, retrying ... ", (Throwable)tte);
                UtilWaitThread.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
                continue;
            }
            catch (ThriftSecurityException e) {
                throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
            }
            catch (ThriftTableOperationException e) {
                switch (e.getType()) {
                    case NAMESPACE_NOTFOUND: {
                        throw new TableNotFoundException(e.getTableName(), new NamespaceNotFoundException(e));
                    }
                    case NOTFOUND: {
                        throw new TableNotFoundException(e);
                    }
                }
                throw new AccumuloException((Throwable)((Object)e));
            }
            catch (ThriftNotActiveServiceException e) {
                LOG.debug("Contacted a Manager which is no longer active, retrying");
                UtilWaitThread.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
                continue;
            }
            catch (ThriftConcurrentModificationException e) {
                throw new ConcurrentModificationException(e.getMessage(), (Throwable)((Object)e));
            }
            catch (Exception e) {
                throw new AccumuloException(e);
            }
            finally {
                if (client == null) continue;
                ThriftUtil.close(client, context);
                continue;
            }
            break;
        }
    }

    @Override
    public void executeVoid(ClientContext context, ThriftClientTypes.ExecVoid<ManagerClientService.Client> exec) throws AccumuloException, AccumuloSecurityException {
        try {
            this.executeVoidTableCommand(context, exec);
        }
        catch (TableNotFoundException e) {
            throw new AccumuloException(e);
        }
    }
}

