/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.spi.scan;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import org.apache.accumulo.core.spi.scan.ScanInfo;
import org.apache.accumulo.core.spi.scan.ScanPrioritizer;

public class IdleRatioScanPrioritizer
implements ScanPrioritizer {
    private static double idleRatio(long currTime, ScanInfo si) {
        double totalRunTime = si.getRunTimeStats().sum();
        double totalIdleTime = Math.max(1L, si.getIdleTimeStats(currTime).sum());
        return totalRunTime / totalIdleTime;
    }

    @Override
    public Comparator<ScanInfo> createComparator(ScanPrioritizer.CreateParameters params) {
        Preconditions.checkArgument((boolean)params.getOptions().isEmpty());
        Comparator c1 = (si1, si2) -> {
            long currTime = System.currentTimeMillis();
            return Double.compare(IdleRatioScanPrioritizer.idleRatio(currTime, si1), IdleRatioScanPrioritizer.idleRatio(currTime, si2));
        };
        return c1.thenComparingLong(si -> si.getLastRunTime().orElse(0L)).thenComparingLong(ScanInfo::getCreationTime);
    }
}

