/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.mvc.internal;

import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Variant;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.internal.util.collection.Refs;
import org.glassfish.jersey.message.internal.InboundMessageContext;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.message.internal.VariantSelector;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.server.mvc.Template;
import org.glassfish.jersey.server.mvc.Viewable;

public final class TemplateHelper {
    private static final Charset DEFAULT_ENCODING = Charset.forName("UTF-8");

    public static String getAbsolutePath(Class<?> resourceClass, String path, char delim) {
        return '/' + resourceClass.getName().replace('.', '/').replace('$', delim) + delim + path;
    }

    public static List<MediaType> getProducibleMediaTypes(ContainerRequest containerRequest, ExtendedUriInfo extendedUriInfo, Ref<String> varyHeaderValue) {
        List<MediaType> producedTypes = TemplateHelper.getResourceMethodProducibleTypes(extendedUriInfo);
        MediaType[] mediaTypes = producedTypes.toArray(new MediaType[producedTypes.size()]);
        List variants = VariantSelector.selectVariants((InboundMessageContext)containerRequest, (List)Variant.mediaTypes((MediaType[])mediaTypes).build(), varyHeaderValue == null ? Refs.emptyRef() : varyHeaderValue);
        return variants.stream().map(variant -> MediaTypes.stripQualityParams((MediaType)variant.getMediaType())).collect(Collectors.toList());
    }

    public static String getTemplateName(Viewable viewable) {
        return viewable.getTemplateName() == null || viewable.getTemplateName().isEmpty() ? "index" : viewable.getTemplateName();
    }

    private static List<MediaType> getResourceMethodProducibleTypes(ExtendedUriInfo extendedUriInfo) {
        if (extendedUriInfo.getMatchedResourceMethod() != null && !extendedUriInfo.getMatchedResourceMethod().getProducedTypes().isEmpty()) {
            return extendedUriInfo.getMatchedResourceMethod().getProducedTypes();
        }
        return Arrays.asList(MediaType.WILDCARD_TYPE);
    }

    public static Template getTemplateAnnotation(Annotation[] annotations) {
        if (annotations != null && annotations.length > 0) {
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof Template)) continue;
                return (Template)annotation;
            }
        }
        return null;
    }

    public static Charset getTemplateOutputEncoding(Configuration configuration, String suffix) {
        String enc = (String)PropertiesHelper.getValue((Map)configuration.getProperties(), (String)("jersey.config.server.mvc.encoding" + suffix), String.class, null);
        if (enc == null) {
            return DEFAULT_ENCODING;
        }
        return Charset.forName(enc);
    }

    private TemplateHelper() {
    }
}

