<?php
namespace Airavata\API;
/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
use Thrift\Base\TBase;
use Thrift\Type\TType;
use Thrift\Type\TMessageType;
use Thrift\Exception\TException;
use Thrift\Exception\TProtocolException;
use Thrift\Protocol\TProtocol;
use Thrift\Protocol\TBinaryProtocolAccelerated;
use Thrift\Exception\TApplicationException;


interface AiravataIf {
  /**
   * Fetch Apache Airavata API version
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getAPIVersion(\Airavata\Model\Security\AuthzToken $authzToken);
  /**
   * Verify if User Exists within Airavata.
   * 
   * @param gatewayId
   * 
   *  @param userName
   * 
   * @return true/false
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayId
   * @param string $userName
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function isUserExists(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $userName);
  /**
   * Register a Gateway with Airavata.
   * 
   * @param gateway
   *    The gateway data model.
   * 
   * @return gatewayId
   *   Th unique identifier of the  newly registered gateway.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param \Airavata\Model\Workspace\Gateway $gateway
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function addGateway(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\Workspace\Gateway $gateway);
  /**
   * Get all users in the gateway
   * 
   * @param gatewayId
   *    The gateway data model.
   * 
   * @return users
   *   list of usernames of the users in the gateway
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayId
   * @return string[]
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getAllUsersInGateway(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId);
  /**
   * Update previously registered Gateway metadata.
   * 
   * @param gatewayId
   *    The gateway Id of the Gateway which require an update.
   * 
   * @return gateway
   *    Modified gateway obejct.
   * 
   * @exception AiravataClientException
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayId
   * @param \Airavata\Model\Workspace\Gateway $updatedGateway
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function updateGateway(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, \Airavata\Model\Workspace\Gateway $updatedGateway);
  /**
   * Get Gateway details by providing gatewayId
   * 
   * @param gatewayId
   *    The gateway Id of the Gateway.
   * 
   * @return gateway
   *    Gateway obejct.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayId
   * @return \Airavata\Model\Workspace\Gateway
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getGateway(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId);
  /**
   * Delete a Gateway
   * 
   * @param gatewayId
   *    The gateway Id of the Gateway to be deleted.
   * 
   * @return boolean
   *    Boolean identifier for the success or failure of the deletion operation.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayId
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function deleteGateway(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId);
  /**
   * Get All the Gateways Connected to Airavata.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @return \Airavata\Model\Workspace\Gateway[]
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getAllGateways(\Airavata\Model\Security\AuthzToken $authzToken);
  /**
   * Check for the Existance of a Gateway within Airavata
   * 
   * @param gatewayId
   *   Provide the gatewayId of the gateway you want to check the existancy
   * 
   * @return boolean
   *   Boolean idetifier for the existance or non-existane of the gatewayId
   * 
   * @return gatewayId
   *   return the gatewayId of the existing gateway.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayId
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function isGatewayExist(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId);
  /**
   *   * API methods to retrieve notifications
   * *
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param \Airavata\Model\Workspace\Notification $notification
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function createNotification(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\Workspace\Notification $notification);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param \Airavata\Model\Workspace\Notification $notification
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function updateNotification(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\Workspace\Notification $notification);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayId
   * @param string $notificationId
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function deleteNotification(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $notificationId);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayId
   * @param string $notificationId
   * @return \Airavata\Model\Workspace\Notification
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getNotification(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $notificationId);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayId
   * @return \Airavata\Model\Workspace\Notification[]
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getAllNotifications(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId);
  /**
   * Generate and Register SSH Key Pair with Airavata Credential Store.
   * 
   * @param gatewayId
   *    The identifier for the requested Gateway.
   * 
   * @param userName
   *    The User for which the credential should be registered. For community accounts, this user is the name of the
   *    community user name. For computational resources, this user name need not be the same user name on resoruces.
   * 
   * @param description
   *    The description field for a credential type, all type of credential can have a description.
   * 
   * @param credentialOwnerType
   *    The type of owner of this credential. Two possible values: GATEWAY (default) and USER
   * 
   * @return airavataCredStoreToken
   *   An SSH Key pair is generated and stored in the credential store and associated with users or community account
   *   belonging to a Gateway.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayId
   * @param string $userName
   * @param string $description
   * @param int $credentialOwnerType
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   */
  public function generateAndRegisterSSHKeys(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $userName, $description, $credentialOwnerType);
  /**
   * Generate and Register Username PWD Pair with Airavata Credential Store.
   * 
   * @param gatewayId
   *    The identifier for the requested Gateway.
   * 
   * @param portalUserName
   *    The User for which the credential should be registered. For community accounts, this user is the name of the
   *    community user name. For computational resources, this user name need not be the same user name on resoruces.
   * 
   * @param loginUserName
   * 
   * @param password
   * 
   * @return airavataCredStoreToken
   *   An SSH Key pair is generated and stored in the credential store and associated with users or community account
   *   belonging to a Gateway.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayId
   * @param string $portalUserName
   * @param string $loginUserName
   * @param string $password
   * @param string $description
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   */
  public function registerPwdCredential(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $portalUserName, $loginUserName, $password, $description);
  /**
   * Get a Public Key by Providing the Token
   * 
   * @param CredStoreToken
   *    Credential Store Token which you want to find the Public Key for.
   * 
   * @param gatewayId
   *    This is the unique identifier of your gateway where the token and public key was generated from.
   * 
   * @return publicKey
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $airavataCredStoreToken
   * @param string $gatewayId
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   */
  public function getSSHPubKey(\Airavata\Model\Security\AuthzToken $authzToken, $airavataCredStoreToken, $gatewayId);
  /**
   * 
   * Get all Public Keys of the Gateway
   * 
   * @param CredStoreToken
   *    Credential Store Token which you want to find the Public Key for.
   * 
   * @param gatewayId
   *    This is the unique identifier of your gateway where the token and public key was generated from.
   * 
   * @return publicKey
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayId
   * @return array
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   */
  public function getAllGatewaySSHPubKeys(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId);
  /**
   * 
   * Get all Credential summaries for the Gateway
   * 
   * @param CredStoreToken
   *    Credential Store Token which you want to find the Public Key for.
   * 
   * @param credential_store_data_models.SummaryType
   *    Summary type : SSH,PASSWD or CERT
   * 
   * @param gatewayId
   *    This is the unique identifier of your gateway where the token and public key was generated from.
   * 
   * @return List of Credential Summary Objects
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param int $type
   * @param string $gatewayId
   * @return \Airavata\Model\Credential\Store\CredentialSummary[]
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   */
  public function getAllCredentialSummaryForGateway(\Airavata\Model\Security\AuthzToken $authzToken, $type, $gatewayId);
  /**
   * 
   * Get all Credential summaries for user in a Gateway
   * 
   * @param CredStoreToken
   *    Credential Store Token which you want to find the Public Key for.
   * 
   * @param credential_store_data_models.SummaryType
   *    Summary type : SSH,PASSWD or CERT
   * 
   * @param gatewayId
   *    This is the unique identifier of your gateway where the token and public key was generated from.
   * 
   * @param userId
   *    This is the unique identifier of user whose public keys are to be fetched.
   * 
   * @return CredentialSummary
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param int $type
   * @param string $gatewayId
   * @param string $userId
   * @return \Airavata\Model\Credential\Store\CredentialSummary[]
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   */
  public function getAllCredentialSummaryForUsersInGateway(\Airavata\Model\Security\AuthzToken $authzToken, $type, $gatewayId, $userId);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayId
   * @return array
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   */
  public function getAllGatewayPWDCredentials(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId);
  /**
   * 
   * Delete a Gateway
   * 
   * @param gatewayId
   *    The gateway Id of the Gateway to be deleted.
   * 
   * @return boolean
   *    Boolean identifier for the success or failure of the deletion operation.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $airavataCredStoreToken
   * @param string $gatewayId
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   */
  public function deleteSSHPubKey(\Airavata\Model\Security\AuthzToken $authzToken, $airavataCredStoreToken, $gatewayId);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $airavataCredStoreToken
   * @param string $gatewayId
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   */
  public function deletePWDCredential(\Airavata\Model\Security\AuthzToken $authzToken, $airavataCredStoreToken, $gatewayId);
  /**
   * 
   * Creates a Project with basic metadata.
   *    A Project is a container of experiments.
   * 
   * @param gatewayId
   *    The identifier for the requested gateway.
   * 
   * @param Project
   *    The Project Object described in the workspace_model.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayId
   * @param \Airavata\Model\Workspace\Project $project
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function createProject(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, \Airavata\Model\Workspace\Project $project);
  /**
   * 
   * Update an Existing Project
   * 
   * @param projectId
   *    The projectId of the project needed an update.
   * 
   * @return void
   *    Currently this does not return any value.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $projectId
   * @param \Airavata\Model\Workspace\Project $updatedProject
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\ProjectNotFoundException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function updateProject(\Airavata\Model\Security\AuthzToken $authzToken, $projectId, \Airavata\Model\Workspace\Project $updatedProject);
  /**
   * 
   * Get a Project by ID
   *    This method is to obtain a project by providing a projectId.
   * 
   * @param projectId
   *    projectId of the project you require.
   * 
   * @return project
   *    project data model will be returned.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $projectId
   * @return \Airavata\Model\Workspace\Project
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\ProjectNotFoundException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getProject(\Airavata\Model\Security\AuthzToken $authzToken, $projectId);
  /**
   * 
   * Delete a Project
   *    This method is used to delete an existing Project.
   * 
   * @param projectId
   *    projectId of the project you want to delete.
   * 
   * @return boolean
   *    Boolean identifier for the success or failure of the deletion operation.
   * 
   *    NOTE: This method is not used within gateways connected with Airavata.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $projectId
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\ProjectNotFoundException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function deleteProject(\Airavata\Model\Security\AuthzToken $authzToken, $projectId);
  /**
   * 
   * Get All User Projects
   * Get all Project for the user with pagination. Results will be ordered based on creation time DESC.
   * 
   * @param gatewayId
   *    The identifier for the requested gateway.
   * 
   * @param userName
   *    The identifier of the user.
   * 
   * @param limit
   *    The amount results to be fetched.
   * 
   * @param offset
   *    The starting point of the results to be fetched.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayId
   * @param string $userName
   * @param int $limit
   * @param int $offset
   * @return \Airavata\Model\Workspace\Project[]
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getUserProjects(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $userName, $limit, $offset);
  /**
   * 
   * Search User Projects
   * Search and get all Projects for user by project description or/and project name  with pagination.
   * Results will be ordered based on creation time DESC.
   * 
   * @param gatewayId
   *    The unique identifier of the gateway making the request.
   * 
   * @param userName
   *    The identifier of the user.
   * 
   * @param filters
   *    Map of multiple filter criteria. Currenlt search filters includes Project Name and Project Description
   * 
   * @param limit
   *    The amount results to be fetched.
   * 
   * @param offset
   *    The starting point of the results to be fetched.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayId
   * @param string $userName
   * @param array $filters
   * @param int $limit
   * @param int $offset
   * @return \Airavata\Model\Workspace\Project[]
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function searchProjects(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $userName, array $filters, $limit, $offset);
  /**
   * Search Experiments.
   * Search Experiments by using multiple filter criteria with pagination. Results will be sorted based on creation time DESC.
   * 
   * @param gatewayId
   *       Identifier of the requested gateway.
   * 
   * @param userName
   *       Username of the user requesting the search function.
   * 
   * @param filters
   *       Map of multiple filter criteria. Currenlt search filters includes Experiment Name, Description, Application, etc....
   * 
   * @param limit
   *       Amount of results to be fetched.
   * 
   * @param offset
   *       The starting point of the results to be fetched.
   * 
   * @return ExperimentSummaryModel
   *    List of experiments for the given search filter. Here only the Experiment summary will be returned.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayId
   * @param string $userName
   * @param array $filters
   * @param int $limit
   * @param int $offset
   * @return \Airavata\Model\Experiment\ExperimentSummaryModel[]
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function searchExperiments(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $userName, array $filters, $limit, $offset);
  /**
   * 
   * Get Experiment Statistics
   * Get Experiment Statisitics for a given gateway for a specific time period. This feature is available only for admins of a particular gateway. Gateway admin access is managed by the user roles.
   * 
   * @param gatewayId
   *       Unique identifier of the gateway making the request to fetch statistics.
   * 
   * @param fromTime
   *       Starting date time.
   * 
   * @param toTime
   *       Ending data time.
   * 
   * @param userName
   *       Gateway username substring with which to further filter statistics.
   * 
   * @param applicationName
   *       Application id substring with which to further filter statistics.
   * 
   * @param resourceHostName
   *       Hostname id substring with which to further filter statistics.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayId
   * @param int $fromTime
   * @param int $toTime
   * @param string $userName
   * @param string $applicationName
   * @param string $resourceHostName
   * @return \Airavata\Model\Experiment\ExperimentStatistics
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getExperimentStatistics(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $fromTime, $toTime, $userName, $applicationName, $resourceHostName);
  /**
   * 
   * Get All Experiments of the Project
   * Get Experiments within project with pagination. Results will be sorted based on creation time DESC.
   * 
   * @param projectId
   *       Uniqie identifier of the project.
   * 
   * @param limit
   *       Amount of results to be fetched.
   * 
   * @param offset
   *       The starting point of the results to be fetched.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $projectId
   * @param int $limit
   * @param int $offset
   * @return \Airavata\Model\Experiment\ExperimentModel[]
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\ProjectNotFoundException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getExperimentsInProject(\Airavata\Model\Security\AuthzToken $authzToken, $projectId, $limit, $offset);
  /**
   * 
   * Get All Experiments of the User
   * Get experiments by user with pagination. Results will be sorted based on creation time DESC.
   * 
   * @param gatewayId
   *       Identifier of the requesting gateway.
   * 
   * @param userName
   *       Username of the requested end user.
   * 
   * @param limit
   *       Amount of results to be fetched.
   * 
   * @param offset
   *       The starting point of the results to be fetched.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayId
   * @param string $userName
   * @param int $limit
   * @param int $offset
   * @return \Airavata\Model\Experiment\ExperimentModel[]
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getUserExperiments(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $userName, $limit, $offset);
  /**
   *   *
   *   * Create New Experiment
   *   * Create an experiment for the specified user belonging to the gateway. The gateway identity is not explicitly passed
   *   *   but inferred from the sshKeyAuthentication header. This experiment is just a persistent place holder. The client
   *   *   has to subsequently configure and launch the created experiment. No action is taken on Airavata Server except
   *   *   registering the experiment in a persistent store.
   *   *
   *   * @param gatewayId
   *   *    The unique ID of the gateway where the experiment is been created.
   *   *
   *   * @param ExperimentModel
   *   *    The create experiment will require the basic experiment metadata like the name and description, intended user,
   *   *      the gateway identifer and if the experiment should be shared public by defualt. During the creation of an experiment
   *   *      the ExperimentMetadata is a required field.
   *   *
   *   * @return
   *   *   The server-side generated.airavata.registry.core.experiment.globally unique identifier.
   *   *
   *   * @throws org.apache.airavata.model.error.InvalidRequestException
   *   *    For any incorrect forming of the request itself.
   *   *
   *   * @throws org.apache.airavata.model.error.AiravataClientException
   *   *    The following list of exceptions are thrown which Airavata Client can take corrective actions to resolve:
   *   *
   *   *      UNKNOWN_GATEWAY_ID - If a Gateway is not registered with Airavata as a one time administrative
   *   *         step, then Airavata Registry will not have a provenance area setup. The client has to follow
   *   *         gateway registration steps and retry this request.
   *   *
   *   *      AUTHENTICATION_FAILURE - How Authentication will be implemented is yet to be determined.
   *   *         For now this is a place holder.
   *   *
   *   *      INVALID_AUTHORIZATION - This will throw an authorization exception. When a more robust security hand-shake
   *   *         is implemented, the authorization will be more substantial.
   *   *
   *   * @throws org.apache.airavata.model.error.AiravataSystemException
   *   *    This exception will be thrown for any Airavata Server side issues and if the problem cannot be corrected by the client
   *   *       rather an Airavata Administrator will be notified to take corrective action.
   *   *
   * *
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayId
   * @param \Airavata\Model\Experiment\ExperimentModel $experiment
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function createExperiment(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, \Airavata\Model\Experiment\ExperimentModel $experiment);
  /**
   * 
   * Delete an Experiment
   * If the experiment is not already launched experiment can be deleted.
   * 
   * @param authzToken
   * 
   * @param experiementId
   *     Experiment ID of the experimnet you want to delete.
   * 
   * @return boolean
   *     Identifier for the success or failure of the deletion operation.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $experimentId
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function deleteExperiment(\Airavata\Model\Security\AuthzToken $authzToken, $experimentId);
  /**
   *   *
   *   * Get Experiment
   *   * Fetch previously created experiment metadata.
   *   *
   *   * @param airavataExperimentId
   *   *    The unique identifier of the requested experiment. This ID is returned during the create experiment step.
   *   *
   *   * @return ExperimentModel
   *   *   This method will return the previously stored experiment metadata.
   *   *
   *   * @throws org.apache.airavata.model.error.InvalidRequestException
   *   *    For any incorrect forming of the request itself.
   *   *
   *   * @throws org.apache.airavata.model.error.ExperimentNotFoundException
   *   *    If the specified experiment is not previously created, then an Experiment Not Found Exception is thrown.
   *   *
   *   * @throws org.apache.airavata.model.error.AiravataClientException
   *   *    The following list of exceptions are thrown which Airavata Client can take corrective actions to resolve:
   *   *
   *   *      UNKNOWN_GATEWAY_ID - If a Gateway is not registered with Airavata as a one time administrative
   *   *         step, then Airavata Registry will not have a provenance area setup. The client has to follow
   *   *         gateway registration steps and retry this request.
   *   *
   *   *      AUTHENTICATION_FAILURE - How Authentication will be implemented is yet to be determined.
   *   *         For now this is a place holder.
   *   *
   *   *      INVALID_AUTHORIZATION - This will throw an authorization exception. When a more robust security hand-shake
   *   *         is implemented, the authorization will be more substantial.
   *   *
   *   * @throws org.apache.airavata.model.error.AiravataSystemException
   *   *    This exception will be thrown for any Airavata Server side issues and if the problem cannot be corrected by the client
   *   *       rather an Airavata Administrator will be notified to take corrective action.
   *   *
   * *
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $airavataExperimentId
   * @return \Airavata\Model\Experiment\ExperimentModel A structure holding the experiment metadata and its child models.
   * 
   * userName:
   *   The user name of the targeted gateway end user on whose behalf the experiment is being created.
   *     the associated gateway identity can only be inferred from the security hand-shake so as to avoid
   *     authorized Airavata Clients mimicking an unauthorized request. If a gateway is not registered with
   *     Airavata, an authorization exception is thrown.
   * 
   * experimentName:
   *   The name of the experiment as defined by the user. The name need not be unique as uniqueness is enforced
   *      by the generated experiment id.
   * 
   * experimentDescription:
   *    The verbose description of the experiment. This is an optional parameter.
   * 
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\ExperimentNotFoundException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getExperiment(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId);
  /**
   *   *
   *   * Get Experiment by an admin user
   *   *
   *   * Used by an admin user to fetch previously created experiment metadata.
   *   *
   *   * @param airavataExperimentId
   *   *    The unique identifier of the requested experiment. This ID is returned during the create experiment step.
   *   *
   *   * @return ExperimentModel
   *   *   This method will return the previously stored experiment metadata.
   *   *
   *   * @throws org.apache.airavata.model.error.InvalidRequestException
   *   *    For any incorrect forming of the request itself.
   *   *
   *   * @throws org.apache.airavata.model.error.ExperimentNotFoundException
   *   *    If the specified experiment is not previously created, then an Experiment Not Found Exception is thrown.
   *   *
   *   * @throws org.apache.airavata.model.error.AiravataClientException
   *   *    The following list of exceptions are thrown which Airavata Client can take corrective actions to resolve:
   *   *
   *   *      UNKNOWN_GATEWAY_ID - If a Gateway is not registered with Airavata as a one time administrative
   *   *         step, then Airavata Registry will not have a provenance area setup. The client has to follow
   *   *         gateway registration steps and retry this request.
   *   *
   *   *      AUTHENTICATION_FAILURE - How Authentication will be implemented is yet to be determined.
   *   *         For now this is a place holder.
   *   *
   *   *      INVALID_AUTHORIZATION - This will throw an authorization exception. When a more robust security hand-shake
   *   *         is implemented, the authorization will be more substantial.
   *   *
   *   * @throws org.apache.airavata.model.error.AiravataSystemException
   *   *    This exception will be thrown for any Airavata Server side issues and if the problem cannot be corrected by the client
   *   *       rather an Airavata Administrator will be notified to take corrective action.
   *   *
   * *
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $airavataExperimentId
   * @return \Airavata\Model\Experiment\ExperimentModel A structure holding the experiment metadata and its child models.
   * 
   * userName:
   *   The user name of the targeted gateway end user on whose behalf the experiment is being created.
   *     the associated gateway identity can only be inferred from the security hand-shake so as to avoid
   *     authorized Airavata Clients mimicking an unauthorized request. If a gateway is not registered with
   *     Airavata, an authorization exception is thrown.
   * 
   * experimentName:
   *   The name of the experiment as defined by the user. The name need not be unique as uniqueness is enforced
   *      by the generated experiment id.
   * 
   * experimentDescription:
   *    The verbose description of the experiment. This is an optional parameter.
   * 
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\ExperimentNotFoundException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getExperimentByAdmin(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId);
  /**
   * 
   * Get Complete Experiment Details
   * Fetch the completed nested tree structue of previously created experiment metadata which includes processes ->
   * tasks -> jobs information.
   * 
   * @param airavataExperimentId
   *    The identifier for the requested experiment. This is returned during the create experiment step.
   * 
   * @return ExperimentModel
   *   This method will return the previously stored experiment metadata including application input parameters, computational resource scheduling
   *   information, special input output handling and additional quality of service parameters.
   * 
   * @throws org.apache.airavata.model.error.InvalidRequestException
   *    For any incorrect forming of the request itself.
   * 
   * @throws org.apache.airavata.model.error.ExperimentNotFoundException
   *    If the specified experiment is not previously created, then an Experiment Not Found Exception is thrown.
   * 
   * @throws org.apache.airavata.model.error.AiravataClientException
   *    The following list of exceptions are thrown which Airavata Client can take corrective actions to resolve:
   * 
   *      UNKNOWN_GATEWAY_ID - If a Gateway is not registered with Airavata as a one time administrative
   *         step, then Airavata Registry will not have a provenance area setup. The client has to follow
   *         gateway registration steps and retry this request.
   * 
   *      AUTHENTICATION_FAILURE - How Authentication will be implemented is yet to be determined.
   *         For now this is a place holder.
   * 
   *      INVALID_AUTHORIZATION - This will throw an authorization exception. When a more robust security hand-shake
   *         is implemented, the authorization will be more substantial.
   * 
   * @throws org.apache.airavata.model.error.AiravataSystemException
   *    This exception will be thrown for any Airavata Server side issues and if the problem cannot be corrected by the client
   *       rather an Airavata Administrator will be notified to take corrective action.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $airavataExperimentId
   * @return \Airavata\Model\Experiment\ExperimentModel A structure holding the experiment metadata and its child models.
   * 
   * userName:
   *   The user name of the targeted gateway end user on whose behalf the experiment is being created.
   *     the associated gateway identity can only be inferred from the security hand-shake so as to avoid
   *     authorized Airavata Clients mimicking an unauthorized request. If a gateway is not registered with
   *     Airavata, an authorization exception is thrown.
   * 
   * experimentName:
   *   The name of the experiment as defined by the user. The name need not be unique as uniqueness is enforced
   *      by the generated experiment id.
   * 
   * experimentDescription:
   *    The verbose description of the experiment. This is an optional parameter.
   * 
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\ExperimentNotFoundException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getDetailedExperimentTree(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId);
  /**
   * 
   * Update a Previously Created Experiment
   * Configure the CREATED experiment with required inputs, scheduling and other quality of service parameters. This method only updates the experiment object within the registry.
   * The experiment has to be launched to make it actionable by the server.
   * 
   * @param airavataExperimentId
   *    The identifier for the requested experiment. This is returned during the create experiment step.
   * 
   * @param ExperimentModel
   *    The configuration information of the experiment with application input parameters, computational resource scheduling
   *      information, special input output handling and additional quality of service parameters.
   * 
   * @return
   *   This method call does not have a return value.
   * 
   * @throws org.apache.airavata.model.error.InvalidRequestException
   *    For any incorrect forming of the request itself.
   * 
   * @throws org.apache.airavata.model.error.ExperimentNotFoundException
   *    If the specified experiment is not previously created, then an Experiment Not Found Exception is thrown.
   * 
   * @throws org.apache.airavata.model.error.AiravataClientException
   *    The following list of exceptions are thrown which Airavata Client can take corrective actions to resolve:
   *      
   *      UNKNOWN_GATEWAY_ID - If a Gateway is not registered with Airavata as a one time administrative
   *         step, then Airavata Registry will not have a provenance area setup. The client has to follow
   *         gateway registration steps and retry this request.
   * 
   *      AUTHENTICATION_FAILURE - How Authentication will be implemented is yet to be determined.
   *         For now this is a place holder.
   * 
   *      INVALID_AUTHORIZATION - This will throw an authorization exception. When a more robust security hand-shake
   *         is implemented, the authorization will be more substantial.
   * 
   * @throws org.apache.airavata.model.error.AiravataSystemException
   *    This exception will be thrown for any Airavata Server side issues and if the problem cannot be corrected by the client
   *       rather an Airavata Administrator will be notified to take corrective action.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $airavataExperimentId
   * @param \Airavata\Model\Experiment\ExperimentModel $experiment
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\ExperimentNotFoundException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function updateExperiment(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId, \Airavata\Model\Experiment\ExperimentModel $experiment);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $airavataExperimentId
   * @param \Airavata\Model\Experiment\UserConfigurationDataModel $userConfiguration
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function updateExperimentConfiguration(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId, \Airavata\Model\Experiment\UserConfigurationDataModel $userConfiguration);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $airavataExperimentId
   * @param \Airavata\Model\Scheduling\ComputationalResourceSchedulingModel $resourceScheduling
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function updateResourceScheduleing(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId, \Airavata\Model\Scheduling\ComputationalResourceSchedulingModel $resourceScheduling);
  /**
   *  *
   *  * Validate experiment configuration.
   *  * A true in general indicates, the experiment is ready to be launched.
   *  *
   *  * @param airavataExperimentId
   *  *    Unique identifier of the experiment (Experimnent ID) of the experiment which need to be validated.
   *  *
   *  * @return boolean
   *  *      Identifier for the success or failure of the validation operation.
   *  *
   * *
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $airavataExperimentId
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\ExperimentNotFoundException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function validateExperiment(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId);
  /**
   * 
   * Launch a Previously Created & Configured Experiment.
   * Airavata Server will then start processing the request and appropriate notifications and intermediate and output data will be subsequently available for this experiment.
   * 
   * @gatewayId
   *    ID of the gateway which will launch the experiment.
   * 
   * @param airavataExperimentId
   *    The identifier for the requested experiment. This is returned during the create experiment step.
   * 
   * @return
   *   This method call does not have a return value.
   * 
   * @throws org.apache.airavata.model.error.InvalidRequestException
   *    For any incorrect forming of the request itself.
   * 
   * @throws org.apache.airavata.model.error.ExperimentNotFoundException
   *    If the specified experiment is not previously created, then an Experiment Not Found Exception is thrown.
   * 
   * @throws org.apache.airavata.model.error.AiravataClientException
   *    The following list of exceptions are thrown which Airavata Client can take corrective actions to resolve:
   *      
   *      UNKNOWN_GATEWAY_ID - If a Gateway is not registered with Airavata as a one time administrative
   *         step, then Airavata Registry will not have a provenance area setup. The client has to follow
   *         gateway registration steps and retry this request.
   * 
   *      AUTHENTICATION_FAILURE - How Authentication will be implemented is yet to be determined.
   *         For now this is a place holder.
   * 
   *      INVALID_AUTHORIZATION - This will throw an authorization exception. When a more robust security hand-shake
   *         is implemented, the authorization will be more substantial.
   * 
   * @throws org.apache.airavata.model.error.AiravataSystemException
   *    This exception will be thrown for any Airavata Server side issues and if the problem cannot be corrected by the client
   *       rather an Airavata Administrator will be notified to take corrective action.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $airavataExperimentId
   * @param string $gatewayId
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\ExperimentNotFoundException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function launchExperiment(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId, $gatewayId);
  /**
   * 
   * Get Experiment Status
   * 
   * Obtain the status of an experiment by providing the Experiment Id
   * 
   * @param authzToken
   * 
   * @param airavataExperimentId
   *     Experiment ID of the experimnet you require the status.
   * 
   * @return ExperimentStatus
   *     ExperimentStatus model with the current status will be returned.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $airavataExperimentId
   * @return \Airavata\Model\Status\ExperimentStatus Status: A generic status object.
   * 
   * state:
   *   State .
   * 
   * timeOfStateChange:
   *   time the status was last updated.
   * 
   * reason:
   *   User friendly reason on how the state is inferred.
   * 
   * 
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\ExperimentNotFoundException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getExperimentStatus(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId);
  /**
   * 
   * Get Experiment Outputs
   * This method to be used when need to obtain final outputs of a certain Experiment
   * 
   * @param authzToken
   * 
   * @param airavataExperimentId
   *     Experiment ID of the experimnet you need the outputs.
   * 
   * @return list
   *     List of experiment outputs will be returned. They will be returned as a list of OutputDataObjectType for the experiment.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $airavataExperimentId
   * @return \Airavata\Model\Application\Io\OutputDataObjectType[]
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\ExperimentNotFoundException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getExperimentOutputs(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId);
  /**
   * 
   * Get Intermediate Experiment Outputs
   * This method to be used when need to obtain intermediate outputs of a certain Experiment
   * 
   * @param authzToken
   * 
   * @param airavataExperimentId
   *     Experiment ID of the experimnet you need intermediate outputs.
   * 
   * @return list
   *     List of intermediate experiment outputs will be returned. They will be returned as a list of OutputDataObjectType for the experiment.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $airavataExperimentId
   * @return \Airavata\Model\Application\Io\OutputDataObjectType[]
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\ExperimentNotFoundException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getIntermediateOutputs(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId);
  /**
   * 
   * Get Job Statuses for an Experiment
   * This method to be used when need to get the job status of an Experiment. An experiment may have one or many jobs; there for one or many job statuses may turnup
   * 
   * @param authzToken
   * 
   * @param experiementId
   *     Experiment ID of the experimnet you need the job statuses.
   * 
   * @return JobStatus
   *     Job status (string) for all all the existing jobs for the experiment will be returned in the form of a map
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $airavataExperimentId
   * @return array
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\ExperimentNotFoundException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getJobStatuses(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId);
  /**
   * 
   * Get Job Details for all the jobs within an Experiment.
   * This method to be used when need to get the job details for one or many jobs of an Experiment.
   * 
   * @param authzToken
   * 
   * @param experiementId
   *     Experiment ID of the experimnet you need job details.
   * 
   * @return list of JobDetails
   *     Job details.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $airavataExperimentId
   * @return \Airavata\Model\Job\JobModel[]
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\ExperimentNotFoundException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getJobDetails(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId);
  /**
   * 
   * Clone an Existing Experiment
   * Existing specified experiment is cloned and a new name is provided. A copy of the experiment configuration is made and is persisted with new metadata.
   *   The client has to subsequently update this configuration if needed and launch the cloned experiment.
   * 
   * @param newExperimentName
   *    experiment name that should be used in the cloned experiment
   * 
   * @param updatedExperiment
   *    Once an experiment is cloned, to disambiguate, the users are suggested to provide new metadata. This will again require
   *      the basic experiment metadata like the name and description, intended user, the gateway identifier and if the experiment
   *      should be shared public by default.
   * @param newExperimentProjectId
   *    The project in which to create the cloned experiment. This is optional and if null the experiment will be created
   *      in the same project as the existing experiment.
   * 
   * @return
   *   The server-side generated.airavata.registry.core.experiment.globally unique identifier (Experiment ID) for the newly cloned experiment.
   * 
   * @throws org.apache.airavata.model.error.InvalidRequestException
   *    For any incorrect forming of the request itself.
   * 
   * @throws org.apache.airavata.model.error.ExperimentNotFoundException
   *    If the specified experiment is not previously created, then an Experiment Not Found Exception is thrown.
   * 
   * @throws org.apache.airavata.model.error.AiravataClientException
   *    The following list of exceptions are thrown which Airavata Client can take corrective actions to resolve:
   *      
   *      UNKNOWN_GATEWAY_ID - If a Gateway is not registered with Airavata as a one time administrative
   *         step, then Airavata Registry will not have a provenance area setup. The client has to follow
   *         gateway registration steps and retry this request.
   * 
   *      AUTHENTICATION_FAILURE - How Authentication will be implemented is yet to be determined.
   *         For now this is a place holder.
   * 
   *      INVALID_AUTHORIZATION - This will throw an authorization exception. When a more robust security hand-shake
   *         is implemented, the authorization will be more substantial.
   * 
   * @throws org.apache.airavata.model.error.AiravataSystemException
   *    This exception will be thrown for any Airavata Server side issues and if the problem cannot be corrected by the client
   *       rather an Airavata Administrator will be notified to take corrective action.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $existingExperimentID
   * @param string $newExperimentName
   * @param string $newExperimentProjectId
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\ExperimentNotFoundException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   * @throws \Airavata\API\Error\ProjectNotFoundException
   */
  public function cloneExperiment(\Airavata\Model\Security\AuthzToken $authzToken, $existingExperimentID, $newExperimentName, $newExperimentProjectId);
  /**
   * 
   * Clone an Existing Experiment by an admin user
   * Existing specified experiment is cloned and a new name is provided. A copy of the experiment configuration is made and is persisted with new metadata.
   *   The client has to subsequently update this configuration if needed and launch the cloned experiment.
   * 
   * @param newExperimentName
   *    experiment name that should be used in the cloned experiment
   * 
   * @param updatedExperiment
   *    Once an experiment is cloned, to disambiguate, the users are suggested to provide new metadata. This will again require
   *      the basic experiment metadata like the name and description, intended user, the gateway identifier and if the experiment
   *      should be shared public by default.
   * @param newExperimentProjectId
   *    The project in which to create the cloned experiment. This is optional and if null the experiment will be created
   *      in the same project as the existing experiment.
   * 
   * @return
   *   The server-side generated.airavata.registry.core.experiment.globally unique identifier (Experiment ID) for the newly cloned experiment.
   * 
   * @throws org.apache.airavata.model.error.InvalidRequestException
   *    For any incorrect forming of the request itself.
   * 
   * @throws org.apache.airavata.model.error.ExperimentNotFoundException
   *    If the specified experiment is not previously created, then an Experiment Not Found Exception is thrown.
   * 
   * @throws org.apache.airavata.model.error.AiravataClientException
   *    The following list of exceptions are thrown which Airavata Client can take corrective actions to resolve:
   * 
   *      UNKNOWN_GATEWAY_ID - If a Gateway is not registered with Airavata as a one time administrative
   *         step, then Airavata Registry will not have a provenance area setup. The client has to follow
   *         gateway registration steps and retry this request.
   * 
   *      AUTHENTICATION_FAILURE - How Authentication will be implemented is yet to be determined.
   *         For now this is a place holder.
   * 
   *      INVALID_AUTHORIZATION - This will throw an authorization exception. When a more robust security hand-shake
   *         is implemented, the authorization will be more substantial.
   * 
   * @throws org.apache.airavata.model.error.AiravataSystemException
   *    This exception will be thrown for any Airavata Server side issues and if the problem cannot be corrected by the client
   *       rather an Airavata Administrator will be notified to take corrective action.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $existingExperimentID
   * @param string $newExperimentName
   * @param string $newExperimentProjectId
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\ExperimentNotFoundException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   * @throws \Airavata\API\Error\ProjectNotFoundException
   */
  public function cloneExperimentByAdmin(\Airavata\Model\Security\AuthzToken $authzToken, $existingExperimentID, $newExperimentName, $newExperimentProjectId);
  /**
   * 
   * Terminate a running Experiment.
   * 
   * @gatewayId
   *    ID of the gateway which will terminate the running Experiment.
   * 
   * @param airavataExperimentId
   *    The identifier of the experiment required termination. This ID is returned during the create experiment step.
   * 
   * @return status
   *   This method call does not have a return value.
   * 
   * @throws org.apache.airavata.model.error.InvalidRequestException
   *    For any incorrect forming of the request itself.
   * 
   * @throws org.apache.airavata.model.error.ExperimentNotFoundException
   *    If the specified experiment is not previously created, then an Experiment Not Found Exception is thrown.
   * 
   * @throws org.apache.airavata.model.error.AiravataClientException
   *    The following list of exceptions are thrown which Airavata Client can take corrective actions to resolve:
   *      
   *      UNKNOWN_GATEWAY_ID - If a Gateway is not registered with Airavata as a one time administrative
   *         step, then Airavata Registry will not have a provenance area setup. The client has to follow
   *         gateway registration steps and retry this request.
   * 
   *      AUTHENTICATION_FAILURE - How Authentication will be implemented is yet to be determined.
   *         For now this is a place holder.
   * 
   *      INVALID_AUTHORIZATION - This will throw an authorization exception. When a more robust security hand-shake
   *         is implemented, the authorization will be more substantial.
   * 
   * @throws org.apache.airavata.model.error.AiravataSystemException
   *    This exception will be thrown for any Airavata Server side issues and if the problem cannot be corrected by the client
   *       rather an Airavata Administrator will be notified to take corrective action.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $airavataExperimentId
   * @param string $gatewayId
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\ExperimentNotFoundException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function terminateExperiment(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId, $gatewayId);
  /**
   * 
   * Register a Application Module.
   * 
   * @gatewayId
   *    ID of the gateway which is registering the new Application Module.
   * 
   * @param applicationModule
   *    Application Module Object created from the datamodel.
   * 
   * @return appModuleId
   *   Returns the server-side generated airavata appModule globally unique identifier.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayId
   * @param \Airavata\Model\AppCatalog\AppDeployment\ApplicationModule $applicationModule
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function registerApplicationModule(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, \Airavata\Model\AppCatalog\AppDeployment\ApplicationModule $applicationModule);
  /**
   * 
   * Fetch a Application Module.
   * 
   * @param appModuleId
   *   The unique identifier of the application module required
   * 
   * @return applicationModule
   *   Returns an Application Module Object.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $appModuleId
   * @return \Airavata\Model\AppCatalog\AppDeployment\ApplicationModule Application Module Information. A module has to be registered before registering a deployment.
   * 
   * appModuleId: Airavata Internal Unique Job ID. This is set by the registry.
   * 
   * appModuleName:
   *   Name of the application module.
   * 
   * appModuleVersion:
   *   Version of the application.
   * 
   * appModuleDescription:
   *    Descriprion of the Module
   * 
   * 
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getApplicationModule(\Airavata\Model\Security\AuthzToken $authzToken, $appModuleId);
  /**
   * 
   * Update a Application Module.
   * 
   * @param appModuleId
   *   The identifier for the requested application module to be updated.
   * 
   * @param applicationModule
   *    Application Module Object created from the datamodel.
   * 
   * @return status
   *   Returns a success/failure of the update.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $appModuleId
   * @param \Airavata\Model\AppCatalog\AppDeployment\ApplicationModule $applicationModule
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function updateApplicationModule(\Airavata\Model\Security\AuthzToken $authzToken, $appModuleId, \Airavata\Model\AppCatalog\AppDeployment\ApplicationModule $applicationModule);
  /**
   * 
   * Fetch all Application Module Descriptions.
   * 
   * @param gatewayId
   *    ID of the gateway which need to list all available application deployment documentation.
   * 
   * @return list
   *    Returns the list of all Application Module Objects.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayId
   * @return \Airavata\Model\AppCatalog\AppDeployment\ApplicationModule[]
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getAllAppModules(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId);
  /**
   * 
   * Delete an Application Module.
   * 
   * @param appModuleId
   *   The identifier of the Application Module to be deleted.
   * 
   * @return status
   *   Returns a success/failure of the deletion.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $appModuleId
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function deleteApplicationModule(\Airavata\Model\Security\AuthzToken $authzToken, $appModuleId);
  /**
   * 
   * Register an Application Deployment.
   * 
   * @param gatewayId
   *    ID of the gateway which is registering the new Application Deployment.
   * 
   * @param applicationDeployment
   *    Application Module Object created from the datamodel.
   * 
   * @return appDeploymentId
   *   Returns a server-side generated airavata appDeployment globally unique identifier.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayId
   * @param \Airavata\Model\AppCatalog\AppDeployment\ApplicationDeploymentDescription $applicationDeployment
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function registerApplicationDeployment(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, \Airavata\Model\AppCatalog\AppDeployment\ApplicationDeploymentDescription $applicationDeployment);
  /**
   * 
   * Fetch a Application Deployment.
   * 
   * @param appDeploymentId
   *   The identifier for the requested application module
   * 
   * @return applicationDeployment
   *   Returns a application Deployment Object.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $appDeploymentId
   * @return \Airavata\Model\AppCatalog\AppDeployment\ApplicationDeploymentDescription Application Deployment Description
   * 
   * appDeploymentId: Airavata Internal Unique Job ID. This is set by the registry.
   * 
   * appModuleName:
   *   Application Module Name. This has to be precise describing the binary.
   * 
   * computeHostId:
   *   This ID maps application deployment to a particular resource previously described within Airavata.
   *   Example: Stampede is first registered and refered when registering WRF.
   * 
   * moduleLoadCmd:
   *  Command string to load modules. This will be placed in the job submisison
   *  Ex: module load amber
   * 
   * libPrependPaths:
   *  prepend to a path variable the value
   * 
   * libAppendPaths:
   *  append to a path variable the value
   * 
   * setEnvironment:
   *  assigns to the environment variable "NAME" the value
   * 
   * 
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getApplicationDeployment(\Airavata\Model\Security\AuthzToken $authzToken, $appDeploymentId);
  /**
   * 
   * Update an Application Deployment.
   * 
   * @param appDeploymentId
   *   The identifier of the requested application deployment to be updated.
   * 
   * @param appDeployment
   *    Application Deployment Object created from the datamodel.
   * 
   * @return status
   *   Returns a success/failure of the update.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $appDeploymentId
   * @param \Airavata\Model\AppCatalog\AppDeployment\ApplicationDeploymentDescription $applicationDeployment
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function updateApplicationDeployment(\Airavata\Model\Security\AuthzToken $authzToken, $appDeploymentId, \Airavata\Model\AppCatalog\AppDeployment\ApplicationDeploymentDescription $applicationDeployment);
  /**
   * 
   * Delete an Application Deployment.
   * 
   * @param appDeploymentId
   *   The unique identifier of application deployment to be deleted.
   * 
   * @return status
   *   Returns a success/failure of the deletion.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $appDeploymentId
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function deleteApplicationDeployment(\Airavata\Model\Security\AuthzToken $authzToken, $appDeploymentId);
  /**
   * 
   * Fetch all Application Deployment Descriptions.
   * 
   * @param gatewayId
   *    ID of the gateway which need to list all available application deployment documentation.
   * 
   * @return list<applicationDeployment.
   *    Returns the list of all application Deployment Objects.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayId
   * @return \Airavata\Model\AppCatalog\AppDeployment\ApplicationDeploymentDescription[]
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getAllApplicationDeployments(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId);
  /**
   * Fetch a list of Deployed Compute Hosts.
   * 
   * @param appModuleId
   *   The identifier for the requested application module
   * 
   * @return list<string>
   *   Returns a list of Deployed Resources.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $appModuleId
   * @return string[]
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getAppModuleDeployedResources(\Airavata\Model\Security\AuthzToken $authzToken, $appModuleId);
  /**
   * 
   * Register a Application Interface.
   * 
   * @param applicationInterface
   *    Application Module Object created from the datamodel.
   * 
   * @return appInterfaceId
   *   Returns a server-side generated airavata application interface globally unique identifier.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayId
   * @param \Airavata\Model\AppCatalog\AppInterface\ApplicationInterfaceDescription $applicationInterface
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function registerApplicationInterface(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, \Airavata\Model\AppCatalog\AppInterface\ApplicationInterfaceDescription $applicationInterface);
  /**
   * 
   * Clone an Application Interface.
   * 
   * @gatewayId
   *    The identifier for the gateway profile to be requested
   * 
   * @param existingAppInterfaceID
   *    Identifier of the existing Application interface you wich to clone.
   * 
   * @param newApplicationName
   *    Name for the new application interface.
   * 
   * @return appInterfaceId
   *    Returns a server-side generated globally unique identifier for the newly cloned application interface.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $existingAppInterfaceID
   * @param string $newApplicationName
   * @param string $gatewayId
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function cloneApplicationInterface(\Airavata\Model\Security\AuthzToken $authzToken, $existingAppInterfaceID, $newApplicationName, $gatewayId);
  /**
   * 
   * Fetch an Application Interface.
   * 
   * @param appInterfaceId
   *   The identifier for the requested application interface.
   * 
   * @return applicationInterface
   *   Returns an application Interface Object.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $appInterfaceId
   * @return \Airavata\Model\AppCatalog\AppInterface\ApplicationInterfaceDescription Application Interface Description
   * 
   * applicationModules:
   *   Associate all application modules with versions which interface is applicable to.
   * 
   * applicationInputs:
   *   Inputs to be passed to the application
   * 
   * applicationOutputs:
   *   Outputs generated from the application
   * 
   * 
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getApplicationInterface(\Airavata\Model\Security\AuthzToken $authzToken, $appInterfaceId);
  /**
   * 
   * Update a Application Interface.
   * 
   * @param appInterfaceId
   *   The identifier of the requested application deployment to be updated.
   * 
   * @param appInterface
   *    Application Interface Object created from the datamodel.
   * 
   * @return status
   *   Returns a success/failure of the update.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $appInterfaceId
   * @param \Airavata\Model\AppCatalog\AppInterface\ApplicationInterfaceDescription $applicationInterface
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function updateApplicationInterface(\Airavata\Model\Security\AuthzToken $authzToken, $appInterfaceId, \Airavata\Model\AppCatalog\AppInterface\ApplicationInterfaceDescription $applicationInterface);
  /**
   * 
   * Delete an Application Interface.
   * 
   * @param appInterfaceId
   *   The identifier for the requested application interface to be deleted.
   * 
   * @return status
   *   Returns a success/failure of the deletion.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $appInterfaceId
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function deleteApplicationInterface(\Airavata\Model\Security\AuthzToken $authzToken, $appInterfaceId);
  /**
   * 
   * Fetch name and ID of  Application Interface documents.
   * 
   * 
   * @return map<applicationId, applicationInterfaceNames>
   *   Returns a list of application interfaces with corresponsing ID's
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayId
   * @return array
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getAllApplicationInterfaceNames(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId);
  /**
   * 
   * Fetch all Application Interface documents.
   * 
   * 
   * @return map<applicationId, applicationInterfaceNames>
   *   Returns a list of application interfaces documents (Application Interface ID, name, description, Inputs and Outputs objects).
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayId
   * @return \Airavata\Model\AppCatalog\AppInterface\ApplicationInterfaceDescription[]
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getAllApplicationInterfaces(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId);
  /**
   * 
   * Fetch the list of Application Inputs.
   * 
   * @param appInterfaceId
   *   The identifier of the application interface which need inputs to be fetched.
   * 
   * @return list<application_interface_model.InputDataObjectType>
   *   Returns a list of application inputs.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $appInterfaceId
   * @return \Airavata\Model\Application\Io\InputDataObjectType[]
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getApplicationInputs(\Airavata\Model\Security\AuthzToken $authzToken, $appInterfaceId);
  /**
   * 
   * Fetch list of Application Outputs.
   * 
   * @param appInterfaceId
   *   The identifier of the application interface which need outputs to be fetched.
   * 
   * @return list<application_interface_model.OutputDataObjectType>
   *   Returns a list of application outputs.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $appInterfaceId
   * @return \Airavata\Model\Application\Io\OutputDataObjectType[]
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getApplicationOutputs(\Airavata\Model\Security\AuthzToken $authzToken, $appInterfaceId);
  /**
   * 
   * Fetch a list of all deployed Compute Hosts for a given application interfaces.
   * 
   * @param appInterfaceId
   *   The identifier for the requested application interface.
   * 
   * @return map<computeResourceId, computeResourceName>
   *   A map of registered compute resource id's and their corresponding hostnames.
   *   Deployments of each modules listed within the interfaces will be listed.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $appInterfaceId
   * @return array
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getAvailableAppInterfaceComputeResources(\Airavata\Model\Security\AuthzToken $authzToken, $appInterfaceId);
  /**
   * Register a Compute Resource.
   * 
   * @param computeResourceDescription
   *    Compute Resource Object created from the datamodel.
   * 
   * @return computeResourceId
   *   Returns a server-side generated airavata compute resource globally unique identifier.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param \Airavata\Model\AppCatalog\ComputeResource\ComputeResourceDescription $computeResourceDescription
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function registerComputeResource(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\AppCatalog\ComputeResource\ComputeResourceDescription $computeResourceDescription);
  /**
   * Fetch the given Compute Resource.
   * 
   * @param computeResourceId
   *   The identifier for the requested compute resource
   * 
   * @return computeResourceDescription
   *    Compute Resource Object created from the datamodel..
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $computeResourceId
   * @return \Airavata\Model\AppCatalog\ComputeResource\ComputeResourceDescription Computational Resource Description
   * 
   * computeResourceId: Airavata Internal Unique Identifier to distinguish Compute Resource.
   * 
   * hostName:
   *   Fully Qualified Host Name.
   * 
   * hostAliases:
   *   Aliases if any.
   * 
   * ipAddress:
   *   IP Addresses of the Resource.
   * 
   * resourceDescription:
   *  A user friendly description of the resource.
   * 
   * JobSubmissionProtocols:
   *  A computational resources may have one or more ways of submitting Jobs. This structure
   *    will hold all available mechanisms to interact with the resource.
   *  The key is the priority
   * 
   * DataMovementProtocol:
   *  Option to specify a prefered data movement mechanism of the available options.
   * 
   * fileSystems:
   *  Map of file systems type and the path.
   * 
   * 
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getComputeResource(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId);
  /**
   * 
   * Fetch all registered Compute Resources.
   * 
   * @return A map of registered compute resource id's and thier corresponding hostnames.
   *    Compute Resource Object created from the datamodel..
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @return array
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getAllComputeResourceNames(\Airavata\Model\Security\AuthzToken $authzToken);
  /**
   * Update a Compute Resource.
   * 
   * @param computeResourceId
   *   The identifier for the requested compute resource to be updated.
   * 
   * @param computeResourceDescription
   *    Compute Resource Object created from the datamodel.
   * 
   * @return status
   *   Returns a success/failure of the update.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $computeResourceId
   * @param \Airavata\Model\AppCatalog\ComputeResource\ComputeResourceDescription $computeResourceDescription
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function updateComputeResource(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, \Airavata\Model\AppCatalog\ComputeResource\ComputeResourceDescription $computeResourceDescription);
  /**
   * Delete a Compute Resource.
   * 
   * @param computeResourceId
   *   The identifier for the requested compute resource to be deleted.
   * 
   * @return status
   *   Returns a success/failure of the deletion.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $computeResourceId
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function deleteComputeResource(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId);
  /**
   * Register a Storage Resource.
   * 
   * @param storageResourceDescription
   *    Storge Resource Object created from the datamodel.
   * 
   * @return storageResourceId
   *   Returns a server-side generated airavata storage resource globally unique identifier.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param \Airavata\Model\AppCatalog\StorageResource\StorageResourceDescription $storageResourceDescription
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function registerStorageResource(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\AppCatalog\StorageResource\StorageResourceDescription $storageResourceDescription);
  /**
   * Fetch the given Storage Resource.
   * 
   * @param storageResourceId
   *   The identifier for the requested storage resource
   * 
   * @return storageResourceDescription
   *    Storage Resource Object created from the datamodel..
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $storageResourceId
   * @return \Airavata\Model\AppCatalog\StorageResource\StorageResourceDescription Storage Resource Description
   * 
   * storageResourceId: Airavata Internal Unique Identifier to distinguish Compute Resource.
   * 
   * hostName:
   *   Fully Qualified Host Name.
   * 
   * storageResourceDescription:
   *  A user friendly description of the resource.
   * 
   * 
   * DataMovementProtocol:
   *  Option to specify a prefered data movement mechanism of the available options.
   * 
   * 
   * 
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getStorageResource(\Airavata\Model\Security\AuthzToken $authzToken, $storageResourceId);
  /**
   * Fetch all registered Storage Resources.
   * 
   * @return A map of registered compute resource id's and thier corresponding hostnames.
   *    Compute Resource Object created from the datamodel..
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @return array
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getAllStorageResourceNames(\Airavata\Model\Security\AuthzToken $authzToken);
  /**
   * Update a Storage Resource.
   * 
   * @param storageResourceId
   *   The identifier for the requested compute resource to be updated.
   * 
   * @param storageResourceDescription
   *    Storage Resource Object created from the datamodel.
   * 
   * @return status
   *   Returns a success/failure of the update.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $storageResourceId
   * @param \Airavata\Model\AppCatalog\StorageResource\StorageResourceDescription $storageResourceDescription
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function updateStorageResource(\Airavata\Model\Security\AuthzToken $authzToken, $storageResourceId, \Airavata\Model\AppCatalog\StorageResource\StorageResourceDescription $storageResourceDescription);
  /**
   * Delete a Storage Resource.
   * 
   * @param storageResourceId
   *   The identifier of the requested compute resource to be deleted.
   * 
   * @return status
   *   Returns a success/failure of the deletion.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $storageResourceId
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function deleteStorageResource(\Airavata\Model\Security\AuthzToken $authzToken, $storageResourceId);
  /**
   * Add a Local Job Submission details to a compute resource
   *  App catalog will return a jobSubmissionInterfaceId which will be added to the jobSubmissionInterfaces.
   * 
   * @param computeResourceId
   *   The identifier of the compute resource to which JobSubmission protocol to be added
   * 
   * @param priorityOrder
   *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
   * 
   * @param localSubmission
   *   The LOCALSubmission object to be added to the resource.
   * 
   * @return status
   *   Returns the unique job submission id.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $computeResourceId
   * @param int $priorityOrder
   * @param \Airavata\Model\AppCatalog\ComputeResource\LOCALSubmission $localSubmission
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function addLocalSubmissionDetails(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\LOCALSubmission $localSubmission);
  /**
   * Update the given Local Job Submission details
   * 
   * @param jobSubmissionInterfaceId
   *   The identifier of the JobSubmission Interface to be updated.
   * 
   * @param localSubmission
   *   The LOCALSubmission object to be updated.
   * 
   * @return status
   *   Returns a success/failure of the deletion.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $jobSubmissionInterfaceId
   * @param \Airavata\Model\AppCatalog\ComputeResource\LOCALSubmission $localSubmission
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function updateLocalSubmissionDetails(\Airavata\Model\Security\AuthzToken $authzToken, $jobSubmissionInterfaceId, \Airavata\Model\AppCatalog\ComputeResource\LOCALSubmission $localSubmission);
  /**
   * This method returns localJobSubmission object
   * @param jobSubmissionInterfaceId
   *   The identifier of the JobSubmission Interface to be retrieved.
   *  @return LOCALSubmission instance
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $jobSubmissionId
   * @return \Airavata\Model\AppCatalog\ComputeResource\LOCALSubmission Locally Fork Jobs as OS processes
   * 
   * alternativeSSHHostName:
   *  If the login to ssh is different than the hostname itself, specify it here
   * 
   * sshPort:
   *  If a non-default port needs to used, specify it.
   * 
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getLocalJobSubmission(\Airavata\Model\Security\AuthzToken $authzToken, $jobSubmissionId);
  /**
   * Add a SSH Job Submission details to a compute resource
   *  App catalog will return a jobSubmissionInterfaceId which will be added to the jobSubmissionInterfaces.
   * 
   * @param computeResourceId
   *   The identifier of the compute resource to which JobSubmission protocol to be added
   * 
   * @param priorityOrder
   *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
   * 
   * @param sshJobSubmission
   *   The SSHJobSubmission object to be added to the resource.
   * 
   * @return status
   *   Returns the unique job submission id.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $computeResourceId
   * @param int $priorityOrder
   * @param \Airavata\Model\AppCatalog\ComputeResource\SSHJobSubmission $sshJobSubmission
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function addSSHJobSubmissionDetails(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\SSHJobSubmission $sshJobSubmission);
  /**
   * Add a SSH_FORK Job Submission details to a compute resource
   *  App catalog will return a jobSubmissionInterfaceId which will be added to the jobSubmissionInterfaces.
   * 
   * @param computeResourceId
   *   The identifier of the compute resource to which JobSubmission protocol to be added
   * 
   * @param priorityOrder
   *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
   * 
   * @param sshJobSubmission
   *   The SSHJobSubmission object to be added to the resource.
   * 
   * @return status
   *   Returns the unique job submission id.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $computeResourceId
   * @param int $priorityOrder
   * @param \Airavata\Model\AppCatalog\ComputeResource\SSHJobSubmission $sshJobSubmission
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function addSSHForkJobSubmissionDetails(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\SSHJobSubmission $sshJobSubmission);
  /**
   * This method returns SSHJobSubmission object
   * @param jobSubmissionInterfaceId
   *   The identifier of the JobSubmission Interface to be retrieved.
   *  @return SSHJobSubmission instance
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $jobSubmissionId
   * @return \Airavata\Model\AppCatalog\ComputeResource\SSHJobSubmission Authenticate using Secured Shell
   * 
   * alternativeSSHHostName:
   *  If the login to ssh is different than the hostname itself, specify it here
   * 
   * sshPort:
   *  If a non-default port needs to used, specify it.
   * 
   * batchQueueEmailSenders:
   *  If a resource always sends the monitoring from a specific address, specify the
   *   full email address. If a resource sends emails from multiple addresses (
   *    example: based on the submitted login node) then use the wildchar * to indicate
   *    the same. Example: *@*.example.com or *@example.com
   * 
   * 
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getSSHJobSubmission(\Airavata\Model\Security\AuthzToken $authzToken, $jobSubmissionId);
  /**
   * 
   * Add a UNICORE Job Submission details to a compute resource
   *  App catalog will return a jobSubmissionInterfaceId which will be added to the jobSubmissionInterfaces.
   * 
   * @param computeResourceId
   *   The identifier of the compute resource to which JobSubmission protocol to be added
   * 
   * @param priorityOrder
   *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
   * 
   * @param unicoreJobSubmission
   *   The UnicoreJobSubmission object to be added to the resource.
   * 
   * @return status
   *  Returns the unique job submission id.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $computeResourceId
   * @param int $priorityOrder
   * @param \Airavata\Model\AppCatalog\ComputeResource\UnicoreJobSubmission $unicoreJobSubmission
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function addUNICOREJobSubmissionDetails(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\UnicoreJobSubmission $unicoreJobSubmission);
  /**
   *   *
   *   * This method returns UnicoreJobSubmission object
   *   *
   *   * @param jobSubmissionInterfaceId
   *   *   The identifier of the JobSubmission Interface to be retrieved.
   *   *  @return UnicoreJobSubmission instance
   *   *
   * *
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $jobSubmissionId
   * @return \Airavata\Model\AppCatalog\ComputeResource\UnicoreJobSubmission Unicore Job Submission
   * 
   * unicoreEndPointURL:
   *  unicoreGateway End Point. The provider will query this service to fetch required service end points.
   * authenticationMode
   *  The authenticationMode defines the way certificate is fetched.
   * 
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getUnicoreJobSubmission(\Airavata\Model\Security\AuthzToken $authzToken, $jobSubmissionId);
  /**
   *    *
   *    * Add a Cloud Job Submission details to a compute resource
   *    *  App catalog will return a jobSubmissionInterfaceId which will be added to the jobSubmissionInterfaces.
   *    *
   *    * @param computeResourceId
   *    *   The identifier of the compute resource to which JobSubmission protocol to be added
   *    *
   *    * @param priorityOrder
   *    *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
   *    *
   *    * @param sshJobSubmission
   *    *   The SSHJobSubmission object to be added to the resource.
   *    *
   *    * @return status
   *    *   Returns the unique job submission id.
   *    *
   * *
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $computeResourceId
   * @param int $priorityOrder
   * @param \Airavata\Model\AppCatalog\ComputeResource\CloudJobSubmission $cloudSubmission
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function addCloudJobSubmissionDetails(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\CloudJobSubmission $cloudSubmission);
  /**
   *    *
   *    * This method returns cloudJobSubmission object
   *    * @param jobSubmissionInterfaceI
   *        *   The identifier of the JobSubmission Interface to be retrieved.
   *    *  @return CloudJobSubmission instance
   * *
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $jobSubmissionId
   * @return \Airavata\Model\AppCatalog\ComputeResource\CloudJobSubmission Cloud Job Submission
   * 
   * 
   * 
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getCloudJobSubmission(\Airavata\Model\Security\AuthzToken $authzToken, $jobSubmissionId);
  /**
   * 
   * Update the given SSH Job Submission details
   * 
   * @param jobSubmissionInterfaceId
   *   The identifier of the JobSubmission Interface to be updated.
   * 
   * @param sshJobSubmission
   *   The SSHJobSubmission object to be updated.
   * 
   * @return status
   *   Returns a success/failure of the update.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $jobSubmissionInterfaceId
   * @param \Airavata\Model\AppCatalog\ComputeResource\SSHJobSubmission $sshJobSubmission
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function updateSSHJobSubmissionDetails(\Airavata\Model\Security\AuthzToken $authzToken, $jobSubmissionInterfaceId, \Airavata\Model\AppCatalog\ComputeResource\SSHJobSubmission $sshJobSubmission);
  /**
   * 
   * Update the cloud Job Submission details
   * 
   * @param jobSubmissionInterfaceId
   *   The identifier of the JobSubmission Interface to be updated.
   * 
   * @param cloudJobSubmission
   *   The CloudJobSubmission object to be updated.
   * 
   * @return status
   *   Returns a success/failure of the update.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $jobSubmissionInterfaceId
   * @param \Airavata\Model\AppCatalog\ComputeResource\CloudJobSubmission $sshJobSubmission
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function updateCloudJobSubmissionDetails(\Airavata\Model\Security\AuthzToken $authzToken, $jobSubmissionInterfaceId, \Airavata\Model\AppCatalog\ComputeResource\CloudJobSubmission $sshJobSubmission);
  /**
   * 
   * Update the UNIOCRE Job Submission details
   * 
   * @param jobSubmissionInterfaceId
   *   The identifier of the JobSubmission Interface to be updated.
   * 
   * @param UnicoreJobSubmission
   *   The UnicoreJobSubmission object to be updated.
   * 
   * @return status
   *   Returns a success/failure of the update.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $jobSubmissionInterfaceId
   * @param \Airavata\Model\AppCatalog\ComputeResource\UnicoreJobSubmission $unicoreJobSubmission
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function updateUnicoreJobSubmissionDetails(\Airavata\Model\Security\AuthzToken $authzToken, $jobSubmissionInterfaceId, \Airavata\Model\AppCatalog\ComputeResource\UnicoreJobSubmission $unicoreJobSubmission);
  /**
   * 
   * Add a Local data movement details to a compute resource
   *  App catalog will return a dataMovementInterfaceId which will be added to the dataMovementInterfaces.
   * 
   * @param productUri
   *   The identifier of the compute resource to which JobSubmission protocol to be added
   * 
   * @param DMType
   *   DMType object to be added to the resource.
   * 
   * @param priorityOrder
   *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
   * 
   * @param localDataMovement
   *   The LOCALDataMovement object to be added to the resource.
   * 
   * @return status
   *   Returns the unique job submission id.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $productUri
   * @param int $dataMoveType
   * @param int $priorityOrder
   * @param \Airavata\Model\Data\Movement\LOCALDataMovement $localDataMovement
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function addLocalDataMovementDetails(\Airavata\Model\Security\AuthzToken $authzToken, $productUri, $dataMoveType, $priorityOrder, \Airavata\Model\Data\Movement\LOCALDataMovement $localDataMovement);
  /**
   * 
   * Update the given Local data movement details
   * 
   * @param dataMovementInterfaceId
   *   The identifier of the data movement Interface to be updated.
   * 
   * @param localDataMovement
   *   The LOCALDataMovement object to be updated.
   * 
   * @return status
   *   Returns a success/failure of the update.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $dataMovementInterfaceId
   * @param \Airavata\Model\Data\Movement\LOCALDataMovement $localDataMovement
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function updateLocalDataMovementDetails(\Airavata\Model\Security\AuthzToken $authzToken, $dataMovementInterfaceId, \Airavata\Model\Data\Movement\LOCALDataMovement $localDataMovement);
  /**
   * 
   * This method returns local datamovement object.
   * 
   * @param dataMovementId
   *   The identifier of the datamovement Interface to be retrieved.
   * 
   *  @return LOCALDataMovement instance
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $dataMovementId
   * @return \Airavata\Model\Data\Movement\LOCALDataMovement LOCAL
   * 
   * alternativeSCPHostName:
   *  If the login to scp is different than the hostname itself, specify it here
   * 
   * sshPort:
   *  If a non-defualt port needs to used, specify it.
   * 
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getLocalDataMovement(\Airavata\Model\Security\AuthzToken $authzToken, $dataMovementId);
  /**
   * 
   * Add a SCP data movement details to a compute resource
   *  App catalog will return a dataMovementInterfaceId which will be added to the dataMovementInterfaces.
   * 
   * @param productUri
   *   The identifier of the compute resource to which JobSubmission protocol to be added
   * 
   * @param priorityOrder
   *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
   * 
   * @param scpDataMovement
   *   The SCPDataMovement object to be added to the resource.
   * 
   * @return status
   *   Returns the unique job submission id.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $productUri
   * @param int $dataMoveType
   * @param int $priorityOrder
   * @param \Airavata\Model\Data\Movement\SCPDataMovement $scpDataMovement
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function addSCPDataMovementDetails(\Airavata\Model\Security\AuthzToken $authzToken, $productUri, $dataMoveType, $priorityOrder, \Airavata\Model\Data\Movement\SCPDataMovement $scpDataMovement);
  /**
   * 
   * Update the given scp data movement details
   *  App catalog will return a dataMovementInterfaceId which will be added to the dataMovementInterfaces.
   * 
   * @param dataMovementInterfaceId
   *   The identifier of the data movement Interface to be updated.
   * 
   * @param scpDataMovement
   *   The SCPDataMovement object to be updated.
   * 
   * @return status
   *   Returns a success/failure of the update.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $dataMovementInterfaceId
   * @param \Airavata\Model\Data\Movement\SCPDataMovement $scpDataMovement
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function updateSCPDataMovementDetails(\Airavata\Model\Security\AuthzToken $authzToken, $dataMovementInterfaceId, \Airavata\Model\Data\Movement\SCPDataMovement $scpDataMovement);
  /**
   * This method returns SCP datamovement object
   * 
   * @param dataMovementId
   *   The identifier of the datamovement Interface to be retrieved.
   * 
   * @return SCPDataMovement instance
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $dataMovementId
   * @return \Airavata\Model\Data\Movement\SCPDataMovement Data Movement through Secured Copy
   * 
   * alternativeSCPHostName:
   *  If the login to scp is different than the hostname itself, specify it here
   * 
   * sshPort:
   *  If a non-default port needs to used, specify it.
   * 
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getSCPDataMovement(\Airavata\Model\Security\AuthzToken $authzToken, $dataMovementId);
  /**
   * 
   * Add a UNICORE data movement details to a compute resource
   *  App catalog will return a dataMovementInterfaceId which will be added to the dataMovementInterfaces.
   * 
   * @param productUri
   *   The identifier of the compute resource to which data movement protocol to be added
   * 
   * @param priorityOrder
   *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
   * 
   * @param UnicoreDataMovement
   *   The UnicoreDataMovement object to be added to the resource.
   * 
   * @return status
   *   Returns the unique data movement id.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $productUri
   * @param int $dataMoveType
   * @param int $priorityOrder
   * @param \Airavata\Model\Data\Movement\UnicoreDataMovement $unicoreDataMovement
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function addUnicoreDataMovementDetails(\Airavata\Model\Security\AuthzToken $authzToken, $productUri, $dataMoveType, $priorityOrder, \Airavata\Model\Data\Movement\UnicoreDataMovement $unicoreDataMovement);
  /**
   * 
   * Update a selected UNICORE data movement details
   *  App catalog will return a dataMovementInterfaceId which will be added to the dataMovementInterfaces.
   * 
   * @param dataMovementInterfaceId
   *   The identifier of the data movement Interface to be updated.
   * 
   * @param UnicoreDataMovement
   *   The UnicoreDataMovement object to be updated.
   * 
   * @return status
   *   Returns a success/failure of the update.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $dataMovementInterfaceId
   * @param \Airavata\Model\Data\Movement\UnicoreDataMovement $unicoreDataMovement
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function updateUnicoreDataMovementDetails(\Airavata\Model\Security\AuthzToken $authzToken, $dataMovementInterfaceId, \Airavata\Model\Data\Movement\UnicoreDataMovement $unicoreDataMovement);
  /**
   * 
   * This method returns UNICORE datamovement object
   * 
   * @param dataMovementId
   *   The identifier of the datamovement Interface to be retrieved.
   * 
   * @return UnicoreDataMovement instance
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $dataMovementId
   * @return \Airavata\Model\Data\Movement\UnicoreDataMovement Data Movement through UnicoreStorage
   * 
   * unicoreEndPointURL:
   *  unicoreGateway End Point. The provider will query this service to fetch required service end points.
   * 
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getUnicoreDataMovement(\Airavata\Model\Security\AuthzToken $authzToken, $dataMovementId);
  /**
   * 
   * Add a GridFTP data movement details to a compute resource
   *  App catalog will return a dataMovementInterfaceId which will be added to the dataMovementInterfaces.
   * 
   * @param productUri
   *   The identifier of the compute resource to which dataMovement protocol to be added
   * 
   * @param DMType
   *    The DMType object to be added to the resource.
   * 
   * @param priorityOrder
   *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
   * 
   * @param gridFTPDataMovement
   *   The GridFTPDataMovement object to be added to the resource.
   * 
   * @return status
   *   Returns the unique data movement id.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $productUri
   * @param int $dataMoveType
   * @param int $priorityOrder
   * @param \Airavata\Model\Data\Movement\GridFTPDataMovement $gridFTPDataMovement
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function addGridFTPDataMovementDetails(\Airavata\Model\Security\AuthzToken $authzToken, $productUri, $dataMoveType, $priorityOrder, \Airavata\Model\Data\Movement\GridFTPDataMovement $gridFTPDataMovement);
  /**
   * Update the given GridFTP data movement details to a compute resource
   *  App catalog will return a dataMovementInterfaceId which will be added to the dataMovementInterfaces.
   * 
   * @param dataMovementInterfaceId
   *   The identifier of the data movement Interface to be updated.
   * 
   * @param gridFTPDataMovement
   *   The GridFTPDataMovement object to be updated.
   * 
   * @return boolean
   *   Returns a success/failure of the update.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $dataMovementInterfaceId
   * @param \Airavata\Model\Data\Movement\GridFTPDataMovement $gridFTPDataMovement
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function updateGridFTPDataMovementDetails(\Airavata\Model\Security\AuthzToken $authzToken, $dataMovementInterfaceId, \Airavata\Model\Data\Movement\GridFTPDataMovement $gridFTPDataMovement);
  /**
   * This method returns GridFTP datamovement object
   * 
   * @param dataMovementId
   *   The identifier of the datamovement Interface to be retrieved.
   * 
   *  @return GridFTPDataMovement instance
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $dataMovementId
   * @return \Airavata\Model\Data\Movement\GridFTPDataMovement Data Movement through GridFTP
   * 
   * alternativeSCPHostName:
   *  If the login to scp is different than the hostname itself, specify it here
   * 
   * sshPort:
   *  If a non-default port needs to used, specify it.
   * 
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getGridFTPDataMovement(\Airavata\Model\Security\AuthzToken $authzToken, $dataMovementId);
  /**
   * Change the priority of a given job submisison interface
   * 
   * @param jobSubmissionInterfaceId
   *   The identifier of the JobSubmission Interface to be changed
   * 
   * @param priorityOrder
   *   The new priority of the job manager interface.
   * 
   * @return status
   *   Returns a success/failure of the change.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $jobSubmissionInterfaceId
   * @param int $newPriorityOrder
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function changeJobSubmissionPriority(\Airavata\Model\Security\AuthzToken $authzToken, $jobSubmissionInterfaceId, $newPriorityOrder);
  /**
   * Change the priority of a given data movement interface
   * 
   * @param dataMovementInterfaceId
   *   The identifier of the DataMovement Interface to be changed
   * 
   * @param priorityOrder
   *   The new priority of the data movement interface.
   * 
   * @return status
   *   Returns a success/failure of the change.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $dataMovementInterfaceId
   * @param int $newPriorityOrder
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function changeDataMovementPriority(\Airavata\Model\Security\AuthzToken $authzToken, $dataMovementInterfaceId, $newPriorityOrder);
  /**
   * Change the priorities of a given set of job submission interfaces
   * 
   * @param jobSubmissionPriorityMap
   *   A Map of identifiers of the JobSubmission Interfaces and thier associated priorities to be set.
   * 
   * @return status
   *   Returns a success/failure of the changes.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param array $jobSubmissionPriorityMap
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function changeJobSubmissionPriorities(\Airavata\Model\Security\AuthzToken $authzToken, array $jobSubmissionPriorityMap);
  /**
   * Change the priorities of a given set of data movement interfaces
   * 
   * @param dataMovementPriorityMap
   *   A Map of identifiers of the DataMovement Interfaces and thier associated priorities to be set.
   * 
   * @return status
   *   Returns a success/failure of the changes.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param array $dataMovementPriorityMap
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function changeDataMovementPriorities(\Airavata\Model\Security\AuthzToken $authzToken, array $dataMovementPriorityMap);
  /**
   * Delete a given job submisison interface
   * 
   * @param jobSubmissionInterfaceId
   *   The identifier of the JobSubmission Interface to be changed
   * 
   * @return status
   *   Returns a success/failure of the deletion.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $computeResourceId
   * @param string $jobSubmissionInterfaceId
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function deleteJobSubmissionInterface(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, $jobSubmissionInterfaceId);
  /**
   * Delete a given data movement interface
   * 
   * @param dataMovementInterfaceId
   *   The identifier of the DataMovement Interface to be changed
   * 
   * @return status
   *   Returns a success/failure of the deletion.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $productUri
   * @param string $dataMovementInterfaceId
   * @param int $dataMoveType
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function deleteDataMovementInterface(\Airavata\Model\Security\AuthzToken $authzToken, $productUri, $dataMovementInterfaceId, $dataMoveType);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param \Airavata\Model\AppCatalog\ComputeResource\ResourceJobManager $resourceJobManager
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function registerResourceJobManager(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\AppCatalog\ComputeResource\ResourceJobManager $resourceJobManager);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $resourceJobManagerId
   * @param \Airavata\Model\AppCatalog\ComputeResource\ResourceJobManager $updatedResourceJobManager
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function updateResourceJobManager(\Airavata\Model\Security\AuthzToken $authzToken, $resourceJobManagerId, \Airavata\Model\AppCatalog\ComputeResource\ResourceJobManager $updatedResourceJobManager);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $resourceJobManagerId
   * @return \Airavata\Model\AppCatalog\ComputeResource\ResourceJobManager Resource Job Manager Information
   * 
   * resourceJobManagerType:
   *  A typical HPC cluster has a single Job Manager to manage the resources.
   * 
   * pushMonitoringEndpoint:
   *  If the job manager pushes out state changes to a database or bus, specify the service endpoint.
   *   Ex: Moab Web Service, Moab MongoDB URL, AMQP (GLUE2) Broker
   * 
   * jobManagerBinPath:
   *  Path to the Job Manager Installation Binary directory.
   * 
   * jobManagerCommands:
   *  An enumeration of commonly used manager commands.
   * 
   * 
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getResourceJobManager(\Airavata\Model\Security\AuthzToken $authzToken, $resourceJobManagerId);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $resourceJobManagerId
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function deleteResourceJobManager(\Airavata\Model\Security\AuthzToken $authzToken, $resourceJobManagerId);
  /**
   * Delete a Compute Resource Queue
   * 
   * @param computeResourceId
   *   The identifier of the compute resource which has the queue to be deleted
   * 
   * @param queueName
   *   Name of the queue need to be deleted. Name is the uniqueue identifier for the queue within a compute resource
   * 
   * @return status
   *   Returns a success/failure of the deletion.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $computeResourceId
   * @param string $queueName
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function deleteBatchQueue(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, $queueName);
  /**
   * Register a Gateway Resource Profile.
   * 
   * @param gatewayResourceProfile
   *    Gateway Resource Profile Object.
   *    The GatewayID should be obtained from Airavata gateway registration and passed to register a corresponding
   *      resource profile.
   * 
   * @return status
   *   Returns a success/failure of the update.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param \Airavata\Model\AppCatalog\GatewayProfile\GatewayResourceProfile $gatewayResourceProfile
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function registerGatewayResourceProfile(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\AppCatalog\GatewayProfile\GatewayResourceProfile $gatewayResourceProfile);
  /**
   * Fetch the given Gateway Resource Profile.
   * 
   * @param gatewayID
   *   The identifier for the requested gateway resource.
   * 
   * @return gatewayResourceProfile
   *    Gateway Resource Profile Object.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayID
   * @return \Airavata\Model\AppCatalog\GatewayProfile\GatewayResourceProfile Gateway Resource Profile
   * 
   * gatewayID:
   *  Unique identifier for the gateway assigned by Airavata. Corelate this to Airavata Admin API Gateway Registration.
   * 
   * credentialStoreToken:
   *  Gateway's defualt credential store token.
   * 
   * computeResourcePreferences:
   *  List of resource preferences for each of the registered compute resources.
   * 
   *  identityServerTenant:
   * 
   *  identityServerPwdCredToken:
   * 
   * 
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getGatewayResourceProfile(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID);
  /**
   * Update a Gateway Resource Profile.
   * 
   * @param gatewayID
   *   The identifier for the requested gateway resource to be updated.
   * 
   * @param gatewayResourceProfile
   *    Gateway Resource Profile Object.
   * 
   * @return status
   *   Returns a success/failure of the update.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayID
   * @param \Airavata\Model\AppCatalog\GatewayProfile\GatewayResourceProfile $gatewayResourceProfile
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function updateGatewayResourceProfile(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID, \Airavata\Model\AppCatalog\GatewayProfile\GatewayResourceProfile $gatewayResourceProfile);
  /**
   * Delete the given Gateway Resource Profile.
   * 
   * @param gatewayID
   *   The identifier for the requested gateway resource to be deleted.
   * 
   * @return status
   *   Returns a success/failure of the deletion.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayID
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function deleteGatewayResourceProfile(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID);
  /**
   * Add a Compute Resource Preference to a registered gateway profile.
   * 
   * @param gatewayID
   *   The identifier for the gateway profile to be added.
   * 
   * @param computeResourceId
   *   Preferences related to a particular compute resource
   * 
   * @param computeResourcePreference
   *   The ComputeResourcePreference object to be added to the resource profile.
   * 
   * @return status
   *   Returns a success/failure of the addition. If a profile already exists, this operation will fail.
   *    Instead an update should be used.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayID
   * @param string $computeResourceId
   * @param \Airavata\Model\AppCatalog\GatewayProfile\ComputeResourcePreference $computeResourcePreference
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function addGatewayComputeResourcePreference(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID, $computeResourceId, \Airavata\Model\AppCatalog\GatewayProfile\ComputeResourcePreference $computeResourcePreference);
  /**
   * Add a Storage Resource Preference to a registered gateway profile.
   * 
   * @param gatewayID
   *   The identifier of the gateway profile to be added.
   * 
   * @param storageResourceId
   *   Preferences related to a particular compute resource
   * 
   * @param computeResourcePreference
   *   The ComputeResourcePreference object to be added to the resource profile.
   * 
   * @return status
   *   Returns a success/failure of the addition. If a profile already exists, this operation will fail.
   *    Instead an update should be used.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayID
   * @param string $storageResourceId
   * @param \Airavata\Model\AppCatalog\GatewayProfile\StoragePreference $storagePreference
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function addGatewayStoragePreference(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID, $storageResourceId, \Airavata\Model\AppCatalog\GatewayProfile\StoragePreference $storagePreference);
  /**
   * 
   * Fetch a Compute Resource Preference of a registered gateway profile.
   * 
   * @param gatewayID
   *   The identifier for the gateway profile to be requested
   * 
   * @param computeResourceId
   *   Preferences related to a particular compute resource
   * 
   * @return computeResourcePreference
   *   Returns the ComputeResourcePreference object.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayID
   * @param string $computeResourceId
   * @return \Airavata\Model\AppCatalog\GatewayProfile\ComputeResourcePreference Gateway specific preferences for a Computer Resource
   * 
   * computeResourceId:
   *   Corelate the preference to a compute resource.
   * 
   * overridebyAiravata:
   *   If turned true, Airavata will override the preferences of better alternatives exist.
   * 
   * loginUserName:
   *   If turned true, Airavata will override the preferences of better alternatives exist.
   * 
   * preferredJobSubmissionProtocol:
   *   For resources with multiple job submission protocols, the gateway can pick a preferred option.
   * 
   * preferredDataMovementProtocol:
   *   For resources with multiple data movement protocols, the gateway can pick a preferred option.
   * 
   * preferredBatchQueue:
   *  Gateways can choose a defualt batch queue based on average job dimention, reservations or other metrics.
   * 
   * scratchLocation:
   *  Path to the local scratch space on a HPC cluster. Typically used to create working directory for job execution.
   * 
   * allocationProjectNumber:
   *  Typically used on HPC machines to charge computing usage to a account number. For instance, on XSEDE once an
   *    allocation is approved, an allocation number is assigned. Before passing this number with job submittions, the
   *    account to be used has to be added to the allocation.
   * 
   * resourceSpecificCredentialStoreToken:
   *  Resource specific credential store token. If this token is specified, then it is superceeded by the gateway's
   *   default credential store.
   * 
   * 
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getGatewayComputeResourcePreference(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID, $computeResourceId);
  /**
   * 
   * Fetch a Storage Resource Preference of a registered gateway profile.
   * 
   * @param gatewayID
   *   The identifier of the gateway profile to request to fetch the particular storage resource preference.
   * 
   * @param storageResourceId
   *   Identifier of the Stprage Preference required to be fetched.
   * 
   * @return StoragePreference
   *   Returns the StoragePreference object.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayID
   * @param string $storageResourceId
   * @return \Airavata\Model\AppCatalog\GatewayProfile\StoragePreference
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getGatewayStoragePreference(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID, $storageResourceId);
  /**
   * 
   * Fetch all Compute Resource Preferences of a registered gateway profile.
   * 
   * @param gatewayID
   *   The identifier for the gateway profile to be requested
   * 
   * @return computeResourcePreference
   *   Returns the ComputeResourcePreference object.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayID
   * @return \Airavata\Model\AppCatalog\GatewayProfile\ComputeResourcePreference[]
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getAllGatewayComputeResourcePreferences(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID);
  /**
   * Fetch all Storage Resource Preferences of a registered gateway profile.
   * 
   * @param gatewayID
   *   The identifier for the gateway profile to be requested
   * 
   * @return StoragePreference
   *   Returns the StoragePreference object.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayID
   * @return \Airavata\Model\AppCatalog\GatewayProfile\StoragePreference[]
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getAllGatewayStoragePreferences(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID);
  /**
   * 
   * Fetch all Gateway Profiles registered
   * 
   * @return GatewayResourceProfile
   *   Returns all the GatewayResourcePrifle list object.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @return \Airavata\Model\AppCatalog\GatewayProfile\GatewayResourceProfile[]
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getAllGatewayResourceProfiles(\Airavata\Model\Security\AuthzToken $authzToken);
  /**
   * Update a Compute Resource Preference to a registered gateway profile.
   * 
   * @param gatewayID
   *   The identifier for the gateway profile to be updated.
   * 
   * @param computeResourceId
   *   Preferences related to a particular compute resource
   * 
   * @param computeResourcePreference
   *   The ComputeResourcePreference object to be updated to the resource profile.
   * 
   * @return status
   *   Returns a success/failure of the updation.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayID
   * @param string $computeResourceId
   * @param \Airavata\Model\AppCatalog\GatewayProfile\ComputeResourcePreference $computeResourcePreference
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function updateGatewayComputeResourcePreference(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID, $computeResourceId, \Airavata\Model\AppCatalog\GatewayProfile\ComputeResourcePreference $computeResourcePreference);
  /**
   * Update a Storage Resource Preference of a registered gateway profile.
   * 
   * @param gatewayID
   *   The identifier of the gateway profile to be updated.
   * 
   * @param storageId
   *   The Storage resource identifier of the one that you want to update
   * 
   * @param storagePreference
   *   The storagePreference object to be updated to the resource profile.
   * 
   * @return status
   *   Returns a success/failure of the updation.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayID
   * @param string $storageId
   * @param \Airavata\Model\AppCatalog\GatewayProfile\StoragePreference $storagePreference
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function updateGatewayStoragePreference(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID, $storageId, \Airavata\Model\AppCatalog\GatewayProfile\StoragePreference $storagePreference);
  /**
   * Delete the Compute Resource Preference of a registered gateway profile.
   * 
   * @param gatewayID
   *   The identifier for the gateway profile to be deleted.
   * 
   * @param computeResourceId
   *   Preferences related to a particular compute resource
   * 
   * @return status
   *   Returns a success/failure of the deletion.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayID
   * @param string $computeResourceId
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function deleteGatewayComputeResourcePreference(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID, $computeResourceId);
  /**
   * Delete the Storage Resource Preference of a registered gateway profile.
   * 
   * @param gatewayID
   *   The identifier of the gateway profile to be deleted.
   * 
   * @param storageId
   *   ID of the storage preference you want to delete.
   * 
   * @return status
   *   Returns a success/failure of the deletion.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayID
   * @param string $storageId
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function deleteGatewayStoragePreference(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID, $storageId);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @return \Airavata\Model\AppCatalog\AccountProvisioning\SSHAccountProvisioner[]
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getSSHAccountProvisioners(\Airavata\Model\Security\AuthzToken $authzToken);
  /**
   * Check if user has an SSH account on the given compute resource. This
   * method will only work if the compute resource has an SSHAccountProvisioner configured for it.
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $computeResourceId
   * @param string $userId
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function doesUserHaveSSHAccount(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, $userId);
  /**
   * Check if SSH account setup is complete for this user on the given compute resource.
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $computeResourceId
   * @param string $airavataCredStoreToken
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function isSSHSetupCompleteForUserComputeResourcePreference(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, $airavataCredStoreToken);
  /**
   * Setup and return a UserComputeResourcePreference object for this user to SSH into the given compute resource with
   * the given SSH credential. This method will only work if the compute resource has an SSHAccountProvisioner
   * configured for it. The returned UserComputeResourcePreference object is not saved; it is up to the client to
   * call addUserComputeResourcePreference to persist it.
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $computeResourceId
   * @param string $userId
   * @param string $airavataCredStoreToken
   * @return \Airavata\Model\AppCatalog\UserResourceProfile\UserComputeResourcePreference User specific preferences for a Computer Resource
   * 
   * computeResourceId:
   *   Corelate the preference to a compute resource.
   * 
   * 
   * loginUserName:
   *   If turned true, Airavata will override the preferences of better alternatives exist.
   * 
   * 
   * preferredBatchQueue:
   *  Gateways can choose a defualt batch queue based on average job dimention, reservations or other metrics.
   * 
   * scratchLocation:
   *  Path to the local scratch space on a HPC cluster. Typically used to create working directory for job execution.
   * 
   * allocationProjectNumber:
   *  Typically used on HPC machines to charge computing usage to a account number. For instance, on XSEDE once an
   *    allocation is approved, an allocation number is assigned. Before passing this number with job submittions, the
   *    account to be used has to be added to the allocation.
   * 
   * resourceSpecificCredentialStoreToken:
   *  Resource specific credential store token. If this token is specified, then it is superceeded by the gateway's
   *   default credential store.
   * 
   * validated:
   *  If true the the configuration has been validated in the sense that the username and credential can be used to
   *  login to the remote host and the scratchLocation is a valid location that the user has permission to write to.
   *  Should be treated as read-only and only mutated by Airavata middleware.
   * 
   * 
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function setupUserComputeResourcePreferencesForSSH(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, $userId, $airavataCredStoreToken);
  /**
   * Register User Resource Profile.
   * 
   * @param UserResourceProfile
   *    User Resource Profile Object.
   *    The userId should be obtained from Airavata user profile data model and passed to register a corresponding
   *      resource profile.
   * 
   * @return status
   *   Returns a success/failure of the update.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param \Airavata\Model\AppCatalog\UserResourceProfile\UserResourceProfile $userResourceProfile
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function registerUserResourceProfile(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\AppCatalog\UserResourceProfile\UserResourceProfile $userResourceProfile);
  /**
   * Fetch the given User Resource Profile.
   * 
   * @param userId
   *   The identifier for the requested user resource profile.
   * 
   * @param gatewayID
   *   The identifier to link a gateway for the requested user resource profile.
   * 
   * @return UserResourceProfile
   *    User Resource Profile Object.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $userId
   * @param string $gatewayID
   * @return \Airavata\Model\AppCatalog\UserResourceProfile\UserResourceProfile User Resource Profile
   * 
   * userId:
   * Unique identifier used to link user to corresponding user data model
   * 
   * gatewayID:
   *  Unique identifier for the gateway assigned by Airavata. Corelate this to Airavata Admin API Gateway Registration.
   * 
   * credentialStoreToken:
   *  Gateway's defualt credential store token.
   * 
   * computeResourcePreferences:
   *  List of resource preferences for each of the registered compute resources.
   * 
   *  identityServerTenant:
   * 
   *  identityServerPwdCredToken:
   * 
   * isNull:
   *  Indicates that this instance is just a container for a null value.
   * 
   * 
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getUserResourceProfile(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID);
  /**
   * Update a User Resource Profile.
   * 
   * @param userId
   *   The identifier for the requested user resource to be updated.
   * 
   * @param gatewayID
   *   The identifier to link a gateway for the requested user resource profile.
   * 
   * @param UserResourceProfile
   *    User Resource Profile Object.
   * 
   * @return status
   *   Returns a success/failure of the update.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $userId
   * @param string $gatewayID
   * @param \Airavata\Model\AppCatalog\UserResourceProfile\UserResourceProfile $userResourceProfile
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function updateUserResourceProfile(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID, \Airavata\Model\AppCatalog\UserResourceProfile\UserResourceProfile $userResourceProfile);
  /**
   * Delete the given User Resource Profile.
   * 
   * @param userId
   *   The identifier for the requested user resource to be deleted.
   * 
   * @param gatewayID
   *   The identifier to link a gateway for the requested user resource profile.
   * 
   * @return status
   *   Returns a success/failure of the deletion.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $userId
   * @param string $gatewayID
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function deleteUserResourceProfile(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID);
  /**
   * Add a Compute Resource Preference to a registered User profile.
   * 
   * @param userId
   *   The identifier for the User resource profile to be added.
   * 
   * @param gatewayID
   *   The identifier to link a gateway for the requested user resource profile.
   * 
   * @param computeResourceId
   *   Preferences related to a particular compute resource
   * 
   * @param computeResourcePreference
   *   The ComputeResourcePreference object to be added to the resource profile.
   * 
   * @return status
   *   Returns a success/failure of the addition. If a profile already exists, this operation will fail.
   *    Instead an update should be used.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $userId
   * @param string $gatewayID
   * @param string $userComputeResourceId
   * @param \Airavata\Model\AppCatalog\UserResourceProfile\UserComputeResourcePreference $userComputeResourcePreference
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function addUserComputeResourcePreference(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID, $userComputeResourceId, \Airavata\Model\AppCatalog\UserResourceProfile\UserComputeResourcePreference $userComputeResourcePreference);
  /**
   * Add a Storage Resource Preference to a registered user resource profile.
   * 
   * @param userId
   *   The identifier of the user resource profile to be added.
   * 
   * @param gatewayID
   *   The identifier to link a gateway for the requested user resource profile.
   * 
   * @param storageResourceId
   *   Preferences related to a particular compute resource
   * 
   * @param computeResourcePreference
   *   The ComputeResourcePreference object to be added to the resource profile.
   * 
   * @return status
   *   Returns a success/failure of the addition. If a profile already exists, this operation will fail.
   *    Instead an update should be used.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $userId
   * @param string $gatewayID
   * @param string $userStorageResourceId
   * @param \Airavata\Model\AppCatalog\UserResourceProfile\UserStoragePreference $userStoragePreference
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function addUserStoragePreference(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID, $userStorageResourceId, \Airavata\Model\AppCatalog\UserResourceProfile\UserStoragePreference $userStoragePreference);
  /**
   * 
   * Fetch a Compute Resource Preference of a registered user resource profile.
   * 
   * @param userId
   *   The identifier for the user profile to be requested
   * 
   * @param gatewayID
   *   The identifier to link a gateway for the requested user resource profile.
   * 
   * @param userComputeResourceId
   *   Preferences related to a particular compute resource
   * 
   * @return computeResourcePreference
   *   Returns the ComputeResourcePreference object.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $userId
   * @param string $gatewayID
   * @param string $userComputeResourceId
   * @return \Airavata\Model\AppCatalog\UserResourceProfile\UserComputeResourcePreference User specific preferences for a Computer Resource
   * 
   * computeResourceId:
   *   Corelate the preference to a compute resource.
   * 
   * 
   * loginUserName:
   *   If turned true, Airavata will override the preferences of better alternatives exist.
   * 
   * 
   * preferredBatchQueue:
   *  Gateways can choose a defualt batch queue based on average job dimention, reservations or other metrics.
   * 
   * scratchLocation:
   *  Path to the local scratch space on a HPC cluster. Typically used to create working directory for job execution.
   * 
   * allocationProjectNumber:
   *  Typically used on HPC machines to charge computing usage to a account number. For instance, on XSEDE once an
   *    allocation is approved, an allocation number is assigned. Before passing this number with job submittions, the
   *    account to be used has to be added to the allocation.
   * 
   * resourceSpecificCredentialStoreToken:
   *  Resource specific credential store token. If this token is specified, then it is superceeded by the gateway's
   *   default credential store.
   * 
   * validated:
   *  If true the the configuration has been validated in the sense that the username and credential can be used to
   *  login to the remote host and the scratchLocation is a valid location that the user has permission to write to.
   *  Should be treated as read-only and only mutated by Airavata middleware.
   * 
   * 
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getUserComputeResourcePreference(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID, $userComputeResourceId);
  /**
   * 
   * Fetch a Storage Resource Preference of a registered user resource profile.
   * 
   * @param userId
   *   The identifier of the user resource profile to request to fetch the particular storage resource preference.
   * 
   * @param gatewayID
   *   The identifier to link a gateway for the requested user resource profile.
   * 
   * @param userStorageResourceId
   *   Identifier of the Stprage Preference required to be fetched.
   * 
   * @return UserStoragePreference
   *   Returns the StoragePreference object.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $userId
   * @param string $gatewayID
   * @param string $userStorageResourceId
   * @return \Airavata\Model\AppCatalog\UserResourceProfile\UserStoragePreference
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getUserStoragePreference(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID, $userStorageResourceId);
  /**
   * 
   * Fetch all Compute Resource Preferences of a registered gateway profile.
   * 
   * @param userId
   *   The identifier of the user resource profile to request to fetch the particular storage resource preference.
   * 
   * @param gatewayID
   *   The identifier for the gateway profile to be requested
   * 
   * @return computeResourcePreference
   *   Returns the ComputeResourcePreference object.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $userId
   * @param string $gatewayID
   * @return \Airavata\Model\AppCatalog\UserResourceProfile\UserComputeResourcePreference[]
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getAllUserComputeResourcePreferences(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID);
  /**
   * Fetch all User Storage Resource Preferences of a registered user profile.
   * 
   * @param userId
   *   The identifier of the user resource profile to request to fetch the particular storage resource preference.
   * 
   * @param gatewayID
   *   The identifier for the gateway profile to be requested
   * 
   * @return StoragePreference
   *   Returns the StoragePreference object.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $userId
   * @param string $gatewayID
   * @return \Airavata\Model\AppCatalog\UserResourceProfile\UserStoragePreference[]
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getAllUserStoragePreferences(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID);
  /**
   * 
   * Fetch all user resources Profiles registered
   * 
   * @return UserResourceProfile
   *   Returns all the UserResourcePrifle list object.
   * 
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @return \Airavata\Model\AppCatalog\UserResourceProfile\UserResourceProfile[]
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getAllUserResourceProfiles(\Airavata\Model\Security\AuthzToken $authzToken);
  /**
   * Update a Compute Resource Preference to a registered user resource profile.
   * 
   * @param userId
   *   The identifier for the user profile to be updated.
   * 
   * @param gatewayID
   *   The identifier to link a gateway for the requested user resource profile.
   * 
   * @param userComputeResourceId
   *   Preferences related to a particular compute resource
   * 
   * @param userComputeResourcePreference
   *   The ComputeResourcePreference object to be updated to the resource profile.
   * 
   * @return status
   *   Returns a success/failure of the updation.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $userId
   * @param string $gatewayID
   * @param string $userComputeResourceId
   * @param \Airavata\Model\AppCatalog\UserResourceProfile\UserComputeResourcePreference $userComputeResourcePreference
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function updateUserComputeResourcePreference(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID, $userComputeResourceId, \Airavata\Model\AppCatalog\UserResourceProfile\UserComputeResourcePreference $userComputeResourcePreference);
  /**
   * Update a Storage Resource Preference of a registered user resource profile.
   * 
   * @param userId
   *   The identifier of the user resource profile to be updated.
   * 
   * @param gatewayID
   *   The identifier to link a gateway for the requested user resource profile.
   * 
   * @param userStorageId
   *   The Storage resource identifier of the one that you want to update
   * 
   * @param userStoragePreference
   *   The storagePreference object to be updated to the resource profile.
   * 
   * @return status
   *   Returns a success/failure of the updation.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $userId
   * @param string $gatewayID
   * @param string $userStorageId
   * @param \Airavata\Model\AppCatalog\UserResourceProfile\UserStoragePreference $userStoragePreference
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function updateUserStoragePreference(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID, $userStorageId, \Airavata\Model\AppCatalog\UserResourceProfile\UserStoragePreference $userStoragePreference);
  /**
   * Delete the Compute Resource Preference of a registered user resource profile.
   * 
   * @param userId
   *   The identifier for the user resource profile to be deleted.
   * 
   * @param gatewayID
   *   The identifier to link a gateway for the requested user resource profile.
   * 
   * @param userComputeResourceId
   *   Preferences related to a particular compute resource
   * 
   * @return status
   *   Returns a success/failure of the deletion.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $userId
   * @param string $gatewayID
   * @param string $userComputeResourceId
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function deleteUserComputeResourcePreference(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID, $userComputeResourceId);
  /**
   * Delete the Storage Resource Preference of a registered user resource profile.
   * 
   * @param userId
   *   The identifier of the user profile to be deleted.
   * 
   * @param gatewayID
   *   The identifier to link a gateway for the requested user resource profile.
   * 
   * @param userStorageId
   *   ID of the storage preference you want to delete.
   * 
   * @return status
   *   Returns a success/failure of the deletion.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $userId
   * @param string $gatewayID
   * @param string $userStorageId
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function deleteUserStoragePreference(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID, $userStorageId);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayId
   * @return string[]
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getAllWorkflows(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @return \Airavata\Model\Status\QueueStatusModel[]
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getLatestQueueStatuses(\Airavata\Model\Security\AuthzToken $authzToken);
  /**
   * 
   * API Methods Related for Work-Flow Submission Features.
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $workflowTemplateId
   * @return \Airavata\Model\WorkflowModel
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getWorkflow(\Airavata\Model\Security\AuthzToken $authzToken, $workflowTemplateId);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $workflowTemplateId
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function deleteWorkflow(\Airavata\Model\Security\AuthzToken $authzToken, $workflowTemplateId);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayId
   * @param \Airavata\Model\WorkflowModel $workflow
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function registerWorkflow(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, \Airavata\Model\WorkflowModel $workflow);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $workflowTemplateId
   * @param \Airavata\Model\WorkflowModel $workflow
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function updateWorkflow(\Airavata\Model\Security\AuthzToken $authzToken, $workflowTemplateId, \Airavata\Model\WorkflowModel $workflow);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $workflowName
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getWorkflowTemplateId(\Airavata\Model\Security\AuthzToken $authzToken, $workflowName);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $workflowName
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function isWorkflowExistWithName(\Airavata\Model\Security\AuthzToken $authzToken, $workflowName);
  /**
   * API Methods related to replica catalog
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param \Airavata\Model\Data\Replica\DataProductModel $dataProductModel
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function registerDataProduct(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\Data\Replica\DataProductModel $dataProductModel);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $dataProductUri
   * @return \Airavata\Model\Data\Replica\DataProductModel
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getDataProduct(\Airavata\Model\Security\AuthzToken $authzToken, $dataProductUri);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param \Airavata\Model\Data\Replica\DataReplicaLocationModel $replicaLocationModel
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function registerReplicaLocation(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\Data\Replica\DataReplicaLocationModel $replicaLocationModel);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $productUri
   * @return \Airavata\Model\Data\Replica\DataProductModel
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getParentDataProduct(\Airavata\Model\Security\AuthzToken $authzToken, $productUri);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $productUri
   * @return \Airavata\Model\Data\Replica\DataProductModel[]
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getChildDataProducts(\Airavata\Model\Security\AuthzToken $authzToken, $productUri);
  /**
   * Group Manager and Data Sharing Related API methods
   * 
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $resourceId
   * @param int $resourceType
   * @param array $userPermissionList
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function shareResourceWithUsers(\Airavata\Model\Security\AuthzToken $authzToken, $resourceId, $resourceType, array $userPermissionList);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $resourceId
   * @param int $resourceType
   * @param array $userPermissionList
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function revokeSharingOfResourceFromUsers(\Airavata\Model\Security\AuthzToken $authzToken, $resourceId, $resourceType, array $userPermissionList);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $resourceId
   * @param int $resourceType
   * @param int $permissionType
   * @return string[]
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getAllAccessibleUsers(\Airavata\Model\Security\AuthzToken $authzToken, $resourceId, $resourceType, $permissionType);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param \Airavata\Model\Group\GroupModel $groupModel
   * @return string
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function createGroup(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\Group\GroupModel $groupModel);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param \Airavata\Model\Group\GroupModel $groupModel
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function updateGroup(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\Group\GroupModel $groupModel);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $groupId
   * @param string $ownerId
   * @return bool
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function deleteGroup(\Airavata\Model\Security\AuthzToken $authzToken, $groupId, $ownerId);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $groupId
   * @return \Airavata\Model\Group\GroupModel
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getGroup(\Airavata\Model\Security\AuthzToken $authzToken, $groupId);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $userName
   * @return \Airavata\Model\Group\GroupModel[]
   * @throws \Airavata\API\Error\InvalidRequestException
   * @throws \Airavata\API\Error\AiravataClientException
   * @throws \Airavata\API\Error\AiravataSystemException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getAllGroupsUserBelongs(\Airavata\Model\Security\AuthzToken $authzToken, $userName);
}

class AiravataClient implements \Airavata\API\AiravataIf {
  protected $input_ = null;
  protected $output_ = null;

  protected $seqid_ = 0;

  public function __construct($input, $output=null) {
    $this->input_ = $input;
    $this->output_ = $output ? $output : $input;
  }

  public function getAPIVersion(\Airavata\Model\Security\AuthzToken $authzToken)
  {
    $this->send_getAPIVersion($authzToken);
    return $this->recv_getAPIVersion();
  }

  public function send_getAPIVersion(\Airavata\Model\Security\AuthzToken $authzToken)
  {
    $args = new \Airavata\API\Airavata_getAPIVersion_args();
    $args->authzToken = $authzToken;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAPIVersion', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAPIVersion', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAPIVersion()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAPIVersion_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAPIVersion_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getAPIVersion failed: unknown result");
  }

  public function isUserExists(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $userName)
  {
    $this->send_isUserExists($authzToken, $gatewayId, $userName);
    return $this->recv_isUserExists();
  }

  public function send_isUserExists(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $userName)
  {
    $args = new \Airavata\API\Airavata_isUserExists_args();
    $args->authzToken = $authzToken;
    $args->gatewayId = $gatewayId;
    $args->userName = $userName;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'isUserExists', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('isUserExists', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_isUserExists()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_isUserExists_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_isUserExists_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("isUserExists failed: unknown result");
  }

  public function addGateway(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\Workspace\Gateway $gateway)
  {
    $this->send_addGateway($authzToken, $gateway);
    return $this->recv_addGateway();
  }

  public function send_addGateway(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\Workspace\Gateway $gateway)
  {
    $args = new \Airavata\API\Airavata_addGateway_args();
    $args->authzToken = $authzToken;
    $args->gateway = $gateway;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'addGateway', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('addGateway', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_addGateway()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_addGateway_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_addGateway_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("addGateway failed: unknown result");
  }

  public function getAllUsersInGateway(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId)
  {
    $this->send_getAllUsersInGateway($authzToken, $gatewayId);
    return $this->recv_getAllUsersInGateway();
  }

  public function send_getAllUsersInGateway(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId)
  {
    $args = new \Airavata\API\Airavata_getAllUsersInGateway_args();
    $args->authzToken = $authzToken;
    $args->gatewayId = $gatewayId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllUsersInGateway', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllUsersInGateway', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllUsersInGateway()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAllUsersInGateway_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAllUsersInGateway_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getAllUsersInGateway failed: unknown result");
  }

  public function updateGateway(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, \Airavata\Model\Workspace\Gateway $updatedGateway)
  {
    $this->send_updateGateway($authzToken, $gatewayId, $updatedGateway);
    return $this->recv_updateGateway();
  }

  public function send_updateGateway(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, \Airavata\Model\Workspace\Gateway $updatedGateway)
  {
    $args = new \Airavata\API\Airavata_updateGateway_args();
    $args->authzToken = $authzToken;
    $args->gatewayId = $gatewayId;
    $args->updatedGateway = $updatedGateway;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateGateway', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateGateway', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateGateway()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateGateway_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateGateway_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("updateGateway failed: unknown result");
  }

  public function getGateway(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId)
  {
    $this->send_getGateway($authzToken, $gatewayId);
    return $this->recv_getGateway();
  }

  public function send_getGateway(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId)
  {
    $args = new \Airavata\API\Airavata_getGateway_args();
    $args->authzToken = $authzToken;
    $args->gatewayId = $gatewayId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getGateway', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getGateway', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getGateway()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getGateway_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getGateway_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getGateway failed: unknown result");
  }

  public function deleteGateway(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId)
  {
    $this->send_deleteGateway($authzToken, $gatewayId);
    return $this->recv_deleteGateway();
  }

  public function send_deleteGateway(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId)
  {
    $args = new \Airavata\API\Airavata_deleteGateway_args();
    $args->authzToken = $authzToken;
    $args->gatewayId = $gatewayId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteGateway', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteGateway', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteGateway()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteGateway_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteGateway_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("deleteGateway failed: unknown result");
  }

  public function getAllGateways(\Airavata\Model\Security\AuthzToken $authzToken)
  {
    $this->send_getAllGateways($authzToken);
    return $this->recv_getAllGateways();
  }

  public function send_getAllGateways(\Airavata\Model\Security\AuthzToken $authzToken)
  {
    $args = new \Airavata\API\Airavata_getAllGateways_args();
    $args->authzToken = $authzToken;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllGateways', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllGateways', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllGateways()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAllGateways_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAllGateways_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getAllGateways failed: unknown result");
  }

  public function isGatewayExist(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId)
  {
    $this->send_isGatewayExist($authzToken, $gatewayId);
    return $this->recv_isGatewayExist();
  }

  public function send_isGatewayExist(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId)
  {
    $args = new \Airavata\API\Airavata_isGatewayExist_args();
    $args->authzToken = $authzToken;
    $args->gatewayId = $gatewayId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'isGatewayExist', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('isGatewayExist', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_isGatewayExist()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_isGatewayExist_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_isGatewayExist_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("isGatewayExist failed: unknown result");
  }

  public function createNotification(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\Workspace\Notification $notification)
  {
    $this->send_createNotification($authzToken, $notification);
    return $this->recv_createNotification();
  }

  public function send_createNotification(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\Workspace\Notification $notification)
  {
    $args = new \Airavata\API\Airavata_createNotification_args();
    $args->authzToken = $authzToken;
    $args->notification = $notification;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'createNotification', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('createNotification', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_createNotification()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_createNotification_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_createNotification_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("createNotification failed: unknown result");
  }

  public function updateNotification(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\Workspace\Notification $notification)
  {
    $this->send_updateNotification($authzToken, $notification);
    return $this->recv_updateNotification();
  }

  public function send_updateNotification(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\Workspace\Notification $notification)
  {
    $args = new \Airavata\API\Airavata_updateNotification_args();
    $args->authzToken = $authzToken;
    $args->notification = $notification;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateNotification', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateNotification', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateNotification()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateNotification_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateNotification_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("updateNotification failed: unknown result");
  }

  public function deleteNotification(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $notificationId)
  {
    $this->send_deleteNotification($authzToken, $gatewayId, $notificationId);
    return $this->recv_deleteNotification();
  }

  public function send_deleteNotification(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $notificationId)
  {
    $args = new \Airavata\API\Airavata_deleteNotification_args();
    $args->authzToken = $authzToken;
    $args->gatewayId = $gatewayId;
    $args->notificationId = $notificationId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteNotification', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteNotification', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteNotification()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteNotification_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteNotification_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("deleteNotification failed: unknown result");
  }

  public function getNotification(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $notificationId)
  {
    $this->send_getNotification($authzToken, $gatewayId, $notificationId);
    return $this->recv_getNotification();
  }

  public function send_getNotification(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $notificationId)
  {
    $args = new \Airavata\API\Airavata_getNotification_args();
    $args->authzToken = $authzToken;
    $args->gatewayId = $gatewayId;
    $args->notificationId = $notificationId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getNotification', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getNotification', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getNotification()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getNotification_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getNotification_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getNotification failed: unknown result");
  }

  public function getAllNotifications(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId)
  {
    $this->send_getAllNotifications($authzToken, $gatewayId);
    return $this->recv_getAllNotifications();
  }

  public function send_getAllNotifications(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId)
  {
    $args = new \Airavata\API\Airavata_getAllNotifications_args();
    $args->authzToken = $authzToken;
    $args->gatewayId = $gatewayId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllNotifications', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllNotifications', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllNotifications()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAllNotifications_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAllNotifications_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getAllNotifications failed: unknown result");
  }

  public function generateAndRegisterSSHKeys(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $userName, $description, $credentialOwnerType)
  {
    $this->send_generateAndRegisterSSHKeys($authzToken, $gatewayId, $userName, $description, $credentialOwnerType);
    return $this->recv_generateAndRegisterSSHKeys();
  }

  public function send_generateAndRegisterSSHKeys(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $userName, $description, $credentialOwnerType)
  {
    $args = new \Airavata\API\Airavata_generateAndRegisterSSHKeys_args();
    $args->authzToken = $authzToken;
    $args->gatewayId = $gatewayId;
    $args->userName = $userName;
    $args->description = $description;
    $args->credentialOwnerType = $credentialOwnerType;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'generateAndRegisterSSHKeys', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('generateAndRegisterSSHKeys', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_generateAndRegisterSSHKeys()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_generateAndRegisterSSHKeys_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_generateAndRegisterSSHKeys_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("generateAndRegisterSSHKeys failed: unknown result");
  }

  public function registerPwdCredential(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $portalUserName, $loginUserName, $password, $description)
  {
    $this->send_registerPwdCredential($authzToken, $gatewayId, $portalUserName, $loginUserName, $password, $description);
    return $this->recv_registerPwdCredential();
  }

  public function send_registerPwdCredential(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $portalUserName, $loginUserName, $password, $description)
  {
    $args = new \Airavata\API\Airavata_registerPwdCredential_args();
    $args->authzToken = $authzToken;
    $args->gatewayId = $gatewayId;
    $args->portalUserName = $portalUserName;
    $args->loginUserName = $loginUserName;
    $args->password = $password;
    $args->description = $description;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'registerPwdCredential', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('registerPwdCredential', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_registerPwdCredential()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_registerPwdCredential_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_registerPwdCredential_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("registerPwdCredential failed: unknown result");
  }

  public function getSSHPubKey(\Airavata\Model\Security\AuthzToken $authzToken, $airavataCredStoreToken, $gatewayId)
  {
    $this->send_getSSHPubKey($authzToken, $airavataCredStoreToken, $gatewayId);
    return $this->recv_getSSHPubKey();
  }

  public function send_getSSHPubKey(\Airavata\Model\Security\AuthzToken $authzToken, $airavataCredStoreToken, $gatewayId)
  {
    $args = new \Airavata\API\Airavata_getSSHPubKey_args();
    $args->authzToken = $authzToken;
    $args->airavataCredStoreToken = $airavataCredStoreToken;
    $args->gatewayId = $gatewayId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getSSHPubKey', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getSSHPubKey', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getSSHPubKey()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getSSHPubKey_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getSSHPubKey_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getSSHPubKey failed: unknown result");
  }

  public function getAllGatewaySSHPubKeys(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId)
  {
    $this->send_getAllGatewaySSHPubKeys($authzToken, $gatewayId);
    return $this->recv_getAllGatewaySSHPubKeys();
  }

  public function send_getAllGatewaySSHPubKeys(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId)
  {
    $args = new \Airavata\API\Airavata_getAllGatewaySSHPubKeys_args();
    $args->authzToken = $authzToken;
    $args->gatewayId = $gatewayId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllGatewaySSHPubKeys', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllGatewaySSHPubKeys', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllGatewaySSHPubKeys()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAllGatewaySSHPubKeys_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAllGatewaySSHPubKeys_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getAllGatewaySSHPubKeys failed: unknown result");
  }

  public function getAllCredentialSummaryForGateway(\Airavata\Model\Security\AuthzToken $authzToken, $type, $gatewayId)
  {
    $this->send_getAllCredentialSummaryForGateway($authzToken, $type, $gatewayId);
    return $this->recv_getAllCredentialSummaryForGateway();
  }

  public function send_getAllCredentialSummaryForGateway(\Airavata\Model\Security\AuthzToken $authzToken, $type, $gatewayId)
  {
    $args = new \Airavata\API\Airavata_getAllCredentialSummaryForGateway_args();
    $args->authzToken = $authzToken;
    $args->type = $type;
    $args->gatewayId = $gatewayId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllCredentialSummaryForGateway', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllCredentialSummaryForGateway', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllCredentialSummaryForGateway()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAllCredentialSummaryForGateway_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAllCredentialSummaryForGateway_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getAllCredentialSummaryForGateway failed: unknown result");
  }

  public function getAllCredentialSummaryForUsersInGateway(\Airavata\Model\Security\AuthzToken $authzToken, $type, $gatewayId, $userId)
  {
    $this->send_getAllCredentialSummaryForUsersInGateway($authzToken, $type, $gatewayId, $userId);
    return $this->recv_getAllCredentialSummaryForUsersInGateway();
  }

  public function send_getAllCredentialSummaryForUsersInGateway(\Airavata\Model\Security\AuthzToken $authzToken, $type, $gatewayId, $userId)
  {
    $args = new \Airavata\API\Airavata_getAllCredentialSummaryForUsersInGateway_args();
    $args->authzToken = $authzToken;
    $args->type = $type;
    $args->gatewayId = $gatewayId;
    $args->userId = $userId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllCredentialSummaryForUsersInGateway', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllCredentialSummaryForUsersInGateway', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllCredentialSummaryForUsersInGateway()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAllCredentialSummaryForUsersInGateway_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAllCredentialSummaryForUsersInGateway_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getAllCredentialSummaryForUsersInGateway failed: unknown result");
  }

  public function getAllGatewayPWDCredentials(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId)
  {
    $this->send_getAllGatewayPWDCredentials($authzToken, $gatewayId);
    return $this->recv_getAllGatewayPWDCredentials();
  }

  public function send_getAllGatewayPWDCredentials(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId)
  {
    $args = new \Airavata\API\Airavata_getAllGatewayPWDCredentials_args();
    $args->authzToken = $authzToken;
    $args->gatewayId = $gatewayId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllGatewayPWDCredentials', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllGatewayPWDCredentials', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllGatewayPWDCredentials()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAllGatewayPWDCredentials_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAllGatewayPWDCredentials_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getAllGatewayPWDCredentials failed: unknown result");
  }

  public function deleteSSHPubKey(\Airavata\Model\Security\AuthzToken $authzToken, $airavataCredStoreToken, $gatewayId)
  {
    $this->send_deleteSSHPubKey($authzToken, $airavataCredStoreToken, $gatewayId);
    return $this->recv_deleteSSHPubKey();
  }

  public function send_deleteSSHPubKey(\Airavata\Model\Security\AuthzToken $authzToken, $airavataCredStoreToken, $gatewayId)
  {
    $args = new \Airavata\API\Airavata_deleteSSHPubKey_args();
    $args->authzToken = $authzToken;
    $args->airavataCredStoreToken = $airavataCredStoreToken;
    $args->gatewayId = $gatewayId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteSSHPubKey', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteSSHPubKey', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteSSHPubKey()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteSSHPubKey_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteSSHPubKey_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("deleteSSHPubKey failed: unknown result");
  }

  public function deletePWDCredential(\Airavata\Model\Security\AuthzToken $authzToken, $airavataCredStoreToken, $gatewayId)
  {
    $this->send_deletePWDCredential($authzToken, $airavataCredStoreToken, $gatewayId);
    return $this->recv_deletePWDCredential();
  }

  public function send_deletePWDCredential(\Airavata\Model\Security\AuthzToken $authzToken, $airavataCredStoreToken, $gatewayId)
  {
    $args = new \Airavata\API\Airavata_deletePWDCredential_args();
    $args->authzToken = $authzToken;
    $args->airavataCredStoreToken = $airavataCredStoreToken;
    $args->gatewayId = $gatewayId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deletePWDCredential', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deletePWDCredential', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deletePWDCredential()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deletePWDCredential_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deletePWDCredential_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("deletePWDCredential failed: unknown result");
  }

  public function createProject(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, \Airavata\Model\Workspace\Project $project)
  {
    $this->send_createProject($authzToken, $gatewayId, $project);
    return $this->recv_createProject();
  }

  public function send_createProject(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, \Airavata\Model\Workspace\Project $project)
  {
    $args = new \Airavata\API\Airavata_createProject_args();
    $args->authzToken = $authzToken;
    $args->gatewayId = $gatewayId;
    $args->project = $project;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'createProject', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('createProject', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_createProject()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_createProject_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_createProject_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("createProject failed: unknown result");
  }

  public function updateProject(\Airavata\Model\Security\AuthzToken $authzToken, $projectId, \Airavata\Model\Workspace\Project $updatedProject)
  {
    $this->send_updateProject($authzToken, $projectId, $updatedProject);
    $this->recv_updateProject();
  }

  public function send_updateProject(\Airavata\Model\Security\AuthzToken $authzToken, $projectId, \Airavata\Model\Workspace\Project $updatedProject)
  {
    $args = new \Airavata\API\Airavata_updateProject_args();
    $args->authzToken = $authzToken;
    $args->projectId = $projectId;
    $args->updatedProject = $updatedProject;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateProject', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateProject', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateProject()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateProject_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateProject_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->pnfe !== null) {
      throw $result->pnfe;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    return;
  }

  public function getProject(\Airavata\Model\Security\AuthzToken $authzToken, $projectId)
  {
    $this->send_getProject($authzToken, $projectId);
    return $this->recv_getProject();
  }

  public function send_getProject(\Airavata\Model\Security\AuthzToken $authzToken, $projectId)
  {
    $args = new \Airavata\API\Airavata_getProject_args();
    $args->authzToken = $authzToken;
    $args->projectId = $projectId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getProject', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getProject', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getProject()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getProject_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getProject_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->pnfe !== null) {
      throw $result->pnfe;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getProject failed: unknown result");
  }

  public function deleteProject(\Airavata\Model\Security\AuthzToken $authzToken, $projectId)
  {
    $this->send_deleteProject($authzToken, $projectId);
    return $this->recv_deleteProject();
  }

  public function send_deleteProject(\Airavata\Model\Security\AuthzToken $authzToken, $projectId)
  {
    $args = new \Airavata\API\Airavata_deleteProject_args();
    $args->authzToken = $authzToken;
    $args->projectId = $projectId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteProject', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteProject', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteProject()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteProject_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteProject_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->pnfe !== null) {
      throw $result->pnfe;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("deleteProject failed: unknown result");
  }

  public function getUserProjects(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $userName, $limit, $offset)
  {
    $this->send_getUserProjects($authzToken, $gatewayId, $userName, $limit, $offset);
    return $this->recv_getUserProjects();
  }

  public function send_getUserProjects(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $userName, $limit, $offset)
  {
    $args = new \Airavata\API\Airavata_getUserProjects_args();
    $args->authzToken = $authzToken;
    $args->gatewayId = $gatewayId;
    $args->userName = $userName;
    $args->limit = $limit;
    $args->offset = $offset;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getUserProjects', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getUserProjects', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getUserProjects()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getUserProjects_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getUserProjects_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getUserProjects failed: unknown result");
  }

  public function searchProjects(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $userName, array $filters, $limit, $offset)
  {
    $this->send_searchProjects($authzToken, $gatewayId, $userName, $filters, $limit, $offset);
    return $this->recv_searchProjects();
  }

  public function send_searchProjects(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $userName, array $filters, $limit, $offset)
  {
    $args = new \Airavata\API\Airavata_searchProjects_args();
    $args->authzToken = $authzToken;
    $args->gatewayId = $gatewayId;
    $args->userName = $userName;
    $args->filters = $filters;
    $args->limit = $limit;
    $args->offset = $offset;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'searchProjects', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('searchProjects', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_searchProjects()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_searchProjects_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_searchProjects_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("searchProjects failed: unknown result");
  }

  public function searchExperiments(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $userName, array $filters, $limit, $offset)
  {
    $this->send_searchExperiments($authzToken, $gatewayId, $userName, $filters, $limit, $offset);
    return $this->recv_searchExperiments();
  }

  public function send_searchExperiments(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $userName, array $filters, $limit, $offset)
  {
    $args = new \Airavata\API\Airavata_searchExperiments_args();
    $args->authzToken = $authzToken;
    $args->gatewayId = $gatewayId;
    $args->userName = $userName;
    $args->filters = $filters;
    $args->limit = $limit;
    $args->offset = $offset;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'searchExperiments', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('searchExperiments', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_searchExperiments()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_searchExperiments_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_searchExperiments_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("searchExperiments failed: unknown result");
  }

  public function getExperimentStatistics(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $fromTime, $toTime, $userName, $applicationName, $resourceHostName)
  {
    $this->send_getExperimentStatistics($authzToken, $gatewayId, $fromTime, $toTime, $userName, $applicationName, $resourceHostName);
    return $this->recv_getExperimentStatistics();
  }

  public function send_getExperimentStatistics(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $fromTime, $toTime, $userName, $applicationName, $resourceHostName)
  {
    $args = new \Airavata\API\Airavata_getExperimentStatistics_args();
    $args->authzToken = $authzToken;
    $args->gatewayId = $gatewayId;
    $args->fromTime = $fromTime;
    $args->toTime = $toTime;
    $args->userName = $userName;
    $args->applicationName = $applicationName;
    $args->resourceHostName = $resourceHostName;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getExperimentStatistics', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getExperimentStatistics', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getExperimentStatistics()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getExperimentStatistics_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getExperimentStatistics_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getExperimentStatistics failed: unknown result");
  }

  public function getExperimentsInProject(\Airavata\Model\Security\AuthzToken $authzToken, $projectId, $limit, $offset)
  {
    $this->send_getExperimentsInProject($authzToken, $projectId, $limit, $offset);
    return $this->recv_getExperimentsInProject();
  }

  public function send_getExperimentsInProject(\Airavata\Model\Security\AuthzToken $authzToken, $projectId, $limit, $offset)
  {
    $args = new \Airavata\API\Airavata_getExperimentsInProject_args();
    $args->authzToken = $authzToken;
    $args->projectId = $projectId;
    $args->limit = $limit;
    $args->offset = $offset;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getExperimentsInProject', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getExperimentsInProject', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getExperimentsInProject()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getExperimentsInProject_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getExperimentsInProject_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->pnfe !== null) {
      throw $result->pnfe;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getExperimentsInProject failed: unknown result");
  }

  public function getUserExperiments(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $userName, $limit, $offset)
  {
    $this->send_getUserExperiments($authzToken, $gatewayId, $userName, $limit, $offset);
    return $this->recv_getUserExperiments();
  }

  public function send_getUserExperiments(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, $userName, $limit, $offset)
  {
    $args = new \Airavata\API\Airavata_getUserExperiments_args();
    $args->authzToken = $authzToken;
    $args->gatewayId = $gatewayId;
    $args->userName = $userName;
    $args->limit = $limit;
    $args->offset = $offset;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getUserExperiments', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getUserExperiments', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getUserExperiments()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getUserExperiments_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getUserExperiments_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getUserExperiments failed: unknown result");
  }

  public function createExperiment(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, \Airavata\Model\Experiment\ExperimentModel $experiment)
  {
    $this->send_createExperiment($authzToken, $gatewayId, $experiment);
    return $this->recv_createExperiment();
  }

  public function send_createExperiment(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, \Airavata\Model\Experiment\ExperimentModel $experiment)
  {
    $args = new \Airavata\API\Airavata_createExperiment_args();
    $args->authzToken = $authzToken;
    $args->gatewayId = $gatewayId;
    $args->experiment = $experiment;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'createExperiment', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('createExperiment', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_createExperiment()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_createExperiment_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_createExperiment_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("createExperiment failed: unknown result");
  }

  public function deleteExperiment(\Airavata\Model\Security\AuthzToken $authzToken, $experimentId)
  {
    $this->send_deleteExperiment($authzToken, $experimentId);
    return $this->recv_deleteExperiment();
  }

  public function send_deleteExperiment(\Airavata\Model\Security\AuthzToken $authzToken, $experimentId)
  {
    $args = new \Airavata\API\Airavata_deleteExperiment_args();
    $args->authzToken = $authzToken;
    $args->experimentId = $experimentId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteExperiment', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteExperiment', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteExperiment()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteExperiment_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteExperiment_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("deleteExperiment failed: unknown result");
  }

  public function getExperiment(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId)
  {
    $this->send_getExperiment($authzToken, $airavataExperimentId);
    return $this->recv_getExperiment();
  }

  public function send_getExperiment(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId)
  {
    $args = new \Airavata\API\Airavata_getExperiment_args();
    $args->authzToken = $authzToken;
    $args->airavataExperimentId = $airavataExperimentId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getExperiment', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getExperiment', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getExperiment()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getExperiment_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getExperiment_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->enf !== null) {
      throw $result->enf;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getExperiment failed: unknown result");
  }

  public function getExperimentByAdmin(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId)
  {
    $this->send_getExperimentByAdmin($authzToken, $airavataExperimentId);
    return $this->recv_getExperimentByAdmin();
  }

  public function send_getExperimentByAdmin(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId)
  {
    $args = new \Airavata\API\Airavata_getExperimentByAdmin_args();
    $args->authzToken = $authzToken;
    $args->airavataExperimentId = $airavataExperimentId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getExperimentByAdmin', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getExperimentByAdmin', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getExperimentByAdmin()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getExperimentByAdmin_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getExperimentByAdmin_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->enf !== null) {
      throw $result->enf;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getExperimentByAdmin failed: unknown result");
  }

  public function getDetailedExperimentTree(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId)
  {
    $this->send_getDetailedExperimentTree($authzToken, $airavataExperimentId);
    return $this->recv_getDetailedExperimentTree();
  }

  public function send_getDetailedExperimentTree(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId)
  {
    $args = new \Airavata\API\Airavata_getDetailedExperimentTree_args();
    $args->authzToken = $authzToken;
    $args->airavataExperimentId = $airavataExperimentId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getDetailedExperimentTree', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getDetailedExperimentTree', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getDetailedExperimentTree()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getDetailedExperimentTree_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getDetailedExperimentTree_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->enf !== null) {
      throw $result->enf;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getDetailedExperimentTree failed: unknown result");
  }

  public function updateExperiment(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId, \Airavata\Model\Experiment\ExperimentModel $experiment)
  {
    $this->send_updateExperiment($authzToken, $airavataExperimentId, $experiment);
    $this->recv_updateExperiment();
  }

  public function send_updateExperiment(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId, \Airavata\Model\Experiment\ExperimentModel $experiment)
  {
    $args = new \Airavata\API\Airavata_updateExperiment_args();
    $args->authzToken = $authzToken;
    $args->airavataExperimentId = $airavataExperimentId;
    $args->experiment = $experiment;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateExperiment', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateExperiment', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateExperiment()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateExperiment_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateExperiment_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->enf !== null) {
      throw $result->enf;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    return;
  }

  public function updateExperimentConfiguration(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId, \Airavata\Model\Experiment\UserConfigurationDataModel $userConfiguration)
  {
    $this->send_updateExperimentConfiguration($authzToken, $airavataExperimentId, $userConfiguration);
    $this->recv_updateExperimentConfiguration();
  }

  public function send_updateExperimentConfiguration(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId, \Airavata\Model\Experiment\UserConfigurationDataModel $userConfiguration)
  {
    $args = new \Airavata\API\Airavata_updateExperimentConfiguration_args();
    $args->authzToken = $authzToken;
    $args->airavataExperimentId = $airavataExperimentId;
    $args->userConfiguration = $userConfiguration;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateExperimentConfiguration', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateExperimentConfiguration', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateExperimentConfiguration()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateExperimentConfiguration_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateExperimentConfiguration_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    return;
  }

  public function updateResourceScheduleing(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId, \Airavata\Model\Scheduling\ComputationalResourceSchedulingModel $resourceScheduling)
  {
    $this->send_updateResourceScheduleing($authzToken, $airavataExperimentId, $resourceScheduling);
    $this->recv_updateResourceScheduleing();
  }

  public function send_updateResourceScheduleing(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId, \Airavata\Model\Scheduling\ComputationalResourceSchedulingModel $resourceScheduling)
  {
    $args = new \Airavata\API\Airavata_updateResourceScheduleing_args();
    $args->authzToken = $authzToken;
    $args->airavataExperimentId = $airavataExperimentId;
    $args->resourceScheduling = $resourceScheduling;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateResourceScheduleing', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateResourceScheduleing', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateResourceScheduleing()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateResourceScheduleing_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateResourceScheduleing_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    return;
  }

  public function validateExperiment(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId)
  {
    $this->send_validateExperiment($authzToken, $airavataExperimentId);
    return $this->recv_validateExperiment();
  }

  public function send_validateExperiment(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId)
  {
    $args = new \Airavata\API\Airavata_validateExperiment_args();
    $args->authzToken = $authzToken;
    $args->airavataExperimentId = $airavataExperimentId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'validateExperiment', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('validateExperiment', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_validateExperiment()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_validateExperiment_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_validateExperiment_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->enf !== null) {
      throw $result->enf;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("validateExperiment failed: unknown result");
  }

  public function launchExperiment(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId, $gatewayId)
  {
    $this->send_launchExperiment($authzToken, $airavataExperimentId, $gatewayId);
    $this->recv_launchExperiment();
  }

  public function send_launchExperiment(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId, $gatewayId)
  {
    $args = new \Airavata\API\Airavata_launchExperiment_args();
    $args->authzToken = $authzToken;
    $args->airavataExperimentId = $airavataExperimentId;
    $args->gatewayId = $gatewayId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'launchExperiment', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('launchExperiment', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_launchExperiment()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_launchExperiment_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_launchExperiment_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->enf !== null) {
      throw $result->enf;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    return;
  }

  public function getExperimentStatus(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId)
  {
    $this->send_getExperimentStatus($authzToken, $airavataExperimentId);
    return $this->recv_getExperimentStatus();
  }

  public function send_getExperimentStatus(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId)
  {
    $args = new \Airavata\API\Airavata_getExperimentStatus_args();
    $args->authzToken = $authzToken;
    $args->airavataExperimentId = $airavataExperimentId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getExperimentStatus', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getExperimentStatus', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getExperimentStatus()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getExperimentStatus_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getExperimentStatus_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->enf !== null) {
      throw $result->enf;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getExperimentStatus failed: unknown result");
  }

  public function getExperimentOutputs(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId)
  {
    $this->send_getExperimentOutputs($authzToken, $airavataExperimentId);
    return $this->recv_getExperimentOutputs();
  }

  public function send_getExperimentOutputs(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId)
  {
    $args = new \Airavata\API\Airavata_getExperimentOutputs_args();
    $args->authzToken = $authzToken;
    $args->airavataExperimentId = $airavataExperimentId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getExperimentOutputs', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getExperimentOutputs', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getExperimentOutputs()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getExperimentOutputs_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getExperimentOutputs_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->enf !== null) {
      throw $result->enf;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getExperimentOutputs failed: unknown result");
  }

  public function getIntermediateOutputs(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId)
  {
    $this->send_getIntermediateOutputs($authzToken, $airavataExperimentId);
    return $this->recv_getIntermediateOutputs();
  }

  public function send_getIntermediateOutputs(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId)
  {
    $args = new \Airavata\API\Airavata_getIntermediateOutputs_args();
    $args->authzToken = $authzToken;
    $args->airavataExperimentId = $airavataExperimentId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getIntermediateOutputs', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getIntermediateOutputs', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getIntermediateOutputs()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getIntermediateOutputs_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getIntermediateOutputs_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->enf !== null) {
      throw $result->enf;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getIntermediateOutputs failed: unknown result");
  }

  public function getJobStatuses(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId)
  {
    $this->send_getJobStatuses($authzToken, $airavataExperimentId);
    return $this->recv_getJobStatuses();
  }

  public function send_getJobStatuses(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId)
  {
    $args = new \Airavata\API\Airavata_getJobStatuses_args();
    $args->authzToken = $authzToken;
    $args->airavataExperimentId = $airavataExperimentId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getJobStatuses', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getJobStatuses', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getJobStatuses()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getJobStatuses_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getJobStatuses_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->enf !== null) {
      throw $result->enf;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getJobStatuses failed: unknown result");
  }

  public function getJobDetails(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId)
  {
    $this->send_getJobDetails($authzToken, $airavataExperimentId);
    return $this->recv_getJobDetails();
  }

  public function send_getJobDetails(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId)
  {
    $args = new \Airavata\API\Airavata_getJobDetails_args();
    $args->authzToken = $authzToken;
    $args->airavataExperimentId = $airavataExperimentId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getJobDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getJobDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getJobDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getJobDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getJobDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->enf !== null) {
      throw $result->enf;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getJobDetails failed: unknown result");
  }

  public function cloneExperiment(\Airavata\Model\Security\AuthzToken $authzToken, $existingExperimentID, $newExperimentName, $newExperimentProjectId)
  {
    $this->send_cloneExperiment($authzToken, $existingExperimentID, $newExperimentName, $newExperimentProjectId);
    return $this->recv_cloneExperiment();
  }

  public function send_cloneExperiment(\Airavata\Model\Security\AuthzToken $authzToken, $existingExperimentID, $newExperimentName, $newExperimentProjectId)
  {
    $args = new \Airavata\API\Airavata_cloneExperiment_args();
    $args->authzToken = $authzToken;
    $args->existingExperimentID = $existingExperimentID;
    $args->newExperimentName = $newExperimentName;
    $args->newExperimentProjectId = $newExperimentProjectId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'cloneExperiment', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('cloneExperiment', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_cloneExperiment()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_cloneExperiment_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_cloneExperiment_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->enf !== null) {
      throw $result->enf;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    if ($result->pnfe !== null) {
      throw $result->pnfe;
    }
    throw new \Exception("cloneExperiment failed: unknown result");
  }

  public function cloneExperimentByAdmin(\Airavata\Model\Security\AuthzToken $authzToken, $existingExperimentID, $newExperimentName, $newExperimentProjectId)
  {
    $this->send_cloneExperimentByAdmin($authzToken, $existingExperimentID, $newExperimentName, $newExperimentProjectId);
    return $this->recv_cloneExperimentByAdmin();
  }

  public function send_cloneExperimentByAdmin(\Airavata\Model\Security\AuthzToken $authzToken, $existingExperimentID, $newExperimentName, $newExperimentProjectId)
  {
    $args = new \Airavata\API\Airavata_cloneExperimentByAdmin_args();
    $args->authzToken = $authzToken;
    $args->existingExperimentID = $existingExperimentID;
    $args->newExperimentName = $newExperimentName;
    $args->newExperimentProjectId = $newExperimentProjectId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'cloneExperimentByAdmin', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('cloneExperimentByAdmin', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_cloneExperimentByAdmin()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_cloneExperimentByAdmin_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_cloneExperimentByAdmin_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->enf !== null) {
      throw $result->enf;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    if ($result->pnfe !== null) {
      throw $result->pnfe;
    }
    throw new \Exception("cloneExperimentByAdmin failed: unknown result");
  }

  public function terminateExperiment(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId, $gatewayId)
  {
    $this->send_terminateExperiment($authzToken, $airavataExperimentId, $gatewayId);
    $this->recv_terminateExperiment();
  }

  public function send_terminateExperiment(\Airavata\Model\Security\AuthzToken $authzToken, $airavataExperimentId, $gatewayId)
  {
    $args = new \Airavata\API\Airavata_terminateExperiment_args();
    $args->authzToken = $authzToken;
    $args->airavataExperimentId = $airavataExperimentId;
    $args->gatewayId = $gatewayId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'terminateExperiment', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('terminateExperiment', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_terminateExperiment()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_terminateExperiment_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_terminateExperiment_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->enf !== null) {
      throw $result->enf;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    return;
  }

  public function registerApplicationModule(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, \Airavata\Model\AppCatalog\AppDeployment\ApplicationModule $applicationModule)
  {
    $this->send_registerApplicationModule($authzToken, $gatewayId, $applicationModule);
    return $this->recv_registerApplicationModule();
  }

  public function send_registerApplicationModule(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, \Airavata\Model\AppCatalog\AppDeployment\ApplicationModule $applicationModule)
  {
    $args = new \Airavata\API\Airavata_registerApplicationModule_args();
    $args->authzToken = $authzToken;
    $args->gatewayId = $gatewayId;
    $args->applicationModule = $applicationModule;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'registerApplicationModule', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('registerApplicationModule', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_registerApplicationModule()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_registerApplicationModule_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_registerApplicationModule_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("registerApplicationModule failed: unknown result");
  }

  public function getApplicationModule(\Airavata\Model\Security\AuthzToken $authzToken, $appModuleId)
  {
    $this->send_getApplicationModule($authzToken, $appModuleId);
    return $this->recv_getApplicationModule();
  }

  public function send_getApplicationModule(\Airavata\Model\Security\AuthzToken $authzToken, $appModuleId)
  {
    $args = new \Airavata\API\Airavata_getApplicationModule_args();
    $args->authzToken = $authzToken;
    $args->appModuleId = $appModuleId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getApplicationModule', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getApplicationModule', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getApplicationModule()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getApplicationModule_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getApplicationModule_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getApplicationModule failed: unknown result");
  }

  public function updateApplicationModule(\Airavata\Model\Security\AuthzToken $authzToken, $appModuleId, \Airavata\Model\AppCatalog\AppDeployment\ApplicationModule $applicationModule)
  {
    $this->send_updateApplicationModule($authzToken, $appModuleId, $applicationModule);
    return $this->recv_updateApplicationModule();
  }

  public function send_updateApplicationModule(\Airavata\Model\Security\AuthzToken $authzToken, $appModuleId, \Airavata\Model\AppCatalog\AppDeployment\ApplicationModule $applicationModule)
  {
    $args = new \Airavata\API\Airavata_updateApplicationModule_args();
    $args->authzToken = $authzToken;
    $args->appModuleId = $appModuleId;
    $args->applicationModule = $applicationModule;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateApplicationModule', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateApplicationModule', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateApplicationModule()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateApplicationModule_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateApplicationModule_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("updateApplicationModule failed: unknown result");
  }

  public function getAllAppModules(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId)
  {
    $this->send_getAllAppModules($authzToken, $gatewayId);
    return $this->recv_getAllAppModules();
  }

  public function send_getAllAppModules(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId)
  {
    $args = new \Airavata\API\Airavata_getAllAppModules_args();
    $args->authzToken = $authzToken;
    $args->gatewayId = $gatewayId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllAppModules', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllAppModules', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllAppModules()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAllAppModules_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAllAppModules_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getAllAppModules failed: unknown result");
  }

  public function deleteApplicationModule(\Airavata\Model\Security\AuthzToken $authzToken, $appModuleId)
  {
    $this->send_deleteApplicationModule($authzToken, $appModuleId);
    return $this->recv_deleteApplicationModule();
  }

  public function send_deleteApplicationModule(\Airavata\Model\Security\AuthzToken $authzToken, $appModuleId)
  {
    $args = new \Airavata\API\Airavata_deleteApplicationModule_args();
    $args->authzToken = $authzToken;
    $args->appModuleId = $appModuleId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteApplicationModule', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteApplicationModule', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteApplicationModule()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteApplicationModule_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteApplicationModule_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("deleteApplicationModule failed: unknown result");
  }

  public function registerApplicationDeployment(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, \Airavata\Model\AppCatalog\AppDeployment\ApplicationDeploymentDescription $applicationDeployment)
  {
    $this->send_registerApplicationDeployment($authzToken, $gatewayId, $applicationDeployment);
    return $this->recv_registerApplicationDeployment();
  }

  public function send_registerApplicationDeployment(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, \Airavata\Model\AppCatalog\AppDeployment\ApplicationDeploymentDescription $applicationDeployment)
  {
    $args = new \Airavata\API\Airavata_registerApplicationDeployment_args();
    $args->authzToken = $authzToken;
    $args->gatewayId = $gatewayId;
    $args->applicationDeployment = $applicationDeployment;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'registerApplicationDeployment', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('registerApplicationDeployment', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_registerApplicationDeployment()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_registerApplicationDeployment_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_registerApplicationDeployment_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("registerApplicationDeployment failed: unknown result");
  }

  public function getApplicationDeployment(\Airavata\Model\Security\AuthzToken $authzToken, $appDeploymentId)
  {
    $this->send_getApplicationDeployment($authzToken, $appDeploymentId);
    return $this->recv_getApplicationDeployment();
  }

  public function send_getApplicationDeployment(\Airavata\Model\Security\AuthzToken $authzToken, $appDeploymentId)
  {
    $args = new \Airavata\API\Airavata_getApplicationDeployment_args();
    $args->authzToken = $authzToken;
    $args->appDeploymentId = $appDeploymentId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getApplicationDeployment', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getApplicationDeployment', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getApplicationDeployment()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getApplicationDeployment_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getApplicationDeployment_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getApplicationDeployment failed: unknown result");
  }

  public function updateApplicationDeployment(\Airavata\Model\Security\AuthzToken $authzToken, $appDeploymentId, \Airavata\Model\AppCatalog\AppDeployment\ApplicationDeploymentDescription $applicationDeployment)
  {
    $this->send_updateApplicationDeployment($authzToken, $appDeploymentId, $applicationDeployment);
    return $this->recv_updateApplicationDeployment();
  }

  public function send_updateApplicationDeployment(\Airavata\Model\Security\AuthzToken $authzToken, $appDeploymentId, \Airavata\Model\AppCatalog\AppDeployment\ApplicationDeploymentDescription $applicationDeployment)
  {
    $args = new \Airavata\API\Airavata_updateApplicationDeployment_args();
    $args->authzToken = $authzToken;
    $args->appDeploymentId = $appDeploymentId;
    $args->applicationDeployment = $applicationDeployment;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateApplicationDeployment', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateApplicationDeployment', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateApplicationDeployment()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateApplicationDeployment_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateApplicationDeployment_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("updateApplicationDeployment failed: unknown result");
  }

  public function deleteApplicationDeployment(\Airavata\Model\Security\AuthzToken $authzToken, $appDeploymentId)
  {
    $this->send_deleteApplicationDeployment($authzToken, $appDeploymentId);
    return $this->recv_deleteApplicationDeployment();
  }

  public function send_deleteApplicationDeployment(\Airavata\Model\Security\AuthzToken $authzToken, $appDeploymentId)
  {
    $args = new \Airavata\API\Airavata_deleteApplicationDeployment_args();
    $args->authzToken = $authzToken;
    $args->appDeploymentId = $appDeploymentId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteApplicationDeployment', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteApplicationDeployment', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteApplicationDeployment()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteApplicationDeployment_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteApplicationDeployment_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("deleteApplicationDeployment failed: unknown result");
  }

  public function getAllApplicationDeployments(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId)
  {
    $this->send_getAllApplicationDeployments($authzToken, $gatewayId);
    return $this->recv_getAllApplicationDeployments();
  }

  public function send_getAllApplicationDeployments(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId)
  {
    $args = new \Airavata\API\Airavata_getAllApplicationDeployments_args();
    $args->authzToken = $authzToken;
    $args->gatewayId = $gatewayId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllApplicationDeployments', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllApplicationDeployments', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllApplicationDeployments()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAllApplicationDeployments_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAllApplicationDeployments_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getAllApplicationDeployments failed: unknown result");
  }

  public function getAppModuleDeployedResources(\Airavata\Model\Security\AuthzToken $authzToken, $appModuleId)
  {
    $this->send_getAppModuleDeployedResources($authzToken, $appModuleId);
    return $this->recv_getAppModuleDeployedResources();
  }

  public function send_getAppModuleDeployedResources(\Airavata\Model\Security\AuthzToken $authzToken, $appModuleId)
  {
    $args = new \Airavata\API\Airavata_getAppModuleDeployedResources_args();
    $args->authzToken = $authzToken;
    $args->appModuleId = $appModuleId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAppModuleDeployedResources', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAppModuleDeployedResources', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAppModuleDeployedResources()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAppModuleDeployedResources_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAppModuleDeployedResources_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getAppModuleDeployedResources failed: unknown result");
  }

  public function registerApplicationInterface(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, \Airavata\Model\AppCatalog\AppInterface\ApplicationInterfaceDescription $applicationInterface)
  {
    $this->send_registerApplicationInterface($authzToken, $gatewayId, $applicationInterface);
    return $this->recv_registerApplicationInterface();
  }

  public function send_registerApplicationInterface(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, \Airavata\Model\AppCatalog\AppInterface\ApplicationInterfaceDescription $applicationInterface)
  {
    $args = new \Airavata\API\Airavata_registerApplicationInterface_args();
    $args->authzToken = $authzToken;
    $args->gatewayId = $gatewayId;
    $args->applicationInterface = $applicationInterface;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'registerApplicationInterface', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('registerApplicationInterface', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_registerApplicationInterface()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_registerApplicationInterface_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_registerApplicationInterface_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("registerApplicationInterface failed: unknown result");
  }

  public function cloneApplicationInterface(\Airavata\Model\Security\AuthzToken $authzToken, $existingAppInterfaceID, $newApplicationName, $gatewayId)
  {
    $this->send_cloneApplicationInterface($authzToken, $existingAppInterfaceID, $newApplicationName, $gatewayId);
    return $this->recv_cloneApplicationInterface();
  }

  public function send_cloneApplicationInterface(\Airavata\Model\Security\AuthzToken $authzToken, $existingAppInterfaceID, $newApplicationName, $gatewayId)
  {
    $args = new \Airavata\API\Airavata_cloneApplicationInterface_args();
    $args->authzToken = $authzToken;
    $args->existingAppInterfaceID = $existingAppInterfaceID;
    $args->newApplicationName = $newApplicationName;
    $args->gatewayId = $gatewayId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'cloneApplicationInterface', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('cloneApplicationInterface', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_cloneApplicationInterface()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_cloneApplicationInterface_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_cloneApplicationInterface_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("cloneApplicationInterface failed: unknown result");
  }

  public function getApplicationInterface(\Airavata\Model\Security\AuthzToken $authzToken, $appInterfaceId)
  {
    $this->send_getApplicationInterface($authzToken, $appInterfaceId);
    return $this->recv_getApplicationInterface();
  }

  public function send_getApplicationInterface(\Airavata\Model\Security\AuthzToken $authzToken, $appInterfaceId)
  {
    $args = new \Airavata\API\Airavata_getApplicationInterface_args();
    $args->authzToken = $authzToken;
    $args->appInterfaceId = $appInterfaceId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getApplicationInterface', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getApplicationInterface', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getApplicationInterface()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getApplicationInterface_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getApplicationInterface_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getApplicationInterface failed: unknown result");
  }

  public function updateApplicationInterface(\Airavata\Model\Security\AuthzToken $authzToken, $appInterfaceId, \Airavata\Model\AppCatalog\AppInterface\ApplicationInterfaceDescription $applicationInterface)
  {
    $this->send_updateApplicationInterface($authzToken, $appInterfaceId, $applicationInterface);
    return $this->recv_updateApplicationInterface();
  }

  public function send_updateApplicationInterface(\Airavata\Model\Security\AuthzToken $authzToken, $appInterfaceId, \Airavata\Model\AppCatalog\AppInterface\ApplicationInterfaceDescription $applicationInterface)
  {
    $args = new \Airavata\API\Airavata_updateApplicationInterface_args();
    $args->authzToken = $authzToken;
    $args->appInterfaceId = $appInterfaceId;
    $args->applicationInterface = $applicationInterface;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateApplicationInterface', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateApplicationInterface', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateApplicationInterface()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateApplicationInterface_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateApplicationInterface_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("updateApplicationInterface failed: unknown result");
  }

  public function deleteApplicationInterface(\Airavata\Model\Security\AuthzToken $authzToken, $appInterfaceId)
  {
    $this->send_deleteApplicationInterface($authzToken, $appInterfaceId);
    return $this->recv_deleteApplicationInterface();
  }

  public function send_deleteApplicationInterface(\Airavata\Model\Security\AuthzToken $authzToken, $appInterfaceId)
  {
    $args = new \Airavata\API\Airavata_deleteApplicationInterface_args();
    $args->authzToken = $authzToken;
    $args->appInterfaceId = $appInterfaceId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteApplicationInterface', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteApplicationInterface', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteApplicationInterface()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteApplicationInterface_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteApplicationInterface_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("deleteApplicationInterface failed: unknown result");
  }

  public function getAllApplicationInterfaceNames(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId)
  {
    $this->send_getAllApplicationInterfaceNames($authzToken, $gatewayId);
    return $this->recv_getAllApplicationInterfaceNames();
  }

  public function send_getAllApplicationInterfaceNames(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId)
  {
    $args = new \Airavata\API\Airavata_getAllApplicationInterfaceNames_args();
    $args->authzToken = $authzToken;
    $args->gatewayId = $gatewayId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllApplicationInterfaceNames', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllApplicationInterfaceNames', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllApplicationInterfaceNames()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAllApplicationInterfaceNames_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAllApplicationInterfaceNames_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getAllApplicationInterfaceNames failed: unknown result");
  }

  public function getAllApplicationInterfaces(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId)
  {
    $this->send_getAllApplicationInterfaces($authzToken, $gatewayId);
    return $this->recv_getAllApplicationInterfaces();
  }

  public function send_getAllApplicationInterfaces(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId)
  {
    $args = new \Airavata\API\Airavata_getAllApplicationInterfaces_args();
    $args->authzToken = $authzToken;
    $args->gatewayId = $gatewayId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllApplicationInterfaces', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllApplicationInterfaces', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllApplicationInterfaces()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAllApplicationInterfaces_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAllApplicationInterfaces_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getAllApplicationInterfaces failed: unknown result");
  }

  public function getApplicationInputs(\Airavata\Model\Security\AuthzToken $authzToken, $appInterfaceId)
  {
    $this->send_getApplicationInputs($authzToken, $appInterfaceId);
    return $this->recv_getApplicationInputs();
  }

  public function send_getApplicationInputs(\Airavata\Model\Security\AuthzToken $authzToken, $appInterfaceId)
  {
    $args = new \Airavata\API\Airavata_getApplicationInputs_args();
    $args->authzToken = $authzToken;
    $args->appInterfaceId = $appInterfaceId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getApplicationInputs', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getApplicationInputs', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getApplicationInputs()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getApplicationInputs_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getApplicationInputs_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getApplicationInputs failed: unknown result");
  }

  public function getApplicationOutputs(\Airavata\Model\Security\AuthzToken $authzToken, $appInterfaceId)
  {
    $this->send_getApplicationOutputs($authzToken, $appInterfaceId);
    return $this->recv_getApplicationOutputs();
  }

  public function send_getApplicationOutputs(\Airavata\Model\Security\AuthzToken $authzToken, $appInterfaceId)
  {
    $args = new \Airavata\API\Airavata_getApplicationOutputs_args();
    $args->authzToken = $authzToken;
    $args->appInterfaceId = $appInterfaceId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getApplicationOutputs', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getApplicationOutputs', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getApplicationOutputs()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getApplicationOutputs_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getApplicationOutputs_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getApplicationOutputs failed: unknown result");
  }

  public function getAvailableAppInterfaceComputeResources(\Airavata\Model\Security\AuthzToken $authzToken, $appInterfaceId)
  {
    $this->send_getAvailableAppInterfaceComputeResources($authzToken, $appInterfaceId);
    return $this->recv_getAvailableAppInterfaceComputeResources();
  }

  public function send_getAvailableAppInterfaceComputeResources(\Airavata\Model\Security\AuthzToken $authzToken, $appInterfaceId)
  {
    $args = new \Airavata\API\Airavata_getAvailableAppInterfaceComputeResources_args();
    $args->authzToken = $authzToken;
    $args->appInterfaceId = $appInterfaceId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAvailableAppInterfaceComputeResources', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAvailableAppInterfaceComputeResources', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAvailableAppInterfaceComputeResources()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAvailableAppInterfaceComputeResources_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAvailableAppInterfaceComputeResources_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getAvailableAppInterfaceComputeResources failed: unknown result");
  }

  public function registerComputeResource(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\AppCatalog\ComputeResource\ComputeResourceDescription $computeResourceDescription)
  {
    $this->send_registerComputeResource($authzToken, $computeResourceDescription);
    return $this->recv_registerComputeResource();
  }

  public function send_registerComputeResource(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\AppCatalog\ComputeResource\ComputeResourceDescription $computeResourceDescription)
  {
    $args = new \Airavata\API\Airavata_registerComputeResource_args();
    $args->authzToken = $authzToken;
    $args->computeResourceDescription = $computeResourceDescription;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'registerComputeResource', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('registerComputeResource', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_registerComputeResource()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_registerComputeResource_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_registerComputeResource_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("registerComputeResource failed: unknown result");
  }

  public function getComputeResource(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId)
  {
    $this->send_getComputeResource($authzToken, $computeResourceId);
    return $this->recv_getComputeResource();
  }

  public function send_getComputeResource(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId)
  {
    $args = new \Airavata\API\Airavata_getComputeResource_args();
    $args->authzToken = $authzToken;
    $args->computeResourceId = $computeResourceId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getComputeResource', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getComputeResource', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getComputeResource()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getComputeResource_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getComputeResource_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getComputeResource failed: unknown result");
  }

  public function getAllComputeResourceNames(\Airavata\Model\Security\AuthzToken $authzToken)
  {
    $this->send_getAllComputeResourceNames($authzToken);
    return $this->recv_getAllComputeResourceNames();
  }

  public function send_getAllComputeResourceNames(\Airavata\Model\Security\AuthzToken $authzToken)
  {
    $args = new \Airavata\API\Airavata_getAllComputeResourceNames_args();
    $args->authzToken = $authzToken;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllComputeResourceNames', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllComputeResourceNames', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllComputeResourceNames()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAllComputeResourceNames_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAllComputeResourceNames_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getAllComputeResourceNames failed: unknown result");
  }

  public function updateComputeResource(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, \Airavata\Model\AppCatalog\ComputeResource\ComputeResourceDescription $computeResourceDescription)
  {
    $this->send_updateComputeResource($authzToken, $computeResourceId, $computeResourceDescription);
    return $this->recv_updateComputeResource();
  }

  public function send_updateComputeResource(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, \Airavata\Model\AppCatalog\ComputeResource\ComputeResourceDescription $computeResourceDescription)
  {
    $args = new \Airavata\API\Airavata_updateComputeResource_args();
    $args->authzToken = $authzToken;
    $args->computeResourceId = $computeResourceId;
    $args->computeResourceDescription = $computeResourceDescription;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateComputeResource', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateComputeResource', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateComputeResource()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateComputeResource_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateComputeResource_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("updateComputeResource failed: unknown result");
  }

  public function deleteComputeResource(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId)
  {
    $this->send_deleteComputeResource($authzToken, $computeResourceId);
    return $this->recv_deleteComputeResource();
  }

  public function send_deleteComputeResource(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId)
  {
    $args = new \Airavata\API\Airavata_deleteComputeResource_args();
    $args->authzToken = $authzToken;
    $args->computeResourceId = $computeResourceId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteComputeResource', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteComputeResource', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteComputeResource()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteComputeResource_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteComputeResource_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("deleteComputeResource failed: unknown result");
  }

  public function registerStorageResource(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\AppCatalog\StorageResource\StorageResourceDescription $storageResourceDescription)
  {
    $this->send_registerStorageResource($authzToken, $storageResourceDescription);
    return $this->recv_registerStorageResource();
  }

  public function send_registerStorageResource(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\AppCatalog\StorageResource\StorageResourceDescription $storageResourceDescription)
  {
    $args = new \Airavata\API\Airavata_registerStorageResource_args();
    $args->authzToken = $authzToken;
    $args->storageResourceDescription = $storageResourceDescription;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'registerStorageResource', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('registerStorageResource', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_registerStorageResource()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_registerStorageResource_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_registerStorageResource_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("registerStorageResource failed: unknown result");
  }

  public function getStorageResource(\Airavata\Model\Security\AuthzToken $authzToken, $storageResourceId)
  {
    $this->send_getStorageResource($authzToken, $storageResourceId);
    return $this->recv_getStorageResource();
  }

  public function send_getStorageResource(\Airavata\Model\Security\AuthzToken $authzToken, $storageResourceId)
  {
    $args = new \Airavata\API\Airavata_getStorageResource_args();
    $args->authzToken = $authzToken;
    $args->storageResourceId = $storageResourceId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getStorageResource', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getStorageResource', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getStorageResource()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getStorageResource_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getStorageResource_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getStorageResource failed: unknown result");
  }

  public function getAllStorageResourceNames(\Airavata\Model\Security\AuthzToken $authzToken)
  {
    $this->send_getAllStorageResourceNames($authzToken);
    return $this->recv_getAllStorageResourceNames();
  }

  public function send_getAllStorageResourceNames(\Airavata\Model\Security\AuthzToken $authzToken)
  {
    $args = new \Airavata\API\Airavata_getAllStorageResourceNames_args();
    $args->authzToken = $authzToken;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllStorageResourceNames', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllStorageResourceNames', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllStorageResourceNames()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAllStorageResourceNames_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAllStorageResourceNames_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getAllStorageResourceNames failed: unknown result");
  }

  public function updateStorageResource(\Airavata\Model\Security\AuthzToken $authzToken, $storageResourceId, \Airavata\Model\AppCatalog\StorageResource\StorageResourceDescription $storageResourceDescription)
  {
    $this->send_updateStorageResource($authzToken, $storageResourceId, $storageResourceDescription);
    return $this->recv_updateStorageResource();
  }

  public function send_updateStorageResource(\Airavata\Model\Security\AuthzToken $authzToken, $storageResourceId, \Airavata\Model\AppCatalog\StorageResource\StorageResourceDescription $storageResourceDescription)
  {
    $args = new \Airavata\API\Airavata_updateStorageResource_args();
    $args->authzToken = $authzToken;
    $args->storageResourceId = $storageResourceId;
    $args->storageResourceDescription = $storageResourceDescription;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateStorageResource', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateStorageResource', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateStorageResource()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateStorageResource_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateStorageResource_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("updateStorageResource failed: unknown result");
  }

  public function deleteStorageResource(\Airavata\Model\Security\AuthzToken $authzToken, $storageResourceId)
  {
    $this->send_deleteStorageResource($authzToken, $storageResourceId);
    return $this->recv_deleteStorageResource();
  }

  public function send_deleteStorageResource(\Airavata\Model\Security\AuthzToken $authzToken, $storageResourceId)
  {
    $args = new \Airavata\API\Airavata_deleteStorageResource_args();
    $args->authzToken = $authzToken;
    $args->storageResourceId = $storageResourceId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteStorageResource', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteStorageResource', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteStorageResource()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteStorageResource_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteStorageResource_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("deleteStorageResource failed: unknown result");
  }

  public function addLocalSubmissionDetails(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\LOCALSubmission $localSubmission)
  {
    $this->send_addLocalSubmissionDetails($authzToken, $computeResourceId, $priorityOrder, $localSubmission);
    return $this->recv_addLocalSubmissionDetails();
  }

  public function send_addLocalSubmissionDetails(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\LOCALSubmission $localSubmission)
  {
    $args = new \Airavata\API\Airavata_addLocalSubmissionDetails_args();
    $args->authzToken = $authzToken;
    $args->computeResourceId = $computeResourceId;
    $args->priorityOrder = $priorityOrder;
    $args->localSubmission = $localSubmission;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'addLocalSubmissionDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('addLocalSubmissionDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_addLocalSubmissionDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_addLocalSubmissionDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_addLocalSubmissionDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("addLocalSubmissionDetails failed: unknown result");
  }

  public function updateLocalSubmissionDetails(\Airavata\Model\Security\AuthzToken $authzToken, $jobSubmissionInterfaceId, \Airavata\Model\AppCatalog\ComputeResource\LOCALSubmission $localSubmission)
  {
    $this->send_updateLocalSubmissionDetails($authzToken, $jobSubmissionInterfaceId, $localSubmission);
    return $this->recv_updateLocalSubmissionDetails();
  }

  public function send_updateLocalSubmissionDetails(\Airavata\Model\Security\AuthzToken $authzToken, $jobSubmissionInterfaceId, \Airavata\Model\AppCatalog\ComputeResource\LOCALSubmission $localSubmission)
  {
    $args = new \Airavata\API\Airavata_updateLocalSubmissionDetails_args();
    $args->authzToken = $authzToken;
    $args->jobSubmissionInterfaceId = $jobSubmissionInterfaceId;
    $args->localSubmission = $localSubmission;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateLocalSubmissionDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateLocalSubmissionDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateLocalSubmissionDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateLocalSubmissionDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateLocalSubmissionDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("updateLocalSubmissionDetails failed: unknown result");
  }

  public function getLocalJobSubmission(\Airavata\Model\Security\AuthzToken $authzToken, $jobSubmissionId)
  {
    $this->send_getLocalJobSubmission($authzToken, $jobSubmissionId);
    return $this->recv_getLocalJobSubmission();
  }

  public function send_getLocalJobSubmission(\Airavata\Model\Security\AuthzToken $authzToken, $jobSubmissionId)
  {
    $args = new \Airavata\API\Airavata_getLocalJobSubmission_args();
    $args->authzToken = $authzToken;
    $args->jobSubmissionId = $jobSubmissionId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getLocalJobSubmission', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getLocalJobSubmission', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getLocalJobSubmission()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getLocalJobSubmission_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getLocalJobSubmission_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getLocalJobSubmission failed: unknown result");
  }

  public function addSSHJobSubmissionDetails(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\SSHJobSubmission $sshJobSubmission)
  {
    $this->send_addSSHJobSubmissionDetails($authzToken, $computeResourceId, $priorityOrder, $sshJobSubmission);
    return $this->recv_addSSHJobSubmissionDetails();
  }

  public function send_addSSHJobSubmissionDetails(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\SSHJobSubmission $sshJobSubmission)
  {
    $args = new \Airavata\API\Airavata_addSSHJobSubmissionDetails_args();
    $args->authzToken = $authzToken;
    $args->computeResourceId = $computeResourceId;
    $args->priorityOrder = $priorityOrder;
    $args->sshJobSubmission = $sshJobSubmission;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'addSSHJobSubmissionDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('addSSHJobSubmissionDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_addSSHJobSubmissionDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_addSSHJobSubmissionDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_addSSHJobSubmissionDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("addSSHJobSubmissionDetails failed: unknown result");
  }

  public function addSSHForkJobSubmissionDetails(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\SSHJobSubmission $sshJobSubmission)
  {
    $this->send_addSSHForkJobSubmissionDetails($authzToken, $computeResourceId, $priorityOrder, $sshJobSubmission);
    return $this->recv_addSSHForkJobSubmissionDetails();
  }

  public function send_addSSHForkJobSubmissionDetails(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\SSHJobSubmission $sshJobSubmission)
  {
    $args = new \Airavata\API\Airavata_addSSHForkJobSubmissionDetails_args();
    $args->authzToken = $authzToken;
    $args->computeResourceId = $computeResourceId;
    $args->priorityOrder = $priorityOrder;
    $args->sshJobSubmission = $sshJobSubmission;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'addSSHForkJobSubmissionDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('addSSHForkJobSubmissionDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_addSSHForkJobSubmissionDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_addSSHForkJobSubmissionDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_addSSHForkJobSubmissionDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("addSSHForkJobSubmissionDetails failed: unknown result");
  }

  public function getSSHJobSubmission(\Airavata\Model\Security\AuthzToken $authzToken, $jobSubmissionId)
  {
    $this->send_getSSHJobSubmission($authzToken, $jobSubmissionId);
    return $this->recv_getSSHJobSubmission();
  }

  public function send_getSSHJobSubmission(\Airavata\Model\Security\AuthzToken $authzToken, $jobSubmissionId)
  {
    $args = new \Airavata\API\Airavata_getSSHJobSubmission_args();
    $args->authzToken = $authzToken;
    $args->jobSubmissionId = $jobSubmissionId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getSSHJobSubmission', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getSSHJobSubmission', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getSSHJobSubmission()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getSSHJobSubmission_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getSSHJobSubmission_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getSSHJobSubmission failed: unknown result");
  }

  public function addUNICOREJobSubmissionDetails(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\UnicoreJobSubmission $unicoreJobSubmission)
  {
    $this->send_addUNICOREJobSubmissionDetails($authzToken, $computeResourceId, $priorityOrder, $unicoreJobSubmission);
    return $this->recv_addUNICOREJobSubmissionDetails();
  }

  public function send_addUNICOREJobSubmissionDetails(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\UnicoreJobSubmission $unicoreJobSubmission)
  {
    $args = new \Airavata\API\Airavata_addUNICOREJobSubmissionDetails_args();
    $args->authzToken = $authzToken;
    $args->computeResourceId = $computeResourceId;
    $args->priorityOrder = $priorityOrder;
    $args->unicoreJobSubmission = $unicoreJobSubmission;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'addUNICOREJobSubmissionDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('addUNICOREJobSubmissionDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_addUNICOREJobSubmissionDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_addUNICOREJobSubmissionDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_addUNICOREJobSubmissionDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("addUNICOREJobSubmissionDetails failed: unknown result");
  }

  public function getUnicoreJobSubmission(\Airavata\Model\Security\AuthzToken $authzToken, $jobSubmissionId)
  {
    $this->send_getUnicoreJobSubmission($authzToken, $jobSubmissionId);
    return $this->recv_getUnicoreJobSubmission();
  }

  public function send_getUnicoreJobSubmission(\Airavata\Model\Security\AuthzToken $authzToken, $jobSubmissionId)
  {
    $args = new \Airavata\API\Airavata_getUnicoreJobSubmission_args();
    $args->authzToken = $authzToken;
    $args->jobSubmissionId = $jobSubmissionId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getUnicoreJobSubmission', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getUnicoreJobSubmission', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getUnicoreJobSubmission()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getUnicoreJobSubmission_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getUnicoreJobSubmission_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getUnicoreJobSubmission failed: unknown result");
  }

  public function addCloudJobSubmissionDetails(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\CloudJobSubmission $cloudSubmission)
  {
    $this->send_addCloudJobSubmissionDetails($authzToken, $computeResourceId, $priorityOrder, $cloudSubmission);
    return $this->recv_addCloudJobSubmissionDetails();
  }

  public function send_addCloudJobSubmissionDetails(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\CloudJobSubmission $cloudSubmission)
  {
    $args = new \Airavata\API\Airavata_addCloudJobSubmissionDetails_args();
    $args->authzToken = $authzToken;
    $args->computeResourceId = $computeResourceId;
    $args->priorityOrder = $priorityOrder;
    $args->cloudSubmission = $cloudSubmission;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'addCloudJobSubmissionDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('addCloudJobSubmissionDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_addCloudJobSubmissionDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_addCloudJobSubmissionDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_addCloudJobSubmissionDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("addCloudJobSubmissionDetails failed: unknown result");
  }

  public function getCloudJobSubmission(\Airavata\Model\Security\AuthzToken $authzToken, $jobSubmissionId)
  {
    $this->send_getCloudJobSubmission($authzToken, $jobSubmissionId);
    return $this->recv_getCloudJobSubmission();
  }

  public function send_getCloudJobSubmission(\Airavata\Model\Security\AuthzToken $authzToken, $jobSubmissionId)
  {
    $args = new \Airavata\API\Airavata_getCloudJobSubmission_args();
    $args->authzToken = $authzToken;
    $args->jobSubmissionId = $jobSubmissionId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getCloudJobSubmission', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getCloudJobSubmission', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getCloudJobSubmission()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getCloudJobSubmission_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getCloudJobSubmission_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getCloudJobSubmission failed: unknown result");
  }

  public function updateSSHJobSubmissionDetails(\Airavata\Model\Security\AuthzToken $authzToken, $jobSubmissionInterfaceId, \Airavata\Model\AppCatalog\ComputeResource\SSHJobSubmission $sshJobSubmission)
  {
    $this->send_updateSSHJobSubmissionDetails($authzToken, $jobSubmissionInterfaceId, $sshJobSubmission);
    return $this->recv_updateSSHJobSubmissionDetails();
  }

  public function send_updateSSHJobSubmissionDetails(\Airavata\Model\Security\AuthzToken $authzToken, $jobSubmissionInterfaceId, \Airavata\Model\AppCatalog\ComputeResource\SSHJobSubmission $sshJobSubmission)
  {
    $args = new \Airavata\API\Airavata_updateSSHJobSubmissionDetails_args();
    $args->authzToken = $authzToken;
    $args->jobSubmissionInterfaceId = $jobSubmissionInterfaceId;
    $args->sshJobSubmission = $sshJobSubmission;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateSSHJobSubmissionDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateSSHJobSubmissionDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateSSHJobSubmissionDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateSSHJobSubmissionDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateSSHJobSubmissionDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("updateSSHJobSubmissionDetails failed: unknown result");
  }

  public function updateCloudJobSubmissionDetails(\Airavata\Model\Security\AuthzToken $authzToken, $jobSubmissionInterfaceId, \Airavata\Model\AppCatalog\ComputeResource\CloudJobSubmission $sshJobSubmission)
  {
    $this->send_updateCloudJobSubmissionDetails($authzToken, $jobSubmissionInterfaceId, $sshJobSubmission);
    return $this->recv_updateCloudJobSubmissionDetails();
  }

  public function send_updateCloudJobSubmissionDetails(\Airavata\Model\Security\AuthzToken $authzToken, $jobSubmissionInterfaceId, \Airavata\Model\AppCatalog\ComputeResource\CloudJobSubmission $sshJobSubmission)
  {
    $args = new \Airavata\API\Airavata_updateCloudJobSubmissionDetails_args();
    $args->authzToken = $authzToken;
    $args->jobSubmissionInterfaceId = $jobSubmissionInterfaceId;
    $args->sshJobSubmission = $sshJobSubmission;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateCloudJobSubmissionDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateCloudJobSubmissionDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateCloudJobSubmissionDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateCloudJobSubmissionDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateCloudJobSubmissionDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("updateCloudJobSubmissionDetails failed: unknown result");
  }

  public function updateUnicoreJobSubmissionDetails(\Airavata\Model\Security\AuthzToken $authzToken, $jobSubmissionInterfaceId, \Airavata\Model\AppCatalog\ComputeResource\UnicoreJobSubmission $unicoreJobSubmission)
  {
    $this->send_updateUnicoreJobSubmissionDetails($authzToken, $jobSubmissionInterfaceId, $unicoreJobSubmission);
    return $this->recv_updateUnicoreJobSubmissionDetails();
  }

  public function send_updateUnicoreJobSubmissionDetails(\Airavata\Model\Security\AuthzToken $authzToken, $jobSubmissionInterfaceId, \Airavata\Model\AppCatalog\ComputeResource\UnicoreJobSubmission $unicoreJobSubmission)
  {
    $args = new \Airavata\API\Airavata_updateUnicoreJobSubmissionDetails_args();
    $args->authzToken = $authzToken;
    $args->jobSubmissionInterfaceId = $jobSubmissionInterfaceId;
    $args->unicoreJobSubmission = $unicoreJobSubmission;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateUnicoreJobSubmissionDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateUnicoreJobSubmissionDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateUnicoreJobSubmissionDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateUnicoreJobSubmissionDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateUnicoreJobSubmissionDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("updateUnicoreJobSubmissionDetails failed: unknown result");
  }

  public function addLocalDataMovementDetails(\Airavata\Model\Security\AuthzToken $authzToken, $productUri, $dataMoveType, $priorityOrder, \Airavata\Model\Data\Movement\LOCALDataMovement $localDataMovement)
  {
    $this->send_addLocalDataMovementDetails($authzToken, $productUri, $dataMoveType, $priorityOrder, $localDataMovement);
    return $this->recv_addLocalDataMovementDetails();
  }

  public function send_addLocalDataMovementDetails(\Airavata\Model\Security\AuthzToken $authzToken, $productUri, $dataMoveType, $priorityOrder, \Airavata\Model\Data\Movement\LOCALDataMovement $localDataMovement)
  {
    $args = new \Airavata\API\Airavata_addLocalDataMovementDetails_args();
    $args->authzToken = $authzToken;
    $args->productUri = $productUri;
    $args->dataMoveType = $dataMoveType;
    $args->priorityOrder = $priorityOrder;
    $args->localDataMovement = $localDataMovement;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'addLocalDataMovementDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('addLocalDataMovementDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_addLocalDataMovementDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_addLocalDataMovementDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_addLocalDataMovementDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("addLocalDataMovementDetails failed: unknown result");
  }

  public function updateLocalDataMovementDetails(\Airavata\Model\Security\AuthzToken $authzToken, $dataMovementInterfaceId, \Airavata\Model\Data\Movement\LOCALDataMovement $localDataMovement)
  {
    $this->send_updateLocalDataMovementDetails($authzToken, $dataMovementInterfaceId, $localDataMovement);
    return $this->recv_updateLocalDataMovementDetails();
  }

  public function send_updateLocalDataMovementDetails(\Airavata\Model\Security\AuthzToken $authzToken, $dataMovementInterfaceId, \Airavata\Model\Data\Movement\LOCALDataMovement $localDataMovement)
  {
    $args = new \Airavata\API\Airavata_updateLocalDataMovementDetails_args();
    $args->authzToken = $authzToken;
    $args->dataMovementInterfaceId = $dataMovementInterfaceId;
    $args->localDataMovement = $localDataMovement;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateLocalDataMovementDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateLocalDataMovementDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateLocalDataMovementDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateLocalDataMovementDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateLocalDataMovementDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("updateLocalDataMovementDetails failed: unknown result");
  }

  public function getLocalDataMovement(\Airavata\Model\Security\AuthzToken $authzToken, $dataMovementId)
  {
    $this->send_getLocalDataMovement($authzToken, $dataMovementId);
    return $this->recv_getLocalDataMovement();
  }

  public function send_getLocalDataMovement(\Airavata\Model\Security\AuthzToken $authzToken, $dataMovementId)
  {
    $args = new \Airavata\API\Airavata_getLocalDataMovement_args();
    $args->authzToken = $authzToken;
    $args->dataMovementId = $dataMovementId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getLocalDataMovement', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getLocalDataMovement', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getLocalDataMovement()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getLocalDataMovement_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getLocalDataMovement_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getLocalDataMovement failed: unknown result");
  }

  public function addSCPDataMovementDetails(\Airavata\Model\Security\AuthzToken $authzToken, $productUri, $dataMoveType, $priorityOrder, \Airavata\Model\Data\Movement\SCPDataMovement $scpDataMovement)
  {
    $this->send_addSCPDataMovementDetails($authzToken, $productUri, $dataMoveType, $priorityOrder, $scpDataMovement);
    return $this->recv_addSCPDataMovementDetails();
  }

  public function send_addSCPDataMovementDetails(\Airavata\Model\Security\AuthzToken $authzToken, $productUri, $dataMoveType, $priorityOrder, \Airavata\Model\Data\Movement\SCPDataMovement $scpDataMovement)
  {
    $args = new \Airavata\API\Airavata_addSCPDataMovementDetails_args();
    $args->authzToken = $authzToken;
    $args->productUri = $productUri;
    $args->dataMoveType = $dataMoveType;
    $args->priorityOrder = $priorityOrder;
    $args->scpDataMovement = $scpDataMovement;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'addSCPDataMovementDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('addSCPDataMovementDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_addSCPDataMovementDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_addSCPDataMovementDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_addSCPDataMovementDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("addSCPDataMovementDetails failed: unknown result");
  }

  public function updateSCPDataMovementDetails(\Airavata\Model\Security\AuthzToken $authzToken, $dataMovementInterfaceId, \Airavata\Model\Data\Movement\SCPDataMovement $scpDataMovement)
  {
    $this->send_updateSCPDataMovementDetails($authzToken, $dataMovementInterfaceId, $scpDataMovement);
    return $this->recv_updateSCPDataMovementDetails();
  }

  public function send_updateSCPDataMovementDetails(\Airavata\Model\Security\AuthzToken $authzToken, $dataMovementInterfaceId, \Airavata\Model\Data\Movement\SCPDataMovement $scpDataMovement)
  {
    $args = new \Airavata\API\Airavata_updateSCPDataMovementDetails_args();
    $args->authzToken = $authzToken;
    $args->dataMovementInterfaceId = $dataMovementInterfaceId;
    $args->scpDataMovement = $scpDataMovement;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateSCPDataMovementDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateSCPDataMovementDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateSCPDataMovementDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateSCPDataMovementDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateSCPDataMovementDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("updateSCPDataMovementDetails failed: unknown result");
  }

  public function getSCPDataMovement(\Airavata\Model\Security\AuthzToken $authzToken, $dataMovementId)
  {
    $this->send_getSCPDataMovement($authzToken, $dataMovementId);
    return $this->recv_getSCPDataMovement();
  }

  public function send_getSCPDataMovement(\Airavata\Model\Security\AuthzToken $authzToken, $dataMovementId)
  {
    $args = new \Airavata\API\Airavata_getSCPDataMovement_args();
    $args->authzToken = $authzToken;
    $args->dataMovementId = $dataMovementId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getSCPDataMovement', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getSCPDataMovement', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getSCPDataMovement()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getSCPDataMovement_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getSCPDataMovement_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getSCPDataMovement failed: unknown result");
  }

  public function addUnicoreDataMovementDetails(\Airavata\Model\Security\AuthzToken $authzToken, $productUri, $dataMoveType, $priorityOrder, \Airavata\Model\Data\Movement\UnicoreDataMovement $unicoreDataMovement)
  {
    $this->send_addUnicoreDataMovementDetails($authzToken, $productUri, $dataMoveType, $priorityOrder, $unicoreDataMovement);
    return $this->recv_addUnicoreDataMovementDetails();
  }

  public function send_addUnicoreDataMovementDetails(\Airavata\Model\Security\AuthzToken $authzToken, $productUri, $dataMoveType, $priorityOrder, \Airavata\Model\Data\Movement\UnicoreDataMovement $unicoreDataMovement)
  {
    $args = new \Airavata\API\Airavata_addUnicoreDataMovementDetails_args();
    $args->authzToken = $authzToken;
    $args->productUri = $productUri;
    $args->dataMoveType = $dataMoveType;
    $args->priorityOrder = $priorityOrder;
    $args->unicoreDataMovement = $unicoreDataMovement;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'addUnicoreDataMovementDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('addUnicoreDataMovementDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_addUnicoreDataMovementDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_addUnicoreDataMovementDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_addUnicoreDataMovementDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("addUnicoreDataMovementDetails failed: unknown result");
  }

  public function updateUnicoreDataMovementDetails(\Airavata\Model\Security\AuthzToken $authzToken, $dataMovementInterfaceId, \Airavata\Model\Data\Movement\UnicoreDataMovement $unicoreDataMovement)
  {
    $this->send_updateUnicoreDataMovementDetails($authzToken, $dataMovementInterfaceId, $unicoreDataMovement);
    return $this->recv_updateUnicoreDataMovementDetails();
  }

  public function send_updateUnicoreDataMovementDetails(\Airavata\Model\Security\AuthzToken $authzToken, $dataMovementInterfaceId, \Airavata\Model\Data\Movement\UnicoreDataMovement $unicoreDataMovement)
  {
    $args = new \Airavata\API\Airavata_updateUnicoreDataMovementDetails_args();
    $args->authzToken = $authzToken;
    $args->dataMovementInterfaceId = $dataMovementInterfaceId;
    $args->unicoreDataMovement = $unicoreDataMovement;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateUnicoreDataMovementDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateUnicoreDataMovementDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateUnicoreDataMovementDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateUnicoreDataMovementDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateUnicoreDataMovementDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("updateUnicoreDataMovementDetails failed: unknown result");
  }

  public function getUnicoreDataMovement(\Airavata\Model\Security\AuthzToken $authzToken, $dataMovementId)
  {
    $this->send_getUnicoreDataMovement($authzToken, $dataMovementId);
    return $this->recv_getUnicoreDataMovement();
  }

  public function send_getUnicoreDataMovement(\Airavata\Model\Security\AuthzToken $authzToken, $dataMovementId)
  {
    $args = new \Airavata\API\Airavata_getUnicoreDataMovement_args();
    $args->authzToken = $authzToken;
    $args->dataMovementId = $dataMovementId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getUnicoreDataMovement', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getUnicoreDataMovement', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getUnicoreDataMovement()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getUnicoreDataMovement_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getUnicoreDataMovement_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getUnicoreDataMovement failed: unknown result");
  }

  public function addGridFTPDataMovementDetails(\Airavata\Model\Security\AuthzToken $authzToken, $productUri, $dataMoveType, $priorityOrder, \Airavata\Model\Data\Movement\GridFTPDataMovement $gridFTPDataMovement)
  {
    $this->send_addGridFTPDataMovementDetails($authzToken, $productUri, $dataMoveType, $priorityOrder, $gridFTPDataMovement);
    return $this->recv_addGridFTPDataMovementDetails();
  }

  public function send_addGridFTPDataMovementDetails(\Airavata\Model\Security\AuthzToken $authzToken, $productUri, $dataMoveType, $priorityOrder, \Airavata\Model\Data\Movement\GridFTPDataMovement $gridFTPDataMovement)
  {
    $args = new \Airavata\API\Airavata_addGridFTPDataMovementDetails_args();
    $args->authzToken = $authzToken;
    $args->productUri = $productUri;
    $args->dataMoveType = $dataMoveType;
    $args->priorityOrder = $priorityOrder;
    $args->gridFTPDataMovement = $gridFTPDataMovement;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'addGridFTPDataMovementDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('addGridFTPDataMovementDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_addGridFTPDataMovementDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_addGridFTPDataMovementDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_addGridFTPDataMovementDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("addGridFTPDataMovementDetails failed: unknown result");
  }

  public function updateGridFTPDataMovementDetails(\Airavata\Model\Security\AuthzToken $authzToken, $dataMovementInterfaceId, \Airavata\Model\Data\Movement\GridFTPDataMovement $gridFTPDataMovement)
  {
    $this->send_updateGridFTPDataMovementDetails($authzToken, $dataMovementInterfaceId, $gridFTPDataMovement);
    return $this->recv_updateGridFTPDataMovementDetails();
  }

  public function send_updateGridFTPDataMovementDetails(\Airavata\Model\Security\AuthzToken $authzToken, $dataMovementInterfaceId, \Airavata\Model\Data\Movement\GridFTPDataMovement $gridFTPDataMovement)
  {
    $args = new \Airavata\API\Airavata_updateGridFTPDataMovementDetails_args();
    $args->authzToken = $authzToken;
    $args->dataMovementInterfaceId = $dataMovementInterfaceId;
    $args->gridFTPDataMovement = $gridFTPDataMovement;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateGridFTPDataMovementDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateGridFTPDataMovementDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateGridFTPDataMovementDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateGridFTPDataMovementDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateGridFTPDataMovementDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("updateGridFTPDataMovementDetails failed: unknown result");
  }

  public function getGridFTPDataMovement(\Airavata\Model\Security\AuthzToken $authzToken, $dataMovementId)
  {
    $this->send_getGridFTPDataMovement($authzToken, $dataMovementId);
    return $this->recv_getGridFTPDataMovement();
  }

  public function send_getGridFTPDataMovement(\Airavata\Model\Security\AuthzToken $authzToken, $dataMovementId)
  {
    $args = new \Airavata\API\Airavata_getGridFTPDataMovement_args();
    $args->authzToken = $authzToken;
    $args->dataMovementId = $dataMovementId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getGridFTPDataMovement', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getGridFTPDataMovement', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getGridFTPDataMovement()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getGridFTPDataMovement_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getGridFTPDataMovement_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getGridFTPDataMovement failed: unknown result");
  }

  public function changeJobSubmissionPriority(\Airavata\Model\Security\AuthzToken $authzToken, $jobSubmissionInterfaceId, $newPriorityOrder)
  {
    $this->send_changeJobSubmissionPriority($authzToken, $jobSubmissionInterfaceId, $newPriorityOrder);
    return $this->recv_changeJobSubmissionPriority();
  }

  public function send_changeJobSubmissionPriority(\Airavata\Model\Security\AuthzToken $authzToken, $jobSubmissionInterfaceId, $newPriorityOrder)
  {
    $args = new \Airavata\API\Airavata_changeJobSubmissionPriority_args();
    $args->authzToken = $authzToken;
    $args->jobSubmissionInterfaceId = $jobSubmissionInterfaceId;
    $args->newPriorityOrder = $newPriorityOrder;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'changeJobSubmissionPriority', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('changeJobSubmissionPriority', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_changeJobSubmissionPriority()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_changeJobSubmissionPriority_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_changeJobSubmissionPriority_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("changeJobSubmissionPriority failed: unknown result");
  }

  public function changeDataMovementPriority(\Airavata\Model\Security\AuthzToken $authzToken, $dataMovementInterfaceId, $newPriorityOrder)
  {
    $this->send_changeDataMovementPriority($authzToken, $dataMovementInterfaceId, $newPriorityOrder);
    return $this->recv_changeDataMovementPriority();
  }

  public function send_changeDataMovementPriority(\Airavata\Model\Security\AuthzToken $authzToken, $dataMovementInterfaceId, $newPriorityOrder)
  {
    $args = new \Airavata\API\Airavata_changeDataMovementPriority_args();
    $args->authzToken = $authzToken;
    $args->dataMovementInterfaceId = $dataMovementInterfaceId;
    $args->newPriorityOrder = $newPriorityOrder;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'changeDataMovementPriority', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('changeDataMovementPriority', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_changeDataMovementPriority()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_changeDataMovementPriority_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_changeDataMovementPriority_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("changeDataMovementPriority failed: unknown result");
  }

  public function changeJobSubmissionPriorities(\Airavata\Model\Security\AuthzToken $authzToken, array $jobSubmissionPriorityMap)
  {
    $this->send_changeJobSubmissionPriorities($authzToken, $jobSubmissionPriorityMap);
    return $this->recv_changeJobSubmissionPriorities();
  }

  public function send_changeJobSubmissionPriorities(\Airavata\Model\Security\AuthzToken $authzToken, array $jobSubmissionPriorityMap)
  {
    $args = new \Airavata\API\Airavata_changeJobSubmissionPriorities_args();
    $args->authzToken = $authzToken;
    $args->jobSubmissionPriorityMap = $jobSubmissionPriorityMap;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'changeJobSubmissionPriorities', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('changeJobSubmissionPriorities', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_changeJobSubmissionPriorities()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_changeJobSubmissionPriorities_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_changeJobSubmissionPriorities_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("changeJobSubmissionPriorities failed: unknown result");
  }

  public function changeDataMovementPriorities(\Airavata\Model\Security\AuthzToken $authzToken, array $dataMovementPriorityMap)
  {
    $this->send_changeDataMovementPriorities($authzToken, $dataMovementPriorityMap);
    return $this->recv_changeDataMovementPriorities();
  }

  public function send_changeDataMovementPriorities(\Airavata\Model\Security\AuthzToken $authzToken, array $dataMovementPriorityMap)
  {
    $args = new \Airavata\API\Airavata_changeDataMovementPriorities_args();
    $args->authzToken = $authzToken;
    $args->dataMovementPriorityMap = $dataMovementPriorityMap;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'changeDataMovementPriorities', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('changeDataMovementPriorities', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_changeDataMovementPriorities()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_changeDataMovementPriorities_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_changeDataMovementPriorities_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("changeDataMovementPriorities failed: unknown result");
  }

  public function deleteJobSubmissionInterface(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, $jobSubmissionInterfaceId)
  {
    $this->send_deleteJobSubmissionInterface($authzToken, $computeResourceId, $jobSubmissionInterfaceId);
    return $this->recv_deleteJobSubmissionInterface();
  }

  public function send_deleteJobSubmissionInterface(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, $jobSubmissionInterfaceId)
  {
    $args = new \Airavata\API\Airavata_deleteJobSubmissionInterface_args();
    $args->authzToken = $authzToken;
    $args->computeResourceId = $computeResourceId;
    $args->jobSubmissionInterfaceId = $jobSubmissionInterfaceId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteJobSubmissionInterface', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteJobSubmissionInterface', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteJobSubmissionInterface()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteJobSubmissionInterface_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteJobSubmissionInterface_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("deleteJobSubmissionInterface failed: unknown result");
  }

  public function deleteDataMovementInterface(\Airavata\Model\Security\AuthzToken $authzToken, $productUri, $dataMovementInterfaceId, $dataMoveType)
  {
    $this->send_deleteDataMovementInterface($authzToken, $productUri, $dataMovementInterfaceId, $dataMoveType);
    return $this->recv_deleteDataMovementInterface();
  }

  public function send_deleteDataMovementInterface(\Airavata\Model\Security\AuthzToken $authzToken, $productUri, $dataMovementInterfaceId, $dataMoveType)
  {
    $args = new \Airavata\API\Airavata_deleteDataMovementInterface_args();
    $args->authzToken = $authzToken;
    $args->productUri = $productUri;
    $args->dataMovementInterfaceId = $dataMovementInterfaceId;
    $args->dataMoveType = $dataMoveType;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteDataMovementInterface', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteDataMovementInterface', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteDataMovementInterface()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteDataMovementInterface_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteDataMovementInterface_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("deleteDataMovementInterface failed: unknown result");
  }

  public function registerResourceJobManager(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\AppCatalog\ComputeResource\ResourceJobManager $resourceJobManager)
  {
    $this->send_registerResourceJobManager($authzToken, $resourceJobManager);
    return $this->recv_registerResourceJobManager();
  }

  public function send_registerResourceJobManager(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\AppCatalog\ComputeResource\ResourceJobManager $resourceJobManager)
  {
    $args = new \Airavata\API\Airavata_registerResourceJobManager_args();
    $args->authzToken = $authzToken;
    $args->resourceJobManager = $resourceJobManager;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'registerResourceJobManager', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('registerResourceJobManager', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_registerResourceJobManager()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_registerResourceJobManager_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_registerResourceJobManager_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("registerResourceJobManager failed: unknown result");
  }

  public function updateResourceJobManager(\Airavata\Model\Security\AuthzToken $authzToken, $resourceJobManagerId, \Airavata\Model\AppCatalog\ComputeResource\ResourceJobManager $updatedResourceJobManager)
  {
    $this->send_updateResourceJobManager($authzToken, $resourceJobManagerId, $updatedResourceJobManager);
    return $this->recv_updateResourceJobManager();
  }

  public function send_updateResourceJobManager(\Airavata\Model\Security\AuthzToken $authzToken, $resourceJobManagerId, \Airavata\Model\AppCatalog\ComputeResource\ResourceJobManager $updatedResourceJobManager)
  {
    $args = new \Airavata\API\Airavata_updateResourceJobManager_args();
    $args->authzToken = $authzToken;
    $args->resourceJobManagerId = $resourceJobManagerId;
    $args->updatedResourceJobManager = $updatedResourceJobManager;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateResourceJobManager', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateResourceJobManager', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateResourceJobManager()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateResourceJobManager_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateResourceJobManager_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("updateResourceJobManager failed: unknown result");
  }

  public function getResourceJobManager(\Airavata\Model\Security\AuthzToken $authzToken, $resourceJobManagerId)
  {
    $this->send_getResourceJobManager($authzToken, $resourceJobManagerId);
    return $this->recv_getResourceJobManager();
  }

  public function send_getResourceJobManager(\Airavata\Model\Security\AuthzToken $authzToken, $resourceJobManagerId)
  {
    $args = new \Airavata\API\Airavata_getResourceJobManager_args();
    $args->authzToken = $authzToken;
    $args->resourceJobManagerId = $resourceJobManagerId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getResourceJobManager', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getResourceJobManager', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getResourceJobManager()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getResourceJobManager_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getResourceJobManager_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getResourceJobManager failed: unknown result");
  }

  public function deleteResourceJobManager(\Airavata\Model\Security\AuthzToken $authzToken, $resourceJobManagerId)
  {
    $this->send_deleteResourceJobManager($authzToken, $resourceJobManagerId);
    return $this->recv_deleteResourceJobManager();
  }

  public function send_deleteResourceJobManager(\Airavata\Model\Security\AuthzToken $authzToken, $resourceJobManagerId)
  {
    $args = new \Airavata\API\Airavata_deleteResourceJobManager_args();
    $args->authzToken = $authzToken;
    $args->resourceJobManagerId = $resourceJobManagerId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteResourceJobManager', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteResourceJobManager', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteResourceJobManager()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteResourceJobManager_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteResourceJobManager_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("deleteResourceJobManager failed: unknown result");
  }

  public function deleteBatchQueue(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, $queueName)
  {
    $this->send_deleteBatchQueue($authzToken, $computeResourceId, $queueName);
    return $this->recv_deleteBatchQueue();
  }

  public function send_deleteBatchQueue(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, $queueName)
  {
    $args = new \Airavata\API\Airavata_deleteBatchQueue_args();
    $args->authzToken = $authzToken;
    $args->computeResourceId = $computeResourceId;
    $args->queueName = $queueName;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteBatchQueue', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteBatchQueue', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteBatchQueue()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteBatchQueue_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteBatchQueue_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("deleteBatchQueue failed: unknown result");
  }

  public function registerGatewayResourceProfile(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\AppCatalog\GatewayProfile\GatewayResourceProfile $gatewayResourceProfile)
  {
    $this->send_registerGatewayResourceProfile($authzToken, $gatewayResourceProfile);
    return $this->recv_registerGatewayResourceProfile();
  }

  public function send_registerGatewayResourceProfile(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\AppCatalog\GatewayProfile\GatewayResourceProfile $gatewayResourceProfile)
  {
    $args = new \Airavata\API\Airavata_registerGatewayResourceProfile_args();
    $args->authzToken = $authzToken;
    $args->gatewayResourceProfile = $gatewayResourceProfile;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'registerGatewayResourceProfile', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('registerGatewayResourceProfile', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_registerGatewayResourceProfile()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_registerGatewayResourceProfile_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_registerGatewayResourceProfile_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("registerGatewayResourceProfile failed: unknown result");
  }

  public function getGatewayResourceProfile(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID)
  {
    $this->send_getGatewayResourceProfile($authzToken, $gatewayID);
    return $this->recv_getGatewayResourceProfile();
  }

  public function send_getGatewayResourceProfile(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID)
  {
    $args = new \Airavata\API\Airavata_getGatewayResourceProfile_args();
    $args->authzToken = $authzToken;
    $args->gatewayID = $gatewayID;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getGatewayResourceProfile', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getGatewayResourceProfile', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getGatewayResourceProfile()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getGatewayResourceProfile_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getGatewayResourceProfile_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getGatewayResourceProfile failed: unknown result");
  }

  public function updateGatewayResourceProfile(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID, \Airavata\Model\AppCatalog\GatewayProfile\GatewayResourceProfile $gatewayResourceProfile)
  {
    $this->send_updateGatewayResourceProfile($authzToken, $gatewayID, $gatewayResourceProfile);
    return $this->recv_updateGatewayResourceProfile();
  }

  public function send_updateGatewayResourceProfile(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID, \Airavata\Model\AppCatalog\GatewayProfile\GatewayResourceProfile $gatewayResourceProfile)
  {
    $args = new \Airavata\API\Airavata_updateGatewayResourceProfile_args();
    $args->authzToken = $authzToken;
    $args->gatewayID = $gatewayID;
    $args->gatewayResourceProfile = $gatewayResourceProfile;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateGatewayResourceProfile', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateGatewayResourceProfile', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateGatewayResourceProfile()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateGatewayResourceProfile_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateGatewayResourceProfile_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("updateGatewayResourceProfile failed: unknown result");
  }

  public function deleteGatewayResourceProfile(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID)
  {
    $this->send_deleteGatewayResourceProfile($authzToken, $gatewayID);
    return $this->recv_deleteGatewayResourceProfile();
  }

  public function send_deleteGatewayResourceProfile(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID)
  {
    $args = new \Airavata\API\Airavata_deleteGatewayResourceProfile_args();
    $args->authzToken = $authzToken;
    $args->gatewayID = $gatewayID;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteGatewayResourceProfile', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteGatewayResourceProfile', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteGatewayResourceProfile()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteGatewayResourceProfile_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteGatewayResourceProfile_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("deleteGatewayResourceProfile failed: unknown result");
  }

  public function addGatewayComputeResourcePreference(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID, $computeResourceId, \Airavata\Model\AppCatalog\GatewayProfile\ComputeResourcePreference $computeResourcePreference)
  {
    $this->send_addGatewayComputeResourcePreference($authzToken, $gatewayID, $computeResourceId, $computeResourcePreference);
    return $this->recv_addGatewayComputeResourcePreference();
  }

  public function send_addGatewayComputeResourcePreference(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID, $computeResourceId, \Airavata\Model\AppCatalog\GatewayProfile\ComputeResourcePreference $computeResourcePreference)
  {
    $args = new \Airavata\API\Airavata_addGatewayComputeResourcePreference_args();
    $args->authzToken = $authzToken;
    $args->gatewayID = $gatewayID;
    $args->computeResourceId = $computeResourceId;
    $args->computeResourcePreference = $computeResourcePreference;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'addGatewayComputeResourcePreference', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('addGatewayComputeResourcePreference', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_addGatewayComputeResourcePreference()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_addGatewayComputeResourcePreference_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_addGatewayComputeResourcePreference_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("addGatewayComputeResourcePreference failed: unknown result");
  }

  public function addGatewayStoragePreference(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID, $storageResourceId, \Airavata\Model\AppCatalog\GatewayProfile\StoragePreference $storagePreference)
  {
    $this->send_addGatewayStoragePreference($authzToken, $gatewayID, $storageResourceId, $storagePreference);
    return $this->recv_addGatewayStoragePreference();
  }

  public function send_addGatewayStoragePreference(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID, $storageResourceId, \Airavata\Model\AppCatalog\GatewayProfile\StoragePreference $storagePreference)
  {
    $args = new \Airavata\API\Airavata_addGatewayStoragePreference_args();
    $args->authzToken = $authzToken;
    $args->gatewayID = $gatewayID;
    $args->storageResourceId = $storageResourceId;
    $args->storagePreference = $storagePreference;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'addGatewayStoragePreference', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('addGatewayStoragePreference', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_addGatewayStoragePreference()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_addGatewayStoragePreference_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_addGatewayStoragePreference_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("addGatewayStoragePreference failed: unknown result");
  }

  public function getGatewayComputeResourcePreference(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID, $computeResourceId)
  {
    $this->send_getGatewayComputeResourcePreference($authzToken, $gatewayID, $computeResourceId);
    return $this->recv_getGatewayComputeResourcePreference();
  }

  public function send_getGatewayComputeResourcePreference(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID, $computeResourceId)
  {
    $args = new \Airavata\API\Airavata_getGatewayComputeResourcePreference_args();
    $args->authzToken = $authzToken;
    $args->gatewayID = $gatewayID;
    $args->computeResourceId = $computeResourceId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getGatewayComputeResourcePreference', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getGatewayComputeResourcePreference', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getGatewayComputeResourcePreference()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getGatewayComputeResourcePreference_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getGatewayComputeResourcePreference_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getGatewayComputeResourcePreference failed: unknown result");
  }

  public function getGatewayStoragePreference(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID, $storageResourceId)
  {
    $this->send_getGatewayStoragePreference($authzToken, $gatewayID, $storageResourceId);
    return $this->recv_getGatewayStoragePreference();
  }

  public function send_getGatewayStoragePreference(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID, $storageResourceId)
  {
    $args = new \Airavata\API\Airavata_getGatewayStoragePreference_args();
    $args->authzToken = $authzToken;
    $args->gatewayID = $gatewayID;
    $args->storageResourceId = $storageResourceId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getGatewayStoragePreference', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getGatewayStoragePreference', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getGatewayStoragePreference()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getGatewayStoragePreference_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getGatewayStoragePreference_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getGatewayStoragePreference failed: unknown result");
  }

  public function getAllGatewayComputeResourcePreferences(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID)
  {
    $this->send_getAllGatewayComputeResourcePreferences($authzToken, $gatewayID);
    return $this->recv_getAllGatewayComputeResourcePreferences();
  }

  public function send_getAllGatewayComputeResourcePreferences(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID)
  {
    $args = new \Airavata\API\Airavata_getAllGatewayComputeResourcePreferences_args();
    $args->authzToken = $authzToken;
    $args->gatewayID = $gatewayID;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllGatewayComputeResourcePreferences', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllGatewayComputeResourcePreferences', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllGatewayComputeResourcePreferences()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAllGatewayComputeResourcePreferences_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAllGatewayComputeResourcePreferences_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getAllGatewayComputeResourcePreferences failed: unknown result");
  }

  public function getAllGatewayStoragePreferences(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID)
  {
    $this->send_getAllGatewayStoragePreferences($authzToken, $gatewayID);
    return $this->recv_getAllGatewayStoragePreferences();
  }

  public function send_getAllGatewayStoragePreferences(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID)
  {
    $args = new \Airavata\API\Airavata_getAllGatewayStoragePreferences_args();
    $args->authzToken = $authzToken;
    $args->gatewayID = $gatewayID;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllGatewayStoragePreferences', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllGatewayStoragePreferences', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllGatewayStoragePreferences()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAllGatewayStoragePreferences_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAllGatewayStoragePreferences_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getAllGatewayStoragePreferences failed: unknown result");
  }

  public function getAllGatewayResourceProfiles(\Airavata\Model\Security\AuthzToken $authzToken)
  {
    $this->send_getAllGatewayResourceProfiles($authzToken);
    return $this->recv_getAllGatewayResourceProfiles();
  }

  public function send_getAllGatewayResourceProfiles(\Airavata\Model\Security\AuthzToken $authzToken)
  {
    $args = new \Airavata\API\Airavata_getAllGatewayResourceProfiles_args();
    $args->authzToken = $authzToken;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllGatewayResourceProfiles', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllGatewayResourceProfiles', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllGatewayResourceProfiles()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAllGatewayResourceProfiles_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAllGatewayResourceProfiles_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getAllGatewayResourceProfiles failed: unknown result");
  }

  public function updateGatewayComputeResourcePreference(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID, $computeResourceId, \Airavata\Model\AppCatalog\GatewayProfile\ComputeResourcePreference $computeResourcePreference)
  {
    $this->send_updateGatewayComputeResourcePreference($authzToken, $gatewayID, $computeResourceId, $computeResourcePreference);
    return $this->recv_updateGatewayComputeResourcePreference();
  }

  public function send_updateGatewayComputeResourcePreference(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID, $computeResourceId, \Airavata\Model\AppCatalog\GatewayProfile\ComputeResourcePreference $computeResourcePreference)
  {
    $args = new \Airavata\API\Airavata_updateGatewayComputeResourcePreference_args();
    $args->authzToken = $authzToken;
    $args->gatewayID = $gatewayID;
    $args->computeResourceId = $computeResourceId;
    $args->computeResourcePreference = $computeResourcePreference;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateGatewayComputeResourcePreference', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateGatewayComputeResourcePreference', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateGatewayComputeResourcePreference()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateGatewayComputeResourcePreference_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateGatewayComputeResourcePreference_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("updateGatewayComputeResourcePreference failed: unknown result");
  }

  public function updateGatewayStoragePreference(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID, $storageId, \Airavata\Model\AppCatalog\GatewayProfile\StoragePreference $storagePreference)
  {
    $this->send_updateGatewayStoragePreference($authzToken, $gatewayID, $storageId, $storagePreference);
    return $this->recv_updateGatewayStoragePreference();
  }

  public function send_updateGatewayStoragePreference(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID, $storageId, \Airavata\Model\AppCatalog\GatewayProfile\StoragePreference $storagePreference)
  {
    $args = new \Airavata\API\Airavata_updateGatewayStoragePreference_args();
    $args->authzToken = $authzToken;
    $args->gatewayID = $gatewayID;
    $args->storageId = $storageId;
    $args->storagePreference = $storagePreference;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateGatewayStoragePreference', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateGatewayStoragePreference', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateGatewayStoragePreference()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateGatewayStoragePreference_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateGatewayStoragePreference_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("updateGatewayStoragePreference failed: unknown result");
  }

  public function deleteGatewayComputeResourcePreference(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID, $computeResourceId)
  {
    $this->send_deleteGatewayComputeResourcePreference($authzToken, $gatewayID, $computeResourceId);
    return $this->recv_deleteGatewayComputeResourcePreference();
  }

  public function send_deleteGatewayComputeResourcePreference(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID, $computeResourceId)
  {
    $args = new \Airavata\API\Airavata_deleteGatewayComputeResourcePreference_args();
    $args->authzToken = $authzToken;
    $args->gatewayID = $gatewayID;
    $args->computeResourceId = $computeResourceId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteGatewayComputeResourcePreference', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteGatewayComputeResourcePreference', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteGatewayComputeResourcePreference()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteGatewayComputeResourcePreference_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteGatewayComputeResourcePreference_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("deleteGatewayComputeResourcePreference failed: unknown result");
  }

  public function deleteGatewayStoragePreference(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID, $storageId)
  {
    $this->send_deleteGatewayStoragePreference($authzToken, $gatewayID, $storageId);
    return $this->recv_deleteGatewayStoragePreference();
  }

  public function send_deleteGatewayStoragePreference(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayID, $storageId)
  {
    $args = new \Airavata\API\Airavata_deleteGatewayStoragePreference_args();
    $args->authzToken = $authzToken;
    $args->gatewayID = $gatewayID;
    $args->storageId = $storageId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteGatewayStoragePreference', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteGatewayStoragePreference', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteGatewayStoragePreference()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteGatewayStoragePreference_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteGatewayStoragePreference_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("deleteGatewayStoragePreference failed: unknown result");
  }

  public function getSSHAccountProvisioners(\Airavata\Model\Security\AuthzToken $authzToken)
  {
    $this->send_getSSHAccountProvisioners($authzToken);
    return $this->recv_getSSHAccountProvisioners();
  }

  public function send_getSSHAccountProvisioners(\Airavata\Model\Security\AuthzToken $authzToken)
  {
    $args = new \Airavata\API\Airavata_getSSHAccountProvisioners_args();
    $args->authzToken = $authzToken;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getSSHAccountProvisioners', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getSSHAccountProvisioners', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getSSHAccountProvisioners()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getSSHAccountProvisioners_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getSSHAccountProvisioners_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getSSHAccountProvisioners failed: unknown result");
  }

  public function doesUserHaveSSHAccount(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, $userId)
  {
    $this->send_doesUserHaveSSHAccount($authzToken, $computeResourceId, $userId);
    return $this->recv_doesUserHaveSSHAccount();
  }

  public function send_doesUserHaveSSHAccount(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, $userId)
  {
    $args = new \Airavata\API\Airavata_doesUserHaveSSHAccount_args();
    $args->authzToken = $authzToken;
    $args->computeResourceId = $computeResourceId;
    $args->userId = $userId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'doesUserHaveSSHAccount', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('doesUserHaveSSHAccount', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_doesUserHaveSSHAccount()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_doesUserHaveSSHAccount_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_doesUserHaveSSHAccount_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("doesUserHaveSSHAccount failed: unknown result");
  }

  public function isSSHSetupCompleteForUserComputeResourcePreference(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, $airavataCredStoreToken)
  {
    $this->send_isSSHSetupCompleteForUserComputeResourcePreference($authzToken, $computeResourceId, $airavataCredStoreToken);
    return $this->recv_isSSHSetupCompleteForUserComputeResourcePreference();
  }

  public function send_isSSHSetupCompleteForUserComputeResourcePreference(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, $airavataCredStoreToken)
  {
    $args = new \Airavata\API\Airavata_isSSHSetupCompleteForUserComputeResourcePreference_args();
    $args->authzToken = $authzToken;
    $args->computeResourceId = $computeResourceId;
    $args->airavataCredStoreToken = $airavataCredStoreToken;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'isSSHSetupCompleteForUserComputeResourcePreference', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('isSSHSetupCompleteForUserComputeResourcePreference', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_isSSHSetupCompleteForUserComputeResourcePreference()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_isSSHSetupCompleteForUserComputeResourcePreference_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_isSSHSetupCompleteForUserComputeResourcePreference_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("isSSHSetupCompleteForUserComputeResourcePreference failed: unknown result");
  }

  public function setupUserComputeResourcePreferencesForSSH(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, $userId, $airavataCredStoreToken)
  {
    $this->send_setupUserComputeResourcePreferencesForSSH($authzToken, $computeResourceId, $userId, $airavataCredStoreToken);
    return $this->recv_setupUserComputeResourcePreferencesForSSH();
  }

  public function send_setupUserComputeResourcePreferencesForSSH(\Airavata\Model\Security\AuthzToken $authzToken, $computeResourceId, $userId, $airavataCredStoreToken)
  {
    $args = new \Airavata\API\Airavata_setupUserComputeResourcePreferencesForSSH_args();
    $args->authzToken = $authzToken;
    $args->computeResourceId = $computeResourceId;
    $args->userId = $userId;
    $args->airavataCredStoreToken = $airavataCredStoreToken;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'setupUserComputeResourcePreferencesForSSH', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('setupUserComputeResourcePreferencesForSSH', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_setupUserComputeResourcePreferencesForSSH()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_setupUserComputeResourcePreferencesForSSH_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_setupUserComputeResourcePreferencesForSSH_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("setupUserComputeResourcePreferencesForSSH failed: unknown result");
  }

  public function registerUserResourceProfile(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\AppCatalog\UserResourceProfile\UserResourceProfile $userResourceProfile)
  {
    $this->send_registerUserResourceProfile($authzToken, $userResourceProfile);
    return $this->recv_registerUserResourceProfile();
  }

  public function send_registerUserResourceProfile(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\AppCatalog\UserResourceProfile\UserResourceProfile $userResourceProfile)
  {
    $args = new \Airavata\API\Airavata_registerUserResourceProfile_args();
    $args->authzToken = $authzToken;
    $args->userResourceProfile = $userResourceProfile;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'registerUserResourceProfile', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('registerUserResourceProfile', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_registerUserResourceProfile()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_registerUserResourceProfile_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_registerUserResourceProfile_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("registerUserResourceProfile failed: unknown result");
  }

  public function getUserResourceProfile(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID)
  {
    $this->send_getUserResourceProfile($authzToken, $userId, $gatewayID);
    return $this->recv_getUserResourceProfile();
  }

  public function send_getUserResourceProfile(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID)
  {
    $args = new \Airavata\API\Airavata_getUserResourceProfile_args();
    $args->authzToken = $authzToken;
    $args->userId = $userId;
    $args->gatewayID = $gatewayID;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getUserResourceProfile', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getUserResourceProfile', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getUserResourceProfile()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getUserResourceProfile_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getUserResourceProfile_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getUserResourceProfile failed: unknown result");
  }

  public function updateUserResourceProfile(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID, \Airavata\Model\AppCatalog\UserResourceProfile\UserResourceProfile $userResourceProfile)
  {
    $this->send_updateUserResourceProfile($authzToken, $userId, $gatewayID, $userResourceProfile);
    return $this->recv_updateUserResourceProfile();
  }

  public function send_updateUserResourceProfile(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID, \Airavata\Model\AppCatalog\UserResourceProfile\UserResourceProfile $userResourceProfile)
  {
    $args = new \Airavata\API\Airavata_updateUserResourceProfile_args();
    $args->authzToken = $authzToken;
    $args->userId = $userId;
    $args->gatewayID = $gatewayID;
    $args->userResourceProfile = $userResourceProfile;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateUserResourceProfile', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateUserResourceProfile', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateUserResourceProfile()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateUserResourceProfile_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateUserResourceProfile_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("updateUserResourceProfile failed: unknown result");
  }

  public function deleteUserResourceProfile(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID)
  {
    $this->send_deleteUserResourceProfile($authzToken, $userId, $gatewayID);
    return $this->recv_deleteUserResourceProfile();
  }

  public function send_deleteUserResourceProfile(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID)
  {
    $args = new \Airavata\API\Airavata_deleteUserResourceProfile_args();
    $args->authzToken = $authzToken;
    $args->userId = $userId;
    $args->gatewayID = $gatewayID;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteUserResourceProfile', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteUserResourceProfile', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteUserResourceProfile()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteUserResourceProfile_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteUserResourceProfile_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("deleteUserResourceProfile failed: unknown result");
  }

  public function addUserComputeResourcePreference(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID, $userComputeResourceId, \Airavata\Model\AppCatalog\UserResourceProfile\UserComputeResourcePreference $userComputeResourcePreference)
  {
    $this->send_addUserComputeResourcePreference($authzToken, $userId, $gatewayID, $userComputeResourceId, $userComputeResourcePreference);
    return $this->recv_addUserComputeResourcePreference();
  }

  public function send_addUserComputeResourcePreference(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID, $userComputeResourceId, \Airavata\Model\AppCatalog\UserResourceProfile\UserComputeResourcePreference $userComputeResourcePreference)
  {
    $args = new \Airavata\API\Airavata_addUserComputeResourcePreference_args();
    $args->authzToken = $authzToken;
    $args->userId = $userId;
    $args->gatewayID = $gatewayID;
    $args->userComputeResourceId = $userComputeResourceId;
    $args->userComputeResourcePreference = $userComputeResourcePreference;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'addUserComputeResourcePreference', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('addUserComputeResourcePreference', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_addUserComputeResourcePreference()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_addUserComputeResourcePreference_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_addUserComputeResourcePreference_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("addUserComputeResourcePreference failed: unknown result");
  }

  public function addUserStoragePreference(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID, $userStorageResourceId, \Airavata\Model\AppCatalog\UserResourceProfile\UserStoragePreference $userStoragePreference)
  {
    $this->send_addUserStoragePreference($authzToken, $userId, $gatewayID, $userStorageResourceId, $userStoragePreference);
    return $this->recv_addUserStoragePreference();
  }

  public function send_addUserStoragePreference(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID, $userStorageResourceId, \Airavata\Model\AppCatalog\UserResourceProfile\UserStoragePreference $userStoragePreference)
  {
    $args = new \Airavata\API\Airavata_addUserStoragePreference_args();
    $args->authzToken = $authzToken;
    $args->userId = $userId;
    $args->gatewayID = $gatewayID;
    $args->userStorageResourceId = $userStorageResourceId;
    $args->userStoragePreference = $userStoragePreference;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'addUserStoragePreference', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('addUserStoragePreference', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_addUserStoragePreference()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_addUserStoragePreference_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_addUserStoragePreference_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("addUserStoragePreference failed: unknown result");
  }

  public function getUserComputeResourcePreference(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID, $userComputeResourceId)
  {
    $this->send_getUserComputeResourcePreference($authzToken, $userId, $gatewayID, $userComputeResourceId);
    return $this->recv_getUserComputeResourcePreference();
  }

  public function send_getUserComputeResourcePreference(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID, $userComputeResourceId)
  {
    $args = new \Airavata\API\Airavata_getUserComputeResourcePreference_args();
    $args->authzToken = $authzToken;
    $args->userId = $userId;
    $args->gatewayID = $gatewayID;
    $args->userComputeResourceId = $userComputeResourceId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getUserComputeResourcePreference', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getUserComputeResourcePreference', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getUserComputeResourcePreference()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getUserComputeResourcePreference_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getUserComputeResourcePreference_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getUserComputeResourcePreference failed: unknown result");
  }

  public function getUserStoragePreference(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID, $userStorageResourceId)
  {
    $this->send_getUserStoragePreference($authzToken, $userId, $gatewayID, $userStorageResourceId);
    return $this->recv_getUserStoragePreference();
  }

  public function send_getUserStoragePreference(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID, $userStorageResourceId)
  {
    $args = new \Airavata\API\Airavata_getUserStoragePreference_args();
    $args->authzToken = $authzToken;
    $args->userId = $userId;
    $args->gatewayID = $gatewayID;
    $args->userStorageResourceId = $userStorageResourceId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getUserStoragePreference', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getUserStoragePreference', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getUserStoragePreference()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getUserStoragePreference_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getUserStoragePreference_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getUserStoragePreference failed: unknown result");
  }

  public function getAllUserComputeResourcePreferences(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID)
  {
    $this->send_getAllUserComputeResourcePreferences($authzToken, $userId, $gatewayID);
    return $this->recv_getAllUserComputeResourcePreferences();
  }

  public function send_getAllUserComputeResourcePreferences(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID)
  {
    $args = new \Airavata\API\Airavata_getAllUserComputeResourcePreferences_args();
    $args->authzToken = $authzToken;
    $args->userId = $userId;
    $args->gatewayID = $gatewayID;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllUserComputeResourcePreferences', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllUserComputeResourcePreferences', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllUserComputeResourcePreferences()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAllUserComputeResourcePreferences_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAllUserComputeResourcePreferences_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getAllUserComputeResourcePreferences failed: unknown result");
  }

  public function getAllUserStoragePreferences(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID)
  {
    $this->send_getAllUserStoragePreferences($authzToken, $userId, $gatewayID);
    return $this->recv_getAllUserStoragePreferences();
  }

  public function send_getAllUserStoragePreferences(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID)
  {
    $args = new \Airavata\API\Airavata_getAllUserStoragePreferences_args();
    $args->authzToken = $authzToken;
    $args->userId = $userId;
    $args->gatewayID = $gatewayID;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllUserStoragePreferences', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllUserStoragePreferences', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllUserStoragePreferences()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAllUserStoragePreferences_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAllUserStoragePreferences_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getAllUserStoragePreferences failed: unknown result");
  }

  public function getAllUserResourceProfiles(\Airavata\Model\Security\AuthzToken $authzToken)
  {
    $this->send_getAllUserResourceProfiles($authzToken);
    return $this->recv_getAllUserResourceProfiles();
  }

  public function send_getAllUserResourceProfiles(\Airavata\Model\Security\AuthzToken $authzToken)
  {
    $args = new \Airavata\API\Airavata_getAllUserResourceProfiles_args();
    $args->authzToken = $authzToken;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllUserResourceProfiles', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllUserResourceProfiles', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllUserResourceProfiles()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAllUserResourceProfiles_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAllUserResourceProfiles_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getAllUserResourceProfiles failed: unknown result");
  }

  public function updateUserComputeResourcePreference(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID, $userComputeResourceId, \Airavata\Model\AppCatalog\UserResourceProfile\UserComputeResourcePreference $userComputeResourcePreference)
  {
    $this->send_updateUserComputeResourcePreference($authzToken, $userId, $gatewayID, $userComputeResourceId, $userComputeResourcePreference);
    return $this->recv_updateUserComputeResourcePreference();
  }

  public function send_updateUserComputeResourcePreference(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID, $userComputeResourceId, \Airavata\Model\AppCatalog\UserResourceProfile\UserComputeResourcePreference $userComputeResourcePreference)
  {
    $args = new \Airavata\API\Airavata_updateUserComputeResourcePreference_args();
    $args->authzToken = $authzToken;
    $args->userId = $userId;
    $args->gatewayID = $gatewayID;
    $args->userComputeResourceId = $userComputeResourceId;
    $args->userComputeResourcePreference = $userComputeResourcePreference;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateUserComputeResourcePreference', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateUserComputeResourcePreference', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateUserComputeResourcePreference()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateUserComputeResourcePreference_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateUserComputeResourcePreference_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("updateUserComputeResourcePreference failed: unknown result");
  }

  public function updateUserStoragePreference(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID, $userStorageId, \Airavata\Model\AppCatalog\UserResourceProfile\UserStoragePreference $userStoragePreference)
  {
    $this->send_updateUserStoragePreference($authzToken, $userId, $gatewayID, $userStorageId, $userStoragePreference);
    return $this->recv_updateUserStoragePreference();
  }

  public function send_updateUserStoragePreference(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID, $userStorageId, \Airavata\Model\AppCatalog\UserResourceProfile\UserStoragePreference $userStoragePreference)
  {
    $args = new \Airavata\API\Airavata_updateUserStoragePreference_args();
    $args->authzToken = $authzToken;
    $args->userId = $userId;
    $args->gatewayID = $gatewayID;
    $args->userStorageId = $userStorageId;
    $args->userStoragePreference = $userStoragePreference;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateUserStoragePreference', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateUserStoragePreference', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateUserStoragePreference()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateUserStoragePreference_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateUserStoragePreference_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("updateUserStoragePreference failed: unknown result");
  }

  public function deleteUserComputeResourcePreference(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID, $userComputeResourceId)
  {
    $this->send_deleteUserComputeResourcePreference($authzToken, $userId, $gatewayID, $userComputeResourceId);
    return $this->recv_deleteUserComputeResourcePreference();
  }

  public function send_deleteUserComputeResourcePreference(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID, $userComputeResourceId)
  {
    $args = new \Airavata\API\Airavata_deleteUserComputeResourcePreference_args();
    $args->authzToken = $authzToken;
    $args->userId = $userId;
    $args->gatewayID = $gatewayID;
    $args->userComputeResourceId = $userComputeResourceId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteUserComputeResourcePreference', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteUserComputeResourcePreference', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteUserComputeResourcePreference()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteUserComputeResourcePreference_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteUserComputeResourcePreference_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("deleteUserComputeResourcePreference failed: unknown result");
  }

  public function deleteUserStoragePreference(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID, $userStorageId)
  {
    $this->send_deleteUserStoragePreference($authzToken, $userId, $gatewayID, $userStorageId);
    return $this->recv_deleteUserStoragePreference();
  }

  public function send_deleteUserStoragePreference(\Airavata\Model\Security\AuthzToken $authzToken, $userId, $gatewayID, $userStorageId)
  {
    $args = new \Airavata\API\Airavata_deleteUserStoragePreference_args();
    $args->authzToken = $authzToken;
    $args->userId = $userId;
    $args->gatewayID = $gatewayID;
    $args->userStorageId = $userStorageId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteUserStoragePreference', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteUserStoragePreference', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteUserStoragePreference()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteUserStoragePreference_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteUserStoragePreference_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("deleteUserStoragePreference failed: unknown result");
  }

  public function getAllWorkflows(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId)
  {
    $this->send_getAllWorkflows($authzToken, $gatewayId);
    return $this->recv_getAllWorkflows();
  }

  public function send_getAllWorkflows(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId)
  {
    $args = new \Airavata\API\Airavata_getAllWorkflows_args();
    $args->authzToken = $authzToken;
    $args->gatewayId = $gatewayId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllWorkflows', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllWorkflows', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllWorkflows()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAllWorkflows_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAllWorkflows_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getAllWorkflows failed: unknown result");
  }

  public function getLatestQueueStatuses(\Airavata\Model\Security\AuthzToken $authzToken)
  {
    $this->send_getLatestQueueStatuses($authzToken);
    return $this->recv_getLatestQueueStatuses();
  }

  public function send_getLatestQueueStatuses(\Airavata\Model\Security\AuthzToken $authzToken)
  {
    $args = new \Airavata\API\Airavata_getLatestQueueStatuses_args();
    $args->authzToken = $authzToken;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getLatestQueueStatuses', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getLatestQueueStatuses', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getLatestQueueStatuses()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getLatestQueueStatuses_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getLatestQueueStatuses_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getLatestQueueStatuses failed: unknown result");
  }

  public function getWorkflow(\Airavata\Model\Security\AuthzToken $authzToken, $workflowTemplateId)
  {
    $this->send_getWorkflow($authzToken, $workflowTemplateId);
    return $this->recv_getWorkflow();
  }

  public function send_getWorkflow(\Airavata\Model\Security\AuthzToken $authzToken, $workflowTemplateId)
  {
    $args = new \Airavata\API\Airavata_getWorkflow_args();
    $args->authzToken = $authzToken;
    $args->workflowTemplateId = $workflowTemplateId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getWorkflow', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getWorkflow', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getWorkflow()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getWorkflow_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getWorkflow_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getWorkflow failed: unknown result");
  }

  public function deleteWorkflow(\Airavata\Model\Security\AuthzToken $authzToken, $workflowTemplateId)
  {
    $this->send_deleteWorkflow($authzToken, $workflowTemplateId);
    $this->recv_deleteWorkflow();
  }

  public function send_deleteWorkflow(\Airavata\Model\Security\AuthzToken $authzToken, $workflowTemplateId)
  {
    $args = new \Airavata\API\Airavata_deleteWorkflow_args();
    $args->authzToken = $authzToken;
    $args->workflowTemplateId = $workflowTemplateId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteWorkflow', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteWorkflow', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteWorkflow()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteWorkflow_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteWorkflow_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    return;
  }

  public function registerWorkflow(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, \Airavata\Model\WorkflowModel $workflow)
  {
    $this->send_registerWorkflow($authzToken, $gatewayId, $workflow);
    return $this->recv_registerWorkflow();
  }

  public function send_registerWorkflow(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId, \Airavata\Model\WorkflowModel $workflow)
  {
    $args = new \Airavata\API\Airavata_registerWorkflow_args();
    $args->authzToken = $authzToken;
    $args->gatewayId = $gatewayId;
    $args->workflow = $workflow;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'registerWorkflow', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('registerWorkflow', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_registerWorkflow()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_registerWorkflow_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_registerWorkflow_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("registerWorkflow failed: unknown result");
  }

  public function updateWorkflow(\Airavata\Model\Security\AuthzToken $authzToken, $workflowTemplateId, \Airavata\Model\WorkflowModel $workflow)
  {
    $this->send_updateWorkflow($authzToken, $workflowTemplateId, $workflow);
    $this->recv_updateWorkflow();
  }

  public function send_updateWorkflow(\Airavata\Model\Security\AuthzToken $authzToken, $workflowTemplateId, \Airavata\Model\WorkflowModel $workflow)
  {
    $args = new \Airavata\API\Airavata_updateWorkflow_args();
    $args->authzToken = $authzToken;
    $args->workflowTemplateId = $workflowTemplateId;
    $args->workflow = $workflow;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateWorkflow', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateWorkflow', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateWorkflow()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateWorkflow_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateWorkflow_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    return;
  }

  public function getWorkflowTemplateId(\Airavata\Model\Security\AuthzToken $authzToken, $workflowName)
  {
    $this->send_getWorkflowTemplateId($authzToken, $workflowName);
    return $this->recv_getWorkflowTemplateId();
  }

  public function send_getWorkflowTemplateId(\Airavata\Model\Security\AuthzToken $authzToken, $workflowName)
  {
    $args = new \Airavata\API\Airavata_getWorkflowTemplateId_args();
    $args->authzToken = $authzToken;
    $args->workflowName = $workflowName;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getWorkflowTemplateId', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getWorkflowTemplateId', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getWorkflowTemplateId()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getWorkflowTemplateId_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getWorkflowTemplateId_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getWorkflowTemplateId failed: unknown result");
  }

  public function isWorkflowExistWithName(\Airavata\Model\Security\AuthzToken $authzToken, $workflowName)
  {
    $this->send_isWorkflowExistWithName($authzToken, $workflowName);
    return $this->recv_isWorkflowExistWithName();
  }

  public function send_isWorkflowExistWithName(\Airavata\Model\Security\AuthzToken $authzToken, $workflowName)
  {
    $args = new \Airavata\API\Airavata_isWorkflowExistWithName_args();
    $args->authzToken = $authzToken;
    $args->workflowName = $workflowName;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'isWorkflowExistWithName', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('isWorkflowExistWithName', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_isWorkflowExistWithName()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_isWorkflowExistWithName_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_isWorkflowExistWithName_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("isWorkflowExistWithName failed: unknown result");
  }

  public function registerDataProduct(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\Data\Replica\DataProductModel $dataProductModel)
  {
    $this->send_registerDataProduct($authzToken, $dataProductModel);
    return $this->recv_registerDataProduct();
  }

  public function send_registerDataProduct(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\Data\Replica\DataProductModel $dataProductModel)
  {
    $args = new \Airavata\API\Airavata_registerDataProduct_args();
    $args->authzToken = $authzToken;
    $args->dataProductModel = $dataProductModel;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'registerDataProduct', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('registerDataProduct', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_registerDataProduct()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_registerDataProduct_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_registerDataProduct_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("registerDataProduct failed: unknown result");
  }

  public function getDataProduct(\Airavata\Model\Security\AuthzToken $authzToken, $dataProductUri)
  {
    $this->send_getDataProduct($authzToken, $dataProductUri);
    return $this->recv_getDataProduct();
  }

  public function send_getDataProduct(\Airavata\Model\Security\AuthzToken $authzToken, $dataProductUri)
  {
    $args = new \Airavata\API\Airavata_getDataProduct_args();
    $args->authzToken = $authzToken;
    $args->dataProductUri = $dataProductUri;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getDataProduct', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getDataProduct', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getDataProduct()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getDataProduct_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getDataProduct_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getDataProduct failed: unknown result");
  }

  public function registerReplicaLocation(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\Data\Replica\DataReplicaLocationModel $replicaLocationModel)
  {
    $this->send_registerReplicaLocation($authzToken, $replicaLocationModel);
    return $this->recv_registerReplicaLocation();
  }

  public function send_registerReplicaLocation(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\Data\Replica\DataReplicaLocationModel $replicaLocationModel)
  {
    $args = new \Airavata\API\Airavata_registerReplicaLocation_args();
    $args->authzToken = $authzToken;
    $args->replicaLocationModel = $replicaLocationModel;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'registerReplicaLocation', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('registerReplicaLocation', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_registerReplicaLocation()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_registerReplicaLocation_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_registerReplicaLocation_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("registerReplicaLocation failed: unknown result");
  }

  public function getParentDataProduct(\Airavata\Model\Security\AuthzToken $authzToken, $productUri)
  {
    $this->send_getParentDataProduct($authzToken, $productUri);
    return $this->recv_getParentDataProduct();
  }

  public function send_getParentDataProduct(\Airavata\Model\Security\AuthzToken $authzToken, $productUri)
  {
    $args = new \Airavata\API\Airavata_getParentDataProduct_args();
    $args->authzToken = $authzToken;
    $args->productUri = $productUri;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getParentDataProduct', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getParentDataProduct', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getParentDataProduct()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getParentDataProduct_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getParentDataProduct_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getParentDataProduct failed: unknown result");
  }

  public function getChildDataProducts(\Airavata\Model\Security\AuthzToken $authzToken, $productUri)
  {
    $this->send_getChildDataProducts($authzToken, $productUri);
    return $this->recv_getChildDataProducts();
  }

  public function send_getChildDataProducts(\Airavata\Model\Security\AuthzToken $authzToken, $productUri)
  {
    $args = new \Airavata\API\Airavata_getChildDataProducts_args();
    $args->authzToken = $authzToken;
    $args->productUri = $productUri;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getChildDataProducts', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getChildDataProducts', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getChildDataProducts()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getChildDataProducts_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getChildDataProducts_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getChildDataProducts failed: unknown result");
  }

  public function shareResourceWithUsers(\Airavata\Model\Security\AuthzToken $authzToken, $resourceId, $resourceType, array $userPermissionList)
  {
    $this->send_shareResourceWithUsers($authzToken, $resourceId, $resourceType, $userPermissionList);
    return $this->recv_shareResourceWithUsers();
  }

  public function send_shareResourceWithUsers(\Airavata\Model\Security\AuthzToken $authzToken, $resourceId, $resourceType, array $userPermissionList)
  {
    $args = new \Airavata\API\Airavata_shareResourceWithUsers_args();
    $args->authzToken = $authzToken;
    $args->resourceId = $resourceId;
    $args->resourceType = $resourceType;
    $args->userPermissionList = $userPermissionList;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'shareResourceWithUsers', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('shareResourceWithUsers', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_shareResourceWithUsers()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_shareResourceWithUsers_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_shareResourceWithUsers_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("shareResourceWithUsers failed: unknown result");
  }

  public function revokeSharingOfResourceFromUsers(\Airavata\Model\Security\AuthzToken $authzToken, $resourceId, $resourceType, array $userPermissionList)
  {
    $this->send_revokeSharingOfResourceFromUsers($authzToken, $resourceId, $resourceType, $userPermissionList);
    return $this->recv_revokeSharingOfResourceFromUsers();
  }

  public function send_revokeSharingOfResourceFromUsers(\Airavata\Model\Security\AuthzToken $authzToken, $resourceId, $resourceType, array $userPermissionList)
  {
    $args = new \Airavata\API\Airavata_revokeSharingOfResourceFromUsers_args();
    $args->authzToken = $authzToken;
    $args->resourceId = $resourceId;
    $args->resourceType = $resourceType;
    $args->userPermissionList = $userPermissionList;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'revokeSharingOfResourceFromUsers', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('revokeSharingOfResourceFromUsers', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_revokeSharingOfResourceFromUsers()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_revokeSharingOfResourceFromUsers_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_revokeSharingOfResourceFromUsers_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("revokeSharingOfResourceFromUsers failed: unknown result");
  }

  public function getAllAccessibleUsers(\Airavata\Model\Security\AuthzToken $authzToken, $resourceId, $resourceType, $permissionType)
  {
    $this->send_getAllAccessibleUsers($authzToken, $resourceId, $resourceType, $permissionType);
    return $this->recv_getAllAccessibleUsers();
  }

  public function send_getAllAccessibleUsers(\Airavata\Model\Security\AuthzToken $authzToken, $resourceId, $resourceType, $permissionType)
  {
    $args = new \Airavata\API\Airavata_getAllAccessibleUsers_args();
    $args->authzToken = $authzToken;
    $args->resourceId = $resourceId;
    $args->resourceType = $resourceType;
    $args->permissionType = $permissionType;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllAccessibleUsers', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllAccessibleUsers', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllAccessibleUsers()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAllAccessibleUsers_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAllAccessibleUsers_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getAllAccessibleUsers failed: unknown result");
  }

  public function createGroup(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\Group\GroupModel $groupModel)
  {
    $this->send_createGroup($authzToken, $groupModel);
    return $this->recv_createGroup();
  }

  public function send_createGroup(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\Group\GroupModel $groupModel)
  {
    $args = new \Airavata\API\Airavata_createGroup_args();
    $args->authzToken = $authzToken;
    $args->groupModel = $groupModel;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'createGroup', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('createGroup', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_createGroup()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_createGroup_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_createGroup_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("createGroup failed: unknown result");
  }

  public function updateGroup(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\Group\GroupModel $groupModel)
  {
    $this->send_updateGroup($authzToken, $groupModel);
    return $this->recv_updateGroup();
  }

  public function send_updateGroup(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\Group\GroupModel $groupModel)
  {
    $args = new \Airavata\API\Airavata_updateGroup_args();
    $args->authzToken = $authzToken;
    $args->groupModel = $groupModel;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateGroup', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateGroup', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateGroup()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateGroup_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateGroup_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("updateGroup failed: unknown result");
  }

  public function deleteGroup(\Airavata\Model\Security\AuthzToken $authzToken, $groupId, $ownerId)
  {
    $this->send_deleteGroup($authzToken, $groupId, $ownerId);
    return $this->recv_deleteGroup();
  }

  public function send_deleteGroup(\Airavata\Model\Security\AuthzToken $authzToken, $groupId, $ownerId)
  {
    $args = new \Airavata\API\Airavata_deleteGroup_args();
    $args->authzToken = $authzToken;
    $args->groupId = $groupId;
    $args->ownerId = $ownerId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteGroup', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteGroup', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteGroup()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteGroup_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteGroup_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("deleteGroup failed: unknown result");
  }

  public function getGroup(\Airavata\Model\Security\AuthzToken $authzToken, $groupId)
  {
    $this->send_getGroup($authzToken, $groupId);
    return $this->recv_getGroup();
  }

  public function send_getGroup(\Airavata\Model\Security\AuthzToken $authzToken, $groupId)
  {
    $args = new \Airavata\API\Airavata_getGroup_args();
    $args->authzToken = $authzToken;
    $args->groupId = $groupId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getGroup', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getGroup', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getGroup()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getGroup_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getGroup_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getGroup failed: unknown result");
  }

  public function getAllGroupsUserBelongs(\Airavata\Model\Security\AuthzToken $authzToken, $userName)
  {
    $this->send_getAllGroupsUserBelongs($authzToken, $userName);
    return $this->recv_getAllGroupsUserBelongs();
  }

  public function send_getAllGroupsUserBelongs(\Airavata\Model\Security\AuthzToken $authzToken, $userName)
  {
    $args = new \Airavata\API\Airavata_getAllGroupsUserBelongs_args();
    $args->authzToken = $authzToken;
    $args->userName = $userName;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllGroupsUserBelongs', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllGroupsUserBelongs', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllGroupsUserBelongs()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAllGroupsUserBelongs_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAllGroupsUserBelongs_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getAllGroupsUserBelongs failed: unknown result");
  }

}

// HELPER FUNCTIONS AND STRUCTURES

class Airavata_getAPIVersion_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAPIVersion_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAPIVersion_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAPIVersion_result {
  static $_TSPEC;

  /**
   * @var string
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        4 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAPIVersion_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAPIVersion_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 4);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_isUserExists_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $gatewayId = null;
  /**
   * @var string
   */
  public $userName = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'userName',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
      if (isset($vals['userName'])) {
        $this->userName = $vals['userName'];
      }
    }
  }

  public function getName() {
    return 'Airavata_isUserExists_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->userName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_isUserExists_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 2);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userName !== null) {
      $xfer += $output->writeFieldBegin('userName', TType::STRING, 3);
      $xfer += $output->writeString($this->userName);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_isUserExists_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        4 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_isUserExists_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_isUserExists_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 4);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_addGateway_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var \Airavata\Model\Workspace\Gateway
   */
  public $gateway = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'gateway',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Workspace\Gateway',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['gateway'])) {
        $this->gateway = $vals['gateway'];
      }
    }
  }

  public function getName() {
    return 'Airavata_addGateway_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->gateway = new \Airavata\Model\Workspace\Gateway();
            $xfer += $this->gateway->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_addGateway_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gateway !== null) {
      if (!is_object($this->gateway)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('gateway', TType::STRUCT, 2);
      $xfer += $this->gateway->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_addGateway_result {
  static $_TSPEC;

  /**
   * @var string
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        4 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_addGateway_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_addGateway_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 4);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllUsersInGateway_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $gatewayId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAllUsersInGateway_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllUsersInGateway_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 2);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllUsersInGateway_result {
  static $_TSPEC;

  /**
   * @var string[]
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        4 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAllUsersInGateway_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size0 = 0;
            $_etype3 = 0;
            $xfer += $input->readListBegin($_etype3, $_size0);
            for ($_i4 = 0; $_i4 < $_size0; ++$_i4)
            {
              $elem5 = null;
              $xfer += $input->readString($elem5);
              $this->success []= $elem5;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllUsersInGateway_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter6)
          {
            $xfer += $output->writeString($iter6);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 4);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateGateway_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $gatewayId = null;
  /**
   * @var \Airavata\Model\Workspace\Gateway
   */
  public $updatedGateway = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'updatedGateway',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Workspace\Gateway',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
      if (isset($vals['updatedGateway'])) {
        $this->updatedGateway = $vals['updatedGateway'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateGateway_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->updatedGateway = new \Airavata\Model\Workspace\Gateway();
            $xfer += $this->updatedGateway->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateGateway_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 2);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->updatedGateway !== null) {
      if (!is_object($this->updatedGateway)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('updatedGateway', TType::STRUCT, 3);
      $xfer += $this->updatedGateway->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateGateway_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        4 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateGateway_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateGateway_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 4);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getGateway_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $gatewayId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getGateway_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getGateway_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 2);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getGateway_result {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Workspace\Gateway
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Workspace\Gateway',
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        4 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getGateway_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Airavata\Model\Workspace\Gateway();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getGateway_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 4);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deleteGateway_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $gatewayId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deleteGateway_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deleteGateway_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 2);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deleteGateway_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        4 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deleteGateway_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deleteGateway_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 4);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllGateways_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAllGateways_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllGateways_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllGateways_result {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Workspace\Gateway[]
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Workspace\Gateway',
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        4 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAllGateways_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size7 = 0;
            $_etype10 = 0;
            $xfer += $input->readListBegin($_etype10, $_size7);
            for ($_i11 = 0; $_i11 < $_size7; ++$_i11)
            {
              $elem12 = null;
              $elem12 = new \Airavata\Model\Workspace\Gateway();
              $xfer += $elem12->read($input);
              $this->success []= $elem12;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllGateways_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter13)
          {
            $xfer += $iter13->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 4);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_isGatewayExist_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $gatewayId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_isGatewayExist_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_isGatewayExist_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 2);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_isGatewayExist_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        4 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_isGatewayExist_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_isGatewayExist_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 4);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_createNotification_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var \Airavata\Model\Workspace\Notification
   */
  public $notification = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'notification',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Workspace\Notification',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['notification'])) {
        $this->notification = $vals['notification'];
      }
    }
  }

  public function getName() {
    return 'Airavata_createNotification_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->notification = new \Airavata\Model\Workspace\Notification();
            $xfer += $this->notification->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_createNotification_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notification !== null) {
      if (!is_object($this->notification)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('notification', TType::STRUCT, 2);
      $xfer += $this->notification->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_createNotification_result {
  static $_TSPEC;

  /**
   * @var string
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        4 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_createNotification_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_createNotification_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 4);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateNotification_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var \Airavata\Model\Workspace\Notification
   */
  public $notification = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'notification',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Workspace\Notification',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['notification'])) {
        $this->notification = $vals['notification'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateNotification_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->notification = new \Airavata\Model\Workspace\Notification();
            $xfer += $this->notification->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateNotification_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notification !== null) {
      if (!is_object($this->notification)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('notification', TType::STRUCT, 2);
      $xfer += $this->notification->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateNotification_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        4 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateNotification_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateNotification_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 4);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deleteNotification_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $gatewayId = null;
  /**
   * @var string
   */
  public $notificationId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'notificationId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
      if (isset($vals['notificationId'])) {
        $this->notificationId = $vals['notificationId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deleteNotification_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->notificationId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deleteNotification_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 2);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notificationId !== null) {
      $xfer += $output->writeFieldBegin('notificationId', TType::STRING, 3);
      $xfer += $output->writeString($this->notificationId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deleteNotification_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        4 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deleteNotification_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deleteNotification_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 4);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getNotification_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $gatewayId = null;
  /**
   * @var string
   */
  public $notificationId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'notificationId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
      if (isset($vals['notificationId'])) {
        $this->notificationId = $vals['notificationId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getNotification_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->notificationId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getNotification_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 2);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->notificationId !== null) {
      $xfer += $output->writeFieldBegin('notificationId', TType::STRING, 3);
      $xfer += $output->writeString($this->notificationId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getNotification_result {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Workspace\Notification
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Workspace\Notification',
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        4 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getNotification_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Airavata\Model\Workspace\Notification();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getNotification_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 4);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllNotifications_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $gatewayId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAllNotifications_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllNotifications_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 2);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllNotifications_result {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Workspace\Notification[]
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Workspace\Notification',
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        4 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAllNotifications_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size14 = 0;
            $_etype17 = 0;
            $xfer += $input->readListBegin($_etype17, $_size14);
            for ($_i18 = 0; $_i18 < $_size14; ++$_i18)
            {
              $elem19 = null;
              $elem19 = new \Airavata\Model\Workspace\Notification();
              $xfer += $elem19->read($input);
              $this->success []= $elem19;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllNotifications_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter20)
          {
            $xfer += $iter20->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 4);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_generateAndRegisterSSHKeys_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $gatewayId = null;
  /**
   * @var string
   */
  public $userName = null;
  /**
   * @var string
   */
  public $description = null;
  /**
   * @var int
   */
  public $credentialOwnerType = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'userName',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'description',
          'type' => TType::STRING,
          ),
        5 => array(
          'var' => 'credentialOwnerType',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
      if (isset($vals['userName'])) {
        $this->userName = $vals['userName'];
      }
      if (isset($vals['description'])) {
        $this->description = $vals['description'];
      }
      if (isset($vals['credentialOwnerType'])) {
        $this->credentialOwnerType = $vals['credentialOwnerType'];
      }
    }
  }

  public function getName() {
    return 'Airavata_generateAndRegisterSSHKeys_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->userName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->description);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->credentialOwnerType);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_generateAndRegisterSSHKeys_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 2);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userName !== null) {
      $xfer += $output->writeFieldBegin('userName', TType::STRING, 3);
      $xfer += $output->writeString($this->userName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->description !== null) {
      $xfer += $output->writeFieldBegin('description', TType::STRING, 4);
      $xfer += $output->writeString($this->description);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->credentialOwnerType !== null) {
      $xfer += $output->writeFieldBegin('credentialOwnerType', TType::I32, 5);
      $xfer += $output->writeI32($this->credentialOwnerType);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_generateAndRegisterSSHKeys_result {
  static $_TSPEC;

  /**
   * @var string
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_generateAndRegisterSSHKeys_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_generateAndRegisterSSHKeys_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_registerPwdCredential_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $gatewayId = null;
  /**
   * @var string
   */
  public $portalUserName = null;
  /**
   * @var string
   */
  public $loginUserName = null;
  /**
   * @var string
   */
  public $password = null;
  /**
   * @var string
   */
  public $description = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'portalUserName',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'loginUserName',
          'type' => TType::STRING,
          ),
        5 => array(
          'var' => 'password',
          'type' => TType::STRING,
          ),
        6 => array(
          'var' => 'description',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
      if (isset($vals['portalUserName'])) {
        $this->portalUserName = $vals['portalUserName'];
      }
      if (isset($vals['loginUserName'])) {
        $this->loginUserName = $vals['loginUserName'];
      }
      if (isset($vals['password'])) {
        $this->password = $vals['password'];
      }
      if (isset($vals['description'])) {
        $this->description = $vals['description'];
      }
    }
  }

  public function getName() {
    return 'Airavata_registerPwdCredential_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->portalUserName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->loginUserName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->password);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 6:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->description);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_registerPwdCredential_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 2);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->portalUserName !== null) {
      $xfer += $output->writeFieldBegin('portalUserName', TType::STRING, 3);
      $xfer += $output->writeString($this->portalUserName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->loginUserName !== null) {
      $xfer += $output->writeFieldBegin('loginUserName', TType::STRING, 4);
      $xfer += $output->writeString($this->loginUserName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->password !== null) {
      $xfer += $output->writeFieldBegin('password', TType::STRING, 5);
      $xfer += $output->writeString($this->password);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->description !== null) {
      $xfer += $output->writeFieldBegin('description', TType::STRING, 6);
      $xfer += $output->writeString($this->description);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_registerPwdCredential_result {
  static $_TSPEC;

  /**
   * @var string
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_registerPwdCredential_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_registerPwdCredential_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getSSHPubKey_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $airavataCredStoreToken = null;
  /**
   * @var string
   */
  public $gatewayId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'airavataCredStoreToken',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['airavataCredStoreToken'])) {
        $this->airavataCredStoreToken = $vals['airavataCredStoreToken'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getSSHPubKey_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->airavataCredStoreToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getSSHPubKey_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->airavataCredStoreToken !== null) {
      $xfer += $output->writeFieldBegin('airavataCredStoreToken', TType::STRING, 2);
      $xfer += $output->writeString($this->airavataCredStoreToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 3);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getSSHPubKey_result {
  static $_TSPEC;

  /**
   * @var string
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getSSHPubKey_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getSSHPubKey_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllGatewaySSHPubKeys_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $gatewayId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAllGatewaySSHPubKeys_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllGatewaySSHPubKeys_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 2);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllGatewaySSHPubKeys_result {
  static $_TSPEC;

  /**
   * @var array
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAllGatewaySSHPubKeys_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::MAP) {
            $this->success = array();
            $_size21 = 0;
            $_ktype22 = 0;
            $_vtype23 = 0;
            $xfer += $input->readMapBegin($_ktype22, $_vtype23, $_size21);
            for ($_i25 = 0; $_i25 < $_size21; ++$_i25)
            {
              $key26 = '';
              $val27 = '';
              $xfer += $input->readString($key26);
              $xfer += $input->readString($val27);
              $this->success[$key26] = $val27;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllGatewaySSHPubKeys_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::MAP, 0);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->success));
        {
          foreach ($this->success as $kiter28 => $viter29)
          {
            $xfer += $output->writeString($kiter28);
            $xfer += $output->writeString($viter29);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllCredentialSummaryForGateway_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var int
   */
  public $type = null;
  /**
   * @var string
   */
  public $gatewayId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'type',
          'type' => TType::I32,
          ),
        3 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['type'])) {
        $this->type = $vals['type'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAllCredentialSummaryForGateway_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->type);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllCredentialSummaryForGateway_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->type !== null) {
      $xfer += $output->writeFieldBegin('type', TType::I32, 2);
      $xfer += $output->writeI32($this->type);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 3);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllCredentialSummaryForGateway_result {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Credential\Store\CredentialSummary[]
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Credential\Store\CredentialSummary',
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAllCredentialSummaryForGateway_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size30 = 0;
            $_etype33 = 0;
            $xfer += $input->readListBegin($_etype33, $_size30);
            for ($_i34 = 0; $_i34 < $_size30; ++$_i34)
            {
              $elem35 = null;
              $elem35 = new \Airavata\Model\Credential\Store\CredentialSummary();
              $xfer += $elem35->read($input);
              $this->success []= $elem35;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllCredentialSummaryForGateway_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter36)
          {
            $xfer += $iter36->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllCredentialSummaryForUsersInGateway_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var int
   */
  public $type = null;
  /**
   * @var string
   */
  public $gatewayId = null;
  /**
   * @var string
   */
  public $userId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'type',
          'type' => TType::I32,
          ),
        3 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'userId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['type'])) {
        $this->type = $vals['type'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
      if (isset($vals['userId'])) {
        $this->userId = $vals['userId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAllCredentialSummaryForUsersInGateway_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->type);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->userId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllCredentialSummaryForUsersInGateway_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->type !== null) {
      $xfer += $output->writeFieldBegin('type', TType::I32, 2);
      $xfer += $output->writeI32($this->type);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 3);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userId !== null) {
      $xfer += $output->writeFieldBegin('userId', TType::STRING, 4);
      $xfer += $output->writeString($this->userId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllCredentialSummaryForUsersInGateway_result {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Credential\Store\CredentialSummary[]
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Credential\Store\CredentialSummary',
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAllCredentialSummaryForUsersInGateway_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size37 = 0;
            $_etype40 = 0;
            $xfer += $input->readListBegin($_etype40, $_size37);
            for ($_i41 = 0; $_i41 < $_size37; ++$_i41)
            {
              $elem42 = null;
              $elem42 = new \Airavata\Model\Credential\Store\CredentialSummary();
              $xfer += $elem42->read($input);
              $this->success []= $elem42;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllCredentialSummaryForUsersInGateway_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter43)
          {
            $xfer += $iter43->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllGatewayPWDCredentials_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $gatewayId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAllGatewayPWDCredentials_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllGatewayPWDCredentials_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 2);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllGatewayPWDCredentials_result {
  static $_TSPEC;

  /**
   * @var array
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAllGatewayPWDCredentials_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::MAP) {
            $this->success = array();
            $_size44 = 0;
            $_ktype45 = 0;
            $_vtype46 = 0;
            $xfer += $input->readMapBegin($_ktype45, $_vtype46, $_size44);
            for ($_i48 = 0; $_i48 < $_size44; ++$_i48)
            {
              $key49 = '';
              $val50 = '';
              $xfer += $input->readString($key49);
              $xfer += $input->readString($val50);
              $this->success[$key49] = $val50;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllGatewayPWDCredentials_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::MAP, 0);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->success));
        {
          foreach ($this->success as $kiter51 => $viter52)
          {
            $xfer += $output->writeString($kiter51);
            $xfer += $output->writeString($viter52);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deleteSSHPubKey_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $airavataCredStoreToken = null;
  /**
   * @var string
   */
  public $gatewayId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'airavataCredStoreToken',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['airavataCredStoreToken'])) {
        $this->airavataCredStoreToken = $vals['airavataCredStoreToken'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deleteSSHPubKey_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->airavataCredStoreToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deleteSSHPubKey_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->airavataCredStoreToken !== null) {
      $xfer += $output->writeFieldBegin('airavataCredStoreToken', TType::STRING, 2);
      $xfer += $output->writeString($this->airavataCredStoreToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 3);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deleteSSHPubKey_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deleteSSHPubKey_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deleteSSHPubKey_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deletePWDCredential_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $airavataCredStoreToken = null;
  /**
   * @var string
   */
  public $gatewayId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'airavataCredStoreToken',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['airavataCredStoreToken'])) {
        $this->airavataCredStoreToken = $vals['airavataCredStoreToken'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deletePWDCredential_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->airavataCredStoreToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deletePWDCredential_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->airavataCredStoreToken !== null) {
      $xfer += $output->writeFieldBegin('airavataCredStoreToken', TType::STRING, 2);
      $xfer += $output->writeString($this->airavataCredStoreToken);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 3);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deletePWDCredential_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deletePWDCredential_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deletePWDCredential_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_createProject_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $gatewayId = null;
  /**
   * @var \Airavata\Model\Workspace\Project
   */
  public $project = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'project',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Workspace\Project',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
      if (isset($vals['project'])) {
        $this->project = $vals['project'];
      }
    }
  }

  public function getName() {
    return 'Airavata_createProject_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->project = new \Airavata\Model\Workspace\Project();
            $xfer += $this->project->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_createProject_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 2);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->project !== null) {
      if (!is_object($this->project)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('project', TType::STRUCT, 3);
      $xfer += $this->project->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_createProject_result {
  static $_TSPEC;

  /**
   * @var string
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        4 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_createProject_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_createProject_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 4);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateProject_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $projectId = null;
  /**
   * @var \Airavata\Model\Workspace\Project
   */
  public $updatedProject = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'projectId',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'updatedProject',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Workspace\Project',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['projectId'])) {
        $this->projectId = $vals['projectId'];
      }
      if (isset($vals['updatedProject'])) {
        $this->updatedProject = $vals['updatedProject'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateProject_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->projectId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->updatedProject = new \Airavata\Model\Workspace\Project();
            $xfer += $this->updatedProject->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateProject_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->projectId !== null) {
      $xfer += $output->writeFieldBegin('projectId', TType::STRING, 2);
      $xfer += $output->writeString($this->projectId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->updatedProject !== null) {
      if (!is_object($this->updatedProject)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('updatedProject', TType::STRUCT, 3);
      $xfer += $this->updatedProject->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateProject_result {
  static $_TSPEC;

  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\ProjectNotFoundException
   */
  public $pnfe = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        4 => array(
          'var' => 'pnfe',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\ProjectNotFoundException',
          ),
        5 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['pnfe'])) {
        $this->pnfe = $vals['pnfe'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateProject_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->pnfe = new \Airavata\API\Error\ProjectNotFoundException();
            $xfer += $this->pnfe->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateProject_result');
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->pnfe !== null) {
      $xfer += $output->writeFieldBegin('pnfe', TType::STRUCT, 4);
      $xfer += $this->pnfe->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 5);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getProject_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $projectId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'projectId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['projectId'])) {
        $this->projectId = $vals['projectId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getProject_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->projectId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getProject_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->projectId !== null) {
      $xfer += $output->writeFieldBegin('projectId', TType::STRING, 2);
      $xfer += $output->writeString($this->projectId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getProject_result {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Workspace\Project
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\ProjectNotFoundException
   */
  public $pnfe = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Workspace\Project',
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        4 => array(
          'var' => 'pnfe',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\ProjectNotFoundException',
          ),
        5 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['pnfe'])) {
        $this->pnfe = $vals['pnfe'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getProject_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Airavata\Model\Workspace\Project();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->pnfe = new \Airavata\API\Error\ProjectNotFoundException();
            $xfer += $this->pnfe->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getProject_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->pnfe !== null) {
      $xfer += $output->writeFieldBegin('pnfe', TType::STRUCT, 4);
      $xfer += $this->pnfe->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 5);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deleteProject_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $projectId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'projectId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['projectId'])) {
        $this->projectId = $vals['projectId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deleteProject_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->projectId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deleteProject_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->projectId !== null) {
      $xfer += $output->writeFieldBegin('projectId', TType::STRING, 2);
      $xfer += $output->writeString($this->projectId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deleteProject_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\ProjectNotFoundException
   */
  public $pnfe = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        4 => array(
          'var' => 'pnfe',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\ProjectNotFoundException',
          ),
        5 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['pnfe'])) {
        $this->pnfe = $vals['pnfe'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deleteProject_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->pnfe = new \Airavata\API\Error\ProjectNotFoundException();
            $xfer += $this->pnfe->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deleteProject_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->pnfe !== null) {
      $xfer += $output->writeFieldBegin('pnfe', TType::STRUCT, 4);
      $xfer += $this->pnfe->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 5);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getUserProjects_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $gatewayId = null;
  /**
   * @var string
   */
  public $userName = null;
  /**
   * @var int
   */
  public $limit = null;
  /**
   * @var int
   */
  public $offset = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'userName',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'limit',
          'type' => TType::I32,
          ),
        5 => array(
          'var' => 'offset',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
      if (isset($vals['userName'])) {
        $this->userName = $vals['userName'];
      }
      if (isset($vals['limit'])) {
        $this->limit = $vals['limit'];
      }
      if (isset($vals['offset'])) {
        $this->offset = $vals['offset'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getUserProjects_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->userName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->limit);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->offset);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getUserProjects_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 2);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userName !== null) {
      $xfer += $output->writeFieldBegin('userName', TType::STRING, 3);
      $xfer += $output->writeString($this->userName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->limit !== null) {
      $xfer += $output->writeFieldBegin('limit', TType::I32, 4);
      $xfer += $output->writeI32($this->limit);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->offset !== null) {
      $xfer += $output->writeFieldBegin('offset', TType::I32, 5);
      $xfer += $output->writeI32($this->offset);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getUserProjects_result {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Workspace\Project[]
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Workspace\Project',
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        4 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getUserProjects_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size53 = 0;
            $_etype56 = 0;
            $xfer += $input->readListBegin($_etype56, $_size53);
            for ($_i57 = 0; $_i57 < $_size53; ++$_i57)
            {
              $elem58 = null;
              $elem58 = new \Airavata\Model\Workspace\Project();
              $xfer += $elem58->read($input);
              $this->success []= $elem58;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getUserProjects_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter59)
          {
            $xfer += $iter59->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 4);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_searchProjects_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $gatewayId = null;
  /**
   * @var string
   */
  public $userName = null;
  /**
   * @var array
   */
  public $filters = null;
  /**
   * @var int
   */
  public $limit = null;
  /**
   * @var int
   */
  public $offset = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'userName',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'filters',
          'type' => TType::MAP,
          'ktype' => TType::I32,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::I32,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        5 => array(
          'var' => 'limit',
          'type' => TType::I32,
          ),
        6 => array(
          'var' => 'offset',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
      if (isset($vals['userName'])) {
        $this->userName = $vals['userName'];
      }
      if (isset($vals['filters'])) {
        $this->filters = $vals['filters'];
      }
      if (isset($vals['limit'])) {
        $this->limit = $vals['limit'];
      }
      if (isset($vals['offset'])) {
        $this->offset = $vals['offset'];
      }
    }
  }

  public function getName() {
    return 'Airavata_searchProjects_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->userName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::MAP) {
            $this->filters = array();
            $_size60 = 0;
            $_ktype61 = 0;
            $_vtype62 = 0;
            $xfer += $input->readMapBegin($_ktype61, $_vtype62, $_size60);
            for ($_i64 = 0; $_i64 < $_size60; ++$_i64)
            {
              $key65 = 0;
              $val66 = '';
              $xfer += $input->readI32($key65);
              $xfer += $input->readString($val66);
              $this->filters[$key65] = $val66;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->limit);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 6:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->offset);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_searchProjects_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 2);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userName !== null) {
      $xfer += $output->writeFieldBegin('userName', TType::STRING, 3);
      $xfer += $output->writeString($this->userName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->filters !== null) {
      if (!is_array($this->filters)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('filters', TType::MAP, 4);
      {
        $output->writeMapBegin(TType::I32, TType::STRING, count($this->filters));
        {
          foreach ($this->filters as $kiter67 => $viter68)
          {
            $xfer += $output->writeI32($kiter67);
            $xfer += $output->writeString($viter68);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->limit !== null) {
      $xfer += $output->writeFieldBegin('limit', TType::I32, 5);
      $xfer += $output->writeI32($this->limit);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->offset !== null) {
      $xfer += $output->writeFieldBegin('offset', TType::I32, 6);
      $xfer += $output->writeI32($this->offset);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_searchProjects_result {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Workspace\Project[]
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Workspace\Project',
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        4 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_searchProjects_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size69 = 0;
            $_etype72 = 0;
            $xfer += $input->readListBegin($_etype72, $_size69);
            for ($_i73 = 0; $_i73 < $_size69; ++$_i73)
            {
              $elem74 = null;
              $elem74 = new \Airavata\Model\Workspace\Project();
              $xfer += $elem74->read($input);
              $this->success []= $elem74;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_searchProjects_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter75)
          {
            $xfer += $iter75->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 4);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_searchExperiments_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $gatewayId = null;
  /**
   * @var string
   */
  public $userName = null;
  /**
   * @var array
   */
  public $filters = null;
  /**
   * @var int
   */
  public $limit = null;
  /**
   * @var int
   */
  public $offset = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'userName',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'filters',
          'type' => TType::MAP,
          'ktype' => TType::I32,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::I32,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        5 => array(
          'var' => 'limit',
          'type' => TType::I32,
          ),
        6 => array(
          'var' => 'offset',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
      if (isset($vals['userName'])) {
        $this->userName = $vals['userName'];
      }
      if (isset($vals['filters'])) {
        $this->filters = $vals['filters'];
      }
      if (isset($vals['limit'])) {
        $this->limit = $vals['limit'];
      }
      if (isset($vals['offset'])) {
        $this->offset = $vals['offset'];
      }
    }
  }

  public function getName() {
    return 'Airavata_searchExperiments_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->userName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::MAP) {
            $this->filters = array();
            $_size76 = 0;
            $_ktype77 = 0;
            $_vtype78 = 0;
            $xfer += $input->readMapBegin($_ktype77, $_vtype78, $_size76);
            for ($_i80 = 0; $_i80 < $_size76; ++$_i80)
            {
              $key81 = 0;
              $val82 = '';
              $xfer += $input->readI32($key81);
              $xfer += $input->readString($val82);
              $this->filters[$key81] = $val82;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->limit);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 6:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->offset);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_searchExperiments_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 2);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userName !== null) {
      $xfer += $output->writeFieldBegin('userName', TType::STRING, 3);
      $xfer += $output->writeString($this->userName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->filters !== null) {
      if (!is_array($this->filters)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('filters', TType::MAP, 4);
      {
        $output->writeMapBegin(TType::I32, TType::STRING, count($this->filters));
        {
          foreach ($this->filters as $kiter83 => $viter84)
          {
            $xfer += $output->writeI32($kiter83);
            $xfer += $output->writeString($viter84);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->limit !== null) {
      $xfer += $output->writeFieldBegin('limit', TType::I32, 5);
      $xfer += $output->writeI32($this->limit);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->offset !== null) {
      $xfer += $output->writeFieldBegin('offset', TType::I32, 6);
      $xfer += $output->writeI32($this->offset);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_searchExperiments_result {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Experiment\ExperimentSummaryModel[]
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Experiment\ExperimentSummaryModel',
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        4 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_searchExperiments_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size85 = 0;
            $_etype88 = 0;
            $xfer += $input->readListBegin($_etype88, $_size85);
            for ($_i89 = 0; $_i89 < $_size85; ++$_i89)
            {
              $elem90 = null;
              $elem90 = new \Airavata\Model\Experiment\ExperimentSummaryModel();
              $xfer += $elem90->read($input);
              $this->success []= $elem90;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_searchExperiments_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter91)
          {
            $xfer += $iter91->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 4);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getExperimentStatistics_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $gatewayId = null;
  /**
   * @var int
   */
  public $fromTime = null;
  /**
   * @var int
   */
  public $toTime = null;
  /**
   * @var string
   */
  public $userName = null;
  /**
   * @var string
   */
  public $applicationName = null;
  /**
   * @var string
   */
  public $resourceHostName = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'fromTime',
          'type' => TType::I64,
          ),
        4 => array(
          'var' => 'toTime',
          'type' => TType::I64,
          ),
        5 => array(
          'var' => 'userName',
          'type' => TType::STRING,
          ),
        6 => array(
          'var' => 'applicationName',
          'type' => TType::STRING,
          ),
        7 => array(
          'var' => 'resourceHostName',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
      if (isset($vals['fromTime'])) {
        $this->fromTime = $vals['fromTime'];
      }
      if (isset($vals['toTime'])) {
        $this->toTime = $vals['toTime'];
      }
      if (isset($vals['userName'])) {
        $this->userName = $vals['userName'];
      }
      if (isset($vals['applicationName'])) {
        $this->applicationName = $vals['applicationName'];
      }
      if (isset($vals['resourceHostName'])) {
        $this->resourceHostName = $vals['resourceHostName'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getExperimentStatistics_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->fromTime);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->toTime);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->userName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 6:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->applicationName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 7:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->resourceHostName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getExperimentStatistics_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 2);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->fromTime !== null) {
      $xfer += $output->writeFieldBegin('fromTime', TType::I64, 3);
      $xfer += $output->writeI64($this->fromTime);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->toTime !== null) {
      $xfer += $output->writeFieldBegin('toTime', TType::I64, 4);
      $xfer += $output->writeI64($this->toTime);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userName !== null) {
      $xfer += $output->writeFieldBegin('userName', TType::STRING, 5);
      $xfer += $output->writeString($this->userName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->applicationName !== null) {
      $xfer += $output->writeFieldBegin('applicationName', TType::STRING, 6);
      $xfer += $output->writeString($this->applicationName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->resourceHostName !== null) {
      $xfer += $output->writeFieldBegin('resourceHostName', TType::STRING, 7);
      $xfer += $output->writeString($this->resourceHostName);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getExperimentStatistics_result {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Experiment\ExperimentStatistics
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Experiment\ExperimentStatistics',
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        4 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getExperimentStatistics_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Airavata\Model\Experiment\ExperimentStatistics();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getExperimentStatistics_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 4);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getExperimentsInProject_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $projectId = null;
  /**
   * @var int
   */
  public $limit = null;
  /**
   * @var int
   */
  public $offset = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'projectId',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'limit',
          'type' => TType::I32,
          ),
        4 => array(
          'var' => 'offset',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['projectId'])) {
        $this->projectId = $vals['projectId'];
      }
      if (isset($vals['limit'])) {
        $this->limit = $vals['limit'];
      }
      if (isset($vals['offset'])) {
        $this->offset = $vals['offset'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getExperimentsInProject_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->projectId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->limit);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->offset);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getExperimentsInProject_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->projectId !== null) {
      $xfer += $output->writeFieldBegin('projectId', TType::STRING, 2);
      $xfer += $output->writeString($this->projectId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->limit !== null) {
      $xfer += $output->writeFieldBegin('limit', TType::I32, 3);
      $xfer += $output->writeI32($this->limit);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->offset !== null) {
      $xfer += $output->writeFieldBegin('offset', TType::I32, 4);
      $xfer += $output->writeI32($this->offset);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getExperimentsInProject_result {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Experiment\ExperimentModel[]
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\ProjectNotFoundException
   */
  public $pnfe = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Experiment\ExperimentModel',
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        4 => array(
          'var' => 'pnfe',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\ProjectNotFoundException',
          ),
        5 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['pnfe'])) {
        $this->pnfe = $vals['pnfe'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getExperimentsInProject_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size92 = 0;
            $_etype95 = 0;
            $xfer += $input->readListBegin($_etype95, $_size92);
            for ($_i96 = 0; $_i96 < $_size92; ++$_i96)
            {
              $elem97 = null;
              $elem97 = new \Airavata\Model\Experiment\ExperimentModel();
              $xfer += $elem97->read($input);
              $this->success []= $elem97;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->pnfe = new \Airavata\API\Error\ProjectNotFoundException();
            $xfer += $this->pnfe->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getExperimentsInProject_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter98)
          {
            $xfer += $iter98->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->pnfe !== null) {
      $xfer += $output->writeFieldBegin('pnfe', TType::STRUCT, 4);
      $xfer += $this->pnfe->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 5);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getUserExperiments_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $gatewayId = null;
  /**
   * @var string
   */
  public $userName = null;
  /**
   * @var int
   */
  public $limit = null;
  /**
   * @var int
   */
  public $offset = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'userName',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'limit',
          'type' => TType::I32,
          ),
        5 => array(
          'var' => 'offset',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
      if (isset($vals['userName'])) {
        $this->userName = $vals['userName'];
      }
      if (isset($vals['limit'])) {
        $this->limit = $vals['limit'];
      }
      if (isset($vals['offset'])) {
        $this->offset = $vals['offset'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getUserExperiments_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->userName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->limit);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->offset);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getUserExperiments_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 2);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userName !== null) {
      $xfer += $output->writeFieldBegin('userName', TType::STRING, 3);
      $xfer += $output->writeString($this->userName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->limit !== null) {
      $xfer += $output->writeFieldBegin('limit', TType::I32, 4);
      $xfer += $output->writeI32($this->limit);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->offset !== null) {
      $xfer += $output->writeFieldBegin('offset', TType::I32, 5);
      $xfer += $output->writeI32($this->offset);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getUserExperiments_result {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Experiment\ExperimentModel[]
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Experiment\ExperimentModel',
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        4 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getUserExperiments_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size99 = 0;
            $_etype102 = 0;
            $xfer += $input->readListBegin($_etype102, $_size99);
            for ($_i103 = 0; $_i103 < $_size99; ++$_i103)
            {
              $elem104 = null;
              $elem104 = new \Airavata\Model\Experiment\ExperimentModel();
              $xfer += $elem104->read($input);
              $this->success []= $elem104;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getUserExperiments_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter105)
          {
            $xfer += $iter105->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 4);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_createExperiment_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $gatewayId = null;
  /**
   * @var \Airavata\Model\Experiment\ExperimentModel
   */
  public $experiment = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'experiment',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Experiment\ExperimentModel',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
      if (isset($vals['experiment'])) {
        $this->experiment = $vals['experiment'];
      }
    }
  }

  public function getName() {
    return 'Airavata_createExperiment_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->experiment = new \Airavata\Model\Experiment\ExperimentModel();
            $xfer += $this->experiment->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_createExperiment_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 2);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->experiment !== null) {
      if (!is_object($this->experiment)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('experiment', TType::STRUCT, 3);
      $xfer += $this->experiment->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_createExperiment_result {
  static $_TSPEC;

  /**
   * @var string
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        4 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_createExperiment_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_createExperiment_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 4);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deleteExperiment_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $experimentId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'experimentId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['experimentId'])) {
        $this->experimentId = $vals['experimentId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deleteExperiment_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->experimentId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deleteExperiment_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->experimentId !== null) {
      $xfer += $output->writeFieldBegin('experimentId', TType::STRING, 2);
      $xfer += $output->writeString($this->experimentId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deleteExperiment_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        4 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deleteExperiment_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deleteExperiment_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 4);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getExperiment_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $airavataExperimentId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'airavataExperimentId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['airavataExperimentId'])) {
        $this->airavataExperimentId = $vals['airavataExperimentId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getExperiment_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->airavataExperimentId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getExperiment_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->airavataExperimentId !== null) {
      $xfer += $output->writeFieldBegin('airavataExperimentId', TType::STRING, 2);
      $xfer += $output->writeString($this->airavataExperimentId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getExperiment_result {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Experiment\ExperimentModel
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\ExperimentNotFoundException
   */
  public $enf = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Experiment\ExperimentModel',
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'enf',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\ExperimentNotFoundException',
          ),
        3 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        4 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        5 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['enf'])) {
        $this->enf = $vals['enf'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getExperiment_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Airavata\Model\Experiment\ExperimentModel();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->enf = new \Airavata\API\Error\ExperimentNotFoundException();
            $xfer += $this->enf->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getExperiment_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->enf !== null) {
      $xfer += $output->writeFieldBegin('enf', TType::STRUCT, 2);
      $xfer += $this->enf->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 3);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 4);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 5);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getExperimentByAdmin_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $airavataExperimentId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'airavataExperimentId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['airavataExperimentId'])) {
        $this->airavataExperimentId = $vals['airavataExperimentId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getExperimentByAdmin_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->airavataExperimentId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getExperimentByAdmin_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->airavataExperimentId !== null) {
      $xfer += $output->writeFieldBegin('airavataExperimentId', TType::STRING, 2);
      $xfer += $output->writeString($this->airavataExperimentId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getExperimentByAdmin_result {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Experiment\ExperimentModel
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\ExperimentNotFoundException
   */
  public $enf = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Experiment\ExperimentModel',
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'enf',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\ExperimentNotFoundException',
          ),
        3 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        4 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        5 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['enf'])) {
        $this->enf = $vals['enf'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getExperimentByAdmin_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Airavata\Model\Experiment\ExperimentModel();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->enf = new \Airavata\API\Error\ExperimentNotFoundException();
            $xfer += $this->enf->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getExperimentByAdmin_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->enf !== null) {
      $xfer += $output->writeFieldBegin('enf', TType::STRUCT, 2);
      $xfer += $this->enf->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 3);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 4);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 5);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getDetailedExperimentTree_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $airavataExperimentId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'airavataExperimentId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['airavataExperimentId'])) {
        $this->airavataExperimentId = $vals['airavataExperimentId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getDetailedExperimentTree_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->airavataExperimentId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getDetailedExperimentTree_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->airavataExperimentId !== null) {
      $xfer += $output->writeFieldBegin('airavataExperimentId', TType::STRING, 2);
      $xfer += $output->writeString($this->airavataExperimentId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getDetailedExperimentTree_result {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Experiment\ExperimentModel
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\ExperimentNotFoundException
   */
  public $enf = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Experiment\ExperimentModel',
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'enf',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\ExperimentNotFoundException',
          ),
        3 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        4 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        5 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['enf'])) {
        $this->enf = $vals['enf'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getDetailedExperimentTree_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Airavata\Model\Experiment\ExperimentModel();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->enf = new \Airavata\API\Error\ExperimentNotFoundException();
            $xfer += $this->enf->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getDetailedExperimentTree_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->enf !== null) {
      $xfer += $output->writeFieldBegin('enf', TType::STRUCT, 2);
      $xfer += $this->enf->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 3);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 4);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 5);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateExperiment_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $airavataExperimentId = null;
  /**
   * @var \Airavata\Model\Experiment\ExperimentModel
   */
  public $experiment = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'airavataExperimentId',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'experiment',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Experiment\ExperimentModel',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['airavataExperimentId'])) {
        $this->airavataExperimentId = $vals['airavataExperimentId'];
      }
      if (isset($vals['experiment'])) {
        $this->experiment = $vals['experiment'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateExperiment_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->airavataExperimentId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->experiment = new \Airavata\Model\Experiment\ExperimentModel();
            $xfer += $this->experiment->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateExperiment_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->airavataExperimentId !== null) {
      $xfer += $output->writeFieldBegin('airavataExperimentId', TType::STRING, 2);
      $xfer += $output->writeString($this->airavataExperimentId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->experiment !== null) {
      if (!is_object($this->experiment)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('experiment', TType::STRUCT, 3);
      $xfer += $this->experiment->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateExperiment_result {
  static $_TSPEC;

  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\ExperimentNotFoundException
   */
  public $enf = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'enf',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\ExperimentNotFoundException',
          ),
        3 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        4 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        5 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['enf'])) {
        $this->enf = $vals['enf'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateExperiment_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->enf = new \Airavata\API\Error\ExperimentNotFoundException();
            $xfer += $this->enf->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateExperiment_result');
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->enf !== null) {
      $xfer += $output->writeFieldBegin('enf', TType::STRUCT, 2);
      $xfer += $this->enf->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 3);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 4);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 5);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateExperimentConfiguration_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $airavataExperimentId = null;
  /**
   * @var \Airavata\Model\Experiment\UserConfigurationDataModel
   */
  public $userConfiguration = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'airavataExperimentId',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'userConfiguration',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Experiment\UserConfigurationDataModel',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['airavataExperimentId'])) {
        $this->airavataExperimentId = $vals['airavataExperimentId'];
      }
      if (isset($vals['userConfiguration'])) {
        $this->userConfiguration = $vals['userConfiguration'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateExperimentConfiguration_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->airavataExperimentId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->userConfiguration = new \Airavata\Model\Experiment\UserConfigurationDataModel();
            $xfer += $this->userConfiguration->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateExperimentConfiguration_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->airavataExperimentId !== null) {
      $xfer += $output->writeFieldBegin('airavataExperimentId', TType::STRING, 2);
      $xfer += $output->writeString($this->airavataExperimentId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userConfiguration !== null) {
      if (!is_object($this->userConfiguration)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('userConfiguration', TType::STRUCT, 3);
      $xfer += $this->userConfiguration->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateExperimentConfiguration_result {
  static $_TSPEC;

  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateExperimentConfiguration_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateExperimentConfiguration_result');
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 1);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateResourceScheduleing_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $airavataExperimentId = null;
  /**
   * @var \Airavata\Model\Scheduling\ComputationalResourceSchedulingModel
   */
  public $resourceScheduling = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'airavataExperimentId',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'resourceScheduling',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Scheduling\ComputationalResourceSchedulingModel',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['airavataExperimentId'])) {
        $this->airavataExperimentId = $vals['airavataExperimentId'];
      }
      if (isset($vals['resourceScheduling'])) {
        $this->resourceScheduling = $vals['resourceScheduling'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateResourceScheduleing_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->airavataExperimentId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->resourceScheduling = new \Airavata\Model\Scheduling\ComputationalResourceSchedulingModel();
            $xfer += $this->resourceScheduling->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateResourceScheduleing_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->airavataExperimentId !== null) {
      $xfer += $output->writeFieldBegin('airavataExperimentId', TType::STRING, 2);
      $xfer += $output->writeString($this->airavataExperimentId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->resourceScheduling !== null) {
      if (!is_object($this->resourceScheduling)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('resourceScheduling', TType::STRUCT, 3);
      $xfer += $this->resourceScheduling->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateResourceScheduleing_result {
  static $_TSPEC;

  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateResourceScheduleing_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateResourceScheduleing_result');
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 1);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_validateExperiment_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $airavataExperimentId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'airavataExperimentId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['airavataExperimentId'])) {
        $this->airavataExperimentId = $vals['airavataExperimentId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_validateExperiment_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->airavataExperimentId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_validateExperiment_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->airavataExperimentId !== null) {
      $xfer += $output->writeFieldBegin('airavataExperimentId', TType::STRING, 2);
      $xfer += $output->writeString($this->airavataExperimentId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_validateExperiment_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\ExperimentNotFoundException
   */
  public $enf = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'enf',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\ExperimentNotFoundException',
          ),
        3 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        4 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        5 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['enf'])) {
        $this->enf = $vals['enf'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_validateExperiment_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->enf = new \Airavata\API\Error\ExperimentNotFoundException();
            $xfer += $this->enf->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_validateExperiment_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->enf !== null) {
      $xfer += $output->writeFieldBegin('enf', TType::STRUCT, 2);
      $xfer += $this->enf->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 3);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 4);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 5);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_launchExperiment_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $airavataExperimentId = null;
  /**
   * @var string
   */
  public $gatewayId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'airavataExperimentId',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['airavataExperimentId'])) {
        $this->airavataExperimentId = $vals['airavataExperimentId'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_launchExperiment_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->airavataExperimentId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_launchExperiment_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->airavataExperimentId !== null) {
      $xfer += $output->writeFieldBegin('airavataExperimentId', TType::STRING, 2);
      $xfer += $output->writeString($this->airavataExperimentId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 3);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_launchExperiment_result {
  static $_TSPEC;

  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\ExperimentNotFoundException
   */
  public $enf = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'enf',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\ExperimentNotFoundException',
          ),
        3 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        4 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        5 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['enf'])) {
        $this->enf = $vals['enf'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_launchExperiment_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->enf = new \Airavata\API\Error\ExperimentNotFoundException();
            $xfer += $this->enf->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_launchExperiment_result');
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->enf !== null) {
      $xfer += $output->writeFieldBegin('enf', TType::STRUCT, 2);
      $xfer += $this->enf->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 3);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 4);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 5);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getExperimentStatus_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $airavataExperimentId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'airavataExperimentId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['airavataExperimentId'])) {
        $this->airavataExperimentId = $vals['airavataExperimentId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getExperimentStatus_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->airavataExperimentId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getExperimentStatus_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->airavataExperimentId !== null) {
      $xfer += $output->writeFieldBegin('airavataExperimentId', TType::STRING, 2);
      $xfer += $output->writeString($this->airavataExperimentId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getExperimentStatus_result {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Status\ExperimentStatus
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\ExperimentNotFoundException
   */
  public $enf = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Status\ExperimentStatus',
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'enf',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\ExperimentNotFoundException',
          ),
        3 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        4 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        5 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['enf'])) {
        $this->enf = $vals['enf'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getExperimentStatus_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Airavata\Model\Status\ExperimentStatus();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->enf = new \Airavata\API\Error\ExperimentNotFoundException();
            $xfer += $this->enf->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getExperimentStatus_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->enf !== null) {
      $xfer += $output->writeFieldBegin('enf', TType::STRUCT, 2);
      $xfer += $this->enf->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 3);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 4);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 5);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getExperimentOutputs_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $airavataExperimentId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'airavataExperimentId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['airavataExperimentId'])) {
        $this->airavataExperimentId = $vals['airavataExperimentId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getExperimentOutputs_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->airavataExperimentId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getExperimentOutputs_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->airavataExperimentId !== null) {
      $xfer += $output->writeFieldBegin('airavataExperimentId', TType::STRING, 2);
      $xfer += $output->writeString($this->airavataExperimentId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getExperimentOutputs_result {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Application\Io\OutputDataObjectType[]
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\ExperimentNotFoundException
   */
  public $enf = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Application\Io\OutputDataObjectType',
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'enf',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\ExperimentNotFoundException',
          ),
        3 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        4 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        5 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['enf'])) {
        $this->enf = $vals['enf'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getExperimentOutputs_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size106 = 0;
            $_etype109 = 0;
            $xfer += $input->readListBegin($_etype109, $_size106);
            for ($_i110 = 0; $_i110 < $_size106; ++$_i110)
            {
              $elem111 = null;
              $elem111 = new \Airavata\Model\Application\Io\OutputDataObjectType();
              $xfer += $elem111->read($input);
              $this->success []= $elem111;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->enf = new \Airavata\API\Error\ExperimentNotFoundException();
            $xfer += $this->enf->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getExperimentOutputs_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter112)
          {
            $xfer += $iter112->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->enf !== null) {
      $xfer += $output->writeFieldBegin('enf', TType::STRUCT, 2);
      $xfer += $this->enf->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 3);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 4);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 5);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getIntermediateOutputs_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $airavataExperimentId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'airavataExperimentId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['airavataExperimentId'])) {
        $this->airavataExperimentId = $vals['airavataExperimentId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getIntermediateOutputs_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->airavataExperimentId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getIntermediateOutputs_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->airavataExperimentId !== null) {
      $xfer += $output->writeFieldBegin('airavataExperimentId', TType::STRING, 2);
      $xfer += $output->writeString($this->airavataExperimentId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getIntermediateOutputs_result {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Application\Io\OutputDataObjectType[]
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\ExperimentNotFoundException
   */
  public $enf = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Application\Io\OutputDataObjectType',
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'enf',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\ExperimentNotFoundException',
          ),
        3 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        4 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        5 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['enf'])) {
        $this->enf = $vals['enf'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getIntermediateOutputs_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size113 = 0;
            $_etype116 = 0;
            $xfer += $input->readListBegin($_etype116, $_size113);
            for ($_i117 = 0; $_i117 < $_size113; ++$_i117)
            {
              $elem118 = null;
              $elem118 = new \Airavata\Model\Application\Io\OutputDataObjectType();
              $xfer += $elem118->read($input);
              $this->success []= $elem118;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->enf = new \Airavata\API\Error\ExperimentNotFoundException();
            $xfer += $this->enf->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getIntermediateOutputs_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter119)
          {
            $xfer += $iter119->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->enf !== null) {
      $xfer += $output->writeFieldBegin('enf', TType::STRUCT, 2);
      $xfer += $this->enf->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 3);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 4);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 5);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getJobStatuses_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $airavataExperimentId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'airavataExperimentId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['airavataExperimentId'])) {
        $this->airavataExperimentId = $vals['airavataExperimentId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getJobStatuses_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->airavataExperimentId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getJobStatuses_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->airavataExperimentId !== null) {
      $xfer += $output->writeFieldBegin('airavataExperimentId', TType::STRING, 2);
      $xfer += $output->writeString($this->airavataExperimentId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getJobStatuses_result {
  static $_TSPEC;

  /**
   * @var array
   */
  public $success = null;
  /**
   * @var \Airavata\API\Error\InvalidRequestException
   */
  public $ire = null;
  /**
   * @var \Airavata\API\Error\ExperimentNotFoundException
   */
  public $enf = null;
  /**
   * @var \Airavata\API\Error\AiravataClientException
   */
  public $ace = null;
  /**
   * @var \Airavata\API\Error\AiravataSystemException
   */
  public $ase = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRUCT,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Status\JobStatus',
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'enf',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\ExperimentNotFoundException',
          ),
        3 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        4 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        5 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['enf'])) {
        $this->enf = $vals['enf'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getJobStatuses_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::MAP) {
            $this->success = array();
            $_size120 = 0;
            $_ktype121 = 0;
            $_vtype122 = 0;
            $xfer += $input->readMapBegin($_ktype121, $_vtype122, $_size120);
            for ($_i124 = 0; $_i124 < $_size120; ++$_i124)
            {
              $key125 = '';
              $val126 = new \Airavata\Model\Status\JobStatus();
              $xfer += $input->readString($key125);
              $val126 = new \Airavata\Model\Status\JobStatus();
              $xfer += $val126->read($input);
              $this->success[$key125] = $val126;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->enf = new \Airavata\API\Error\ExperimentNotFoundException();
            $xfer += $this->enf->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getJobStatuses_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::MAP, 0);
      {
        $output->writeMapBegin(TType::STRING, TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $kiter127 => $viter128)
          {
            $xfer += $output->writeString($kiter127);
            $xfer += $viter128->write($output);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->enf !== null) {
      $xfer += $output->writeFieldBegin('enf', TType::STRUCT, 2);
      $xfer += $this->enf->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 3);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 4);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 5);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getJobDetails_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $airavataExperimentId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'airavataExperimentId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['airavataExperimentId'])) {
        $this->airavataExperimentId = $vals['airavataExperimentId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getJobDetails_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->airavataExperimentId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getJobDetails_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException: