/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Autogenerated by Thrift Compiler (0.9.1)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
#ifndef computeResourceModel_TYPES_H
#define computeResourceModel_TYPES_H

#include <thrift/Thrift.h>
#include <thrift/TApplicationException.h>
#include <thrift/protocol/TProtocol.h>
#include <thrift/transport/TTransport.h>

#include <thrift/cxxfunctional.h>


namespace apache { namespace airavata { namespace model { namespace appcatalog { namespace computeresource {

struct ResourceJobManagerType {
  enum type {
    FORK = 0,
    PBS = 1,
    SLURM = 2,
    LSF = 3,
    UGE = 4
  };
};

extern const std::map<int, const char*> _ResourceJobManagerType_VALUES_TO_NAMES;

struct JobManagerCommand {
  enum type {
    SUBMISSION = 0,
    JOB_MONITORING = 1,
    DELETION = 2,
    CHECK_JOB = 3,
    SHOW_QUEUE = 4,
    SHOW_RESERVATION = 5,
    SHOW_START = 6
  };
};

extern const std::map<int, const char*> _JobManagerCommand_VALUES_TO_NAMES;

struct FileSystems {
  enum type {
    HOME = 0,
    WORK = 1,
    LOCALTMP = 2,
    SCRATCH = 3,
    ARCHIVE = 4
  };
};

extern const std::map<int, const char*> _FileSystems_VALUES_TO_NAMES;

struct SecurityProtocol {
  enum type {
    USERNAME_PASSWORD = 0,
    SSH_KEYS = 1,
    GSI = 2,
    KERBEROS = 3,
    OAUTH = 4
  };
};

extern const std::map<int, const char*> _SecurityProtocol_VALUES_TO_NAMES;

struct JobSubmissionProtocol {
  enum type {
    LOCAL = 0,
    SSH = 1,
    GLOBUS = 2,
    UNICORE = 3,
    CLOUD = 4
  };
};

extern const std::map<int, const char*> _JobSubmissionProtocol_VALUES_TO_NAMES;

struct MonitorMode {
  enum type {
    POLL_JOB_MANAGER = 0,
    JOB_EMAIL_NOTIFICATION_MONITOR = 1,
    XSEDE_AMQP_SUBSCRIBE = 2
  };
};

extern const std::map<int, const char*> _MonitorMode_VALUES_TO_NAMES;

struct DataMovementProtocol {
  enum type {
    LOCAL = 0,
    SCP = 1,
    SFTP = 2,
    GridFTP = 3,
    UNICORE_STORAGE_SERVICE = 4
  };
};

extern const std::map<int, const char*> _DataMovementProtocol_VALUES_TO_NAMES;

struct ProviderName {
  enum type {
    EC2 = 0,
    AWSEC2 = 1,
    RACKSPACE = 2
  };
};

extern const std::map<int, const char*> _ProviderName_VALUES_TO_NAMES;

typedef struct _ResourceJobManager__isset {
  _ResourceJobManager__isset() : pushMonitoringEndpoint(false), jobManagerBinPath(false), jobManagerCommands(false) {}
  bool pushMonitoringEndpoint;
  bool jobManagerBinPath;
  bool jobManagerCommands;
} _ResourceJobManager__isset;

class ResourceJobManager {
 public:

  static const char* ascii_fingerprint; // = "F61CAF80247D0E44C8D52504F3A43BED";
  static const uint8_t binary_fingerprint[16]; // = {0xF6,0x1C,0xAF,0x80,0x24,0x7D,0x0E,0x44,0xC8,0xD5,0x25,0x04,0xF3,0xA4,0x3B,0xED};

  ResourceJobManager() : resourceJobManagerId("DO_NOT_SET_AT_CLIENTS"), resourceJobManagerType((ResourceJobManagerType::type)0), pushMonitoringEndpoint(), jobManagerBinPath() {
  }

  virtual ~ResourceJobManager() throw() {}

  std::string resourceJobManagerId;
  ResourceJobManagerType::type resourceJobManagerType;
  std::string pushMonitoringEndpoint;
  std::string jobManagerBinPath;
  std::map<JobManagerCommand::type, std::string>  jobManagerCommands;

  _ResourceJobManager__isset __isset;

  void __set_resourceJobManagerId(const std::string& val) {
    resourceJobManagerId = val;
  }

  void __set_resourceJobManagerType(const ResourceJobManagerType::type val) {
    resourceJobManagerType = val;
  }

  void __set_pushMonitoringEndpoint(const std::string& val) {
    pushMonitoringEndpoint = val;
    __isset.pushMonitoringEndpoint = true;
  }

  void __set_jobManagerBinPath(const std::string& val) {
    jobManagerBinPath = val;
    __isset.jobManagerBinPath = true;
  }

  void __set_jobManagerCommands(const std::map<JobManagerCommand::type, std::string> & val) {
    jobManagerCommands = val;
    __isset.jobManagerCommands = true;
  }

  bool operator == (const ResourceJobManager & rhs) const
  {
    if (!(resourceJobManagerId == rhs.resourceJobManagerId))
      return false;
    if (!(resourceJobManagerType == rhs.resourceJobManagerType))
      return false;
    if (__isset.pushMonitoringEndpoint != rhs.__isset.pushMonitoringEndpoint)
      return false;
    else if (__isset.pushMonitoringEndpoint && !(pushMonitoringEndpoint == rhs.pushMonitoringEndpoint))
      return false;
    if (__isset.jobManagerBinPath != rhs.__isset.jobManagerBinPath)
      return false;
    else if (__isset.jobManagerBinPath && !(jobManagerBinPath == rhs.jobManagerBinPath))
      return false;
    if (__isset.jobManagerCommands != rhs.__isset.jobManagerCommands)
      return false;
    else if (__isset.jobManagerCommands && !(jobManagerCommands == rhs.jobManagerCommands))
      return false;
    return true;
  }
  bool operator != (const ResourceJobManager &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const ResourceJobManager & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

void swap(ResourceJobManager &a, ResourceJobManager &b);

typedef struct _BatchQueue__isset {
  _BatchQueue__isset() : queueDescription(false), maxRunTime(false), maxNodes(false), maxProcessors(false), maxJobsInQueue(false), maxMemory(false) {}
  bool queueDescription;
  bool maxRunTime;
  bool maxNodes;
  bool maxProcessors;
  bool maxJobsInQueue;
  bool maxMemory;
} _BatchQueue__isset;

class BatchQueue {
 public:

  static const char* ascii_fingerprint; // = "ED0A78585E8BA402743AC1D5D510EF9E";
  static const uint8_t binary_fingerprint[16]; // = {0xED,0x0A,0x78,0x58,0x5E,0x8B,0xA4,0x02,0x74,0x3A,0xC1,0xD5,0xD5,0x10,0xEF,0x9E};

  BatchQueue() : queueName(), queueDescription(), maxRunTime(0), maxNodes(0), maxProcessors(0), maxJobsInQueue(0), maxMemory(0) {
  }

  virtual ~BatchQueue() throw() {}

  std::string queueName;
  std::string queueDescription;
  int32_t maxRunTime;
  int32_t maxNodes;
  int32_t maxProcessors;
  int32_t maxJobsInQueue;
  int32_t maxMemory;

  _BatchQueue__isset __isset;

  void __set_queueName(const std::string& val) {
    queueName = val;
  }

  void __set_queueDescription(const std::string& val) {
    queueDescription = val;
    __isset.queueDescription = true;
  }

  void __set_maxRunTime(const int32_t val) {
    maxRunTime = val;
    __isset.maxRunTime = true;
  }

  void __set_maxNodes(const int32_t val) {
    maxNodes = val;
    __isset.maxNodes = true;
  }

  void __set_maxProcessors(const int32_t val) {
    maxProcessors = val;
    __isset.maxProcessors = true;
  }

  void __set_maxJobsInQueue(const int32_t val) {
    maxJobsInQueue = val;
    __isset.maxJobsInQueue = true;
  }

  void __set_maxMemory(const int32_t val) {
    maxMemory = val;
    __isset.maxMemory = true;
  }

  bool operator == (const BatchQueue & rhs) const
  {
    if (!(queueName == rhs.queueName))
      return false;
    if (__isset.queueDescription != rhs.__isset.queueDescription)
      return false;
    else if (__isset.queueDescription && !(queueDescription == rhs.queueDescription))
      return false;
    if (__isset.maxRunTime != rhs.__isset.maxRunTime)
      return false;
    else if (__isset.maxRunTime && !(maxRunTime == rhs.maxRunTime))
      return false;
    if (__isset.maxNodes != rhs.__isset.maxNodes)
      return false;
    else if (__isset.maxNodes && !(maxNodes == rhs.maxNodes))
      return false;
    if (__isset.maxProcessors != rhs.__isset.maxProcessors)
      return false;
    else if (__isset.maxProcessors && !(maxProcessors == rhs.maxProcessors))
      return false;
    if (__isset.maxJobsInQueue != rhs.__isset.maxJobsInQueue)
      return false;
    else if (__isset.maxJobsInQueue && !(maxJobsInQueue == rhs.maxJobsInQueue))
      return false;
    if (__isset.maxMemory != rhs.__isset.maxMemory)
      return false;
    else if (__isset.maxMemory && !(maxMemory == rhs.maxMemory))
      return false;
    return true;
  }
  bool operator != (const BatchQueue &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const BatchQueue & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

void swap(BatchQueue &a, BatchQueue &b);

typedef struct _SCPDataMovement__isset {
  _SCPDataMovement__isset() : alternativeSCPHostName(false), sshPort(true) {}
  bool alternativeSCPHostName;
  bool sshPort;
} _SCPDataMovement__isset;

class SCPDataMovement {
 public:

  static const char* ascii_fingerprint; // = "63CAE6EE336A7DBD91CCCD6E22628F4A";
  static const uint8_t binary_fingerprint[16]; // = {0x63,0xCA,0xE6,0xEE,0x33,0x6A,0x7D,0xBD,0x91,0xCC,0xCD,0x6E,0x22,0x62,0x8F,0x4A};

  SCPDataMovement() : dataMovementInterfaceId("DO_NOT_SET_AT_CLIENTS"), securityProtocol((SecurityProtocol::type)0), alternativeSCPHostName(), sshPort(22) {
  }

  virtual ~SCPDataMovement() throw() {}

  std::string dataMovementInterfaceId;
  SecurityProtocol::type securityProtocol;
  std::string alternativeSCPHostName;
  int32_t sshPort;

  _SCPDataMovement__isset __isset;

  void __set_dataMovementInterfaceId(const std::string& val) {
    dataMovementInterfaceId = val;
  }

  void __set_securityProtocol(const SecurityProtocol::type val) {
    securityProtocol = val;
  }

  void __set_alternativeSCPHostName(const std::string& val) {
    alternativeSCPHostName = val;
    __isset.alternativeSCPHostName = true;
  }

  void __set_sshPort(const int32_t val) {
    sshPort = val;
    __isset.sshPort = true;
  }

  bool operator == (const SCPDataMovement & rhs) const
  {
    if (!(dataMovementInterfaceId == rhs.dataMovementInterfaceId))
      return false;
    if (!(securityProtocol == rhs.securityProtocol))
      return false;
    if (__isset.alternativeSCPHostName != rhs.__isset.alternativeSCPHostName)
      return false;
    else if (__isset.alternativeSCPHostName && !(alternativeSCPHostName == rhs.alternativeSCPHostName))
      return false;
    if (__isset.sshPort != rhs.__isset.sshPort)
      return false;
    else if (__isset.sshPort && !(sshPort == rhs.sshPort))
      return false;
    return true;
  }
  bool operator != (const SCPDataMovement &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const SCPDataMovement & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

void swap(SCPDataMovement &a, SCPDataMovement &b);


class GridFTPDataMovement {
 public:

  static const char* ascii_fingerprint; // = "790EE8B1D56A3B9B76C41DD063726E75";
  static const uint8_t binary_fingerprint[16]; // = {0x79,0x0E,0xE8,0xB1,0xD5,0x6A,0x3B,0x9B,0x76,0xC4,0x1D,0xD0,0x63,0x72,0x6E,0x75};

  GridFTPDataMovement() : dataMovementInterfaceId("DO_NOT_SET_AT_CLIENTS"), securityProtocol((SecurityProtocol::type)0) {
  }

  virtual ~GridFTPDataMovement() throw() {}

  std::string dataMovementInterfaceId;
  SecurityProtocol::type securityProtocol;
  std::vector<std::string>  gridFTPEndPoints;

  void __set_dataMovementInterfaceId(const std::string& val) {
    dataMovementInterfaceId = val;
  }

  void __set_securityProtocol(const SecurityProtocol::type val) {
    securityProtocol = val;
  }

  void __set_gridFTPEndPoints(const std::vector<std::string> & val) {
    gridFTPEndPoints = val;
  }

  bool operator == (const GridFTPDataMovement & rhs) const
  {
    if (!(dataMovementInterfaceId == rhs.dataMovementInterfaceId))
      return false;
    if (!(securityProtocol == rhs.securityProtocol))
      return false;
    if (!(gridFTPEndPoints == rhs.gridFTPEndPoints))
      return false;
    return true;
  }
  bool operator != (const GridFTPDataMovement &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const GridFTPDataMovement & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

void swap(GridFTPDataMovement &a, GridFTPDataMovement &b);


class UnicoreDataMovement {
 public:

  static const char* ascii_fingerprint; // = "D9F4CFE2F293A8B1052FD3031DD2C847";
  static const uint8_t binary_fingerprint[16]; // = {0xD9,0xF4,0xCF,0xE2,0xF2,0x93,0xA8,0xB1,0x05,0x2F,0xD3,0x03,0x1D,0xD2,0xC8,0x47};

  UnicoreDataMovement() : dataMovementInterfaceId("DO_NOT_SET_AT_CLIENTS"), securityProtocol((SecurityProtocol::type)0), unicoreEndPointURL() {
  }

  virtual ~UnicoreDataMovement() throw() {}

  std::string dataMovementInterfaceId;
  SecurityProtocol::type securityProtocol;
  std::string unicoreEndPointURL;

  void __set_dataMovementInterfaceId(const std::string& val) {
    dataMovementInterfaceId = val;
  }

  void __set_securityProtocol(const SecurityProtocol::type val) {
    securityProtocol = val;
  }

  void __set_unicoreEndPointURL(const std::string& val) {
    unicoreEndPointURL = val;
  }

  bool operator == (const UnicoreDataMovement & rhs) const
  {
    if (!(dataMovementInterfaceId == rhs.dataMovementInterfaceId))
      return false;
    if (!(securityProtocol == rhs.securityProtocol))
      return false;
    if (!(unicoreEndPointURL == rhs.unicoreEndPointURL))
      return false;
    return true;
  }
  bool operator != (const UnicoreDataMovement &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const UnicoreDataMovement & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

void swap(UnicoreDataMovement &a, UnicoreDataMovement &b);


class LOCALSubmission {
 public:

  static const char* ascii_fingerprint; // = "A5A35C842CBE1CA9D6A13C5974C6FB8F";
  static const uint8_t binary_fingerprint[16]; // = {0xA5,0xA3,0x5C,0x84,0x2C,0xBE,0x1C,0xA9,0xD6,0xA1,0x3C,0x59,0x74,0xC6,0xFB,0x8F};

  LOCALSubmission() : jobSubmissionInterfaceId("DO_NOT_SET_AT_CLIENTS") {
  }

  virtual ~LOCALSubmission() throw() {}

  std::string jobSubmissionInterfaceId;
  ResourceJobManager resourceJobManager;

  void __set_jobSubmissionInterfaceId(const std::string& val) {
    jobSubmissionInterfaceId = val;
  }

  void __set_resourceJobManager(const ResourceJobManager& val) {
    resourceJobManager = val;
  }

  bool operator == (const LOCALSubmission & rhs) const
  {
    if (!(jobSubmissionInterfaceId == rhs.jobSubmissionInterfaceId))
      return false;
    if (!(resourceJobManager == rhs.resourceJobManager))
      return false;
    return true;
  }
  bool operator != (const LOCALSubmission &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const LOCALSubmission & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

void swap(LOCALSubmission &a, LOCALSubmission &b);


class LOCALDataMovement {
 public:

  static const char* ascii_fingerprint; // = "EFB929595D312AC8F305D5A794CFEDA1";
  static const uint8_t binary_fingerprint[16]; // = {0xEF,0xB9,0x29,0x59,0x5D,0x31,0x2A,0xC8,0xF3,0x05,0xD5,0xA7,0x94,0xCF,0xED,0xA1};

  LOCALDataMovement() : dataMovementInterfaceId("DO_NOT_SET_AT_CLIENTS") {
  }

  virtual ~LOCALDataMovement() throw() {}

  std::string dataMovementInterfaceId;

  void __set_dataMovementInterfaceId(const std::string& val) {
    dataMovementInterfaceId = val;
  }

  bool operator == (const LOCALDataMovement & rhs) const
  {
    if (!(dataMovementInterfaceId == rhs.dataMovementInterfaceId))
      return false;
    return true;
  }
  bool operator != (const LOCALDataMovement &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const LOCALDataMovement & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

void swap(LOCALDataMovement &a, LOCALDataMovement &b);

typedef struct _SSHJobSubmission__isset {
  _SSHJobSubmission__isset() : alternativeSSHHostName(false), sshPort(true), monitorMode(false) {}
  bool alternativeSSHHostName;
  bool sshPort;
  bool monitorMode;
} _SSHJobSubmission__isset;

class SSHJobSubmission {
 public:

  static const char* ascii_fingerprint; // = "A62183DAA7AFF027173705420A9D99D0";
  static const uint8_t binary_fingerprint[16]; // = {0xA6,0x21,0x83,0xDA,0xA7,0xAF,0xF0,0x27,0x17,0x37,0x05,0x42,0x0A,0x9D,0x99,0xD0};

  SSHJobSubmission() : jobSubmissionInterfaceId("DO_NOT_SET_AT_CLIENTS"), securityProtocol((SecurityProtocol::type)0), alternativeSSHHostName(), sshPort(22), monitorMode((MonitorMode::type)0) {
  }

  virtual ~SSHJobSubmission() throw() {}

  std::string jobSubmissionInterfaceId;
  SecurityProtocol::type securityProtocol;
  ResourceJobManager resourceJobManager;
  std::string alternativeSSHHostName;
  int32_t sshPort;
  MonitorMode::type monitorMode;

  _SSHJobSubmission__isset __isset;

  void __set_jobSubmissionInterfaceId(const std::string& val) {
    jobSubmissionInterfaceId = val;
  }

  void __set_securityProtocol(const SecurityProtocol::type val) {
    securityProtocol = val;
  }

  void __set_resourceJobManager(const ResourceJobManager& val) {
    resourceJobManager = val;
  }

  void __set_alternativeSSHHostName(const std::string& val) {
    alternativeSSHHostName = val;
    __isset.alternativeSSHHostName = true;
  }

  void __set_sshPort(const int32_t val) {
    sshPort = val;
    __isset.sshPort = true;
  }

  void __set_monitorMode(const MonitorMode::type val) {
    monitorMode = val;
    __isset.monitorMode = true;
  }

  bool operator == (const SSHJobSubmission & rhs) const
  {
    if (!(jobSubmissionInterfaceId == rhs.jobSubmissionInterfaceId))
      return false;
    if (!(securityProtocol == rhs.securityProtocol))
      return false;
    if (!(resourceJobManager == rhs.resourceJobManager))
      return false;
    if (__isset.alternativeSSHHostName != rhs.__isset.alternativeSSHHostName)
      return false;
    else if (__isset.alternativeSSHHostName && !(alternativeSSHHostName == rhs.alternativeSSHHostName))
      return false;
    if (__isset.sshPort != rhs.__isset.sshPort)
      return false;
    else if (__isset.sshPort && !(sshPort == rhs.sshPort))
      return false;
    if (__isset.monitorMode != rhs.__isset.monitorMode)
      return false;
    else if (__isset.monitorMode && !(monitorMode == rhs.monitorMode))
      return false;
    return true;
  }
  bool operator != (const SSHJobSubmission &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const SSHJobSubmission & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

void swap(SSHJobSubmission &a, SSHJobSubmission &b);

typedef struct _GlobusJobSubmission__isset {
  _GlobusJobSubmission__isset() : globusGateKeeperEndPoint(false) {}
  bool globusGateKeeperEndPoint;
} _GlobusJobSubmission__isset;

class GlobusJobSubmission {
 public:

  static const char* ascii_fingerprint; // = "AF422FFD77BB68BA57079B8B33BC8CF7";
  static const uint8_t binary_fingerprint[16]; // = {0xAF,0x42,0x2F,0xFD,0x77,0xBB,0x68,0xBA,0x57,0x07,0x9B,0x8B,0x33,0xBC,0x8C,0xF7};

  GlobusJobSubmission() : jobSubmissionInterfaceId("DO_NOT_SET_AT_CLIENTS"), securityProtocol((SecurityProtocol::type)0) {
  }

  virtual ~GlobusJobSubmission() throw() {}

  std::string jobSubmissionInterfaceId;
  SecurityProtocol::type securityProtocol;
  std::vector<std::string>  globusGateKeeperEndPoint;

  _GlobusJobSubmission__isset __isset;

  void __set_jobSubmissionInterfaceId(const std::string& val) {
    jobSubmissionInterfaceId = val;
  }

  void __set_securityProtocol(const SecurityProtocol::type val) {
    securityProtocol = val;
  }

  void __set_globusGateKeeperEndPoint(const std::vector<std::string> & val) {
    globusGateKeeperEndPoint = val;
    __isset.globusGateKeeperEndPoint = true;
  }

  bool operator == (const GlobusJobSubmission & rhs) const
  {
    if (!(jobSubmissionInterfaceId == rhs.jobSubmissionInterfaceId))
      return false;
    if (!(securityProtocol == rhs.securityProtocol))
      return false;
    if (__isset.globusGateKeeperEndPoint != rhs.__isset.globusGateKeeperEndPoint)
      return false;
    else if (__isset.globusGateKeeperEndPoint && !(globusGateKeeperEndPoint == rhs.globusGateKeeperEndPoint))
      return false;
    return true;
  }
  bool operator != (const GlobusJobSubmission &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const GlobusJobSubmission & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

void swap(GlobusJobSubmission &a, GlobusJobSubmission &b);


class UnicoreJobSubmission {
 public:

  static const char* ascii_fingerprint; // = "D9F4CFE2F293A8B1052FD3031DD2C847";
  static const uint8_t binary_fingerprint[16]; // = {0xD9,0xF4,0xCF,0xE2,0xF2,0x93,0xA8,0xB1,0x05,0x2F,0xD3,0x03,0x1D,0xD2,0xC8,0x47};

  UnicoreJobSubmission() : jobSubmissionInterfaceId("DO_NOT_SET_AT_CLIENTS"), securityProtocol((SecurityProtocol::type)0), unicoreEndPointURL() {
  }

  virtual ~UnicoreJobSubmission() throw() {}

  std::string jobSubmissionInterfaceId;
  SecurityProtocol::type securityProtocol;
  std::string unicoreEndPointURL;

  void __set_jobSubmissionInterfaceId(const std::string& val) {
    jobSubmissionInterfaceId = val;
  }

  void __set_securityProtocol(const SecurityProtocol::type val) {
    securityProtocol = val;
  }

  void __set_unicoreEndPointURL(const std::string& val) {
    unicoreEndPointURL = val;
  }

  bool operator == (const UnicoreJobSubmission & rhs) const
  {
    if (!(jobSubmissionInterfaceId == rhs.jobSubmissionInterfaceId))
      return false;
    if (!(securityProtocol == rhs.securityProtocol))
      return false;
    if (!(unicoreEndPointURL == rhs.unicoreEndPointURL))
      return false;
    return true;
  }
  bool operator != (const UnicoreJobSubmission &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const UnicoreJobSubmission & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

void swap(UnicoreJobSubmission &a, UnicoreJobSubmission &b);


class CloudJobSubmission {
 public:

  static const char* ascii_fingerprint; // = "F98AE2E6E51F2426504F2566EB71B5CC";
  static const uint8_t binary_fingerprint[16]; // = {0xF9,0x8A,0xE2,0xE6,0xE5,0x1F,0x24,0x26,0x50,0x4F,0x25,0x66,0xEB,0x71,0xB5,0xCC};

  CloudJobSubmission() : jobSubmissionInterfaceId("DO_NOT_SET_AT_CLIENTS"), securityProtocol((SecurityProtocol::type)0), nodeId(), executableType(), providerName((ProviderName::type)0), userAccountName() {
  }

  virtual ~CloudJobSubmission() throw() {}

  std::string jobSubmissionInterfaceId;
  SecurityProtocol::type securityProtocol;
  std::string nodeId;
  std::string executableType;
  ProviderName::type providerName;
  std::string userAccountName;

  void __set_jobSubmissionInterfaceId(const std::string& val) {
    jobSubmissionInterfaceId = val;
  }

  void __set_securityProtocol(const SecurityProtocol::type val) {
    securityProtocol = val;
  }

  void __set_nodeId(const std::string& val) {
    nodeId = val;
  }

  void __set_executableType(const std::string& val) {
    executableType = val;
  }

  void __set_providerName(const ProviderName::type val) {
    providerName = val;
  }

  void __set_userAccountName(const std::string& val) {
    userAccountName = val;
  }

  bool operator == (const CloudJobSubmission & rhs) const
  {
    if (!(jobSubmissionInterfaceId == rhs.jobSubmissionInterfaceId))
      return false;
    if (!(securityProtocol == rhs.securityProtocol))
      return false;
    if (!(nodeId == rhs.nodeId))
      return false;
    if (!(executableType == rhs.executableType))
      return false;
    if (!(providerName == rhs.providerName))
      return false;
    if (!(userAccountName == rhs.userAccountName))
      return false;
    return true;
  }
  bool operator != (const CloudJobSubmission &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const CloudJobSubmission & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

void swap(CloudJobSubmission &a, CloudJobSubmission &b);


class JobSubmissionInterface {
 public:

  static const char* ascii_fingerprint; // = "A0A4DD7B8243FB842E64EAC6E5DA6C7B";
  static const uint8_t binary_fingerprint[16]; // = {0xA0,0xA4,0xDD,0x7B,0x82,0x43,0xFB,0x84,0x2E,0x64,0xEA,0xC6,0xE5,0xDA,0x6C,0x7B};

  JobSubmissionInterface() : jobSubmissionInterfaceId(), jobSubmissionProtocol((JobSubmissionProtocol::type)0), priorityOrder(0) {
  }

  virtual ~JobSubmissionInterface() throw() {}

  std::string jobSubmissionInterfaceId;
  JobSubmissionProtocol::type jobSubmissionProtocol;
  int32_t priorityOrder;

  void __set_jobSubmissionInterfaceId(const std::string& val) {
    jobSubmissionInterfaceId = val;
  }

  void __set_jobSubmissionProtocol(const JobSubmissionProtocol::type val) {
    jobSubmissionProtocol = val;
  }

  void __set_priorityOrder(const int32_t val) {
    priorityOrder = val;
  }

  bool operator == (const JobSubmissionInterface & rhs) const
  {
    if (!(jobSubmissionInterfaceId == rhs.jobSubmissionInterfaceId))
      return false;
    if (!(jobSubmissionProtocol == rhs.jobSubmissionProtocol))
      return false;
    if (!(priorityOrder == rhs.priorityOrder))
      return false;
    return true;
  }
  bool operator != (const JobSubmissionInterface &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const JobSubmissionInterface & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

void swap(JobSubmissionInterface &a, JobSubmissionInterface &b);


class DataMovementInterface {
 public:

  static const char* ascii_fingerprint; // = "A0A4DD7B8243FB842E64EAC6E5DA6C7B";
  static const uint8_t binary_fingerprint[16]; // = {0xA0,0xA4,0xDD,0x7B,0x82,0x43,0xFB,0x84,0x2E,0x64,0xEA,0xC6,0xE5,0xDA,0x6C,0x7B};

  DataMovementInterface() : dataMovementInterfaceId(), dataMovementProtocol((DataMovementProtocol::type)0), priorityOrder(0) {
  }

  virtual ~DataMovementInterface() throw() {}

  std::string dataMovementInterfaceId;
  DataMovementProtocol::type dataMovementProtocol;
  int32_t priorityOrder;

  void __set_dataMovementInterfaceId(const std::string& val) {
    dataMovementInterfaceId = val;
  }

  void __set_dataMovementProtocol(const DataMovementProtocol::type val) {
    dataMovementProtocol = val;
  }

  void __set_priorityOrder(const int32_t val) {
    priorityOrder = val;
  }

  bool operator == (const DataMovementInterface & rhs) const
  {
    if (!(dataMovementInterfaceId == rhs.dataMovementInterfaceId))
      return false;
    if (!(dataMovementProtocol == rhs.dataMovementProtocol))
      return false;
    if (!(priorityOrder == rhs.priorityOrder))
      return false;
    return true;
  }
  bool operator != (const DataMovementInterface &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const DataMovementInterface & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

void swap(DataMovementInterface &a, DataMovementInterface &b);

typedef struct _ComputeResourceDescription__isset {
  _ComputeResourceDescription__isset() : hostAliases(false), ipAddresses(false), resourceDescription(false), batchQueues(false), fileSystems(false), jobSubmissionInterfaces(false), dataMovementInterfaces(false), maxMemoryPerNode(false) {}
  bool hostAliases;
  bool ipAddresses;
  bool resourceDescription;
  bool batchQueues;
  bool fileSystems;
  bool jobSubmissionInterfaces;
  bool dataMovementInterfaces;
  bool maxMemoryPerNode;
} _ComputeResourceDescription__isset;

class ComputeResourceDescription {
 public:

  static const char* ascii_fingerprint; // = "3CD4212965217787DCD6081F1744069F";
  static const uint8_t binary_fingerprint[16]; // = {0x3C,0xD4,0x21,0x29,0x65,0x21,0x77,0x87,0xDC,0xD6,0x08,0x1F,0x17,0x44,0x06,0x9F};

  ComputeResourceDescription() : computeResourceId("DO_NOT_SET_AT_CLIENTS"), hostName(), resourceDescription(), maxMemoryPerNode(0) {
  }

  virtual ~ComputeResourceDescription() throw() {}

  std::string computeResourceId;
  std::string hostName;
  std::vector<std::string>  hostAliases;
  std::vector<std::string>  ipAddresses;
  std::string resourceDescription;
  std::vector<BatchQueue>  batchQueues;
  std::map<FileSystems::type, std::string>  fileSystems;
  std::vector<JobSubmissionInterface>  jobSubmissionInterfaces;
  std::vector<DataMovementInterface>  dataMovementInterfaces;
  int32_t maxMemoryPerNode;

  _ComputeResourceDescription__isset __isset;

  void __set_computeResourceId(const std::string& val) {
    computeResourceId = val;
  }

  void __set_hostName(const std::string& val) {
    hostName = val;
  }

  void __set_hostAliases(const std::vector<std::string> & val) {
    hostAliases = val;
    __isset.hostAliases = true;
  }

  void __set_ipAddresses(const std::vector<std::string> & val) {
    ipAddresses = val;
    __isset.ipAddresses = true;
  }

  void __set_resourceDescription(const std::string& val) {
    resourceDescription = val;
    __isset.resourceDescription = true;
  }

  void __set_batchQueues(const std::vector<BatchQueue> & val) {
    batchQueues = val;
    __isset.batchQueues = true;
  }

  void __set_fileSystems(const std::map<FileSystems::type, std::string> & val) {
    fileSystems = val;
    __isset.fileSystems = true;
  }

  void __set_jobSubmissionInterfaces(const std::vector<JobSubmissionInterface> & val) {
    jobSubmissionInterfaces = val;
    __isset.jobSubmissionInterfaces = true;
  }

  void __set_dataMovementInterfaces(const std::vector<DataMovementInterface> & val) {
    dataMovementInterfaces = val;
    __isset.dataMovementInterfaces = true;
  }

  void __set_maxMemoryPerNode(const int32_t val) {
    maxMemoryPerNode = val;
    __isset.maxMemoryPerNode = true;
  }

  bool operator == (const ComputeResourceDescription & rhs) const
  {
    if (!(computeResourceId == rhs.computeResourceId))
      return false;
    if (!(hostName == rhs.hostName))
      return false;
    if (__isset.hostAliases != rhs.__isset.hostAliases)
      return false;
    else if (__isset.hostAliases && !(hostAliases == rhs.hostAliases))
      return false;
    if (__isset.ipAddresses != rhs.__isset.ipAddresses)
      return false;
    else if (__isset.ipAddresses && !(ipAddresses == rhs.ipAddresses))
      return false;
    if (__isset.resourceDescription != rhs.__isset.resourceDescription)
      return false;
    else if (__isset.resourceDescription && !(resourceDescription == rhs.resourceDescription))
      return false;
    if (__isset.batchQueues != rhs.__isset.batchQueues)
      return false;
    else if (__isset.batchQueues && !(batchQueues == rhs.batchQueues))
      return false;
    if (__isset.fileSystems != rhs.__isset.fileSystems)
      return false;
    else if (__isset.fileSystems && !(fileSystems == rhs.fileSystems))
      return false;
    if (__isset.jobSubmissionInterfaces != rhs.__isset.jobSubmissionInterfaces)
      return false;
    else if (__isset.jobSubmissionInterfaces && !(jobSubmissionInterfaces == rhs.jobSubmissionInterfaces))
      return false;
    if (__isset.dataMovementInterfaces != rhs.__isset.dataMovementInterfaces)
      return false;
    else if (__isset.dataMovementInterfaces && !(dataMovementInterfaces == rhs.dataMovementInterfaces))
      return false;
    if (__isset.maxMemoryPerNode != rhs.__isset.maxMemoryPerNode)
      return false;
    else if (__isset.maxMemoryPerNode && !(maxMemoryPerNode == rhs.maxMemoryPerNode))
      return false;
    return true;
  }
  bool operator != (const ComputeResourceDescription &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const ComputeResourceDescription & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

void swap(ComputeResourceDescription &a, ComputeResourceDescription &b);

}}}}} // namespace

#endif
