/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.registry.core.app.catalog.model.StorageInterface;
import org.apache.airavata.registry.core.app.catalog.model.StorageInterface_PK;
import org.apache.airavata.registry.core.app.catalog.model.StorageResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatAbstractResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.resources.StorageResourceResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogJPAUtils;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogQueryGenerator;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogResourceType;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageInterfaceResource
extends AppCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(StorageInterfaceResource.class);
    private String storageResourceId;
    private StorageResourceResource storageResourceResource;
    private String dataMovementProtocol;
    private String dataMovementInterfaceId;
    private int priorityOrder;
    private Timestamp createdTime;
    private Timestamp updatedTime;

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    public Timestamp getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(Timestamp updatedTime) {
        this.updatedTime = updatedTime;
    }

    public int getPriorityOrder() {
        return this.priorityOrder;
    }

    public void setPriorityOrder(int priorityOrder) {
        this.priorityOrder = priorityOrder;
    }

    @Override
    public void remove(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("StorageInterface", new Object[0][]);
            generator.setParameter("storageResourceId", ids.get("storageResourceId"));
            generator.setParameter("dataMovementInterfaceId", ids.get("dataMovementInterfaceId"));
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public AppCatalogResource get(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("StorageInterface", new Object[0][]);
            generator.setParameter("storageResourceId", ids.get("storageResourceId"));
            generator.setParameter("dataMovementInterfaceId", ids.get("dataMovementInterfaceId"));
            Query q = generator.selectQuery(em);
            StorageInterface storageInterface = (StorageInterface)q.getSingleResult();
            StorageInterfaceResource storageInterfaceResource = (StorageInterfaceResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.STORAGE_INTERFACE, storageInterface);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            StorageInterfaceResource storageInterfaceResource2 = storageInterfaceResource;
            return storageInterfaceResource2;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<AppCatalogResource> get(String fieldName, Object value) throws AppCatalogException {
        ArrayList<AppCatalogResource> storageInterfaceResources = new ArrayList<AppCatalogResource>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("StorageInterface", new Object[0][]);
            if (fieldName.equals("storageResourceId") || fieldName.equals("dataMovementProtocol") || fieldName.equals("dataMovementInterfaceId")) {
                generator.setParameter(fieldName, value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                for (Object result : results) {
                    StorageInterface storageInterface = (StorageInterface)result;
                    StorageInterfaceResource storageInterfaceResource = (StorageInterfaceResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.STORAGE_INTERFACE, storageInterface);
                    storageInterfaceResources.add(storageInterfaceResource);
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Data Movement Interface Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Data Movement Interface Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return storageInterfaceResources;
    }

    @Override
    public List<AppCatalogResource> getAll() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getAllIds() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getIds(String fieldName, Object value) throws AppCatalogException {
        ArrayList<String> storageInterfaceResourceIDs = new ArrayList<String>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("StorageInterface", new Object[0][]);
            if (fieldName.equals("storageResourceId") || fieldName.equals("dataMovementProtocol") || fieldName.equals("dataMovementInterfaceId")) {
                generator.setParameter(fieldName, value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                for (Object result : results) {
                    StorageInterface storageInterface = (StorageInterface)result;
                    StorageInterfaceResource storageInterfaceResource = (StorageInterfaceResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.STORAGE_INTERFACE, storageInterface);
                    storageInterfaceResourceIDs.add(storageInterfaceResource.getStorageResourceId());
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Storage Interface Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Storage Interface Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return storageInterfaceResourceIDs;
    }

    @Override
    public void save() throws AppCatalogException {
        EntityManager em = null;
        try {
            StorageInterface storageInterface;
            em = AppCatalogJPAUtils.getEntityManager();
            StorageInterface existingStorageInterface = (StorageInterface)em.find(StorageInterface.class, (Object)new StorageInterface_PK(this.storageResourceId, this.dataMovementInterfaceId));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            if (existingStorageInterface == null) {
                storageInterface = new StorageInterface();
                storageInterface.setCreationTime(AiravataUtils.getCurrentTimestamp());
            } else {
                storageInterface = existingStorageInterface;
                storageInterface.setUpdateTime(AiravataUtils.getCurrentTimestamp());
            }
            storageInterface.setStorageResourceId(this.getStorageResourceId());
            StorageResource storageResource = (StorageResource)em.find(StorageResource.class, (Object)this.getStorageResourceId());
            storageInterface.setStorageResource(storageResource);
            storageInterface.setDataMovementProtocol(this.getDataMovementProtocol());
            storageInterface.setDataMovementInterfaceId(this.getDataMovementInterfaceId());
            storageInterface.setPriorityOrder(this.priorityOrder);
            if (existingStorageInterface == null) {
                em.persist((Object)storageInterface);
            } else {
                em.merge((Object)storageInterface);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            StorageInterface storageInterface = (StorageInterface)em.find(StorageInterface.class, (Object)new StorageInterface_PK((String)ids.get("storageResourceId"), (String)ids.get("dataMovementInterfaceId")));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = storageInterface != null;
            return bl;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public String getDataMovementProtocol() {
        return this.dataMovementProtocol;
    }

    public String getDataMovementInterfaceId() {
        return this.dataMovementInterfaceId;
    }

    public void setDataMovementProtocol(String dataMovementProtocol) {
        this.dataMovementProtocol = dataMovementProtocol;
    }

    public void setDataMovementInterfaceId(String dataMovementInterfaceId) {
        this.dataMovementInterfaceId = dataMovementInterfaceId;
    }

    public String getStorageResourceId() {
        return this.storageResourceId;
    }

    public void setStorageResourceId(String storageResourceId) {
        this.storageResourceId = storageResourceId;
    }

    public StorageResourceResource getStorageResourceResource() {
        return this.storageResourceResource;
    }

    public void setStorageResourceResource(StorageResourceResource storageResourceResource) {
        this.storageResourceResource = storageResourceResource;
    }
}

