/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.registry.core.app.catalog.model.ComputeResource;
import org.apache.airavata.registry.core.app.catalog.model.UserComputeResourcePreference;
import org.apache.airavata.registry.core.app.catalog.model.UserComputeResourcePreferencePK;
import org.apache.airavata.registry.core.app.catalog.model.UserResourceProfile;
import org.apache.airavata.registry.core.app.catalog.model.UserResourceProfilePK;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatAbstractResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.resources.ComputeResourceResource;
import org.apache.airavata.registry.core.app.catalog.resources.UserResourceProfileResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogJPAUtils;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogQueryGenerator;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogResourceType;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.apache.airavata.registry.cpi.CompositeIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserComputeHostPreferenceResource
extends AppCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(UserComputeHostPreferenceResource.class);
    private String gatewayID;
    private String resourceId;
    private String userId;
    private String batchQueue;
    private String scratchLocation;
    private String projectNumber;
    private String loginUserName;
    private String resourceCSToken;
    private String qualityOfService;
    private String reservation;
    private Timestamp reservationStartTime;
    private Timestamp reservationEndTime;
    private boolean validated = false;
    private UserResourceProfileResource userResourceProfileResource;
    private ComputeResourceResource computeHostResource;

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getLoginUserName() {
        return this.loginUserName;
    }

    public void setLoginUserName(String loginUserName) {
        this.loginUserName = loginUserName;
    }

    public String getGatewayId() {
        return this.gatewayID;
    }

    public void setGatewayId(String gatewayID) {
        this.gatewayID = gatewayID;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getBatchQueue() {
        return this.batchQueue;
    }

    public void setBatchQueue(String batchQueue) {
        this.batchQueue = batchQueue;
    }

    public String getScratchLocation() {
        return this.scratchLocation;
    }

    public void setScratchLocation(String scratchLocation) {
        this.scratchLocation = scratchLocation;
    }

    public String getProjectNumber() {
        return this.projectNumber;
    }

    public void setProjectNumber(String projectNumber) {
        this.projectNumber = projectNumber;
    }

    public ComputeResourceResource getComputeHostResource() {
        return this.computeHostResource;
    }

    public void setComputeHostResource(ComputeResourceResource computeHostResource) {
        this.computeHostResource = computeHostResource;
    }

    public UserResourceProfileResource getUserResourceProfileResource() {
        return this.userResourceProfileResource;
    }

    public void setUserResourceProfileResource(UserResourceProfileResource userResourceProfileResource) {
        this.userResourceProfileResource = userResourceProfileResource;
    }

    public String getResourceCSToken() {
        return this.resourceCSToken;
    }

    public void setResourceCSToken(String resourceCSToken) {
        this.resourceCSToken = resourceCSToken;
    }

    public String getQualityOfService() {
        return this.qualityOfService;
    }

    public void setQualityOfService(String qualityOfService) {
        this.qualityOfService = qualityOfService;
    }

    public String getReservation() {
        return this.reservation;
    }

    public void setReservation(String reservation) {
        this.reservation = reservation;
    }

    public Timestamp getReservationStartTime() {
        return this.reservationStartTime;
    }

    public void setReservationStartTime(Timestamp reservationStartTime) {
        this.reservationStartTime = reservationStartTime;
    }

    public Timestamp getReservationEndTime() {
        return this.reservationEndTime;
    }

    public void setReservationEndTime(Timestamp reservationEndTime) {
        this.reservationEndTime = reservationEndTime;
    }

    public boolean isValidated() {
        return this.validated;
    }

    public void setValidated(boolean validated) {
        this.validated = validated;
    }

    @Override
    public void remove(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof CompositeIdentifier)) {
            logger.error("Identifier should be a instance of CompositeIdentifier class");
            throw new AppCatalogException("Identifier should be a instance of CompositeIdentifier class");
        }
        CompositeIdentifier ids = (CompositeIdentifier)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("UserComputeResourcePreference", new Object[0][]);
            generator.setParameter("resourceId", ids.getTopLevelIdentifier().toString());
            generator.setParameter("userId", ids.getSecondLevelIdentifier().toString());
            generator.setParameter("gatewayID", ids.getThirdLevelIdentifier().toString());
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public AppCatalogResource get(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof CompositeIdentifier)) {
            logger.error("Identifier should be a instance of CompositeIdentifier class");
            throw new AppCatalogException("Identifier should be a instance of CompositeIdentifier class");
        }
        CompositeIdentifier ids = (CompositeIdentifier)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("UserComputeResourcePreference", new Object[0][]);
            generator.setParameter("resourceId", ids.getTopLevelIdentifier().toString());
            generator.setParameter("userId", ids.getSecondLevelIdentifier().toString());
            generator.setParameter("gatewayID", ids.getThirdLevelIdentifier().toString());
            Query q = generator.selectQuery(em);
            UserComputeResourcePreference preference = (UserComputeResourcePreference)q.getSingleResult();
            UserComputeHostPreferenceResource preferenceResource = (UserComputeHostPreferenceResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.USER_COMPUTE_RESOURCE_PREFERENCE, preference);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            UserComputeHostPreferenceResource userComputeHostPreferenceResource = preferenceResource;
            return userComputeHostPreferenceResource;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<AppCatalogResource> get(String fieldName, Object value) throws AppCatalogException {
        ArrayList<AppCatalogResource> preferenceResourceList = new ArrayList<AppCatalogResource>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("UserComputeResourcePreference", new Object[0][]);
            if (fieldName.equals("resourceId")) {
                generator.setParameter("resourceId", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        UserComputeResourcePreference preference = (UserComputeResourcePreference)result;
                        if (preference.getComputeHostResource() == null) continue;
                        UserComputeHostPreferenceResource preferenceResource = (UserComputeHostPreferenceResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.USER_COMPUTE_RESOURCE_PREFERENCE, preference);
                        preferenceResourceList.add(preferenceResource);
                    }
                }
            } else if (fieldName.equals("userId")) {
                if (!(value instanceof CompositeIdentifier)) {
                    logger.error("Identifier should be a instance of CompositeIdentifier class");
                    throw new AppCatalogException("Identifier should be a instance of CompositeIdentifier class");
                }
                CompositeIdentifier ids = (CompositeIdentifier)value;
                generator.setParameter("userId", ids.getTopLevelIdentifier().toString());
                generator.setParameter("gatewayID", ids.getSecondLevelIdentifier().toString());
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        UserComputeResourcePreference preference = (UserComputeResourcePreference)result;
                        if (preference.getComputeHostResource() == null) continue;
                        UserComputeHostPreferenceResource preferenceResource = (UserComputeHostPreferenceResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.USER_COMPUTE_RESOURCE_PREFERENCE, preference);
                        preferenceResourceList.add(preferenceResource);
                    }
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Compute host preference Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Compute host preference Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return preferenceResourceList;
    }

    @Override
    public List<AppCatalogResource> getAll() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getAllIds() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getIds(String fieldName, Object value) throws AppCatalogException {
        logger.error("Unsupported for objects with a composite identifier");
        throw new AppCatalogException("Unsupported for objects with a composite identifier");
    }

    @Override
    public void save() throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            UserComputeResourcePreference existingPreference = (UserComputeResourcePreference)em.find(UserComputeResourcePreference.class, (Object)new UserComputeResourcePreferencePK(this.userId, this.gatewayID, this.resourceId));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            ComputeResource computeResource = (ComputeResource)em.find(ComputeResource.class, (Object)this.resourceId);
            UserResourceProfile userResourceProfile = (UserResourceProfile)em.find(UserResourceProfile.class, (Object)new UserResourceProfilePK(this.userId, this.gatewayID));
            if (existingPreference != null) {
                existingPreference.setResourceId(this.resourceId);
                existingPreference.setUserId(this.userId);
                existingPreference.setGatewayID(this.gatewayID);
                existingPreference.setComputeHostResource(computeResource);
                existingPreference.setUserResouceProfile(userResourceProfile);
                existingPreference.setScratchLocation(this.scratchLocation);
                existingPreference.setProjectNumber(this.projectNumber);
                existingPreference.setBatchQueue(this.batchQueue);
                existingPreference.setLoginUserName(this.loginUserName);
                existingPreference.setComputeResourceCSToken(this.resourceCSToken);
                existingPreference.setQualityOfService(this.qualityOfService);
                existingPreference.setReservation(this.reservation);
                existingPreference.setReservationStartTime(this.reservationStartTime);
                existingPreference.setReservationEndTime(this.reservationEndTime);
                existingPreference.setValidated(this.validated);
                em.merge((Object)existingPreference);
            } else {
                UserComputeResourcePreference resourcePreference = new UserComputeResourcePreference();
                resourcePreference.setResourceId(this.resourceId);
                resourcePreference.setGatewayID(this.gatewayID);
                resourcePreference.setUserId(this.userId);
                resourcePreference.setComputeHostResource(computeResource);
                resourcePreference.setScratchLocation(this.scratchLocation);
                resourcePreference.setProjectNumber(this.projectNumber);
                resourcePreference.setBatchQueue(this.batchQueue);
                resourcePreference.setLoginUserName(this.loginUserName);
                resourcePreference.setComputeResourceCSToken(this.resourceCSToken);
                resourcePreference.setQualityOfService(this.qualityOfService);
                resourcePreference.setReservation(this.reservation);
                resourcePreference.setReservationStartTime(this.reservationStartTime);
                resourcePreference.setReservationEndTime(this.reservationEndTime);
                resourcePreference.setValidated(this.validated);
                em.persist((Object)resourcePreference);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof CompositeIdentifier)) {
            logger.error("Identifier should be a instance of CompositeIdentifier class");
            throw new AppCatalogException("Identifier should be a instance of CompositeIdentifier class");
        }
        CompositeIdentifier ids = (CompositeIdentifier)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            String resourceId = ids.getTopLevelIdentifier().toString();
            String userId = ids.getSecondLevelIdentifier().toString();
            String gatewayId = ids.getThirdLevelIdentifier().toString();
            UserComputeResourcePreference existingPreference = (UserComputeResourcePreference)em.find(UserComputeResourcePreference.class, (Object)new UserComputeResourcePreferencePK(userId, gatewayId, resourceId));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = existingPreference != null;
            return bl;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

