/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.experiment.catalog.resources;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.airavata.registry.core.experiment.catalog.ExpCatResourceUtils;
import org.apache.airavata.registry.core.experiment.catalog.ExperimentCatResource;
import org.apache.airavata.registry.core.experiment.catalog.ResourceType;
import org.apache.airavata.registry.core.experiment.catalog.model.UserConfigurationData;
import org.apache.airavata.registry.core.experiment.catalog.resources.AbstractExpCatResource;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserConfigurationDataResource
extends AbstractExpCatResource {
    private static final Logger logger = LoggerFactory.getLogger(UserConfigurationDataResource.class);
    private String experimentId;
    private boolean airavataAutoSchedule;
    private boolean overrideManualScheduledParams;
    private boolean shareExperimentPublically;
    private boolean throttleResources;
    private String userDn;
    private boolean generateCert;
    private String resourceHostId;
    private Integer totalCpuCount;
    private Integer nodeCount;
    private Integer numberOfThreads;
    private String queueName;
    private Integer wallTimeLimit;
    private Integer totalPhysicalMemory;
    private String staticWorkingDir;
    private String overrideLoginUserName;
    private String overrideScratchLocation;
    private String overrideAllocationProjectNumber;
    private String storageId;
    private String experimentDataDir;
    private boolean useUserCRPref;

    public String getExperimentId() {
        return this.experimentId;
    }

    public void setExperimentId(String experimentId) {
        this.experimentId = experimentId;
    }

    public String getResourceHostId() {
        return this.resourceHostId;
    }

    public void setResourceHostId(String resourceHostId) {
        this.resourceHostId = resourceHostId;
    }

    public Integer getTotalCpuCount() {
        return this.totalCpuCount;
    }

    public void setTotalCpuCount(Integer totalCpuCount) {
        this.totalCpuCount = totalCpuCount;
    }

    public Integer getNodeCount() {
        return this.nodeCount;
    }

    public void setNodeCount(Integer nodeCount) {
        this.nodeCount = nodeCount;
    }

    public Integer getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public void setNumberOfThreads(Integer numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public Integer getWallTimeLimit() {
        return this.wallTimeLimit;
    }

    public void setWallTimeLimit(Integer wallTimeLimit) {
        this.wallTimeLimit = wallTimeLimit;
    }

    public String getStorageId() {
        return this.storageId;
    }

    public void setStorageId(String storageId) {
        this.storageId = storageId;
    }

    public Integer getTotalPhysicalMemory() {
        return this.totalPhysicalMemory;
    }

    public void setTotalPhysicalMemory(Integer totalPhysicalMemory) {
        this.totalPhysicalMemory = totalPhysicalMemory;
    }

    public boolean getAiravataAutoSchedule() {
        return this.airavataAutoSchedule;
    }

    public void setAiravataAutoSchedule(boolean airavataAutoSchedule) {
        this.airavataAutoSchedule = airavataAutoSchedule;
    }

    public boolean getOverrideManualScheduledParams() {
        return this.overrideManualScheduledParams;
    }

    public void setOverrideManualScheduledParams(boolean overrideManualScheduledParams) {
        this.overrideManualScheduledParams = overrideManualScheduledParams;
    }

    public boolean getShareExperimentPublically() {
        return this.shareExperimentPublically;
    }

    public void setShareExperimentPublically(boolean shareExperimentPublically) {
        this.shareExperimentPublically = shareExperimentPublically;
    }

    public boolean getThrottleResources() {
        return this.throttleResources;
    }

    public void setThrottleResources(boolean throttleResources) {
        this.throttleResources = throttleResources;
    }

    public String getUserDn() {
        return this.userDn;
    }

    public void setUserDn(String userDn) {
        this.userDn = userDn;
    }

    public boolean getGenerateCert() {
        return this.generateCert;
    }

    public void setGenerateCert(boolean generateCert) {
        this.generateCert = generateCert;
    }

    public String getStaticWorkingDir() {
        return this.staticWorkingDir;
    }

    public void setStaticWorkingDir(String staticWorkingDir) {
        this.staticWorkingDir = staticWorkingDir;
    }

    public String getOverrideLoginUserName() {
        return this.overrideLoginUserName;
    }

    public void setOverrideLoginUserName(String overrideLoginUserName) {
        this.overrideLoginUserName = overrideLoginUserName;
    }

    public String getOverrideScratchLocation() {
        return this.overrideScratchLocation;
    }

    public void setOverrideScratchLocation(String overrideScratchLocation) {
        this.overrideScratchLocation = overrideScratchLocation;
    }

    public String getOverrideAllocationProjectNumber() {
        return this.overrideAllocationProjectNumber;
    }

    public void setOverrideAllocationProjectNumber(String overrideAllocationProjectNumber) {
        this.overrideAllocationProjectNumber = overrideAllocationProjectNumber;
    }

    public String getExperimentDataDir() {
        return this.experimentDataDir;
    }

    public void setExperimentDataDir(String experimentDataDir) {
        this.experimentDataDir = experimentDataDir;
    }

    public boolean getUseUserCRPref() {
        return this.useUserCRPref;
    }

    public void setUseUserCRPref(boolean useUserCRPref) {
        this.useUserCRPref = useUserCRPref;
    }

    @Override
    public ExperimentCatResource create(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for process resource scheduling data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for process resource scheduling data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public ExperimentCatResource get(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for process resource scheduling data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ExperimentCatResource> get(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for process resource scheduling data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            if (this.experimentId == null) {
                throw new RegistryException("Does not have the experiment id");
            }
            UserConfigurationData existingConf = (UserConfigurationData)em.find(UserConfigurationData.class, (Object)this.experimentId);
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            UserConfigurationData userConfigurationData = existingConf == null ? new UserConfigurationData() : existingConf;
            userConfigurationData.setExperimentId(this.experimentId);
            userConfigurationData.setAiravataAutoSchedule(this.airavataAutoSchedule);
            userConfigurationData.setOverrideManualScheduledParams(this.overrideManualScheduledParams);
            userConfigurationData.setShareExperimentPublically(this.shareExperimentPublically);
            userConfigurationData.setThrottleResources(this.throttleResources);
            userConfigurationData.setUserDn(this.userDn);
            userConfigurationData.setGenerateCert(this.generateCert);
            userConfigurationData.setResourceHostId(this.resourceHostId);
            userConfigurationData.setTotalCpuCount(this.totalCpuCount);
            userConfigurationData.setNodeCount(this.nodeCount);
            userConfigurationData.setNumberOfThreads(this.numberOfThreads);
            userConfigurationData.setQueueName(this.queueName);
            userConfigurationData.setWallTimeLimit(this.wallTimeLimit);
            userConfigurationData.setStaticWorkingDir(this.staticWorkingDir);
            userConfigurationData.setOverrideLoginUserName(this.overrideLoginUserName);
            userConfigurationData.setOverrideScratchLocation(this.overrideScratchLocation);
            userConfigurationData.setOverrideAllocationProjectNumber(this.overrideAllocationProjectNumber);
            userConfigurationData.setTotalPhysicalMemory(this.totalPhysicalMemory);
            userConfigurationData.setStorageId(this.storageId);
            userConfigurationData.setExperimentDataDir(this.experimentDataDir);
            userConfigurationData.setUseUserCRPref(this.useUserCRPref);
            if (existingConf == null) {
                em.persist((Object)userConfigurationData);
            } else {
                em.merge((Object)userConfigurationData);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

