/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.deployment;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.component.xml.Component;
import org.wso2.carbon.utils.component.xml.ComponentConfigFactory;
import org.wso2.carbon.utils.component.xml.config.DeployerConfig;
import org.wso2.carbon.utils.deployment.GhostDeployer;

public class GhostDeployerRegistry
implements BundleListener {
    private static Log log = LogFactory.getLog(GhostDeployerRegistry.class);
    private DeploymentEngine deploymentEngine;
    private final Lock lock = new ReentrantLock();
    private Map<Bundle, DeployerConfig> deployerMap;
    private GhostDeployer ghostDeployer = new GhostDeployer();

    public GhostDeployerRegistry(AxisConfiguration axisConfiguration) {
        this.deployerMap = new HashMap<Bundle, DeployerConfig>();
        this.deploymentEngine = (DeploymentEngine)axisConfiguration.getConfigurator();
        try {
            axisConfiguration.addParameter("ghostDeployer", (Object)this.ghostDeployer);
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error while adding Ghost Deployer into AxisConfiguration as a parameter..", (Throwable)axisFault);
        }
    }

    public void register(Bundle[] bundles) {
        for (Bundle bundle : bundles) {
            this.register(bundle);
        }
        this.deploymentEngine.addDeployer((Deployer)this.ghostDeployer, "axis2services", "aar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Bundle bundle) {
        block13: {
            this.lock.lock();
            try {
                DeployerConfig[] newDepConfigs;
                if (this.deployerMap.get(bundle) != null || bundle.getState() != 32) {
                    return;
                }
                URL url = bundle.getEntry("META-INF/component.xml");
                if (url == null) {
                    log.warn((Object)"Axis2Deployer header found in the MANIFEST : But no component.xml found in the bundle");
                    return;
                }
                InputStream inputStream = url.openStream();
                Component component = ComponentConfigFactory.build(inputStream);
                DeployerConfig[] deployerConfigs = null;
                if (component != null) {
                    deployerConfigs = (DeployerConfig[])component.getComponentConfig("deployers");
                }
                if (deployerConfigs == null) break block13;
                for (DeployerConfig deployerConfig : newDepConfigs = CarbonUtils.addCappDeployer(deployerConfigs, this.deploymentEngine.getAxisConfig())) {
                    Class<?> deployerClass;
                    try {
                        deployerClass = bundle.loadClass(deployerConfig.getClassStr());
                    }
                    catch (ClassNotFoundException e) {
                        deployerClass = Class.forName(deployerConfig.getClassStr());
                    }
                    Deployer deployer = (Deployer)deployerClass.newInstance();
                    String directory = deployerConfig.getDirectory();
                    String extension = deployerConfig.getExtension();
                    deployer.setDirectory(directory);
                    deployer.setExtension(extension);
                    this.deploymentEngine.addDeployer((Deployer)this.ghostDeployer, directory, extension);
                    this.ghostDeployer.addDeployer(deployer, directory, extension);
                    this.deployerMap.put(bundle, deployerConfig);
                }
            }
            catch (Exception e) {
                String msg = "Error while deploying the Deployer from bunlde : " + bundle.getSymbolicName() + "-" + bundle.getVersion();
                log.error((Object)msg, (Throwable)e);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Bundle bundle) {
        this.lock.lock();
        try {
            DeployerConfig deployerConfig = this.deployerMap.get(bundle);
            if (deployerConfig == null) {
                return;
            }
            this.deploymentEngine.removeDeployer(deployerConfig.getDirectory(), deployerConfig.getExtension());
        }
        finally {
            this.lock.unlock();
        }
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 4) {
            this.unregister(event.getBundle());
        }
    }
}

