/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.QueueingConsumer;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;

public class RpcServer {
    private final Channel _channel;
    private final String _queueName;
    private boolean _mainloopRunning = true;
    private QueueingConsumer _consumer;

    public RpcServer(Channel channel) throws IOException {
        this(channel, null);
    }

    public RpcServer(Channel channel, String queueName) throws IOException {
        this._channel = channel;
        this._queueName = queueName == null || queueName.equals("") ? this._channel.queueDeclare().getQueue() : queueName;
        this._consumer = this.setupConsumer();
    }

    public void close() throws IOException {
        if (this._consumer != null) {
            this._channel.basicCancel(this._consumer.getConsumerTag());
            this._consumer = null;
        }
        this.terminateMainloop();
    }

    protected QueueingConsumer setupConsumer() throws IOException {
        QueueingConsumer consumer = new QueueingConsumer(this._channel);
        this._channel.basicConsume(this._queueName, consumer);
        return consumer;
    }

    public ShutdownSignalException mainloop() throws IOException {
        try {
            while (this._mainloopRunning) {
                QueueingConsumer.Delivery request;
                try {
                    request = this._consumer.nextDelivery();
                }
                catch (InterruptedException ie) {
                    continue;
                }
                this.processRequest(request);
                this._channel.basicAck(request.getEnvelope().getDeliveryTag(), false);
            }
            return null;
        }
        catch (ShutdownSignalException sse) {
            return sse;
        }
    }

    public void terminateMainloop() {
        this._mainloopRunning = false;
    }

    public void processRequest(QueueingConsumer.Delivery request) throws IOException {
        AMQP.BasicProperties requestProperties = request.getProperties();
        String correlationId = requestProperties.getCorrelationId();
        String replyTo = requestProperties.getReplyTo();
        if (correlationId != null && replyTo != null) {
            AMQP.BasicProperties replyProperties = new AMQP.BasicProperties.Builder().correlationId(correlationId).build();
            byte[] replyBody = this.handleCall(request, replyProperties);
            this._channel.basicPublish("", replyTo, replyProperties, replyBody);
        } else {
            this.handleCast(request);
        }
    }

    public byte[] handleCall(QueueingConsumer.Delivery request, AMQP.BasicProperties replyProperties) {
        return this.handleCall(request.getProperties(), request.getBody(), replyProperties);
    }

    public byte[] handleCall(AMQP.BasicProperties requestProperties, byte[] requestBody, AMQP.BasicProperties replyProperties) {
        return this.handleCall(requestBody, replyProperties);
    }

    public byte[] handleCall(byte[] requestBody, AMQP.BasicProperties replyProperties) {
        return new byte[0];
    }

    public void handleCast(QueueingConsumer.Delivery request) {
        this.handleCast(request.getProperties(), request.getBody());
    }

    public void handleCast(AMQP.BasicProperties requestProperties, byte[] requestBody) {
        this.handleCast(requestBody);
    }

    public void handleCast(byte[] requestBody) {
    }

    public Channel getChannel() {
        return this._channel;
    }

    public String getQueueName() {
        return this._queueName;
    }
}

