/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.map.RecordStore;
import com.hazelcast.map.operation.AbstractMapOperation;
import com.hazelcast.map.operation.ClearBackupOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class ClearOperation
extends AbstractMapOperation
implements BackupAwareOperation,
PartitionAwareOperation {
    Set<Data> keys;
    boolean shouldBackup = true;

    public ClearOperation(String name) {
        super(name);
    }

    public ClearOperation(String name, Set<Data> keys) {
        super(name);
        this.keys = keys;
    }

    public ClearOperation() {
    }

    @Override
    public void run() {
        RecordStore recordStore = this.mapService.getRecordStore(this.getPartitionId(), this.name);
        if (this.keys == null) {
            recordStore.removeAll();
            return;
        }
        if (this.keys.isEmpty()) {
            this.shouldBackup = false;
        }
        for (Data key : this.keys) {
            if (recordStore.isLocked(key)) continue;
            recordStore.evict(key);
        }
    }

    @Override
    public boolean shouldBackup() {
        return this.shouldBackup;
    }

    @Override
    public int getSyncBackupCount() {
        return this.mapService.getMapContainer(this.name).getBackupCount();
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapService.getMapContainer(this.name).getAsyncBackupCount();
    }

    @Override
    public boolean returnsResponse() {
        return this.keys == null;
    }

    @Override
    public Operation getBackupOperation() {
        ClearBackupOperation clearBackupOperation = new ClearBackupOperation(this.name, this.keys);
        clearBackupOperation.setServiceName("hz:impl:mapService");
        return clearBackupOperation;
    }

    public String toString() {
        return "ClearOperation{}";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        if (this.keys == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.keys.size());
            for (Data key : this.keys) {
                key.writeData(out);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        if (size > -1) {
            this.keys = new HashSet<Data>(size);
            for (int i = 0; i < size; ++i) {
                Data data = new Data();
                data.readData(in);
                this.keys.add(data);
            }
        }
    }
}

