/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.util;

import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WSToolingUtils {
    private static final Log log = LogFactory.getLog(WSToolingUtils.class);

    public static boolean hasValue(String str) {
        return str != null && str.length() > 0;
    }

    public static String getWsGenVersion() throws ClassNotFoundException, IOException {
        Class clazz = null;
        try {
            clazz = WSToolingUtils.forName("com.sun.tools.ws.WsGen", false, WSToolingUtils.getContextClassLoader(null));
        }
        catch (ClassNotFoundException e1) {
            try {
                clazz = WSToolingUtils.forName("com.sun.tools.internal.ws.WsGen", false, WSToolingUtils.getContextClassLoader(null));
            }
            catch (ClassNotFoundException e2) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Exception thrown from getWsGenVersion: " + e2.getMessage()), (Throwable)e2);
                }
                throw e2;
            }
        }
        Properties p = new Properties();
        try {
            p.load(clazz.getResourceAsStream("version.properties"));
        }
        catch (IOException ioex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from getWsGenVersion: " + ioex.getMessage()), (Throwable)ioex);
            }
            throw (IOException)ioex.getCause();
        }
        return p.getProperty("major-version");
    }

    private static ClassLoader getContextClassLoader(final ClassLoader classLoader) {
        ClassLoader cl;
        try {
            cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e.getMessage()), (Throwable)e);
            }
            throw ExceptionFactory.makeWebServiceException(e.getException());
        }
        return cl;
    }

    private static Class forName(final String className, final boolean initialize, final ClassLoader classloader) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Class.forName(className, initialize, classloader);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e.getMessage()), (Throwable)e);
            }
            throw (ClassNotFoundException)e.getException();
        }
        return cl;
    }

    public static boolean isValidVersion(String wsGenVersion) {
        int tokenCnt;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start isValidVersion(String)");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("isValidVersion: Determining if WsGen version: " + wsGenVersion + " is appropriate version for using new SUN RI behavior"));
        }
        if (wsGenVersion == null) {
            return false;
        }
        int[] minimumVersionRequired = new int[]{2, 1, 6};
        String version = wsGenVersion.trim();
        StringTokenizer st = new StringTokenizer(version, ".");
        if (st.countTokens() <= 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No Tokens to validate the tooling version, Input version String is invalid.");
            }
            return false;
        }
        boolean lastCheckEqual = false;
        for (tokenCnt = 0; tokenCnt < minimumVersionRequired.length && st.hasMoreTokens(); ++tokenCnt) {
            int minimumVersionNumber;
            String token = st.nextToken();
            if (token == null) {
                return false;
            }
            int versionNumber = WSToolingUtils.getIntegerValue(token);
            if (versionNumber < (minimumVersionNumber = minimumVersionRequired[tokenCnt])) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Validation failed on tokenCnt = " + tokenCnt));
                    log.debug((Object)("Input VersionNumber =" + versionNumber));
                    log.debug((Object)("Minimum Version Number required = " + minimumVersionNumber));
                }
                return false;
            }
            if (versionNumber > minimumVersionNumber) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Validation passed on tokenCnt = " + tokenCnt));
                    log.debug((Object)("Input VersionNumber = " + versionNumber));
                    log.debug((Object)("Minimum Version Number required = " + minimumVersionNumber));
                }
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Validation unresolved on tokenCnt = " + tokenCnt));
                log.debug((Object)("Input VersionNumber = " + versionNumber));
                log.debug((Object)("Minimum Version Number required = " + minimumVersionNumber));
            }
            lastCheckEqual = true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit isValidVersion(String)");
        }
        return !lastCheckEqual || tokenCnt >= minimumVersionRequired.length;
    }

    private static int getIntegerValue(String s) {
        int returnValue = -1;
        StringBuffer valueString = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (Character.isDigit(ch)) {
                valueString.append(Character.getNumericValue(ch));
                continue;
            }
            if (valueString.length() > 0) break;
        }
        if (valueString.length() > 0) {
            returnValue = Integer.valueOf(valueString.toString());
        }
        return returnValue;
    }
}

