/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.util.FileWriter;
import org.apache.axis2.util.XMLPrettyPrinter;
import org.apache.ws.commons.schema.XmlSchema;

public class SchemaWriter {
    private File baseFolder = null;

    public SchemaWriter(File baseFolder) {
        this.baseFolder = baseFolder;
    }

    public void writeSchema(XmlSchema schema, String schemaFileName) {
        try {
            if (schema != null) {
                File outputFile = FileWriter.createClassFile(this.baseFolder, null, schemaFileName.substring(0, schemaFileName.lastIndexOf(".")), ".xsd");
                FileOutputStream fos = new FileOutputStream(outputFile);
                schema.write((OutputStream)fos, this.getDefaultOptionMap());
                fos.flush();
                fos.close();
                XMLPrettyPrinter.prettify(outputFile);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Schema writing failed!", e);
        }
    }

    private Map getDefaultOptionMap() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("omit-xml-declaration", "no");
        options.put("indent", "yes");
        return options;
    }
}

