/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.ns;

import eu.emi.security.authn.x509.helpers.ObserversHandler;
import eu.emi.security.authn.x509.helpers.ns.AbstractNamespacesStore;
import eu.emi.security.authn.x509.helpers.ns.EuGridPmaNamespacesParser;
import eu.emi.security.authn.x509.helpers.ns.NamespacePolicy;
import eu.emi.security.authn.x509.helpers.ns.NamespacesParser;
import eu.emi.security.authn.x509.helpers.trust.OpensslTruststoreHelper;
import eu.emi.security.authn.x509.impl.OpensslNameUtils;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.x500.X500Principal;

public abstract class AbstractEuGridPmaNamespacesStore
extends AbstractNamespacesStore {
    public static final String SUFFIX = ".namespaces";

    public AbstractEuGridPmaNamespacesStore(ObserversHandler observers, boolean openssl1Mode) {
        super(observers, openssl1Mode);
    }

    @Override
    protected String getNotificationType() {
        return "EUGridPMA namespace";
    }

    @Override
    protected NamespacesParser getParser(String path) {
        return new EuGridPmaNamespacesParser(path, this.openssl1Mode);
    }

    @Override
    protected String getFileSuffix() {
        return SUFFIX;
    }

    @Override
    public synchronized List<NamespacePolicy> getPolicies(X500Principal[] chain, int position) {
        ArrayList<NamespacePolicy> policy = new ArrayList<NamespacePolicy>();
        X500Principal issuerName = chain[position];
        String issuerDn = OpensslNameUtils.convertFromRfc2253(issuerName.getName(), false);
        String normalizedDn = OpensslNameUtils.normalize(issuerDn);
        String issuerHash = OpensslTruststoreHelper.getOpenSSLCAHash(issuerName, this.openssl1Mode);
        for (int i = position; i < chain.length; ++i) {
            X500Principal casubject = chain[i];
            String definedForHash = OpensslTruststoreHelper.getOpenSSLCAHash(casubject, this.openssl1Mode);
            List<NamespacePolicy> byHash = this.getPoliciesByIssuerHash(definedForHash, issuerHash);
            List<NamespacePolicy> byName = this.getPoliciesByIssuerDn(definedForHash, normalizedDn);
            if (byHash == null && byName == null) continue;
            if (byHash != null) {
                policy.addAll(byHash);
                return policy;
            }
            if (byName == null) continue;
            policy.addAll(byName);
            return policy;
        }
        return null;
    }

    protected abstract List<NamespacePolicy> getPoliciesByIssuerHash(String var1, String var2);

    protected abstract List<NamespacePolicy> getPoliciesByIssuerDn(String var1, String var2);
}

