/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import com.amazonaws.services.dynamodbv2.datamodeling.PaginatedList;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import java.util.List;

public class PaginatedQueryList<T>
extends PaginatedList<T> {
    private final QueryRequest queryRequest;
    private final DynamoDBMapperConfig config;
    private QueryResult queryResult;

    public PaginatedQueryList(DynamoDBMapper mapper, Class<T> clazz, AmazonDynamoDB dynamo, QueryRequest queryRequest, QueryResult queryResult, DynamoDBMapperConfig.PaginationLoadingStrategy paginationLoadingStrategy, DynamoDBMapperConfig config) {
        super(mapper, clazz, dynamo, paginationLoadingStrategy);
        this.queryRequest = queryRequest;
        this.queryResult = queryResult;
        this.config = config;
        this.allResults.addAll(mapper.marshallIntoObjects(mapper.toParameters(queryResult.getItems(), clazz, config)));
        if (paginationLoadingStrategy == DynamoDBMapperConfig.PaginationLoadingStrategy.EAGER_LOADING) {
            this.loadAllResults();
        }
    }

    @Override
    protected boolean atEndOfResults() {
        return this.queryResult.getLastEvaluatedKey() == null;
    }

    @Override
    protected synchronized List<T> fetchNextPage() {
        this.queryRequest.setExclusiveStartKey(this.queryResult.getLastEvaluatedKey());
        this.queryResult = this.dynamo.query(DynamoDBMapper.applyUserAgent(this.queryRequest));
        return this.mapper.marshallIntoObjects(this.mapper.toParameters(this.queryResult.getItems(), this.clazz, this.config));
    }
}

