/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.document.spec;

import com.amazonaws.event.ProgressListener;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.dynamodbv2.document.TableKeysAndAttributes;
import com.amazonaws.services.dynamodbv2.document.spec.AbstractSpec;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class BatchGetItemSpec
extends AbstractSpec<BatchGetItemRequest> {
    private Collection<TableKeysAndAttributes> tableKeyAndAttributes;
    private Map<String, KeysAndAttributes> unprocessedKeys;

    public BatchGetItemSpec() {
        super(new BatchGetItemRequest());
    }

    public Collection<TableKeysAndAttributes> getTableKeysAndAttributes() {
        return this.tableKeyAndAttributes;
    }

    public BatchGetItemSpec withTableKeyAndAttributes(TableKeysAndAttributes ... tableKeyAndAttributes) {
        if (tableKeyAndAttributes == null) {
            this.tableKeyAndAttributes = null;
        } else {
            HashSet<String> names = new HashSet<String>();
            for (TableKeysAndAttributes e : tableKeyAndAttributes) {
                names.add(e.getTableName());
            }
            if (names.size() != tableKeyAndAttributes.length) {
                throw new IllegalArgumentException("table names must not duplicate in the list of TableKeysAndAttributes");
            }
            this.tableKeyAndAttributes = Arrays.asList(tableKeyAndAttributes);
        }
        return this;
    }

    public String getReturnConsumedCapacity() {
        return ((BatchGetItemRequest)this.getRequest()).getReturnConsumedCapacity();
    }

    public BatchGetItemSpec withReturnConsumedCapacity(ReturnConsumedCapacity capacity) {
        ((BatchGetItemRequest)this.getRequest()).withReturnConsumedCapacity(capacity);
        return this;
    }

    public BatchGetItemSpec withProgressListener(ProgressListener progressListener) {
        this.setProgressListener(progressListener);
        return this;
    }

    public BatchGetItemSpec withRequestMetricCollector(RequestMetricCollector requestMetricCollector) {
        this.setRequestMetricCollector(requestMetricCollector);
        return this;
    }

    public Map<String, KeysAndAttributes> getUnprocessedKeys() {
        return this.unprocessedKeys;
    }

    public BatchGetItemSpec withUnprocessedKeys(Map<String, KeysAndAttributes> unprocessedKeys) {
        this.unprocessedKeys = Collections.unmodifiableMap(new HashMap<String, KeysAndAttributes>(unprocessedKeys));
        return this;
    }
}

