/*
 * Decompiled with CFR 0.152.
 */
package org.databene.contiperf.junit;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.databene.contiperf.Config;
import org.databene.contiperf.ExecutionLogger;
import org.databene.contiperf.junit.PerformanceRequirementFailedError;
import org.databene.contiperf.report.LoggerModuleAdapter;
import org.databene.contiperf.report.ReportContext;
import org.databene.contiperf.report.ReportModule;

public class JUnitReportContext
extends ReportContext {
    public static final Class<PerformanceRequirementFailedError> FAILURE_CLASS = PerformanceRequirementFailedError.class;

    public JUnitReportContext() {
        super(Config.instance().getReportFolder(), FAILURE_CLASS);
    }

    public static JUnitReportContext createInstance(Object suite) {
        List<ReportModule> modules = JUnitReportContext.parseReportModules(suite);
        JUnitReportContext context = new JUnitReportContext();
        for (ReportModule module : modules) {
            context.addReportModule(module);
        }
        return context;
    }

    private static List<ReportModule> parseReportModules(Object suite) {
        ArrayList<ReportModule> modules = new ArrayList<ReportModule>();
        if (suite != null) {
            for (Field field : suite.getClass().getFields()) {
                try {
                    if (ReportModule.class.isAssignableFrom(field.getType())) {
                        modules.add((ReportModule)field.get(suite));
                        continue;
                    }
                    if (!ExecutionLogger.class.isAssignableFrom(field.getType())) continue;
                    modules.add(new LoggerModuleAdapter((ExecutionLogger)field.get(suite)));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return modules;
    }
}

