/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.jparss;

import eu.unicore.uftp.jparss.PConfig;
import eu.unicore.uftp.jparss.PWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class POutputStream
extends OutputStream {
    private OutputStream[] outputs_ = null;
    private int seq_ = 0;
    private boolean[] status_ = null;
    private PWriter[] writers_ = null;
    private boolean done_ = false;
    private int writeCount_ = 0;

    public POutputStream(OutputStream[] streams) {
        int i;
        this.outputs_ = new OutputStream[streams.length];
        this.status_ = new boolean[streams.length];
        for (i = 0; i < streams.length; ++i) {
            this.outputs_[i] = streams[i];
            this.status_[i] = true;
        }
        if (PConfig.usethreads) {
            Thread worker = null;
            this.writers_ = new PWriter[this.outputs_.length];
            for (i = 0; i < this.outputs_.length; ++i) {
                this.writers_[i] = new PWriter(this, this.outputs_[i], i, this.outputs_.length);
                worker = new Thread(this.writers_[i]);
                worker.start();
            }
        }
    }

    @Override
    public void close() throws IOException {
        int i;
        if (this.outputs_ == null) {
            throw new IOException("No internal output streams.");
        }
        byte[] tbuf = new byte[4];
        if (PConfig.usethreads) {
            this.done_ = true;
            for (i = 0; i < this.writers_.length; ++i) {
                this.writers_[i].set(tbuf, 0, 0);
            }
        }
        for (i = 0; i < this.outputs_.length; ++i) {
            this.outputs_[i].close();
        }
    }

    public synchronized boolean finished() {
        return this.done_;
    }

    public synchronized void writerStatus(int pos, boolean stat) {
        if (pos >= 0 && pos < this.status_.length) {
            this.status_[pos] = stat;
            ++this.writeCount_;
        }
        if (this.writeCount_ == this.status_.length) {
            this.notify();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.outputs_ == null) {
            throw new IOException("No internal output streams.");
        }
        for (int i = 0; i < this.outputs_.length; ++i) {
            this.outputs_[i].flush();
        }
    }

    @Override
    public void write(int b) throws IOException {
        DataOutputStream ostream = null;
        for (int i = 0; i < this.outputs_.length; ++i) {
            ostream = new DataOutputStream(this.outputs_[0]);
            ostream.writeShort(-12609);
            ostream.writeShort((short)i);
            ostream.writeInt(this.seq_);
            ostream.writeInt(1);
            if (i == 0) {
                ostream.writeInt(1);
                ostream.writeByte(b);
                continue;
            }
            ostream.writeInt(0);
        }
        ++this.seq_;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (PConfig.usethreads) {
            this.writeParallel(b, off, len);
        } else {
            this.writeSingleThreaded(b, off, len);
        }
        ++this.seq_;
    }

    protected void writeParallel(byte[] b, int off, int len) throws IOException {
        this.resetVariables();
        int i = 0;
        for (i = 0; i < this.writers_.length; ++i) {
            this.writers_[i].set(b, off, len);
        }
        if (PConfig.debug) {
            System.out.println("POutputStream is waking up all writers.");
        }
        if (PConfig.debug) {
            System.out.println("POutputStream is waiting for writers to finish.");
        }
        this.waitWriters();
        if (PConfig.debug) {
            System.out.println("POutputStream is finished write\n");
        }
        for (i = 0; i < this.status_.length; ++i) {
            if (this.status_[i]) continue;
            throw new IOException("Internal stream write error");
        }
    }

    protected void writeSingleThreaded(byte[] b, int off, int len) throws IOException {
        DataOutputStream ostream = null;
        int i = 0;
        int chunk = len / this.outputs_.length;
        for (i = 0; i < this.outputs_.length; ++i) {
            ostream = new DataOutputStream(this.outputs_[i]);
            int toffset = off + i * chunk;
            int tlen = i == this.outputs_.length - 1 ? len - i * chunk : chunk;
            if (PConfig.debug) {
                System.out.println("Writer " + String.valueOf(i) + " writes from " + String.valueOf(toffset) + " with " + String.valueOf(tlen) + " bytes");
            }
            ostream.writeShort(-12609);
            ostream.writeShort((short)i);
            ostream.writeInt(this.seq_);
            ostream.writeInt(len);
            ostream.writeInt(tlen);
            ostream.write(b, toffset, tlen);
        }
    }

    private synchronized void waitWriters() {
        while (this.writeCount_ < this.outputs_.length) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized int getSeq() {
        return this.seq_;
    }

    private void resetVariables() {
        for (int i = 0; i < this.status_.length; ++i) {
            this.status_[i] = true;
        }
        this.writeCount_ = 0;
    }
}

