/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.jparss;

import eu.unicore.uftp.jparss.PConfig;
import eu.unicore.uftp.jparss.POutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class PWriter
implements Runnable {
    private static final Logger logger = Logger.getLogger(PWriter.class);
    private byte[] buffer_ = null;
    private int offset_ = 0;
    private int len_ = 0;
    public int num_ = 0;
    private OutputStream output_ = null;
    private DataOutputStream ostream_ = null;
    private int pos_ = 0;
    private POutputStream parent_ = null;

    public PWriter(POutputStream parent, OutputStream stream, int pos, int numwriters) {
        this.parent_ = parent;
        this.output_ = stream;
        this.pos_ = pos;
        this.num_ = numwriters;
        this.ostream_ = new DataOutputStream(this.output_);
    }

    public synchronized void set(byte[] buf, int off, int length) {
        this.buffer_ = buf;
        this.offset_ = off;
        this.len_ = length;
        if (this.buffer_ != null) {
            this.notify();
        }
    }

    private void reset() {
        this.buffer_ = null;
        this.offset_ = 0;
        this.len_ = 0;
    }

    public synchronized void writeData() throws IOException {
        boolean doit = true;
        if (PConfig.debug) {
            System.out.println("Writer[" + String.valueOf(this.pos_) + "] is waiting");
        }
        while (this.buffer_ == null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                doit = false;
            }
        }
        if (PConfig.debug) {
            System.out.println("Writer[" + String.valueOf(this.pos_) + "] is awaken");
        }
        if (!this.parent_.finished() && doit && this.len_ > 0) {
            this.doWrite();
        }
    }

    private void doWrite() throws IOException {
        int chunk = this.len_ / this.num_;
        int toffset = this.offset_ + this.pos_ * chunk;
        int tlen = this.pos_ == this.num_ - 1 ? this.len_ - this.pos_ * chunk : chunk;
        try {
            this.ostream_.writeShort(-12609);
            this.ostream_.writeShort((short)this.pos_);
            this.ostream_.writeInt(this.parent_.getSeq());
            this.ostream_.writeInt(this.len_);
            this.ostream_.writeInt(tlen);
            this.ostream_.write(this.buffer_, toffset, tlen);
            if (PConfig.debug) {
                System.out.println("Writer " + String.valueOf(this.pos_) + " writes from " + String.valueOf(toffset) + " with " + String.valueOf(tlen) + " bytes and total bytes " + String.valueOf(this.len_));
            }
        }
        catch (IOException e) {
            if (PConfig.debug) {
                System.out.println("Writer " + String.valueOf(this.pos_) + " got IOException");
                System.out.flush();
            }
            this.reset();
            throw e;
        }
        this.reset();
    }

    @Override
    public void run() {
        boolean status = true;
        logger.info("Writer starting");
        while (!this.parent_.finished()) {
            status = true;
            try {
                this.writeData();
            }
            catch (IOException e) {
                status = false;
            }
            this.parent_.writerStatus(this.pos_, status);
        }
    }
}

