/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.server.unix;

import java.util.List;

public class UnixGroup {
    private int gid;
    private String name;
    private List<String> members;

    public UnixGroup(String groupName) throws IllegalArgumentException {
        if (!this.lookupByName(groupName)) {
            throw new IllegalArgumentException("No such group: " + groupName);
        }
    }

    public UnixGroup(int gid) throws IllegalArgumentException {
        if (!this.lookupByGid(gid)) {
            throw new IllegalArgumentException("No such group: " + gid);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getGid() {
        return this.gid;
    }

    public List<String> getMembers() {
        return this.members;
    }

    private synchronized native boolean lookupByName(String var1);

    private synchronized native boolean lookupByGid(int var1);

    public String toString() {
        return "UnixGroup: [name=" + this.getName() + ", gid=" + this.getGid() + ", members=" + this.members;
    }
}

