/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ascii.memcache;

import com.hazelcast.ascii.TextCommandConstants;
import com.hazelcast.ascii.TextCommandService;
import com.hazelcast.ascii.memcache.MemcacheCommandProcessor;
import com.hazelcast.ascii.memcache.SimpleCommand;
import com.hazelcast.logging.ILogger;

public class SimpleCommandProcessor
extends MemcacheCommandProcessor<SimpleCommand> {
    private final ILogger logger;

    public SimpleCommandProcessor(TextCommandService textCommandService) {
        super(textCommandService);
        this.logger = textCommandService.getNode().getLogger(this.getClass().getName());
    }

    @Override
    public void handle(SimpleCommand command) {
        if (command.getType() == TextCommandConstants.TextCommandType.QUIT) {
            try {
                command.getSocketTextReader().closeConnection();
            }
            catch (Exception e) {
                this.logger.warning(e);
            }
        } else if (command.getType() == TextCommandConstants.TextCommandType.UNKNOWN) {
            command.setResponse(ERROR);
            this.textCommandService.sendResponse(command);
        }
    }

    @Override
    public void handleRejection(SimpleCommand command) {
        this.handle(command);
    }
}

