/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations.client;

import com.hazelcast.client.RetryableRequest;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.operations.CollectionResponse;
import com.hazelcast.collection.operations.MultiMapOperationFactory;
import com.hazelcast.collection.operations.client.CollectionAllPartitionRequest;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.OperationFactory;
import com.hazelcast.spi.impl.PortableCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class KeySetRequest
extends CollectionAllPartitionRequest
implements RetryableRequest {
    public KeySetRequest() {
    }

    public KeySetRequest(CollectionProxyId proxyId) {
        super(proxyId);
    }

    @Override
    protected OperationFactory createOperationFactory() {
        return new MultiMapOperationFactory(this.proxyId, MultiMapOperationFactory.OperationFactoryType.KEY_SET);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        HashSet<Data> keySet = new HashSet<Data>();
        for (Object obj : map.values()) {
            CollectionResponse response;
            Collection coll;
            if (obj == null || (coll = (response = (CollectionResponse)obj).getCollection()) == null) continue;
            keySet.addAll(coll);
        }
        return new PortableCollection(keySet);
    }

    @Override
    public int getClassId() {
        return 12;
    }
}

