/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.countdownlatch;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;

public class CountDownLatchInfo
implements DataSerializable {
    private String name;
    private int count = 0;

    public CountDownLatchInfo() {
    }

    public CountDownLatchInfo(String name) {
        this.name = name;
    }

    public int countDown() {
        if (this.count > 0) {
            --this.count;
        }
        return this.count;
    }

    public int getCount() {
        return this.count;
    }

    public String getName() {
        return this.name;
    }

    public boolean setCount(int count) {
        if (this.count > 0 || count <= 0) {
            return false;
        }
        this.count = count;
        return true;
    }

    public void setCountDirect(int count) {
        this.count = count;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LocalCountDownLatch");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", count=").append(this.count);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeInt(this.count);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.count = in.readInt();
    }
}

