/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.core.QueueStore;
import java.util.Properties;

public class QueueStoreConfig {
    private boolean enabled = true;
    private String className = null;
    private Properties properties = new Properties();
    private QueueStore storeImplementation;

    public QueueStoreConfig() {
    }

    public QueueStoreConfig(String className, boolean enabled) {
        this.className = className;
        this.enabled = enabled;
    }

    public QueueStoreConfig(QueueStore storeImplementation) {
        this.storeImplementation = storeImplementation;
    }

    public QueueStore getStoreImplementation() {
        return this.storeImplementation;
    }

    public QueueStoreConfig setStoreImplementation(QueueStore storeImplementation) {
        this.storeImplementation = storeImplementation;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public QueueStoreConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public QueueStoreConfig setClassName(String className) {
        this.className = className;
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public QueueStoreConfig setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public QueueStoreConfig setProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("QueueStoreConfig");
        sb.append("{enabled=").append(this.enabled);
        sb.append(", className='").append(this.className).append('\'');
        sb.append(", properties=").append(this.properties);
        sb.append('}');
        return sb.toString();
    }
}

