/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.multitenancy;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;

public class MultitenantServerManager {
    private static final Log log = LogFactory.getLog(MultitenantServerManager.class);
    private static final ScheduledExecutorService tenantCleanupExec = Executors.newScheduledThreadPool(1);
    private static final int TENANT_CLEANUP_PERIOD_SECS = 60;
    private static final int DEFAULT_TENANT_IDLE_MINS = 30;
    private static long tenantIdleTimeMillis;

    public void start(ConfigurationContext configCtx) throws Exception {
        TenantCleanupTask tenantCleanupTask = new TenantCleanupTask();
        tenantCleanupExec.scheduleAtFixedRate(tenantCleanupTask, 60L, 60L, TimeUnit.SECONDS);
    }

    public void cleanup() {
        tenantCleanupExec.shutdownNow();
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                tenantCleanupExec.shutdownNow();
            }
        });
        tenantIdleTimeMillis = Long.parseLong(System.getProperty("tenant.idle.time", String.valueOf(30))) * 60L * 1000L;
    }

    private static class TenantCleanupTask
    implements Runnable {
        private TenantCleanupTask() {
        }

        @Override
        public void run() {
            try {
                TenantAxisUtils.cleanupTenants(tenantIdleTimeMillis);
            }
            catch (Throwable e) {
                log.error((Object)"Error occurred while executing tenant cleanup", e);
            }
        }
    }
}

