/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.binding.scanner;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.compass.core.config.binding.scanner.FileScanner;
import org.compass.core.config.binding.scanner.Filter;
import org.compass.core.config.binding.scanner.JarScanner;
import org.compass.core.config.binding.scanner.Scanner;

public class ScannerFactoy {
    public static Scanner create(String basePackage, URL url, Filter filter) throws IOException {
        String urlString = url.toString();
        if ((urlString = urlString.substring(0, urlString.lastIndexOf(basePackage))).endsWith("!/")) {
            urlString = urlString.substring(4);
            urlString = urlString.substring(0, urlString.length() - 2);
            url = new URL(urlString);
        }
        if (!urlString.endsWith("/")) {
            return new JarScanner(basePackage, url.openStream(), filter);
        }
        if (url.getProtocol().equals("file")) {
            File f = new File(url.getPath());
            if (f.isDirectory()) {
                return new FileScanner(basePackage, f, filter);
            }
            return new JarScanner(basePackage, url.openStream(), filter);
        }
        throw new IOException("Protocol [" + url.getProtocol() + "] is not supported by scanner");
    }
}

