/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.common.utils;

import java.net.URI;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.infoset.XmlAttribute;
import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlNamespace;

public class WSDLUtil {
    private static final Logger logger = LoggerFactory.getLogger(WSDLUtil.class);

    public static String appendWSDLQuary(String uri) {
        URI wsdlURI = WSDLUtil.appendWSDLQuary(URI.create(uri));
        return wsdlURI.toString();
    }

    public static List<XmlNamespace> getNamespaces(XmlElement element) {
        LinkedList<XmlNamespace> namespaces = new LinkedList<XmlNamespace>();
        namespaces.add(element.getNamespace());
        Iterable attributes = element.attributes();
        for (XmlAttribute xmlAttribute : attributes) {
            String prefix;
            int index;
            if (xmlAttribute.getNamespace() != null && !namespaces.contains(xmlAttribute.getNamespace())) {
                namespaces.add(xmlAttribute.getNamespace());
            }
            if (-1 == (index = xmlAttribute.getValue().indexOf(58)) || element.lookupNamespaceByPrefix(prefix = xmlAttribute.getValue().substring(0, index)) == null) continue;
            namespaces.add(element.lookupNamespaceByPrefix(prefix));
        }
        Iterable children = element.children();
        for (Object object : children) {
            if (!(object instanceof XmlElement)) continue;
            List<XmlNamespace> newNSs = WSDLUtil.getNamespaces((XmlElement)object);
            for (XmlNamespace xmlNamespace : newNSs) {
                if (namespaces.contains(xmlNamespace)) continue;
                namespaces.add(xmlNamespace);
            }
        }
        return namespaces;
    }

    public static URI appendWSDLQuary(URI uri) {
        if (uri.toString().endsWith("?wsdl")) {
            logger.warn("URL already has ?wsdl at the end: " + uri.toString());
            return uri;
        }
        String path = uri.getPath();
        if (path == null || path.length() == 0) {
            uri = uri.resolve("/");
        }
        uri = URI.create(uri.toString() + "?wsdl");
        return uri;
    }

    public static <T> T getfirst(Iterable<T> vals) {
        Iterator<T> iterator = vals.iterator();
        if (iterator.hasNext()) {
            T class1 = iterator.next();
            return class1;
        }
        throw new RuntimeException("Iterator empty");
    }

    public static String findWorkflowName(URI workflowID) {
        String[] splits = workflowID.toString().split("/");
        return splits[splits.length - 1];
    }

    public static void replaceAttributeValue(XmlElement element, String name, String oldValue, String newValue) {
        XmlAttribute attribute = element.attribute(name);
        if (null != attribute && oldValue.equals(attribute.getValue())) {
            element.removeAttribute(attribute);
            element.setAttributeValue(name, newValue);
        }
        Iterable iterator = element.children();
        for (Object object : iterator) {
            if (!(object instanceof XmlElement)) continue;
            WSDLUtil.replaceAttributeValue((XmlElement)object, name, oldValue, newValue);
        }
    }

    public static boolean attributeExist(XmlElement element, String name, String value) {
        XmlAttribute attribute = element.attribute(name);
        if (null != attribute && value.equals(attribute.getValue())) {
            return true;
        }
        Iterable iterator = element.children();
        boolean ret = false;
        for (Object object : iterator) {
            if (!(object instanceof XmlElement)) continue;
            ret = ret || WSDLUtil.attributeExist((XmlElement)object, name, value);
        }
        return ret;
    }
}

