/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.ArrayList;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.CreateConstraintConstantAction;
import org.apache.derby.impl.sql.execute.CreateSequenceConstantAction;
import org.apache.derby.impl.sql.execute.DDLConstantAction;
import org.apache.derby.impl.sql.execute.RowUtil;

class CreateTableConstantAction
extends DDLConstantAction {
    private char lockGranularity;
    private boolean onCommitDeleteRows;
    private boolean onRollbackDeleteRows;
    private String tableName;
    private String schemaName;
    private int tableType;
    private ColumnInfo[] columnInfo;
    private CreateConstraintConstantAction[] constraintActions;
    private Properties properties;

    CreateTableConstantAction(String string, String string2, int n, ColumnInfo[] columnInfoArray, CreateConstraintConstantAction[] createConstraintConstantActionArray, Properties properties, char c, boolean bl, boolean bl2) {
        this.schemaName = string;
        this.tableName = string2;
        this.tableType = n;
        this.columnInfo = columnInfoArray;
        this.constraintActions = createConstraintConstantActionArray;
        this.properties = properties;
        this.lockGranularity = c;
        this.onCommitDeleteRows = bl;
        this.onRollbackDeleteRows = bl2;
    }

    public String toString() {
        if (this.tableType == 3) {
            return this.constructToString("DECLARE GLOBAL TEMPORARY TABLE ", this.tableName);
        }
        return this.constructToString("CREATE TABLE ", this.tableName);
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        int n;
        Object object;
        TableDescriptor tableDescriptor;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        activation.setForCreateTable();
        ExecRow execRow = RowUtil.getEmptyValueRow(this.columnInfo.length, languageConnectionContext);
        int[] nArray = new int[this.columnInfo.length];
        for (int i = 0; i < this.columnInfo.length; ++i) {
            ColumnInfo columnInfo = this.columnInfo[i];
            if (columnInfo.defaultValue != null) {
                execRow.setColumn(i + 1, columnInfo.defaultValue);
            } else {
                execRow.setColumn(i + 1, columnInfo.dataType.getNull());
            }
            nArray[i] = columnInfo.dataType.getCollationType();
        }
        long l = transactionController.createConglomerate("heap", execRow.getRowArray(), null, nArray, this.properties, this.tableType == 3 ? 3 : 0);
        if (this.tableType != 3) {
            dataDictionary.startWriting(languageConnectionContext);
        }
        SchemaDescriptor schemaDescriptor = this.tableType == 3 ? dataDictionary.getSchemaDescriptor(this.schemaName, transactionController, true) : DDLConstantAction.getSchemaDescriptorForCreate(dataDictionary, activation, this.schemaName);
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        if (this.tableType != 3) {
            tableDescriptor = dataDescriptorGenerator.newTableDescriptor(this.tableName, schemaDescriptor, this.tableType, this.lockGranularity);
            dataDictionary.addDescriptor(tableDescriptor, schemaDescriptor, 1, false, transactionController);
        } else {
            tableDescriptor = dataDescriptorGenerator.newTableDescriptor(this.tableName, schemaDescriptor, this.tableType, this.onCommitDeleteRows, this.onRollbackDeleteRows);
            tableDescriptor.setUUID(dataDictionary.getUUIDFactory().createUUID());
        }
        UUID uUID = tableDescriptor.getUUID();
        activation.setDDLTableDescriptor(tableDescriptor);
        int n2 = 1;
        TupleDescriptor[] tupleDescriptorArray = new ColumnDescriptor[this.columnInfo.length];
        for (int i = 0; i < this.columnInfo.length; ++i) {
            ColumnDescriptor columnDescriptor;
            UUID uUID2 = this.columnInfo[i].newDefaultUUID;
            if (this.columnInfo[i].defaultInfo != null && uUID2 == null) {
                uUID2 = dataDictionary.getUUIDFactory().createUUID();
            }
            if (this.columnInfo[i].autoincInc != 0L) {
                columnDescriptor = new ColumnDescriptor(this.columnInfo[i].name, n2++, this.columnInfo[i].dataType, this.columnInfo[i].defaultValue, this.columnInfo[i].defaultInfo, tableDescriptor, uUID2, this.columnInfo[i].autoincStart, this.columnInfo[i].autoincInc, this.columnInfo[i].autoinc_create_or_modify_Start_Increment);
                if (dataDictionary.checkVersion(230, null)) {
                    object = CreateTableConstantAction.makeCSCA(this.columnInfo[i], TableDescriptor.makeSequenceName(uUID));
                    ((CreateSequenceConstantAction)object).executeConstantAction(activation);
                }
            } else {
                columnDescriptor = new ColumnDescriptor(this.columnInfo[i].name, n2++, this.columnInfo[i].dataType, this.columnInfo[i].defaultValue, this.columnInfo[i].defaultInfo, tableDescriptor, uUID2, this.columnInfo[i].autoincStart, this.columnInfo[i].autoincInc);
            }
            tupleDescriptorArray[i] = columnDescriptor;
        }
        if (this.tableType != 3) {
            dataDictionary.addDescriptorArray(tupleDescriptorArray, tableDescriptor, 2, false, transactionController);
        }
        ColumnDescriptorList columnDescriptorList = tableDescriptor.getColumnDescriptorList();
        for (int i = 0; i < tupleDescriptorArray.length; ++i) {
            columnDescriptorList.add(tupleDescriptorArray[i]);
        }
        ConglomerateDescriptor conglomerateDescriptor = dataDescriptorGenerator.newConglomerateDescriptor(l, null, false, null, false, null, uUID, schemaDescriptor.getUUID());
        if (this.tableType != 3) {
            dataDictionary.addDescriptor(conglomerateDescriptor, schemaDescriptor, 0, false, transactionController);
        }
        object = tableDescriptor.getConglomerateDescriptorList();
        ((ArrayList)object).add(conglomerateDescriptor);
        if (this.constraintActions != null) {
            for (n = 0; n < this.constraintActions.length; ++n) {
                if (this.constraintActions[n].isForeignKeyConstraint()) continue;
                this.constraintActions[n].executeConstantAction(activation);
            }
            for (n = 0; n < this.constraintActions.length; ++n) {
                if (!this.constraintActions[n].isForeignKeyConstraint()) continue;
                this.constraintActions[n].executeConstantAction(activation);
            }
        }
        for (n = 0; n < this.columnInfo.length; ++n) {
            this.addColumnDependencies(languageConnectionContext, dataDictionary, tableDescriptor, this.columnInfo[n]);
        }
        this.adjustUDTDependencies(languageConnectionContext, dataDictionary, tableDescriptor, this.columnInfo, false);
        if (this.tableType == 3) {
            languageConnectionContext.addDeclaredGlobalTempTable(tableDescriptor);
        }
        dataDictionary.getDependencyManager().addDependency(activation.getPreparedStatement(), tableDescriptor, languageConnectionContext.getContextManager());
    }

    public static CreateSequenceConstantAction makeCSCA(ColumnInfo columnInfo, String string) throws StandardException {
        DataTypeDescriptor dataTypeDescriptor = columnInfo.dataType;
        long[] lArray = dataTypeDescriptor.getNumericBounds();
        long l = lArray[0];
        long l2 = lArray[1];
        boolean bl = false;
        if (columnInfo.autoincCycle == 1L) {
            bl = true;
        }
        return new CreateSequenceConstantAction("SYS", string, dataTypeDescriptor, columnInfo.autoincStart, columnInfo.autoincInc, l2, l, bl);
    }
}

