/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.security.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.airavata.security.AiravataSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustStoreManager {
    private static final Logger logger = LoggerFactory.getLogger(TrustStoreManager.class);

    public SSLContext initializeTrustStoreManager(String trustStorePath, String trustStorePassword) throws AiravataSecurityException {
        try {
            FileInputStream trustStream = new FileInputStream(new File(trustStorePath));
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            char[] trustPassword = trustStorePassword.toCharArray();
            trustStore.load(trustStream, trustPassword);
            TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustFactory.init(trustStore);
            TrustManager[] trustManagers = trustFactory.getTrustManagers();
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustManagers, null);
            SSLContext.setDefault(sslContext);
            return sslContext;
        }
        catch (CertificateException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException("Error in initializing the trust store.");
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException("Error in initializing the trust store.");
        }
        catch (KeyStoreException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException("Error in initializing the trust store.");
        }
        catch (KeyManagementException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException("Error in initializing the trust store.");
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException("Error in initializing the trust store.");
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException("Error in initializing the trust store.");
        }
    }
}

