/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.helper;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;

public class BundleEntryHttpContext
implements HttpContext {
    private Bundle bundle;
    private String bundlePath;

    public BundleEntryHttpContext(Bundle bundle) {
        this.bundle = bundle;
    }

    public BundleEntryHttpContext(Bundle b, String bundlePath) {
        this(b);
        if (bundlePath != null) {
            if (bundlePath.endsWith("/")) {
                bundlePath = bundlePath.substring(0, bundlePath.length() - 1);
            }
            if (bundlePath.length() == 0) {
                bundlePath = null;
            }
        }
        this.bundlePath = bundlePath;
    }

    public String getMimeType(String arg0) {
        return null;
    }

    public boolean handleSecurity(HttpServletRequest arg0, HttpServletResponse arg1) throws IOException {
        return true;
    }

    public URL getResource(String resourceName) {
        String file;
        Enumeration entryPaths;
        int lastSlash;
        if (this.bundlePath != null) {
            resourceName = this.bundlePath + resourceName;
        }
        if ((lastSlash = resourceName.lastIndexOf(47)) == -1) {
            return null;
        }
        String path = resourceName.substring(0, lastSlash);
        if (path.length() == 0) {
            path = "/";
        }
        if ((entryPaths = this.bundle.findEntries(path, file = this.sanitizeEntryName(resourceName.substring(lastSlash + 1)), false)) != null && entryPaths.hasMoreElements()) {
            return (URL)entryPaths.nextElement();
        }
        return null;
    }

    private String sanitizeEntryName(String name) {
        StringBuffer buffer = null;
        block3: for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            switch (c) {
                case '*': 
                case '\\': {
                    if (buffer == null) {
                        buffer = new StringBuffer(name.length() + 16);
                        buffer.append(name.substring(0, i));
                    }
                    buffer.append('\\').append(c);
                    continue block3;
                }
                default: {
                    if (buffer == null) continue block3;
                    buffer.append(c);
                }
            }
        }
        return buffer == null ? name : buffer.toString();
    }

    public Set getResourcePaths(String path) {
        Enumeration entryPaths;
        if (this.bundlePath != null) {
            path = this.bundlePath + path;
        }
        if ((entryPaths = this.bundle.findEntries(path, null, false)) == null) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        while (entryPaths.hasMoreElements()) {
            URL entryURL = (URL)entryPaths.nextElement();
            String entryPath = entryURL.getFile();
            if (this.bundlePath == null) {
                result.add(entryPath);
                continue;
            }
            result.add(entryPath.substring(this.bundlePath.length()));
        }
        return result;
    }
}

