/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreateTableRequestMarshaller
implements Marshaller<Request<CreateTableRequest>, CreateTableRequest> {
    public Request<CreateTableRequest> marshall(CreateTableRequest createTableRequest) {
        if (createTableRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createTableRequest, "AmazonDynamoDBv2");
        String target = "DynamoDB_20120810.CreateTable";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ProvisionedThroughput provisionedThroughput;
            ListWithAutoConstructFlag globalSecondaryIndexesList;
            ListWithAutoConstructFlag localSecondaryIndexesList;
            ListWithAutoConstructFlag keySchemaList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            ListWithAutoConstructFlag attributeDefinitionsList = (ListWithAutoConstructFlag)createTableRequest.getAttributeDefinitions();
            if (!(attributeDefinitionsList == null || attributeDefinitionsList.isAutoConstruct() && attributeDefinitionsList.isEmpty())) {
                jsonWriter.key("AttributeDefinitions");
                jsonWriter.array();
                for (AttributeDefinition attributeDefinitionsListValue : attributeDefinitionsList) {
                    if (attributeDefinitionsListValue == null) continue;
                    jsonWriter.object();
                    if (attributeDefinitionsListValue.getAttributeName() != null) {
                        jsonWriter.key("AttributeName").value((Object)attributeDefinitionsListValue.getAttributeName());
                    }
                    if (attributeDefinitionsListValue.getAttributeType() != null) {
                        jsonWriter.key("AttributeType").value((Object)attributeDefinitionsListValue.getAttributeType());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (createTableRequest.getTableName() != null) {
                jsonWriter.key("TableName").value((Object)createTableRequest.getTableName());
            }
            if (!((keySchemaList = (ListWithAutoConstructFlag)createTableRequest.getKeySchema()) == null || keySchemaList.isAutoConstruct() && keySchemaList.isEmpty())) {
                jsonWriter.key("KeySchema");
                jsonWriter.array();
                for (KeySchemaElement keySchemaListValue : keySchemaList) {
                    if (keySchemaListValue == null) continue;
                    jsonWriter.object();
                    if (keySchemaListValue.getAttributeName() != null) {
                        jsonWriter.key("AttributeName").value((Object)keySchemaListValue.getAttributeName());
                    }
                    if (keySchemaListValue.getKeyType() != null) {
                        jsonWriter.key("KeyType").value((Object)keySchemaListValue.getKeyType());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (!((localSecondaryIndexesList = (ListWithAutoConstructFlag)createTableRequest.getLocalSecondaryIndexes()) == null || localSecondaryIndexesList.isAutoConstruct() && localSecondaryIndexesList.isEmpty())) {
                jsonWriter.key("LocalSecondaryIndexes");
                jsonWriter.array();
                for (LocalSecondaryIndex localSecondaryIndexesListValue : localSecondaryIndexesList) {
                    Projection projection;
                    ListWithAutoConstructFlag keySchema2List;
                    if (localSecondaryIndexesListValue == null) continue;
                    jsonWriter.object();
                    if (localSecondaryIndexesListValue.getIndexName() != null) {
                        jsonWriter.key("IndexName").value((Object)localSecondaryIndexesListValue.getIndexName());
                    }
                    if (!((keySchema2List = (ListWithAutoConstructFlag)localSecondaryIndexesListValue.getKeySchema()) == null || keySchema2List.isAutoConstruct() && keySchema2List.isEmpty())) {
                        jsonWriter.key("KeySchema");
                        jsonWriter.array();
                        for (KeySchemaElement keySchema2ListValue : keySchema2List) {
                            if (keySchema2ListValue == null) continue;
                            jsonWriter.object();
                            if (keySchema2ListValue.getAttributeName() != null) {
                                jsonWriter.key("AttributeName").value((Object)keySchema2ListValue.getAttributeName());
                            }
                            if (keySchema2ListValue.getKeyType() != null) {
                                jsonWriter.key("KeyType").value((Object)keySchema2ListValue.getKeyType());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    if ((projection = localSecondaryIndexesListValue.getProjection()) != null) {
                        ListWithAutoConstructFlag nonKeyAttributesList;
                        jsonWriter.key("Projection");
                        jsonWriter.object();
                        if (projection.getProjectionType() != null) {
                            jsonWriter.key("ProjectionType").value((Object)projection.getProjectionType());
                        }
                        if (!((nonKeyAttributesList = (ListWithAutoConstructFlag)projection.getNonKeyAttributes()) == null || nonKeyAttributesList.isAutoConstruct() && nonKeyAttributesList.isEmpty())) {
                            jsonWriter.key("NonKeyAttributes");
                            jsonWriter.array();
                            for (String nonKeyAttributesListValue : nonKeyAttributesList) {
                                if (nonKeyAttributesListValue == null) continue;
                                jsonWriter.value((Object)nonKeyAttributesListValue);
                            }
                            jsonWriter.endArray();
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (!((globalSecondaryIndexesList = (ListWithAutoConstructFlag)createTableRequest.getGlobalSecondaryIndexes()) == null || globalSecondaryIndexesList.isAutoConstruct() && globalSecondaryIndexesList.isEmpty())) {
                jsonWriter.key("GlobalSecondaryIndexes");
                jsonWriter.array();
                for (GlobalSecondaryIndex globalSecondaryIndexesListValue : globalSecondaryIndexesList) {
                    ProvisionedThroughput provisionedThroughput2;
                    Projection projection;
                    ListWithAutoConstructFlag keySchema2List;
                    if (globalSecondaryIndexesListValue == null) continue;
                    jsonWriter.object();
                    if (globalSecondaryIndexesListValue.getIndexName() != null) {
                        jsonWriter.key("IndexName").value((Object)globalSecondaryIndexesListValue.getIndexName());
                    }
                    if (!((keySchema2List = (ListWithAutoConstructFlag)globalSecondaryIndexesListValue.getKeySchema()) == null || keySchema2List.isAutoConstruct() && keySchema2List.isEmpty())) {
                        jsonWriter.key("KeySchema");
                        jsonWriter.array();
                        for (KeySchemaElement keySchema2ListValue : keySchema2List) {
                            if (keySchema2ListValue == null) continue;
                            jsonWriter.object();
                            if (keySchema2ListValue.getAttributeName() != null) {
                                jsonWriter.key("AttributeName").value((Object)keySchema2ListValue.getAttributeName());
                            }
                            if (keySchema2ListValue.getKeyType() != null) {
                                jsonWriter.key("KeyType").value((Object)keySchema2ListValue.getKeyType());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    if ((projection = globalSecondaryIndexesListValue.getProjection()) != null) {
                        ListWithAutoConstructFlag nonKeyAttributesList;
                        jsonWriter.key("Projection");
                        jsonWriter.object();
                        if (projection.getProjectionType() != null) {
                            jsonWriter.key("ProjectionType").value((Object)projection.getProjectionType());
                        }
                        if (!((nonKeyAttributesList = (ListWithAutoConstructFlag)projection.getNonKeyAttributes()) == null || nonKeyAttributesList.isAutoConstruct() && nonKeyAttributesList.isEmpty())) {
                            jsonWriter.key("NonKeyAttributes");
                            jsonWriter.array();
                            for (String nonKeyAttributesListValue : nonKeyAttributesList) {
                                if (nonKeyAttributesListValue == null) continue;
                                jsonWriter.value((Object)nonKeyAttributesListValue);
                            }
                            jsonWriter.endArray();
                        }
                        jsonWriter.endObject();
                    }
                    if ((provisionedThroughput2 = globalSecondaryIndexesListValue.getProvisionedThroughput()) != null) {
                        jsonWriter.key("ProvisionedThroughput");
                        jsonWriter.object();
                        if (provisionedThroughput2.getReadCapacityUnits() != null) {
                            jsonWriter.key("ReadCapacityUnits").value((Object)provisionedThroughput2.getReadCapacityUnits());
                        }
                        if (provisionedThroughput2.getWriteCapacityUnits() != null) {
                            jsonWriter.key("WriteCapacityUnits").value((Object)provisionedThroughput2.getWriteCapacityUnits());
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if ((provisionedThroughput = createTableRequest.getProvisionedThroughput()) != null) {
                jsonWriter.key("ProvisionedThroughput");
                jsonWriter.object();
                if (provisionedThroughput.getReadCapacityUnits() != null) {
                    jsonWriter.key("ReadCapacityUnits").value((Object)provisionedThroughput.getReadCapacityUnits());
                }
                if (provisionedThroughput.getWriteCapacityUnits() != null) {
                    jsonWriter.key("WriteCapacityUnits").value((Object)provisionedThroughput.getWriteCapacityUnits());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

