/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.logs.model.GetLogEventsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class GetLogEventsRequestMarshaller
implements Marshaller<Request<GetLogEventsRequest>, GetLogEventsRequest> {
    public Request<GetLogEventsRequest> marshall(GetLogEventsRequest getLogEventsRequest) {
        if (getLogEventsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getLogEventsRequest, "AWSLogs");
        String target = "Logs_20140328.GetLogEvents";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (getLogEventsRequest.getLogGroupName() != null) {
                jsonWriter.key("logGroupName").value((Object)getLogEventsRequest.getLogGroupName());
            }
            if (getLogEventsRequest.getLogStreamName() != null) {
                jsonWriter.key("logStreamName").value((Object)getLogEventsRequest.getLogStreamName());
            }
            if (getLogEventsRequest.getStartTime() != null) {
                jsonWriter.key("startTime").value((Object)getLogEventsRequest.getStartTime());
            }
            if (getLogEventsRequest.getEndTime() != null) {
                jsonWriter.key("endTime").value((Object)getLogEventsRequest.getEndTime());
            }
            if (getLogEventsRequest.getNextToken() != null) {
                jsonWriter.key("nextToken").value((Object)getLogEventsRequest.getNextToken());
            }
            if (getLogEventsRequest.getLimit() != null) {
                jsonWriter.key("limit").value((Object)getLogEventsRequest.getLimit());
            }
            if (getLogEventsRequest.isStartFromHead() != null) {
                jsonWriter.key("startFromHead").value((Object)getLogEventsRequest.isStartFromHead());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

